<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

// Connect to the database
try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    // set the PDO error mode to exception
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['status' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// Retrieve session user ID
$userloggedid = $_SESSION["userid"];

// Retrieve and filter input data
$id = filter_input(INPUT_POST, "id");
$name = filter_input(INPUT_POST, "name");
$phone = filter_input(INPUT_POST, "phone"); 
$email = filter_input(INPUT_POST, "email");
$address = filter_input(INPUT_POST, "address");
$nrc = filter_input(INPUT_POST, "nrc");  
$tpin = filter_input(INPUT_POST, "tpin");
$depotid = filter_input(INPUT_POST, "depotId");  
//$accountType = filter_input(INPUT_POST, "accountType");
$status = filter_input(INPUT_POST, "accountStatus");
$departmentid = filter_input(INPUT_POST, "userdepartmentid");          
$roleid = filter_input(INPUT_POST, "userroleid");  
$rolename = filter_input(INPUT_POST, "userrolename"); 
// Validate required fields
$requiredFields = [
    'id' => $id,
    'name' => $name,
    'phone' => $phone,
   // 'email' => $email,
   // 'address' => $address,
   // 'nrc' => $nrc,  
   // 'businesscategory' => $businesscategory,
   // 'accountType' => $accountType,
   // 'status' => $status
];
foreach ($requiredFields as $field => $value) {
    if ($value === null || $value === false || $value === '' || $value === 'undefined') {
        echo json_encode(['status' => 'not updated', 'error' => "Missing or invalid value for $field"]);
        exit;
    }
}

// Handle avatar file upload if present
$avatarUpdateSQL = '';
$avatarParam = [];
if (isset($_FILES['avatarImage']) && $_FILES['avatarImage']['error'] === UPLOAD_ERR_OK) {
    // Get old avatar path from DB
    $oldAvatarPath = '';
    $getOldAvatarStmt = $conn->prepare('SELECT avatar FROM users WHERE id = :id LIMIT 1');
    $getOldAvatarStmt->execute([':id' => $id]);
    $oldAvatarRow = $getOldAvatarStmt->fetch(PDO::FETCH_ASSOC);
    if ($oldAvatarRow && !empty($oldAvatarRow['avatar'])) {
        $oldAvatarPath = $oldAvatarRow['avatar'];
    }

    $uploadDir = '../../../xd-uploads/user-pictures/';
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    $fileInfo = pathinfo($_FILES['avatarImage']['name']);
    $fileExtension = strtolower($fileInfo['extension']);
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    if (!in_array($fileExtension, $allowedExtensions)) {
        echo json_encode(['status' => 'not updated', 'error' => 'Invalid file type. Only JPG, PNG, GIF, and WebP files are allowed.']);
        exit;
    }
    if ($_FILES['avatarImage']['size'] > 5 * 1024 * 1024) {
        echo json_encode(['status' => 'not updated', 'error' => 'File size too large. Maximum 5MB allowed.']);
        exit;
    }
    $timestamp = time();
    $randomString = bin2hex(random_bytes(8));
    $newFileName = "avatar_" . $timestamp . "_" . $randomString . "." . $fileExtension;
    $targetPath = $uploadDir . $newFileName;
    if (move_uploaded_file($_FILES['avatarImage']['tmp_name'], $targetPath)) {
        $avatarPath = 'xd-uploads/user-pictures/' . $newFileName;
        $avatarUpdateSQL = ', avatar = :avatar';
        $avatarParam = [':avatar' => $avatarPath];
        // Delete old avatar file if not default and exists
        if ($oldAvatarPath && $oldAvatarPath !== 'xd-uploads/user-pictures/avatar.png') {
            $oldAvatarFullPath = '../../../' . $oldAvatarPath;
            if (file_exists($oldAvatarFullPath)) {
                unlink($oldAvatarFullPath);
            }
        }
    } else {
        echo json_encode(['status' => 'not updated', 'error' => 'Failed to upload avatar image.']);
        exit;
    }
}

// Prepare the SQL update query
$updateQuery = "
    UPDATE users SET 
        email = :email,
        names = :name,
        phone = :phone, 
        address = :address,
        nrc = :nrc, 
        tpin = :tpin,  
        user_type = :rolename,
        status = :status,
        sessionUserId = :userloggedid" . $avatarUpdateSQL . "
    WHERE id = :id
";

// Prepare and execute the statement
$statement = $conn->prepare($updateQuery);

$params = [
    ':email' => $email,
    ':name' => $name,
    ':phone' => $phone, 
    ':address' => $address,
    ':nrc' => $nrc,  
    ':tpin' => $tpin, 
    ':rolename' => $rolename,
    ':status' => $status,
    ':userloggedid' => $userloggedid,
    ':id' => $id
] + $avatarParam;

try {
    $statement->execute($params);
    // Update clients table with relevant fields
    $updateClientsQuery = "
        UPDATE workforce SET  
            status = :status,
            department_id = :departmentid,
             role_id = :roleid, 
             depot_id = :depotid
        WHERE user_id = :id
    ";
    $clientsStatement = $conn->prepare($updateClientsQuery);
    $clientsParams = [
        ':status' => $status, 
        ':departmentid' => $departmentid,
        ':roleid' => $roleid,
        ':id' => $id, 
        ':depotid' => $depotid,
    ];
    $clientsStatement->execute($clientsParams);
    $json_data = ['status' => 'Success'];
    echo json_encode($json_data);
} catch (PDOException $e) {
    $json_data = ['status' => 'not updated', 'error' => $e->getMessage()];
    echo json_encode($json_data);
}
?>
