<?php  
header('Access-Control-Allow-Origin: *');  
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');     
session_start();   
require_once '../../../xd-assets/backend/config/dbconfig.php'; 

$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
// set the PDO error mode to exception 
$conn->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION); 

$userloggedid = $_SESSION["userid"];          
$orgid = $_SESSION["orgid"];          
// Get form data
$name = filter_input(INPUT_POST, "name");          
$phone = filter_input(INPUT_POST, "phone");                
$email = filter_input(INPUT_POST, "email");          
$address = filter_input(INPUT_POST, "address");          
$nrc = filter_input(INPUT_POST, "nrc");  
$tpin = filter_input(INPUT_POST, "tpin");                   
$userdepartmentId = filter_input(INPUT_POST, "userdepartmentId");          
$userroleId = filter_input(INPUT_POST, "userroleId");    
$departmentName = filter_input(INPUT_POST, "departmentName");     
$depotId = filter_input(INPUT_POST, "depotId"); // Added depotId for consistency    
//$depotCode = filter_input(INPUT_POST, "depotCode"); // Added depotId for consistency   
$status = 'Active';          
$role = filter_input(INPUT_POST, "rolename");  

 $np = 1234;
// Hash the new password
$hashedPassword = password_hash($np, PASSWORD_DEFAULT);

    // Debug logs
 //   error_log("Raw password before hashing: " . $np);
 //   error_log("Hashed password: " . $hashedPassword);

// Check if user already exists and get user_id
$checkQuery = "SELECT id FROM users WHERE email = :email OR phone = :phone LIMIT 1";
$checkStmt = $conn->prepare($checkQuery);
$checkStmt->execute([':email' => $email, ':phone' => $phone]);
$existingUser = $checkStmt->fetch(PDO::FETCH_ASSOC);

$userid = null;
$avatarPath = 'xd-uploads/user-pictures/avatar.png'; // Default avatar
$isExistingUser = false;

if ($existingUser) {
    // User exists, get the user_id
    $userid = $existingUser['id'];
    $isExistingUser = true;
} else {
    // User doesn't exist, create new user
    
    // Handle avatar file upload
    if (isset($_FILES['avatarImage']) && $_FILES['avatarImage']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = '../../../xd-uploads/user-pictures/';
        
        // Create directory if it doesn't exist
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $fileInfo = pathinfo($_FILES['avatarImage']['name']);
        $fileExtension = strtolower($fileInfo['extension']);
        
        // Validate file type
        $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        if (!in_array($fileExtension, $allowedExtensions)) {
            $json_data = array(
                'status' => 'error',
                'message' => 'Invalid file type. Only JPG, PNG, GIF, and WebP files are allowed.'
            );
            echo json_encode($json_data);
            exit;
        }
        
        // Generate unique filename
        $timestamp = time();
        $randomString = bin2hex(random_bytes(8));
        $newFileName = "avatar_" . $timestamp . "_" . $randomString . "." . $fileExtension;
        $targetPath = $uploadDir . $newFileName;
        
        // Validate file size (5MB limit)
        if ($_FILES['avatarImage']['size'] > 5 * 1024 * 1024) {
            $json_data = array(
                'status' => 'error',
                'message' => 'File size too large. Maximum 5MB allowed.'
            );
            echo json_encode($json_data);
            exit;
        }
        
        // Move uploaded file
        if (move_uploaded_file($_FILES['avatarImage']['tmp_name'], $targetPath)) {
            // Store relative path for database
            $avatarPath = 'xd-uploads/user-pictures/' . $newFileName;
        } else {
            $json_data = array(
                'status' => 'error',
                'message' => 'Failed to upload avatar image. Using default avatar.'
            );
            echo json_encode($json_data);
            exit;
        }
    } else if (isset($_FILES['avatarImage']) && $_FILES['avatarImage']['error'] !== UPLOAD_ERR_NO_FILE) {
        // Handle other upload errors (but still continue with default avatar)
        error_log("Avatar upload error: " . $_FILES['avatarImage']['error']);
        // $avatarPath remains as default avatar.png
    }

    // Insert new user with avatar path
    $insertnewuserQuery = "INSERT INTO users (email, names, phone, password, address, nrc, avatar, tpin, role, org_id, status, sessionUserId,user_id) VALUES (:email, :name, :phone, :password, :address, :nrc, :avatar, :tpin, :role, :orgid, :status, :userloggedid, :orgid)"; 

    $insertnewUser = $conn->prepare($insertnewuserQuery); 
    $insertnewUser->execute([
        ':email' => $email,
        ':name' => $name,
        ':phone' => $phone, 
        ':address' => $address,
        ':nrc' => $nrc,   
        'role' => $role,
        ':tpin' => $tpin,
        ':status' => $status,
        ':userloggedid' => $userloggedid,
        ':avatar' => $avatarPath,
        'password' => $hashedPassword,
        'orgid' => $orgid
    ]);

    if ($insertnewUser) {
        $userid = $conn->lastInsertId();
    } else {
        // Clean up uploaded file if user creation failed (but not if it's default avatar)
        if ($avatarPath && $avatarPath !== 'xd-uploads/user-pictures/avatar.png' && file_exists('../../../' . $avatarPath)) {
            unlink('../../../' . $avatarPath);
        }
        
        $json_data = array(
            'status' => 'not created',
            'message' => 'Failed to create user'
        );
        echo json_encode($json_data);
        exit;
    }
}

// Proceed with client and user_roles insertion (for both existing and new users)
if ($userid) {
    $client_id = $userid;
    $userdepartmentId = $userdepartmentId ? $userdepartmentId : '1';
    $depot_id = $depotId ? $depotId : '1';
  //  $business_category = $businesscategory ? $businesscategory : '1';
    $created_by = $userloggedid;
    $status_client = 'Active';

    // Get role_id for 'Client' from roles table
    $roleQuery = "SELECT role_id FROM roles WHERE role_name = :role_name AND org_id=:org_id LIMIT 1";
    $roleStmt = $conn->prepare($roleQuery);
    //$roleStmt->execute([':role_name' => 'Agent']);
     $roleStmt->execute([
                ':role_name' => 'Agent',
                ':org_id' => $orgid
            ]);
    $roleRow = $roleStmt->fetch(PDO::FETCH_ASSOC);
    
    if ($roleRow && isset($roleRow['role_id'])) {
        $role_id = $roleRow['role_id'];
        
        // Check if user_role already exists to avoid duplicates
        $checkUserRoleQuery = "SELECT id FROM user_roles WHERE user_id = :user_id AND role_id = :role_id AND org_id = :org_id LIMIT 1";
        $checkUserRoleStmt = $conn->prepare($checkUserRoleQuery);
        $checkUserRoleStmt->execute([
            ':user_id' => $userid,
            ':role_id' => $role_id,
            ':org_id' => $orgid
        ]);
        
        if (!$checkUserRoleStmt->fetch(PDO::FETCH_ASSOC)) {
            // Insert into user_roles table only if it doesn't exist
            $insertUserRoleQuery = "INSERT INTO user_roles (user_id, role_id, status, created_by, org_id) VALUES (:user_id, :role_id, :status, :created_by, :org_id)";
            $insertUserRole = $conn->prepare($insertUserRoleQuery);
            $insertUserRole->execute([
                ':user_id' => $userid,
                ':role_id' => $role_id,
                ':status' => 'Active',
                ':created_by' => $userloggedid,
                ':org_id' => $orgid
            ]);
        }
    } else {
        // Optionally handle error if role_id not found
        error_log('Role "Client" not found in roles table.');
    }

    // Check if client record already exists to avoid duplicates
    $checkClientQuery = "SELECT user_id FROM workforce WHERE user_id = :user_id AND org_id = :org_id LIMIT 1";
    $checkClientStmt = $conn->prepare($checkClientQuery);
    $checkClientStmt->execute([
        ':user_id' => $userid, 
        ':org_id' => $orgid
    ]);
    
    if (!$checkClientStmt->fetch(PDO::FETCH_ASSOC)) {
        // Insert into clients table only if it doesn't exist
        $insertClientQuery = "INSERT INTO workforce (user_id, status, department_id, role_id, depot_id, created_by, org_id) VALUES (:client_id, :status, :department_id, :role_id, :depotId, :created_by, :org_id)";
        $insertClient = $conn->prepare($insertClientQuery);
        $insertClient->execute([
            ':client_id' => $client_id,
            ':org_id' => $orgid,
            ':department_id' => $userdepartmentId,
            ':role_id' => $role_id,
            ':depotId' => $depot_id,
            ':created_by' => $created_by,
            ':status' => $status_client
        ]);
    }
    
   // $responseStatus = $isExistingUser ? 'User Exists - Client Added' : 'Created';
    $responseStatus = 'Created';
    $json_data = array(
        'status' => $responseStatus,
        'user_id' => $userid,
        'avatar_path' => $avatarPath,
        'avatar_is_default' => ($avatarPath === 'xd-uploads/user-pictures/avatar.png'),
        'is_existing_user' => $isExistingUser
    );
    echo json_encode($json_data);
    exit;
} else {
    $json_data = array(
        'status' => 'error',
        'message' => 'Failed to process user'
    );
    echo json_encode($json_data);
    exit;
}
?>