// ************************************************
// Shopping Cart API
//*******************************************
// Shopping Cart API
// ************************************************
var shoppingCart = (function() {
  // =============================
  // Private methods and properties
  // =============================
  cart = [];
  var totalBalanceCF = 0;  // Define totalBalanceCF in the shoppingCart object

  // Constructor with balanceCF added
  function Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, balanceCF) {
    this.name = name;
    this.price = price;
    this.charge_rate = charge_rate;
    this.count = count;
    this.id = id;
    this.productcode = productcode;
    this.category = category;
    this.categorycode = categorycode;
    this.depot = depot;
    this.depotid = depotid;
    this.depotcode = depotcode;
    this.balanceCF = balanceCF;  // Add balanceCF property
  }
  
  // Save cart
  function saveCart() {
    sessionStorage.setItem('shoppingCart', JSON.stringify(cart));
  }

  // Load cart
  function loadCart() {
    cart = JSON.parse(sessionStorage.getItem('shoppingCart'));
  }

  if (sessionStorage.getItem("shoppingCart") != null) {
    loadCart();
  }

  // =============================
  // Public methods and properties
  // =============================
  var obj = {};

  // Add to cart
  obj.addItemToCart = function(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart[item].count++;
        saveCart();
        return;
      }
    }
    var balanceCF = price - (price * count); // Calculate balanceCF
    var item = new Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, balanceCF);
    cart.push(item);
    saveCart();
  }

  // Set count for item
  obj.setCountForItem = function(name, count) {
    for(var i in cart) {
      if (cart[i].name === name) {
        cart[i].count = count;
        cart[i].balanceCF = cart[i].price - (cart[i].price * count); // Update balanceCF on count change
        break;
      }
    }
  };

  // Remove item from cart
  obj.removeItemFromCart = function(name) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart[item].count--;
        cart[item].balanceCF = cart[item].price - (cart[item].price * cart[item].count); // Update balanceCF on item removal
        if(cart[item].count === 0) {
          cart.splice(item, 1);
        }
        break;
      }
    }
    saveCart();
  }

  // Remove all items from cart
  obj.removeItemFromCartAll = function(name) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart.splice(item, 1);
        break;
      }
    }
    saveCart();
  }

  // Clear cart
  obj.clearCart = function() {
    cart = [];
    saveCart();
  }

  // Count cart 
  obj.totalCount = function() {
    var totalCount = 0;
    for(var item in cart) {
      totalCount += cart[item].count;
    }
    return totalCount;
  }

  // Total cart
  obj.totalCart = function() {
    var totalCart = 0;
    for(var item in cart) {
      totalCart += cart[item].price * cart[item].count;
    }
    return Number(totalCart.toFixed(2));
  }

  // Total Balance CF
  obj.totalBalanceCF = function() {
    return totalBalanceCF.toFixed(2);
  }

  // List cart
  obj.listCart = function() {
    var cartCopy = [];
    totalBalanceCF = 0; // Reset totalBalanceCF

    for(i in cart) {
      item = cart[i];
      itemCopy = {};
      for(p in item) {
        itemCopy[p] = item[p];
      }
      itemCopy.total = Number(item.price * item.count).toFixed(2);

      // Use balanceCF from the item and add it to the total
      totalBalanceCF += parseFloat(item.balanceCF);
      
      cartCopy.push(itemCopy);
    }

    return cartCopy;
  }

  // Function to get the price for an item
  obj.getPriceForItem = function(name) {
    var cartArray = this.listCart();
    for (var i in cartArray) {
      if (cartArray[i].name === name) {
        return cartArray[i].price;
      }
    }
    return 0;
  };

  return obj;
})();

// *****************************************
// Triggers / Events
// ***************************************** 
// Clear items
$('.clear-cart').click(function() {
  shoppingCart.clearCart();
  displayCart();
});

// Delete item button
$(document).on("click", ".delete-item", function(event) {
  var name = $(this).data('name');
  shoppingCart.removeItemFromCartAll(name);
  displayCart();
});

// Item count input
let debounceTimer;
$('.show-cart').on("keyup", ".item-count", function(event) {
  clearTimeout(debounceTimer);
  var name = $(this).data('name');
  debounceTimer = setTimeout(() => {
    var count = Number($(this).val());
    shoppingCart.setCountForItem(name, count);
    displayCart();
  }, 1000);
});

$('.show-cart').on("change", ".item-count", function(event) {
  var name = $(this).data('name');
  var count = Number($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart();
});

// Handle changes in itemTotal
$('.show-cart').on("keyup", ".itemTotal", function(event) {
  clearTimeout(debounceTimer);
  var name = $(this).data('name');
  debounceTimer = setTimeout(() => {
    var total = Number($(this).val());
    var price = shoppingCart.getPriceForItem(name);
    var newCount = total / price;
    shoppingCart.setCountForItem(name, newCount);
    displayCart();
  }, 2500);
});

$('.show-cart').on("change", ".itemTotal", function(event) {
  var name = $(this).data('name');
  var total = Number($(this).val());
  var price = shoppingCart.getPriceForItem(name);
  var newCount = total / price;
  shoppingCart.setCountForItem(name, newCount);
  displayCart();
});

// Function to display cart
function displayCart() {
  var cartArray = shoppingCart.listCart();
  var output = "";

  for(var i in cartArray) {
    var totalItemCost = (cartArray[i].count * cartArray[i].price).toFixed(2);
    var balanceBF = parseFloat(cartArray[i].price);
    var balanceCF = cartArray[i].balanceCF;  // Use the balanceCF stored in the item

    output += "<div class='w3-col l12 m12 s12' style='float:left;padding-left:0px;'>"
    + "<div class='w3-col l5 m5 s8 cartProductId808' data-productid='"+cartArray[i].id+"' data-productname='"+cartArray[i].name+"' style='float:left;padding-left:5px;text-align:left;cursor:pointer;'>" + cartArray[i].name + "</div>" 
    + "<div class='w3-col l2 m2 s2 balanceBFDiv' style='float:left;font-size:0.9em;'>K" + cartArray[i].price + "</div>"
    + "<div class='w3-col l1 m1 s1' style='border-right:1px solid gray'><div class='input-group'>"
    + "<input type='number' step='0.01' class='item-count form-control w3-hide-small' data-name='" + cartArray[i].name + "' value='" + cartArray[i].count + "' style='max-width:40px;border:none;font-size:0.7em;outline:none;'>"
    + "</div></div>"
    + "<div class='w3-col l2 m2 s2'><input type='number' step='0.01' class='itemTotal form-control' data-name='" + cartArray[i].name + "' value='" + totalItemCost + "' style='border:none;font-size:0.8em;font-weight:600;outline:none;'></div>" 
    + "<div class='w3-col l2 m2 s2 balanceCFDiv w3-hide-small' style='float:left;border:none;font-size:0.8em;font-weight:600;outline:none;'>K" + balanceCF + "</div>" 
    + "</div>";
  }

  $('.show-cart').html(output);
  $('.displayInvoice77').html(output);
  $('.total-cart').html(shoppingCart.totalCart());
  $('.total-count').html(shoppingCart.totalCount());
  
  // Update the total for balanceCFDivTotal
  $('.balanceCFDivTotal').html("K" + shoppingCart.totalBalanceCF());
}

// Initially display the cart
displayCart();
// Event for adding items to the invoice
$(document).on('click','#addInvoiceItem045', function (event) {
  var name = $(this).data('name');
  var category = $(this).data('category');
  var price = Number($(this).data('price'));
  var charge_rate = ($(this).data('chargerate'));
  var id = ($(this).data('id'));
  var categorycode = ($(this).data('categorycode'));
  var productcode = ($(this).data('productcode'));

  var depot = $(this).data('depot');
  var depotid = ($(this).data('depotid'));
  var depotcode = ($(this).data('depotcode')); 
  var balanceCF ='00';
  shoppingCart.addItemToCart(name, price, charge_rate, 1, id, productcode, category, categorycode, depot, depotid, depotcode,balanceCF);
  displayCart();

  $('#invoiceItemsList').append(orderDetails);
});


// add product delivery charge


// MAKE PAYMENT
$(document).on('click','.transact0',function (event) {
transact101();
})
function transact101(){
//alert('iam trasact');	
$('#transact_modal').fadeIn('slow');
 addInvoicedItem(); 
 $('#paymentresponseDivBottom').empty(); 
$('#addInvoicedItemDiv').empty();
$('#addInvoicedItemDiv').append('<span  id="addInvoicedItem0" style="float:left;margin-left:7px;cursor: pointer;">Product/Service <span class="fontx fx-plus" style="color:rgba(96, 146, 205,1);cursor: pointer;"></span></span>');
$('#addInvoiceClientDiv').empty();
$('#addInvoiceClientDiv').append('<button type="button" id="addInvoiceClient0" style="float:left;font-weight:600;color:rgba(96, 146, 205,1);height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button>');
$('.modeOfPaymentDiv0').fadeIn('slow');
$('.modeOfPaymentDiv0').empty(); 
$('.modeOfPaymentDiv0').append('<select id="modeOfPayment" style="outline: none;margin-bottom:0px;color:black;margin-left:10px;float:left;margin-top:0px;border:none;font-weight:600;font-size:1em;background-color: transparent;-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"><option value="BANK">Bank Deposit</option><option value="CASH">Cash payment</option><option value="MOMO">Mobile Money</option></select>');
 $('#invoiceType').empty();
$('#invoiceType').append('<option value="RECEIPT"> RECEIPT</option><option value="INVOICE">INVOICE</option><option value="QUOTATION">QUOTATION</option>');
 // empty the print div
 $('#printReceiptDiv102').empty();
 document.getElementById('invoiceDueDate').value ='';
$('#payment-btns-div01').fadeIn('slow'); 
$('#payment-btns01').empty();
$('#payment-btns01').append('<div style="height:40px;width:100%;color:#eee;background-color:rgba(96, 146, 205,1);padding:5px;"><div class="w3-col l6 m6 s6 custom-file"  style="border-right:1px solid #eee;height:40px;"><input type="file" class="custom-file__input" id="field-upload" name="field-upload" required><label class="custom-file__label fontx fx-file-plus" for="field-upload">Select File</label></div><div class="w3-col l6 m6 s6 bankTransact0" style="cursor:pointer;margin-top:-5px;font-size:1.3em;font-weight:400"><span class="fontx fx-archive"></span> Transact</div></div></div>');

$('#bankNameDiv0').fadeIn('slow');
$('#bankDepositSlipIdDiv').fadeIn('slow');
$('.bankInvoiceDetailsDiv').fadeOut('slow');
$('.bankInvoiceDetailsDiv0').fadeIn('slow');
$.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
  $('#bankName').empty();
  $.each(data.details, function(i,cyberdesk) {
  $('#bankName').append('<option value="'+cyberdesk.account_name+'" data-accountnumber="'+cyberdesk.account_number+'">'+cyberdesk.account_name+'</option>');
  });
   
  });



}

$(document).on('click','.close_transact_modal',function (event) {
 event.preventDefault();
  event.stopPropagation(); 
  $('#transact_modal').fadeOut('slow');
   $('#invoiceNumber').empty();
 $('#invoicedClientName0').empty();
 $('#invoicedClientAddress0').empty();
 $('#invoicedClientEmail0').empty();
 $('#invoicedClientId0').empty();
 $('#payment-btns01').empty(); 
 $('#payment-btns01').append('<center><div class="cashTransact01 w3-col" style="font-weight: 600;height:35px;line-height: 30px;">Make Cash  Transaction</div></center>'); 
 $('#paymentresponseDivBottom').empty(); 

 $('#paymentresponseDivBottom').empty();

 $('#plotnumber07').empty();
 $('#area07').empty();
 $('#nrc07').empty();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('trasactionTime34').value ='';
 document.getElementById('invoicedClientPhone0').value ='';
 document.getElementById('invoiceDueDate').value ='';
  shoppingCart.clearCart();
  displayCart(); 
       
});

$(document).on('click','.invoices0',function (event) {
  invoicing();
});

function invoicing() {
  $('#page-title3434').empty();
  $('#page-options').empty();
  $('#page-options').append('<span style="font-weight:400;font-size:1em;margin-top:-7px;"><select class="invoicesSelect0" style="text-transform:uppercase;border:none;background-color:transparent;color:gray;outline:none;"><option value="All">All invoices</option></select><span id="record01" class="w3-hide-small" style="font-size:0.8em;background-color:transparent;padding:3px;border-radius:8%;width:;color:gray;">0</span></span>');
  
  $.getJSON('xd-modules/agent-module/backend/currentRota.php',function(data){
    $('.invoicesSelect0').empty();
    $('.invoicesSelect0').append('<option value="All" class="invoicesSelect004">All Invoices</option>');
    $.each(data.freelancedetails, function(i,cyberdesk) {
      $('.invoicesSelect0').append('<option class="invoicesSelect004" value="'+cyberdesk.rota_code+'">'+cyberdesk.name+'</option>');
      });
  // this script trims long title texts
  $('.invoicesSelect004').each(function() {
    var title = $(this).text();
    if (title.length > 14) {
    title = title.substr(0, 14) + '...';    
    }
    $(this).text(title);
  });

  });

  $('#sub_top_nav').empty();
  $('#sub_top_nav').append('<div class="w3-col l12 m12 s12 w3-center" style="height:30px;background-color:#eee;margin-top:-1px;border-bottom:1px solid aliceblue;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input id="searchAgentInvoices" type="text" placeholder="Search invoices..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgb(95, 44, 62);font-size:1.3em"></span></div></div>');
  $('#sub_top_nav').append('<ul id="tabs" class="tabs"><li class="invoices0" style="color:rgba(96, 146, 205,1);background-color:#fff;border:1px solid rgba(96, 146, 205,1);border-radius:10px;">Invoices</li><li class="trasactions0">Trasactions</li><li  class="collectionSummary101">Summary</li><li  class="deposits0">Deposit</li><li class="revenueTasks">Tasks</li></ul>');
  $('#right_nav_options0').empty();
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');

  $.getJSON('xd-modules/agent-module/backend/due_invoices.php',function(data){

    if(data.details=='No Data'){

   //alert('No Data');
   $('#main-body').empty();
   $('#main-body').append('<center style="margin-top:17%;"><p>You have no invoices. Click the transact button to start make a trasaction.</p></center>');
   transactions();
   
  }else{
      $('#main-body').empty();
      $('#record01').empty();
      $('#record01').append('<span>K'+data.total+' ('+data.numofrows+')</span>');
     //  $('#main-body').append('</br></br>');
      $.each(data.details,function(i,cyberdesk) {
     $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:400;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
    });
    }



});

 }

  //  SEARCH invoices
$(document).on('change keyup','#searchAgentInvoices',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($("#searchAgentInvoices").val()=='') {	
	invoicing();
  } else{
   var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $("#searchAgentInvoices").val();
	  //var key45 = ($("#searchKey45").text());	 
	 datastring='searchKey='+searchKey+'&searchCategory='+searchCategory;
   $('#main-body').empty(); 
   $('#main-body').append('<center><div class="body-loader"></div><br/></center>');
 
			 
	 $.ajax({
				  
		   data:datastring,
	   url: "xd-modules/agent-module/backend/searchDueInvoices.php",
		   type: "POST"
	   
	  }).done (function(data) {

	   $('#main-body').empty();  
	  var details0 = JSON.parse(data); 
    $('#main-body').empty();
    //record01
    $('#record01').empty();
    $('#record01').append('<span>K'+details0.total+' ('+details0.numofrows+')</span>');
 
    if(details0.numofrows>0){
     // $('#main-body').append('</br></br>');
      $.each(details0.details,function(i,cyberdesk) {
    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:400;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
    });
    }else{
      $('#main-body').append('<center><p style="margin-top:20%">There are no results for your search.</p></center>');
    }
 
	}); 	
	

  } 
    
});
// end of SEARCH invoices
// SELECT IVOICES CATEGORIES 
$(document).on('change keyup','.invoicesSelect0',function (event) {
  var searchCategory = $(".invoicesSelect0").val(); 
  //  alert(searchCategory);
  datastring='searchCategory='+searchCategory;
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');
  
  $.ajax({
      
  data:datastring,
  url: "xd-modules/agent-module/backend/searchDueInvoicesByCategory.php",
  type: "POST"
  
  }).done (function(data) {
  $('#main-body').empty();  
  var details0 = JSON.parse(data);
  //alert(details.numofrows);
  // alert(details0.details);
  //var details1 = JSON.stringify(details.freelancedetails);
  $('#main-body').empty();
  //record01
  $('#record01').empty();
  $('#record01').append('<span>K'+details0.total+' ('+details0.numofrows+')</span>');
  
  if(details0.numofrows>0){
  $('#main-body').append('</br></br>');
  $.each(details0.details,function(i,cyberdesk) {
    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:600;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
  });
  }else{
  $('#main-body').append('<center><p style="margin-top:20%">There are no results for your search.</p></center>');
  }
  
  
  }); 
  
  });
  //ed of SELECT IVOICE CATEGORY
  $(document).on('click', '.invoiceTransactions0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var productname = $(this).data('productname');
     var names = $(this).data('names');
    // var companyname = $(this).data('companyname');
    var userid = $(this).data('userid');
    $('#generalmodalLarge').fadeIn('slow');
    $('#generalmodalLargeMainDiv').hide();
    //$('#generalmodalLarge').append();
    $('#generalmodalLarge').append('<div id="tempDiv00"></div>');
    $('#tempDiv00').append('<div class="w3-top" style="height:50px;width:100%;color:#eee;background-color:rgba(96, 146, 205,1);"><div class="w3-col l1 m1 s1" style="margin-top:12px;"><span class="fontx fx-arrow-left closeLargeModal99" style="font-size:1.6em;cursor:pointer;float:left;padding-left:10px;"></span></div><div class="w3-col l10 m10 s10"><div id="userTitle93" class="w3-col l12 m12 s12" style="text-transform:uppercase;float:left;"></div><div id="productTitle93" class="w3-col l12 m12 s12"></div></div><div class="w3-col l1 m1 s1" style="margin-top:12px;"><span class="fontx fx-more-vertical" style="font-size:1.6em;cursor:pointer;float:right;"></span><span id="productuserid93" style="display:none"></span></div></div>');
    $('#tempDiv00').append('<div class="w3-top w3-center" style="height:30px;background-color:#eee;margin-top:50px;border-bottom:1px solid aliceblue;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input id="searchInvoiceTrasactions" type="text" placeholder="Search invoice transactions..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgb(95, 44, 62);font-size:1.3em"></span></div></div>');
   $('#tempDiv00').append('<div id="tempTransactionsDiv" class="w3-col l12 m12 s12" style="background-color:#fff;height:100vh;margin-top:-50px;padding-top:80px"><center><div class="body-loader"></div><br/></center></div>')
  $('#userTitle93').empty();
   $('#userTitle93').append(names);
   $('#productTitle93').empty();
   $('#productTitle93').append(productname);
   $('#productuserid93').empty();
   $('#productuserid93').append(userid);
  
   if(productname=='' && userid=='') {	
    // do nothing
    } else{
     //var searchKey = $("#searchInvoices0").val();
      //var key45 = ($("#searchKey45").text());	 
     datastring='productname='+productname+'&userid='+userid;
         
     $.ajax({
            
         data:datastring,
       url: "xd-modules/agent-module/backend/invoiceTransactions.php",
         type: "POST"
      }).done (function(data) {
  
        $('#tempTransactionsDiv').empty();
      var details = JSON.parse(data);
      var details1 = JSON.stringify(details.freelancedetails);
      //alert(details.numofrows);
      var arr = JSON.parse(details1);
     for (i in arr) {
     var companyname= arr[i].cfname;
     var clientname= arr[i].clname;
     var payment_mode= arr[i].payment_mode;
     var transaction_date= arr[i].transaction_date;
     var transaction_time= arr[i].transaction_time;
     //var invoiceNumber= arr[i].invoiceNumber;
     var cphone= arr[i].cphone;
     var cemail= arr[i].cemail;
     var delivery_address= arr[i].delivery_address;
     var receipt_date= arr[i].receipt_date;
     var user_id = arr[i].user_id;
     var businessCategory = arr[i].business_category;
     var transaction_status = arr[i].transaction_status;
     var transaction_reference = arr[i].transaction_reference;
     var area = arr[i].area;
     var plot_no = arr[i].plot_no;
     var receipt_no = arr[i].receipt_no;
     var bank_name = arr[i].bank_name;
     var bank_account_name = arr[i].bank_account_name;
     var bank_deposit_slip = arr[i].bank_deposit_slip;
     var bank_deposit_id = arr[i].bank_deposit_id;
    
     //alert(payment_mode);
    var detailsxy = JSON.parse(arr[i].order_details);
     // alert(detailsxy);
    
    // $('#tempTransactionsDiv').append('<br/>');
      for (i in detailsxy) {
    //	alert(detailsxy[i].name);
    if(payment_mode=='BANK'){
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span><span class="fontx fx-file-text bankdepositslip0" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-bankname="'+bank_name+'" data-bankaccountname="'+bank_account_name+'" data-bankdepositslip="'+bank_deposit_slip+'" data-bankdepositid="'+bank_deposit_id+'" style="margin-right:7px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }else{
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }
    
      }
    }
      
     
    }); 	
    
    
  
    } 
    
  });
  // searchInvoiceTrasactions
  // search products or chart of A/C
  $(document).on('change keyup','#searchInvoiceTrasactions',function (event) {
    event.preventDefault(); 
    event.stopPropagation();  
    if($("#searchInvoiceTrasactions").val()=='') {	
    //addInvoicedItem();
    } else{
     //var searchCategory = $(".invoicesSelect0").val();
     var searchKey = $("#searchInvoiceTrasactions").val(); 
     var productuserid = $("#productuserid93").html();
     var productTitle = $("#productTitle93").html();
     datastring='searchKey='+searchKey+'&productuserid='+productuserid+'&productTitle='+productTitle;
     $('#tempTransactionsDiv').empty(); 
     $('#tempTransactionsDiv').append('<center><div class="body-loader"></div><br/></center>');
        
     $.ajax({
            
         data:datastring,
       url: "xd-modules/agent-module/backend/searchInvoiceTrasactions.php",
         type: "POST"
       
      }).done (function(data) {
    
       $('#tempTransactionsDiv').empty();
      var details = JSON.parse(data);
      var details1 = JSON.stringify(details.freelancedetails);
      //alert(details.numofrows);
      var arr = JSON.parse(details1);
     for (i in arr) {
     var companyname= arr[i].cfname;
     var clientname= arr[i].clname;
     var payment_mode= arr[i].payment_mode;
     var transaction_date= arr[i].transaction_date;
     var transaction_time= arr[i].transaction_time;
     var invoiceNumber= arr[i].invoiceNumber;
     var cphone= arr[i].cphone;
     var cemail= arr[i].cemail;
     var delivery_address= arr[i].delivery_address;
     var receipt_date= arr[i].receipt_date;
     var user_id = arr[i].user_id;
     var businessCategory = arr[i].business_category;
     var transaction_status = arr[i].transaction_status;
     var transaction_reference = arr[i].transaction_reference;
     var area = arr[i].area;
     var plot_no = arr[i].plot_no;
     var receipt_no = arr[i].receipt_no;
     var bank_name = arr[i].bank_name;
     var bank_account_name = arr[i].bank_account_name;
     var bank_deposit_slip = arr[i].bank_deposit_slip;
     var bank_deposit_id = arr[i].bank_deposit_id;
    
     //alert(payment_mode);
    var detailsxy = JSON.parse(arr[i].order_details);
     // alert(detailsxy);
    
    // $('#tempTransactionsDiv').append('<br/>');
      for (i in detailsxy) {
    //	alert(detailsxy[i].name);
    if(payment_mode=='BANK'){
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span><span class="fontx fx-file-text bankdepositslip0" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-bankname="'+bank_name+'" data-bankaccountname="'+bank_account_name+'" data-bankdepositslip="'+bank_deposit_slip+'" data-bankdepositid="'+bank_deposit_id+'" style="margin-right:7px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }else{
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }
    
      }
    }
     
    }); 	
    
    
  
    } 
    
        
  });
  // end of search products or chart of A/C
  
    // selectig mode of paymet
     $(document).on('change keyup','#modeOfPayment',function (event) {
	   var modeOfPayment = $("#modeOfPayment").val(); 
        
      if(modeOfPayment=="CASH"){
        //   $('.dropdown').show();
          $('#payment-btns-div01').show();
          $('#payment-btns01').empty();
          $('#payment-btns01').append('<center><div class="cashTransact01 w3-col" style="font-weight: 600;height:40px;width:100%;line-height: 40px;"><span class="fontx fx-dollar"></span> Cash Transact</div></center>');
        //  $('.paymentBtnsDiv012').empty();
        // $('.paymentBtnsDiv012').append('<div class="cashTransact01" style="font-weight: 600;height:30px;line-height: 30px;float:right;background-color:#eee;color:rgba(96, 146, 205,1);margin-top:3px;margin-right:12px;border-radius:3px;padding-right:5px; padding-left:5px;cursor:pointer"> Cash Trasact</div>');
        $('#bankNameDiv0').hide();
        $('#bankDepositSlipIdDiv').hide();
        }else if(modeOfPayment=="BANK"){
               
           $('#payment-btns-div01').show();
          $('#payment-btns01').empty();
          $('#payment-btns01').append('<div style="height:40px;width:100%;color:#eee;background-color:rgba(96, 146, 205,1);padding:5px;"><div class="w3-col l6 m6 s6 custom-file"  style="border-right:1px solid #eee;height:40px;"><input type="file" class="custom-file__input" id="field-upload" name="field-upload" required><label class="custom-file__label fontx fx-file-plus" for="field-upload">Select File</label></div><div class="w3-col l6 m6 s6 bankTransact0" style="cursor:pointer;margin-top:-5px;font-size:1.3em;font-weight:400"><span class="fontx fx-archive"></span> Transact</div></div></div>');

          $('#bankNameDiv0').fadeIn('slow');
          $('#bankDepositSlipIdDiv').fadeIn('slow');
          $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
 
            $('#bankName').empty();
            $.each(data.details, function(i,cyberdesk) {
            $('#bankName').append('<option value="'+cyberdesk.account_name+'" data-accountnumber="'+cyberdesk.account_number+'">'+cyberdesk.account_name+'</option>');
            });
             
            });

           $('.bankInvoiceDetailsDiv').fadeOut('slow');
           $('.bankInvoiceDetailsDiv0').fadeIn('slow');

            }else if(modeOfPayment=="MOMO"){
              
              $('#payment-btns-div01').show();
              $('#payment-btns01').empty();
              $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:40px;width:100%;line-height: 40px;"><span class="fontx fx-tablet"></span> Mobile Transact</div></center>');
              $('#bankNameDiv0').hide();
              $('#bankDepositSlipIdDiv').hide();
            }
    });


// close large modal
$(document).on('click','.closeLargeModal99',function (event) {
  $('#tempDiv00').remove();
  $('#generalmodalLarge').fadeOut();
 $('#generalmodalLargeMainDiv').show();
});

//bankrefid
$(document).on('click', '.bankdepositslip0', function(event){
  event.preventDefault();
  event.stopPropagation();
  var bankname = $(this).data('bankname');
  var bankaccountname = $(this).data('bankaccountname');
  var bankdepositslip = $(this).data('bankdepositslip');
  var bankdepositid = $(this).data('bankdepositid');
  $('#generalmodalLarge').fadeIn('slow');
  $('#div_title342').empty();
	$('#div_title342').append('<h4 style="margin-top:-7px;font-weight:600;">DEPOSIT SLIP DETAILS</h4>');
	$('#div_body342').empty();
  $('#div_body342').append('<b>'+bankname+'</b>: <span>'+bankaccountname+'</span><br/>');
  $('#div_body342').append('<b>Referece Id</b>: <span>'+bankdepositid+'</span>');
  $('#div_body342').append('<img src="xd-uploads/documents/deposits-slips/'+bankdepositslip+'" style="margin-top:20px;height:500px;width:100%;"/>');
  //$('#div_body342').append('<p id="closeModal876" style="background-color:transparent;color:green;height:35px;line-height:30px;width:100px;border-radius:15px;border:2px solid green;font-weight:600;cursor:pointer;">Send</p>');

});




// invoicePayment0
$(document).on('click','.reprintReceipt0',function (event) { 
  // alert('Reprint charge @K20 will apply!');
   event.preventDefault();
   event.stopPropagation(); 
   $('#transact_modal').fadeIn('slow');
   $('#invoiceType').empty();
   $('#invoiceType').append('<option value="REPRINT"> RECEIPT <span style="color:red;"> (REPRINT)</span></option>');
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
  
   var invoicenumber = $(this).data('invoicenumber');
   var payment_mode = $(this).data('paymentmode');
   var bankname = $(this).data('bankname');
   var bankdepositslip = $(this).data('bankdepositslip');

   if(payment_mode=='CASH'){ 
$('#modeOfPayment').empty();
$('#modeOfPayment').append('<option value="CASH">Cash</option>');

   }else if(payment_mode=='BANK'){
    $('#modeOfPayment').empty();
    $('#modeOfPayment').append('<option value="BANK">Bank Deposit</option>');
    $('#bankName').empty();
    $('#bankName').append('<option value="'+bankname+'">'+bankname+'</option>');
     document.getElementById('bankDepositSlipId').value ='';
    document.getElementById('bankDepositSlipId').value = bankdepositslip;

   }

   shoppingCart.clearCart();
   $('.'+invoicenumber+'').each(function() { 
   // alert(productname2);
    var id = $(this).data('productid'); 
    var name = $(this).data('productname');
    var price = $(this).data('productprice');
   ///alert(id);alert(name);alert(price);
   
    var category = ($(this).data('category'));
      var categorycode = ($(this).data('categorycode'));
    var productcode = ($(this).data('productcode'));
    var depot = $(this).data('depot');
    var depotid= ($(this).data('depotid'));
    var depotcode = ($(this).data('depotcode'));  
 
   shoppingCart.addItemToCart(name, price, 1, id,  productcode, category, categorycode,depot,depotid,depotcode);
  displayCart();
  
    shoppingCart.addItemToCart(name, price, 1, id);

    displayCart();
 
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(invoicenumber);
     var clientname = $(this).data('names');
     var companyname = $(this).data('companyname');
     var phone = $(this).data('phone');
     var email = $(this).data('cemail');
     //alert(email);
     var address = $(this).data('address');
     var userid = $(this).data('userid');
     var transactiontime = $(this).data('transactiontime');
     var transactiondate = $(this).data('transactiondate');
     
    var pacra =$(this).data('pacra');
     var plotnumber =$(this).data('plotnumber');
     var area = $(this).data('area');
     var nrc = $(this).data('nrc');
     var tpin =$(this).data('tpin');
     var businessCategory=$(this).data('businesscategory');
    
   $('#productid').empty();
   $('#productid').append(id);
   $('#addInvoicedItemDiv').empty();
   $('#addInvoicedItemDiv').append('<span style="float:left;margin-left:7px;cursor: pointer;">Product/Service </span>');
   $('#addInvoiceClientDiv').empty();
   $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
  // document.getElementById('invoicedClientName0').value='';
   if(companyname==''){
        //document.getElementById('invoicedClientName0').value=clientname;
        $('.invoicedClientName0Div').empty();
        $('.invoicedClientName0Div').append('<input id="invoicedClientName0" value="'+clientname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
        
   }else{
    // document.getElementById('invoicedClientName0').value=companyname;
     $('.invoicedClientName0Div').empty();
     $('.invoicedClientName0Div').append('<input id="invoicedClientName0" value="'+companyname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
    }

   $('#invoicedClientName1').empty();
   $('#invoicedClientName1').append(clientname);
   $('.plotnumber07Div').empty();
   $('.plotnumber07Div').append('<input id="plotnumber07" value="'+plotnumber+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;width:100px;" readonly/>');
   $('.plotnumber07Div').append('<input id="invoicedClientAddress0" value="'+address+'" type="address" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
   $('.plotnumber07Div').append('<input id="area07" value="'+area+'" type="text" class="w3-hide-small" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
  // $('#invoicedClientAddress0').empty();
   //$('#invoicedClientAddress0').append(address);
  // $('#plotnumber07').empty();
  // $('#plotnumber07').append(plotnumber);
  // $('#area07').empty();
  // $('#area07').append(area); 
   
   $('.nrc07Div').empty();
    $('.nrc07Div').append('<input id="nrc07" value="'+nrc+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;" readonly/>');
    //$('#nrc07').empty();
   //$('#nrc07').append(nrc);

  // $('#invoicedClientEmail0').empty();
  // $('#invoicedClientEmail0').append(email); 
   $('.invoicedClientEmail0Div').empty();
   $('.invoicedClientEmail0Div').append('<input id="invoicedClientEmail0" value="'+email+'" type="email"  style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
   $('.invoicedClientEmail0Div').append('<input id="invoicedClientPhone0" value="'+phone+'" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;" readonly/>');
    
   $('#invoicedClientId0').empty();
   $('#invoicedClientId0').append(userid);
   $('#pacra00').empty();
   $('#pacra00').append(pacra); 
   $('#tpin00').empty();
   $('#tpin00').append(tpin); 
   $('#businesscategory00').empty();
   $('#businesscategory00').append(businessCategory); 
   //document.getElementById('invoicedClientPhone0').value ='';
  // document.getElementById('invoicedClientPhone0').value = phone;

   document.getElementById('invoiceDueDate').value ='';
   document.getElementById('invoiceDueDate').value = transactiondate;
   document.getElementById('trasactionTime34').value ='';
   document.getElementById('trasactionTime34').value = transactiontime;

  });
  // GETTIG REPRIT CHARGE
  $.getJSON('xd-modules/cashier-module/backend/reprintCharge.php',function(data){

    $('#paymentresponseDivBottom').empty();
    $('#payment-btns01').show();
    $('#payment-btns01').empty();
     $.each(data.freelancedetails, function(i,cyberdesk) {
    $('#payment-btns01').append('<center><div id="cashReprintTransact0" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.name+'" data-productcode="'+cyberdesk.product_code+'" data-price="'+cyberdesk.price+'" style="font-weight: 600;height:35px;line-height: 30px;">Click To Re-print (@ K'+cyberdesk.price+')</div></center>');
     
  });
   
      });

});

$(document).on('click','#reverseTransaction0',function (event) {
	event.preventDefault();
   event.stopPropagation();
   alert('Reversal not activated');
});



  //paymentresponseDivBottom
  $(document).on('click','.printDivOnClick',function (event){
    //invoicing();
    window.print();

    //shoppingCart.clearCart();
   // $('#transact_modal').fadeOut('slow');
  //  $("#paymentresponseDivTop").empty();
   // $("#paymentresponseDivTop").hide();
  // $("#paymentresponseDivBottom").empty();
  //  $("#paymentresponseDivBottom").hide();
    $("#topInvoiceNavContents").show();
    $("#payment-btns01").empty();
    $("#payment-btns01").hide();
   // $('#plotnumber07').empty();
   //$('#area07').empty();
   // $('#nrc07').empty();
  //  document.getElementsByClassName('carddetailsinput').value ='';
    //clear-cart
    //shoppingCart.clearCart();
    //displayCart();

    setTimeout(function(){
     //location.reload(); 
    // $("#paymentresponseDivBottom").empty();
     // $("#paymentresponseDivBottom").hide();
     $("payment-btns01").show();
     $("paymentresponseDivBottom").hide();
      //document.getElementById('invoiceDueDate').value ='';
      //document.getElementById('invoiceDueDate').value = today;
      $('#printReceiptDiv102').empty();
      $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
     
    }, 800);
  

  });


  // MOMO TRANSACTION

  $(document).on('click', '.momoTransact0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var amount = $('.total-cart').html();
   // var userid = $("#invoicedClientId0").html();
    var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10);  // Fetch and convert to integer

    var fname = $("#invoicedClientName0").val();
    var lname =  $("#invoicedClientName1").html();
    var email = $("#invoicedClientEmail0").val();
    var productid = $("#productid").html();
    var deliveryaddress = $("#invoicedClientAddress0").val();
    var pacra = $("#pacra00").html(); 
    var tpin = $("#tpin00").html(); 
    var businessCategory = $("#businesscategory00").html();
    var plotnumber = $("#plotnumber07").val(); 
    var area = $("#area07").val(); 
    var nrc = $("#nrc07").val();
    var transtype = $("#invoiceType").val();
    var phone =  $("#invoicedClientPhone0").val();
    var invoiceNumber= $("#invoiceNumber").html();
    var invoiceDueDate= $("#invoiceDueDate").val();
    var deliverylat = $('#lat0').val();
    var deliverylng = $('#lng0').val();   
    var cartlist = shoppingCart.listCart();
    var cartlistDetails = JSON.stringify(cartlist);
    

		if(phone != '' && cartlistDetails != '')
		{
      datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
		   
	    $.ajax({
				 					
	        data:datastring,
			url: "xd-modules/payment-processing/momoPay.php",
	        type: "POST"	
				
	    }).done (function(data) {
			  
			 var newdata = JSON.parse(data);
			
    $("#topInvoiceNavContents").hide();
    $("#payment-btns01").hide(); 
    $("#paymentresponseDivTop").show();
    $("#paymentresponseDivTop").append('<center><span class="w3-col l12 s12 m12" style="color:black;font-weight:600;" id="topResponse98" class="w3-animate-fading">Please wait!</span><span class="w3-col l12 s12 m12" style="color:black;font-weight:600;"> <span id="transactioReferenceStorage01"></span></span></center>');
    $("#paymentresponseDivBottom").empty();
    $("#paymentresponseDivBottom").show();
    $("#paymentresponseDivBottom").append('<center><div id="container_count_down">Wait for prompt in: <div id="countdown"><span id="timer"></span></div></center>');
   
    function cntDown() {
      let sec = 45;
      const el = document.getElementById("timer");
      const timer = setInterval(() => {
        el.innerHTML = sec--;
        if (sec < 15) el.style.color = "#ff0";
        if (sec < 7) el.style.color = "#f00";
        if (sec < 0){
          clearInterval(timer);
          $("#paymentresponseDivBottom").empty();
          $("#paymentresponseDivBottom").append('<center><a href="" style="width:100%;height:30px;">Click to try again!</a></center>');
         
        }
      }, 1000);
    }
   
    cntDown();
    
			 $('#transactioReferenceStorage01').empty();
			 $('#transactioReferenceStorage01').append(newdata.transactionReference);
			 //var reference = ;
			 
			 
	 setInterval(function(){
                
                      var tref = $('#transactioReferenceStorage01').html();
		
                   if(tref != ''){
					 
						datastring='tref='+tref;

						$.ajax({

						data:datastring,
						url: "xd-modules/payment-processing/verifyPayment.php",
						type: "POST"	

						}).done (function(data) {

						 var newdata = JSON.parse(data);
						 
						  //alert(data);
                          // alert(newdata.transaction_status);
						  
							$.each(newdata.details, function(i,cyberdesk) {
 
     if(cyberdesk.transaction_status == 'approved'){
 
      $("#paymentresponseDivTop").show();
      $("#topResponse98").empty();
     $("#transactioReferenceStorage01").empty();
     $("#topResponse98").remove();
     $("#transactioReferenceStorage01").remove();

     $("#paymentresponseDivBottom").empty();
     $("#paymentresponseDivBottom").show();
     $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:30px;">Success. Print receipt!</span></center>');
       $("#topResponse98").empty();
    
      $("#topInvoiceNavContents").hide();
      $('#invoiceNumber').empty();
      $('#invoiceNumber').append(cyberdesk.receipt_no);
     document.getElementById('invoiceDueDate').value ='';
     document.getElementById('invoiceDueDate').value =cyberdesk.transaction_date;
     document.getElementById('trasactionTime34').value = '';
	   document.getElementById('trasactionTime34').value = cyberdesk.transaction_time;
      $("#payment-btns01").empty(); 
      $("#payment-btns01").hide();
      
      // print the documet
      setTimeout(function(){ 
     // window.print(); 
      }, 100);
      // print the documet

      setTimeout(function(){ 
     
        // clearing client data
        $('.clearOnTransactionSuccess').each(function() {
          if (this.tagName === 'INPUT') {
              $(this).val('');
          } else if (this.tagName === 'SPAN') {
              $(this).empty();
          }
      });
    
      // starating another transaction
      transact101();
      
      // showing the transact button  
      $('#payment-btns-div01').show();
      $('#payment-btns01').empty();
      $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">Mobile Money Transact</div></center>');
        $('#modeOfPayment').empty(); 
        $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="BANK">Bank Deposit</option><option value="CASH">Cash Payment</option>'); 
       
      }, 700);


      setTimeout(function(){ 
      $("#topInvoiceNavContents").show();
      }, 700);


	} else if(cyberdesk.transaction_status == 'failed'){
                    
    $("#topInvoiceNavContents").hide();
    $("#topResponse98").empty();
    $("#topResponse98").append('Payment failed!');  
    $("#payment-btns01").hide();
    $("#paymentresponseDivBottom").empty();
    $("#paymentresponseDivBottom").show();
    $("#paymentresponseDivBottom").append('<center><a href="" style="width:100%;height:30px;">Failed please try again!</a></center>');
   
    }
 
							
	});
						  
						}); 
			 
					}else{
						
						
					}
				 

             }, 6000);
     //console.log(newdata.transactionReference);
		 
				  
		}); 	
		
		 
		}
		else
		{
		
		    location.reload();
         alert('Please fill in all data!');
		}
		
		
	});
  //MOMO TRASACTIO


  
// CASH TRASACTION PAYMENT
$(document).on('click', '.cashTransact01', function(event) {
  event.preventDefault();
  event.stopPropagation();
  $('.bankAccoutDiv101').hide(); 
  // Gather data for the transaction
  var amount = $('.total-cart').html();
 // var userid = $("#invoicedClientId0").html();
  var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10);  // Fetch and convert to integer

 // alert(userid);
  var fname = $("#invoicedClientName0").val();
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone = $("#invoicedClientPhone0").val();
  var invoiceNumber = $("#invoiceNumber").html();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
  if (phone != '' && cartlistDetails != '') {
      var datastring = 'userid=' + userid + '&phone=' + phone + '&fname=' + fname + '&lname=' + lname +
                       '&email=' + email + '&orderDetails=' + cartlistDetails + '&amount=' + amount +
                       '&deliverylat=' + deliverylat + '&deliverylng=' + deliverylng + '&deliveryaddress=' +
                       deliveryaddress + '&transtype=' + transtype + '&invoiceNumber=' + invoiceNumber +'&hiddenInvoiceNumber='+hiddenInvoiceNumber+
                       '&invoiceDueDate=' + invoiceDueDate + '&productid=' + productid + '&businessCategory=' +
                       businessCategory + '&pacra=' + pacra + '&tpin=' + tpin + '&plotnumber=' + plotnumber +
                       '&area=' + area + '&nrc=' + nrc;

      $.ajax({    
          data: datastring,
          url: "xd-modules/agent-module/backend/cashTransact.php",
          type: "POST"   
      }).done(function(data) {
          var response = JSON.parse(data);

          if (response.status == 'created') {
              // Clear and update invoice information
              $('#invoiceNumber').empty().append(response.receiptnumber);
              document.getElementById('invoiceDueDate').value = response.date;
              document.getElementById('trasactionTime34').value = response.time;
           
              $("#paymentresponseDivBottom").empty().show();
              $("#topInvoiceNavContents").hide();
              $('#payment-btns-div01').hide();
              // Printing the receipt
              setTimeout(function() { 
                  const modal = document.getElementById('transact_modal');
                  if (modal) {
                      modal.style.display = 'block'; // Ensure the modal is visible
                      window.print(); // Trigger the print dialog
                       
                     


                  } else {
                      alert('Modal not found!');
                  }
              }, 100);

              // CLEARING MODAL & USER DATA AFTER TRANSACTION SUCCESS
              setTimeout(function(){ 
             
                // clearing client data
                $('.clearOnTransactionSuccess').each(function() {
                  if (this.tagName === 'INPUT') {
                      $(this).val('');
                  } else if (this.tagName === 'SPAN') {
                      $(this).empty();
                  }
              });
              $('#payment-btns-div01').fadeIn('slow'); 
             $('.bankAccoutDiv101').hide(); 
          
                $("#topInvoiceNavContents").show();
                $('#printReceiptDiv102').empty();
               // $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
               
              }, 1000);


          } else {
              $("#paymentresponseDivBottom").empty().append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');
          }
      });
  } else {
      alert('Please fill in all data!');
  }
});



// CASH REPRIT CHARGE
$(document).on('click', '#cashReprintTransact0', function(event){
  event.preventDefault();
  event.stopPropagation();
  var amount = $(this).data('price');
  var userid = $("#invoicedClientId0").html();
  var fname = $("#invoicedClientName0").val();
  var lname =  $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $(this).data('id');
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone =  $("#invoicedClientPhone0").val();
  var invoiceDueDate= $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
  var invoiceNumber = (Math.floor(100000 + Math.random() * 900000));
  
 if(phone != '' && cartlistDetails != '')
 {
    datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
   
 $.ajax({    
     data:datastring,
 url: "xd-modules/agent-module/backend/cashReprintTransact.php",
     type: "POST"	
   
 }).done (function(data) {
  var response = JSON.parse(data);

  if(response.status=='created'){
    
   $("#topInvoiceNavContents").hide();
 // document.getElementById('invoiceDueDate').value ='';
  //document.getElementById('invoiceDueDate').value =response.date;
 // document.getElementById('trasactionTime34').value = '';
 // document.getElementById('trasactionTime34').value = response.time;
   $("#payment-btns01").empty(); 
   $("#payment-btns01").hide();
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   setTimeout(function(){ 
   window.print(); 
   }, 100);
   setTimeout(function(){ 
   $("#topInvoiceNavContents").show();
   }, 700);

  // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
 // $('#paymentresponseDivTop').fadeOut();


  }else{
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');

  }

   //console.log(newdata.transactionReference);

     
}); 	


}
else
{

   //location.reload();
    alert('Please fill in all data!');
}


}); 
//bankTransact0

 
/// TRANSACTING BY BANK ACCOUNT

$(document).on('click', '.bankTransact0', function(event) {
  event.preventDefault();
  event.stopPropagation();
  // Get the file input
  var fileInput = $('#field-upload');
  var file = fileInput[0].files[0]; // File may be undefined if no file is selected

  // Retrieve other necessary data
  var amount = $('.total-cart').html();
  var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10); // Fetch and convert to integer
  var fname = $("#invoicedClientName0").val();
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var productid = $("#productid").html();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone = $("#invoicedClientPhone0").val();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var bankDepositSlipId = $('#bankDepositSlipId').val();
  var bankAccountName = $('#bankName').val();
  var myBankAccountNumber44 = document.querySelector("#bankName option:checked").dataset.accountnumber;
  var bankName = $('#bankName').val();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);

  if (phone != '' && cartlistDetails != '' && bankDepositSlipId != '' && bankAccountName != '' && bankName != '' && myBankAccountNumber44 !='') {
      // Create FormData object for file and other data
      var formData = new FormData();
      
      // Only append the file if it exists
      if (file) {
          formData.append('field-upload', file);
      }

      formData.append('userid', userid);
      formData.append('phone', phone);
      formData.append('fname', fname);
      formData.append('lname', lname);
      formData.append('email', email);
      formData.append('orderDetails', cartlistDetails);
      formData.append('amount', amount);
      formData.append('deliverylat', deliverylat);
      formData.append('deliverylng', deliverylng);
      formData.append('deliveryaddress', deliveryaddress);
      formData.append('transtype', transtype);
      formData.append('invoiceDueDate', invoiceDueDate);
      formData.append('bankDepositSlipId', bankDepositSlipId);
      formData.append('bankAccountName', bankAccountName);
      formData.append('bankName', bankName);
      formData.append('productid', productid);
      formData.append('businessCategory', businessCategory);
      formData.append('pacra', pacra);
      formData.append('tpin', tpin);
      formData.append('plotnumber', plotnumber);
      formData.append('area', area);
      formData.append('nrc', nrc);
      formData.append('hiddenInvoiceNumber', hiddenInvoiceNumber);
      formData.append('myBankAccountNumber44', myBankAccountNumber44);
      
      // AJAX request with progress
      $.ajax({
          url: "xd-modules/agent-module/backend/bankTransact.php",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          xhr: function() {
              var xhr = new XMLHttpRequest();
              xhr.upload.addEventListener('progress', function(event) {
                  if (event.lengthComputable) {
                      var percentComplete = Math.round((event.loaded / event.total) * 100);
                      // Update the progress in the div
                      $('.bankTransact0').text('Uploading: ' + percentComplete + '%');
                  }
              }, false);
              return xhr;
          },
      }).done(function(data) {
          var response = JSON.parse(data);
          if (response.status == 'created') { 
              $("#topInvoiceNavContents").hide();
              $('#payment-btns-div01').hide();
              $('#invoiceNumber').empty();
              $('#invoiceNumber').append(response.receiptnumber);
              document.getElementById('invoiceDueDate').value = '';
              document.getElementById('invoiceDueDate').value = response.date;
              document.getElementById('trasactionTime34').value = '';
              document.getElementById('trasactionTime34').value = response.time;
               setTimeout(function(){ 
                  window.print(); 
              }, 200);

              setTimeout(function(){ 
                  // clearing client data
                  $('.clearOnTransactionSuccess').each(function() {
                      if (this.tagName === 'INPUT') {
                          $(this).val('');
                      } else if (this.tagName === 'SPAN') {
                          $(this).empty();
                      }
                  });
                  $('#payment-btns-div01').fadeIn('slow');
                  $('.bankTransact0').empty();
                  $('.bankTransact0').append('Submit'); 
                  $('#bankName').empty();
                  $('#bankName').append('<option>Select bank </option><option value="Zanaco main account">Zanaco main account</option><option value="Zanaco Development Account">Zanaco Development A/C</option><option value="Indo transit account">Indo transit account </option><option value="Indo Fire Account">Indo Fire Account</option><option value="Indo Waste Account">Indo Waste Account</option><option value="Indo Capital Account">Indo Capital Account</option><option value="Airtel money account">Airtel money account</option><option value="MTN Money Account">MTN Money Account</option>');
                  $('#bankNameDiv0').fadeIn('slow');
                  $('#bankDepositSlipIdDiv').fadeIn('slow');
                  $('#modeOfPayment').empty(); 
                  $('#modeOfPayment').append('<option value="BANK">Bank Deposit</option><option value="CASH">Cash Payment</option><option value="MOMO">Mobile Money</option>'); 
                  $("#topInvoiceNavContents").show();
                  $('#printReceiptDiv102').empty();
              }, 700);
          } else {
              $("#paymentresponseDivBottom").empty();
              $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Okay</span></center>');
          }
      });
  } else {
      alert('Please fill in all data!');
  }
});

//// END OF TRANSACTING BY BANK


//bankTransact02
$(document).on('submit', '#depositslipform', function(event){
  event.preventDefault();
  event.stopPropagation();
   var invoiceNumber01 = $('#invoiceNumber01').val();
   
  var extension = $('#imageInput').val().split('.').pop().toLowerCase();
   
  if(extension != ''){
      if(jQuery.inArray(extension, ['gif','png','jpg','jpeg']) == -1)
      {
          alert("Invalid Image File");
          $('#imageInput').val('');
          return false;
      }
  }	
    
  
  if(extension != '')
  {
   $('#payment-btns-div01').empty();
   $('#payment-btns-div01').append('<center><p>Uploading...</p></center>');
        
      $.ajax({
          url:"xd-modules/payment-processing/uploadDepositSlip.php",
          method:'POST',
          data:new FormData(this),
          contentType:false,
          processData:false,
          catche:false,
          success:function(data)
          {
          
          var postStatus = JSON.parse(data);
             
             
                if(postStatus.status=='uploaded'){
                
              $("#depositslipform").trigger('reset'); //jquery
              $("#topInvoiceNavContents").hide();
              $("#topResponse98").empty();
              $("#topResponse98").append('Payment succesful!');  
              $('#payment-btns-div01').empty();
              $('#payment-btns-div01').append('<a href="" id="closeDepositSlipProcess" class="w3-col l12 m12 s12" style="color:white;"><p style="background-color:white;width:100px;color:rgba(96, 146, 205,1);padding:7px;border-radius:4px;">CLose</p></a>');     
                  
            } else{
              $("#depositslipform").trigger('reset'); //jquery
              
              
             }
                     
              
              
                
          }
      });
  }
  else
  {
  
            // $('#upload_media_form0946').hide();
             $('#status44').empty();
             $('#status44').append('Please fill in all data!');
                
  }
});
/// opting out of uploadig deposit slip
$(document).on('click', '#bankTransact03', function(event){
 // alert('you can upload or capture deposit slip later ');
  shoppingCart.clearCart();
  displayCart();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
  setTimeout(function(){
   // location.reload();
	}, 500);
});
/// opting out of uploadig deposit slip

//closeDepositSlipProcess
$(document).on('click','#closeDepositSlipProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
  $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
//  $("#payment-btns-div0").hide();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  //clear-cart
  shoppingCart.clearCart();
  displayCart();
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 //$('#invoiceNumber').empty();
 //$('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});


//GET INVOICES DETAILS
$(document).on('click','#invoiceDetails0',function (event) {
	event.preventDefault(); 
	event.stopPropagation();  
	var id = $(this).data('id'); 
	var names = $(this).data('names');
	var address = $(this).data('address');
	 var email = $(this).data('email'); 
	 var phone = $(this).data('phone');
	 var due = $(this).data('due');
	 var amount = $(this).data('amount');
	//alert(id);alert(names);alert(email);

   $('#external_page_contents').empty(); 
    $('#external_page_contents').load('xd-modules/admin-modules/create_invoice.html',function() {
    $('#create_invoice_modal').fadeIn('slow');
	$('#addInvoicedItem0').hide();
	$('#addInvoicedItem0').hide();
	$('#invoicedClientId0').empty();
	$('#invoicedClientId0').append(id);
	$('#invoicedClientName0').empty();
	$('#invoicedClientName0').append(names);
	$('#invoicedClientAddress0').empty();
	$('#invoicedClientAddress0').append(address);
	$('#invoicedClientEmail0').empty();
	$('#invoicedClientEmail0').append(email);
	$('#invoicedClientPhone0').empty();
	$('#invoicedClientPhone0').append(phone);
	$('#invoicedClientId0').empty();
	$('#invoicedClientId0').append(id);
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(amount);
	$('#invoiceDueDate').val('');
	$('#invoiceDueDate').val(due);
	
	datastring='id='+id;
			   
	 $.ajax({
										 
		 data:datastring,
		 url: "xd-modules/accounts-module/backend/edit-product-service.php",
		 type: "POST"
	 
 
	 }).done (function(data) {
	 
	 
			 
	 }); 

   });
  

});
// Create Invoice 
$(document).on('click','#create_invoice0',function (event) {
	 
	event.preventDefault(); 
	event.stopPropagation();  
   $('#external_page_contents').empty(); 

    $('#external_page_contents').load('xd-modules/admin-modules/create_invoice.html',function() {
	 
	 $('#create_invoice_modal').fadeIn('slow');

	 var randReceipt=(Math.floor(100000 + Math.random() * 900000));
	 $('#invoiceNumber').empty();
	 $('#invoiceNumber').append(randReceipt);
	 let today = new Date().toLocaleDateString();
	 document.getElementById('invoiceDueDate').value ='';
	 document.getElementById('invoiceDueDate').value = today;

   });

});

//addInvoiceItem0
$(document).on('click','#addInvoiceClient0',function (event) {
	addInvoiceClient();
  });
  function addInvoiceClient() {
	   
   $('#invoiceAddClients').fadeIn('slow');
	$('.invoice_modal_contents345').fadeOut('slow');
  $('#backToInvoice0').remove();
	$('#invoiceAddClientsTopnav').empty();
	$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l10 m10 s10" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchUsersForReceiptInvoice" type="text" placeholder="Search clients..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0,0,0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l1 m1 s1" style="padding-top: 5px;"><span class="fontx fx-more-vertical" style="color:rgba(96, 146, 205,1);font-size:1.3em;"></span></div></div>');
	//$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top" style="background-color:rgba(96, 146, 205,1);height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:#fff;font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:#eee;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsForReceiptInvoice" type="text" placeholder="Search..." style="font-weight:400;outline:none;color:#eee;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:#eee;font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 5px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:#eee;padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:25px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.7em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a</div>');
	
  $('#invoiceAddClientsDiv08').empty(); 
   $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
   
   
		$.getJSON('xd-modules/agent-module/backend/allClients.php',function(data){

			$('#invoiceAddClientsDiv08').empty();
			$('#invoiceAddClientsDiv08').append('<br/>');
			$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
			$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
		$.each(data.freelancedetails, function(i,freelance) {
		  if(freelance.status=='active'){

			 $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" id="addInvoiceClient01" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
			 
		   }else{
		 //	there are no active clients or something 


		   }
		});

       //$('#invoiceAddClients').append('<div id="backToInvoice0" class="fontx fx-arrow-right" style="position:fixed;height:40px;width:40px;border-radius:50%;color:#fff;background-color: rgba(96, 146, 205,1);line-height:40px;right:10%;bottom:8%;cursor: pointer;"></div></div>');
		
	});

};

// SEARCH USERS SCRIPT
//searchUsers.php

$(document).on('change keyup','.searchUsersForReceiptInvoice',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchUsersForReceiptInvoice").val()=='') {	
	addInvoiceClient()
  } else{
   //var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $(".searchUsersForReceiptInvoice").val(); 
	 datastring='searchKey='+searchKey;
	 $('#invoiceAddClientsDiv08').empty(); 
	 $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
	 	 
	 $.ajax({
				  
		   data:datastring,
	   url: "xd-modules/agent-module/backend/searchUsers.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
	  $('#invoiceAddClientsDiv08').empty(); 
	  $('#invoiceAddClientsDiv08').append('<br/>');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
  
	$.each(details0.details, function(i,freelance) {
	//	$('#invoiceAddClientsDiv08').append('<div id="'+freelance.id+'" class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;border-bottom:1px solid #eee;"><div class="w3-col l11 m11 s9"><span class="w3-col l3 m3 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' ('+freelance.business_category+')</span> <span class="w3-col l12 m12 s12" style="color:gray;">'+freelance.names+' ('+freelance.nrc+')</span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l12 m12 s12"><b>PACRA:</b> <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l12 m12 s12"><b>TPIN:</b> <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span><span class="w3-col l2 m2 s12" style="padding-left:7px;"><span class="w3-col l12 m12 s12"> '+freelance.email+'</span><span class="w3-col l12 m12 s12"> '+freelance.phone+'</span></span><span class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="padding-left:10px;"> '+freelance.address+'</span><span class="w3-col l12 m12 s12" style="padding-left:10px;"> '+freelance.plot_number+' '+freelance.area+'</span></span><span id="addInvoiceClient01" class="w3-col l1 m1 s12" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'"><a href="#" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:17px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;line-height:20px;">Add</a></span></div></div>');
  $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" id="addInvoiceClient01" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
			 	   
	  });
	 
	}); 	
	
	

  } 
  
		  
});
//backToInvoiceItem0
$(document).on('click','#backToInvoice0',function (event) { 
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');

});
//close_create_invoice_modal
$(document).on('click','#close_create_invoice_modal',function (event) { 
	$('#create_invoice_modal').fadeOut('slow');
	 
});
$(document).on('click','.close_invoiceAddClients_div',function (event) {
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');		  
});
//addInvoiceClient01
$(document).on('click','#addInvoiceClient01',function (event) { 
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');
	var id = $(this).data('id'); 
	var names = $(this).data('names');
	var companyname = $(this).data('orgname');
	var address = $(this).data('address');
	 var email = $(this).data('email'); 
	 var phone = $(this).data('phone'); 
	 var pacra =$(this).data('pacra');
	 var tpin =$(this).data('tpin');
	 var nrc = $(this).data('nrc'); 
	 var area =$(this).data('pacra');
	 var plotnumber =$(this).data('plotnumber');
	 var businessCategory=$(this).data('businesscategory');
	 //var plotnumber =$(this).data('tpin');
	 $('#invoicedClientId0').empty();
	 $('#invoicedClientId0').append(id);
	 document.getElementById('invoicedClientName0').vallue='';
	 document.getElementById('invoicedClientName0').value=companyname;
	 $('#invoicedClientName1').empty();
	 $('#invoicedClientName1').append(names);
   document.getElementById('invoicedClientAddress0').value='';
	 document.getElementById('invoicedClientAddress0').value=address;
	 document.getElementById('plotnumber07').value='';
	 document.getElementById('plotnumber07').value= plotnumber;
	 document.getElementById('area07').value='';
	 document.getElementById('area07').value=area;
   document.getElementById('nrc07').vallue='';
	 document.getElementById('nrc07').vallue=nrc;
	 document.getElementById('invoicedClientEmail0').value='';
	 document.getElementById('invoicedClientEmail0').value=email;
	  $('#invoicedClientId0').empty();
	 $('#invoicedClientId0').append(id);
	 $('#pacra00').empty();
	 $('#pacra00').append(pacra); 
	 $('#tpin00').empty();
	 $('#tpin00').append(tpin); 
	 $('#businesscategory00').empty();
	 $('#businesscategory00').append(businessCategory);
	document.getElementById('invoicedClientPhone0').value ='';
	document.getElementById('invoicedClientPhone0').value = phone;
		
});

//addInvoicedItem0
$(document).on('click','#addInvoicedItem0',function (event) {
	addInvoicedItem();
  });
  function addInvoicedItem() {	  
	$('#invoiceAddClients').fadeIn('slow'); 
 // var div34 = document.getElementById('transact_modal');
  document.getElementById('transact_modal').scroll({top:0,behavior:'smooth'});
 // div34.scrollTop = 0;
	$('.invoice_modal_contents345').fadeOut('slow');
	$('#invoiceAddClientsTopnav').empty();
	$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsForReceiptInvoice" type="text" placeholder="Search & add items to cart..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0, 0, 0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 0px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:rgba(96, 146, 205,1);padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:22px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.4em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a></div>');
	
  $('#invoiceAddClientsDiv08').empty(); 
   $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
   
   
   $.getJSON('xd-modules/cashier-module/backend/allProducts.php',function(data){
	$('#invoiceAddClientsDiv08').empty(); 
	$('#invoiceAddClientsDiv08').append('<br/>');
	$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');

 //$('#invoiceAddClientsDiv08').append('<center style="margin-top:17%;"><p>Unfortunately no products/services were added to your account. Contact your superiors!</p></center>');
     $.each(data.freelancedetails, function(i,freelance) {

      $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l4 m6 s12" style="padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
 
   });
 


	$('#invoiceAddClients').append('<div id="backToInvoice0" class="w3-bottom" style="position:fixed;height:40px;width:100%;color:#fff;background-color:rgba(96, 146, 205,1);line-height:40px;cursor: pointer;font-weight:600;">PROCEED <span class="fontx fx-arrow-right"></span></div></div>');
		

	});

};
// search products or chart of A/C
$(document).on('change keyup','.searchProductsForReceiptInvoice',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchProductsForReceiptInvoice").val()=='') {	
	addInvoicedItem();
  } else{
   //var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $(".searchProductsForReceiptInvoice").val(); 
	 datastring='searchKey='+searchKey;
	 $('#invoiceAddClientsDiv08').empty(); 
	 $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
	 	 
	 $.ajax({
				  
		   data:datastring,
	     url: "xd-modules/agent-module/backend/searchProducts.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
	  $('#invoiceAddClientsDiv08').empty(); 
	  $('#invoiceAddClientsDiv08').append('<br/>');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
  
	$.each(details0.details, function(i,freelance) {

   // $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" style="padding-left:7px;margin-top:3px;background-color:rgba(250,250,250);"><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">ID:</b>'+freelance.id+'</div><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Charge:</b>  '+freelance.price+'</div><div class="w3-col l2 m2 s12"><b style="color:black;">'+freelance.name+'</b></div><div class="w3-col l4 m4 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Desc:</b> '+freelance.description+'</a></div><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Status:</b> '+freelance.status+'</a></div><div class="w3-col l2 m2 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Timestamp:</b> '+freelance.datemodified+'</a></div><div class="w3-col l1 m1 s12"><span class="w3-hide-large w3-hide-medium" style="float:left;">K'+freelance.price+'</span><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'"  data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'"  data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;line-height:20px;cursor:pointer;"/></div></div>');
      $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l4 m6 s12" style="padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
 
	  });
	 
	}); 	
	
	

  } 
  
		  
});
// end of search products or chart of A/C




 //sum invoice
 $(document).on('click','#backToInvoice0',function (event) {

	var total = 0;
	$('.invoiceItemTotalPrice0').each(function(){
		total += parseFloat($(this).text().replace(/,/g,''))
	});
	//$('.total').text(total)
	//alert(total);
	$('#invoiceSubTotal').empty();
	$('#invoiceSubTotal').append(total);
	//invoiceTaxTotal0
	var taxPercent = total*0.10;
	$('#invoiceTaxTotal0').empty();
	$('#invoiceTaxTotal0').append(taxPercent);
    //invoiceTotal0
	var invoiceTotal = total-taxPercent;
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(invoiceTotal);
 
});

//CHANGING INVOICE UNITS AND SUMING UP THE TOTAL INVOICE

$(document).on('click','.invoiceItemDiv0',function (event) {

	var count = $(this).closest(".invoiceItemDiv0").find(".invoiceUnits0").val();
	var unitPrice = $(this).closest(".invoiceItemDiv0").find(".invoiceItemPrice0").html();
	var totalItemPrice = unitPrice*count;
	//alert(count);alert(totalItemPrice);
	$(this).closest(".invoiceItemDiv0").find(".invoiceItemTotalPrice0").empty();
	$(this).closest(".invoiceItemDiv0").find(".invoiceItemTotalPrice0").append(totalItemPrice);
	
	// NOW WE TOTAL UP THE INVOICE TOTAL PRICE FOR EACH ITEM
	var total = 0;
	$('.invoiceItemTotalPrice0').each(function(){
		total += parseFloat($(this).text().replace(/,/g,''))
	});
	//$('.total').text(total)
	//alert(total);
	$('#invoiceSubTotal').empty();
	$('#invoiceSubTotal').append(total);
	//invoiceTaxTotal0
	var taxPercent = total*0.10;
	$('#invoiceTaxTotal0').empty();
	$('#invoiceTaxTotal0').append(taxPercent);
	//invoiceTotal0
	var invoiceTotal = total-taxPercent;
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(invoiceTotal);
	
	});
	
//CHANGING INVOICE UNITS AND SUMING UP THE TOTAL INVOICE


/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
$(document).on('click', '.transactionPost0', function(event){
    event.preventDefault(); 
    event.stopPropagation();    
    $('#general-modal713').fadeIn('slow');
    $('#div_title341').empty();
    $('#div_title341').append('<p style="font-size:1.5em;margin-top:-20px;color:#7da6ff;">Post Transaction</p>');
    $('#div_body341').empty();
    $('#div_body341').append('<div><select type="text"  id="staffAgent12" name="staffAgent12" style="border:none;margin-top:10px;outline:none;background-color:transparent;max-width:300px" required><option value="">Select Staff/Revenue Collecttor</option></select></div>');
    $('#div_body341').append('<div><select type="text" id="addProduct34" name="addProduct34" style="border:none;margin-top:15px;outline:none;background-color:transparent;max-width:300px" required><option value="">Select Product/Chart of Account</option></select></div>');
   $('#div_body341').append('<div><select type="text" id="revenuePoint55" name="revenuePoint55" style="border:none;margin-top:15px;outline:none;background-color:transparent;max-width:300px" required><option value="">Select Revenue Point</option></select></div>');
   
    $('#div_body341').append('<div><select type="text"  name="bankName451" id="bankName451" style="border:none;margin-top:10px;outline:none;background-color:transparent;" required><option value="">Select Bank Account</option><select></div>');
  
    $('#div_body341').append('<div class="input-cont"><input type="number"  id="amount54" name="amount54" autocomplete="on" required><label for="amount54" class="label-name"><span class="content-name">Enter Amount</span></label></div>');
    $('#div_body341').append('<div class="input-cont"><input type="text" id="units310" name="units310"  autocomplete="on" required><label for="units310" class="label-name"><span class="content-name">Enter Units</span></label></div>');
 
    $('#div_body341').append('<div class="input-cont"><input type="text"  id="depositid54" name="depositid54" autocomplete="on" required><label for="depositid54" class="label-name"><span class="content-name">Enter deposit id</span></label></div>');
    $('#div_body341').append('<div class="input-cont"><input type="date" id="depositSlipDate54" name="depositSlipDate54"  autocomplete="on" required><label for="depositSlipDate54" class="label-name"><span class="content-name"></span></label></div>');
 
    $('#div_body341').append('<div id="submitDiv"><button id="postTransaction300" style="background-color:rgba(96, 146, 205,1);cursor:pointer;color:white;height:40px;line-height:40px;width:100px;border-radius:8px;border:none;margin-top:25px;">Post</button></div>');
  
    $.getJSON('xd-modules/admin-modules/backend/allStaff.php',function(data){
    $.each(data.freelancedetails, function(i,freelance) {
    $('#staffAgent12').append('<option value="'+freelance.id+'" data-phone="'+freelance.phone+'" data-agentname="'+freelance.names+'">'+freelance.names+' ('+freelance.phone+')</option>');
    });
    });
    $.getJSON('xd-modules/accounts-module/backend/products-services.php',function(data){
    $.each(data.freelancedetails, function(i,freelance) {
    $('#addProduct34').append('<option value="'+freelance.id+'" data-productname="'+freelance.name+'" data-productcode="'+freelance.product_code+'" data-productcategory="'+freelance.category+'" data-productcategorycode="'+freelance.category_code+'" data-price="'+freelance.price+'">'+freelance.name+' (K'+freelance.price+')</option>');
    });
    });

    $.getJSON('xd-modules/admin-modules/backend/depots.php',function(data){
    $.each(data.details, function(i,cyberdesk) {
    $('#revenuePoint55').append('<option value="'+cyberdesk.depot_id+'" data-depotname="'+cyberdesk.depot_name+'">'+cyberdesk.depot_name+'</option>');
    });
    });

    $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
    $.each(data.details, function(i,cyberdesk) {
    $('#bankName451').append('<option value="'+cyberdesk.account_name+'" data-accountnumber="'+cyberdesk.account_number+'">'+cyberdesk.account_name+'</option>');
    });
      
    });
    
    });
 
    $(document).on('click','#postTransaction300',function (event) {
      event.preventDefault(); 
      event.stopPropagation();      
      var agentId = document.getElementById("staffAgent12").value;
      var agentName = document.querySelector("#staffAgent12 option:checked").dataset.agentname; 
      var agentPhone = document.querySelector("#staffAgent12 option:checked").dataset.phone; 

      var productId = document.getElementById("addProduct34").value;
      var productName = document.querySelector("#addProduct34 option:checked").dataset.productname; 
      var totalAmount = document.getElementById("amount54").value; 
      var units310 = document.getElementById("units310").value; 
      var productcode = document.querySelector("#addProduct34 option:checked").dataset.productcode;
      var productcategory = document.querySelector("#addProduct34 option:checked").dataset.productcategory;
      var productcategorycode = document.querySelector("#addProduct34 option:checked").dataset.productcategorycode;

      var revenuePointId = document.getElementById("revenuePoint55").value;
      var depotname = document.querySelector("#revenuePoint55 option:checked").dataset.depotname; 
     
      var bankName = document.getElementById("bankName451").value;
      var accountnumber = document.querySelector("#bankName451 option:checked").dataset.accountnumber;

      var depositId = document.getElementById("depositid54").value;
      var depositSlipDate = document.getElementById("depositSlipDate54").value;

       if(agentId != '' && agentName != '' && productId != '' && productName != '' && productcode != '' && bankName != '' && accountnumber != ''){

         $('#submitDiv').empty();$('#submitDiv').append('<button id="postTransaction300" style="background-color:gray;cursor:pointer;color:white;height:40px;line-height:40px;width:100px;border-radius:8px;border:none;margin-top:25px;">Posting...</button>');

       datastring='agentId='+agentId+'&agentName='+agentName+'&agentPhone='+agentPhone+'&productId='+productId+'&productName='+productName+'&totalAmount='+totalAmount+'&units310='+units310+'&productcode='+productcode+'&productcategory='+productcategory+'&productcategorycode='+productcategorycode+'&revenuePointId='+revenuePointId+'&depotname='+depotname+'&bankName='+bankName+'&accountnumber='+accountnumber+'&depositSlipDate='+depositSlipDate+'&depositId='+depositId;
               
       $.ajax({
        data: datastring,
        url: "xd-modules/cashier-module/backend/postTransaction.php",
        type: "POST"
      }).done(function(data) {
        console.log("Raw response from server:", data); // Log raw response for debugging
        
        try {
          var response = JSON.parse(data); // Parse the JSON response
          
          console.log("Parsed JSON response:", response); // Log parsed response
      
          if (response.status == 'success') {
            
            $('#div_body341').empty().append(
              '<p>Transaction post was successful with receipt number <b style="color:red;">' + 
              response.receiptnumber + 
              '</b>. To verify the post go to collection summary and select <b>'+agentName+'</b> collection details.</span></p>'
            );
      
            setTimeout(function() {
              $('#general-modal713').fadeOut('slow');
            }, 5000);
            collectionsummary0();
          } else {
            $('#submitDiv').empty().append('<p style="color:red;">Something went wrong. Please reload and try again.</p>');
          }
        } catch (e) {
          console.error("Failed to parse JSON response:", e);
          $('#submitDiv').empty().append('<p style="color:red;">Invalid response received from the server.</p>');
        }
      });
      
    
       }else{
       
       alert('Something wet wrong try again!');
       
       }
       
      
    });

/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
 