<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $paymentStatus = filter_input(INPUT_POST, "paymentStatus");
    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($paymentStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "due_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "due_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(tblproduct.name LIKE :search_key OR tblproduct.product_code LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }
    // Prepare the SQL query with the conditions
    $query = "SELECT COUNT(billing_subscription.product_id) AS accounts, 
    SUM(billing_subscription.paid) AS paid,SUM(billing_subscription.balance) AS balance,
    billing_subscription.product_id,tblproduct.id,tblproduct.name,tblproduct.product_code,tblproduct.price,tblproduct.charge_rate,tblproduct.category,tblproduct.units,tblproduct.penalty_code,tblproduct.due_date,tblproduct.due_time 
    FROM billing_subscription 
    RIGHT JOIN tblproduct ON billing_subscription.product_id=tblproduct.id 
    WHERE tblproduct.status<>'deleted'
    AND billing_subscription.document_type='QUOTATION' 
    AND tblproduct.charge_rate!='Once off' 
    AND tblproduct.charge_rate!='Once' 
    AND tblproduct.charge_rate!='Other' 
    AND tblproduct.category!='Penalties' 
    AND tblproduct.category!='Penalty'";

    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " GROUP BY tblproduct.name ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    $totalProductTotal = 0; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalProductTotal += $rowDs['balance']; 
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        "totalProductTotal" => $totalProductTotal
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
