<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $paymentStatus = filter_input(INPUT_POST, "paymentStatus");
    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($paymentStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "due_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "due_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(company_name LIKE :search_key OR company_registration_number LIKE :search_key OR tpin LIKE :search_key OR business_category LIKE :search_key OR client_name LIKE :search_key OR product_name LIKE :search_key OR phone_contact LIKE :search_key OR nrc LIKE :search_key OR transaction_date LIKE :search_key OR invoice_no LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }
    // Prepare the SQL query with the conditions
    $query =  "SELECT 
    SUM(paid) AS paid, SUM(balance) AS balance,COUNT(product_name) AS items,
    b_id,company_name,company_registration_number,tpin,business_category,client_name,client_id,product_id,units,unit_price,total_charge,billing_interval,payment_advance,invoice_no,due_date,due_time,b_status,phone_contact,email_contact,delivery_address,plot_number,area,nrc,lat,lng,user_id 
    FROM billing_subscription 
    WHERE 
    balance > 0 
    AND document_type='QUOTATION' AND status='Active'";
 
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " GROUP BY invoice_no DESC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    $totalProductTotal = 0; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalProductTotal += $rowDs['balance']; 
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        "totalProductTotal" => $totalProductTotal
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
