<?php
// Set CORS headers to allow cross-origin requests
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

// Start session
session_start();

// Include database configuration file
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    // Create a new PDO instance for database connection
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $id = filter_input(INPUT_POST, "id");
  //  $name = filter_input(INPUT_POST, "name");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(cfname LIKE :search_key OR clname LIKE :search_key OR cphone LIKE :search_key OR product_name LIKE :search_key OR transaction_amount LIKE :search_key OR transaction_reference LIKE :search_key OR delivery_address LIKE :search_key OR area LIKE :search_key OR plot_no LIKE :search_key OR nrc LIKE :search_key OR transaction_date LIKE :search_key OR receipt_no LIKE :search_key OR invoiceNumber LIKE :search_key OR receipt_date LIKE :search_key OR bank_deposit_id LIKE :search_key OR business_category LIKE :search_key OR pacra LIKE :search_key OR tpin LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the conditions
    $query = "SELECT 
               id, cfname, clname, cemail, cphone, product_name, product_id, transaction_amount, quantity, transaction_reference, transaction_status, order_details, user_id, agent_id, trans_type, depot, delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, invoiceNumber, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, bank_deposit_id, business_category, pacra, tpin
          FROM 
            transaction_details 
        WHERE 
             cphone = '$id' 
            AND debit_or_credit = 'Credit' 
            AND (transaction_status = 'approved' OR transaction_status = 'active')";

    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " ORDER BY id DESC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
   // $getDrivers->bindParam(':product_id', $product_id);
   // $getDrivers->bindParam(':product_name', $product_name);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    $totalTransactionAmount = 0; 
    $totalQuantity = 0;
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalTransactionAmount += $rowDs['transaction_amount']; 
        $totalQuantity += $rowDs['quantity'];
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        "totalTransactionAmount" => $totalTransactionAmount,
        "totalQuantity" => $totalQuantity,
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    // Handle database connection error
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    // Handle other exceptions
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
