<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(transaction_details.agent_name LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the conditions
    $query = "SELECT 
             transaction_details.agent_name, 
            transaction_details.agent_id, 
            COUNT(transaction_details.product_id) AS accounts,
            SUM(transaction_details.transaction_amount) AS producttotal,
            SUM(transaction_details.quantity) AS totalquantity,
            SUM(rota.target) AS totaltarget
    FROM 
        transaction_details 
        LEFT JOIN rota ON transaction_details.agent_id=rota.user_id
    WHERE 
        debit_or_credit = 'Credit' 
        AND (transaction_details.transaction_status = 'approved' OR transaction_details.transaction_status = 'active' OR transaction_details.transaction_status = 'Pending')";

    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " GROUP BY transaction_details.agent_name";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    $totalProductTotal = 0;
    $totalAccounts = 0;
    $totalQuantityTotal = 0;
    $totaltargettotals = 0;
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalProductTotal += $rowDs['producttotal'];
        $totalAccounts += $rowDs['accounts'];
        $totalQuantityTotal += $rowDs['totalquantity'];
        $totaltargettotals += $rowDs['totaltarget'];
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        "totalProductTotal" => $totalProductTotal,
        "totalAccounts" => $totalAccounts,
        "totalQuantityTotal" => $totalQuantityTotal,
        "totaltargettotals" => $totaltargettotals
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
