<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

// Include database configuration
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    // Connect to the database
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Query to retrieve product details and their totals
    $getproductsquery = "SELECT 
                            transaction_details.agent_name, 
                            transaction_details.agent_id, 
                            COUNT(transaction_details.product_id) AS accounts,
                            SUM(transaction_details.transaction_amount) AS producttotal,
                            SUM(transaction_details.quantity) AS totalquantity,
                            SUM(rota.target) AS totaltarget
                        FROM 
                            transaction_details 
                            LEFT JOIN rota ON transaction_details.agent_id=rota.user_id
                        WHERE 
                        transaction_details.debit_or_credit='Credit' 
                            AND (transaction_details.transaction_status='approved' OR transaction_details.transaction_status='active' OR transaction_details.transaction_status='Pending') 
                        GROUP BY 
                        transaction_details.agent_name";

    // Execute the query
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    // Initialize variables
    $nestedData = array(); 
    $totalProductTotal = 0;
    $totalAccounts = 0;
	$totalQuantityTotal = 0;
    $totaltargettotals = 0;
    // Fetch individual records and calculate total sum
    while ($row = $getproducts->fetch()) {
        // Add the producttotal to the total sum
        $totalProductTotal += $row['producttotal'];
		$totalAccounts += $row['accounts'];
		$totalQuantityTotal += $row['totalquantity'];
        $totaltargettotals += $row['totaltarget'];
        // Add the current row to the nested data array
        $nestedData[] = $row;
    }

    // Prepare the response data
    $totalrecords = count($nestedData);
    $json_data = array(
        "details" => $nestedData,   // total data array
        "totalProductTotal" => $totalProductTotal,
		"totalAccounts" => $totalAccounts,
		"totalQuantityTotal" => $totalQuantityTotal,
        "numofrows" => $totalrecords,
        "totaltargettotals" => $totaltargettotals
    );

    // Send data as JSON format
    echo json_encode($json_data);
    exit;
} catch(PDOException $e) {
    // Handle database connection errors
    $error_message = "Connection failed: " . $e->getMessage();
    echo json_encode(array("error" => $error_message));
    exit;
}
?>
