<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$userloggedid = $_SESSION["userid"];
$billingAccountId = filter_input(INPUT_POST, "billingAccountId");

// SQL query using LEFT JOIN to exclude rows
$getproductsquery = "
    SELECT 
        users.id, users.email, users.names, users.phone, users.address, users.nrc, 
        users.org_name, users.company_registration_number, users.tpin, users.area, 
        users.plot_number, users.business_category, users.user_type, users.status, 
        booths.code, booths.productcategory, booths.productcategorycode, 
        booths.tenancy_start_date, booths.depot, booths.depot_id, booths.depot_code
    FROM 
        users
    INNER JOIN 
        booths ON booths.tenant_id = users.id 
    LEFT JOIN 
        billing_subscription ON billing_subscription.serial_no = booths.code 
        AND billing_subscription.product_id = :billingAccountId
    WHERE 
        booths.product_id = :billingAccountId
        AND users.status = 'active'
        AND billing_subscription.serial_no IS NULL
    ORDER BY 
        booths.code DESC";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->bindParam(':billingAccountId', $billingAccountId);
$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$totalrecords = $getproducts->rowCount();

if ($totalrecords == 0) {
    $json_data = array(
        'numofrows' => $totalrecords
    );
    echo json_encode($json_data);
    exit;
} else {
    $nestedData = array();
    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }
    $json_data = array(
        'details' => $nestedData,
        'numofrows' => $totalrecords
    );
    echo json_encode($json_data);
    exit;
}
?>
