<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Establish database connection
   // $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    //$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
        echo json_encode(["error" => "At least one input parameter is required"]);
        exit;
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(agent_name LIKE :search_key OR agent_id LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the conditions
    $getproductsquery = "
        SELECT 
            COUNT(id) AS transactions,
            SUM(transaction_amount) AS totalSales,
            agent_name, agent_id, cash_in_status,
            SUM(CASE WHEN payment_mode = 'CASH' THEN transaction_amount ELSE 0 END) AS totalCash,
            SUM(CASE WHEN payment_mode = 'MOMO' THEN transaction_amount ELSE 0 END) AS totalMomo,
            SUM(CASE WHEN payment_mode = 'BANK' THEN transaction_amount ELSE 0 END) AS totalBank
        FROM transaction_details 
        WHERE 
            trans_type = 'RECEIPT' 
            AND (transaction_status = 'active' OR transaction_status = 'approved' OR transaction_status='Cashed In')";

    if (!empty($conditions)) {
        $getproductsquery .= " AND " . implode(" AND ", $conditions);
    }

    $getproductsquery .= " GROUP BY agent_id ORDER BY id ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $agentData = [];

    if ($getproducts->rowCount() > 0) {
        while ($row = $getproducts->fetch()) {
            $agentId = $row['agent_id'];
            $cashInStatus = $row['cash_in_status'];

            if (!isset($agentData[$agentId])) {
                $agentData[$agentId] = [
                    'agent_id' => $agentId,
                    'agent_name' => $row['agent_name'],
                    'totalCashed' => 0,
                    'totalNotCashed' => 0,
                    'totalCash' => 0,
                    'totalMomo' => 0,
                    'totalBank' => 0,
                    'transactions' => 0,
                    'totalSales' => 0, 
                ];
            }

            if ($cashInStatus == 'approved') {
                $agentData[$agentId]['totalCashed'] += $row['totalCash'];
            } elseif ($cashInStatus == 'Pending') {
                $agentData[$agentId]['totalNotCashed'] += $row['totalCash'];
            }

            $agentData[$agentId]['transactions'] += $row['transactions'];
            $agentData[$agentId]['totalSales'] += $row['totalSales'];
            $agentData[$agentId]['totalCash'] += $row['totalCash'];
            $agentData[$agentId]['totalMomo'] += $row['totalMomo'];
            $agentData[$agentId]['totalBank'] += $row['totalBank'];
        }
    }

    $totalAmountsCollected = array_sum(array_column($agentData, 'totalCash')) + array_sum(array_column($agentData, 'totalMomo')) + array_sum(array_column($agentData, 'totalBank'));
    $totalCashed = array_sum(array_column($agentData, 'totalCashed'));
    $totalNotCashed = array_sum(array_column($agentData, 'totalNotCashed'));

    $jsonData = [
        'details' => array_values($agentData),
        'numofrows' => count($agentData),
        'totalAmountsCollected' => $totalAmountsCollected,
        'totalCashed' => $totalCashed,
        'totalNotCashed' => $totalNotCashed
    ];

    echo json_encode($jsonData);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
