<?php
// Set CORS headers to allow cross-origin requests
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

// Start session
session_start();

// Include database configuration file
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Create a new PDO instance for database connection
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");

    $agentId=filter_input(INPUT_POST, "agentId");
	$trnumber=filter_input(INPUT_POST, "trnumber");
	$cashierid=filter_input(INPUT_POST, "cashierid");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        // Convert startDateInput to the start of the day (00:00:00)
        $conditions[] = "cashing_timestamp >= :start_date";
        $parameters[':start_date'] = date('Y-m-d 00:00:00', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        // Convert endDateInput to the end of the day (23:59:59)
        $conditions[] = "cashing_timestamp <= :end_date";
        $parameters[':end_date'] = date('Y-m-d 23:59:59', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(product_name LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the conditions
 $query = "SELECT COUNT(id) AS transactions,
		SUM(transaction_amount) AS totalSales,
		id,product_id, product_name,product_code,agent_name, agent_id,transaction_date,cash_in_status
		FROM transaction_details 
		WHERE 
		trans_type='RECEIPT' 
		AND transaction_status='approved'
		AND payment_mode='CASH'
		AND treasurers_receipt='$trnumber'
		AND cash_in_status='approved'
		AND agent_id='$agentId'";

    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= "GROUP BY product_id ORDER BY product_name ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    $totalSales = 0;
    $transactions =0;
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs; 
        $totalSales+= $rowDs['totalSales'];
		$transactions+= $rowDs['transactions'];
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        'totalSales' => $totalSales,
        'transactions' => $transactions
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    // Handle database connection error
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    // Handle other exceptions
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
