<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $userloggedid = $_SESSION["userid"];
    
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $agentKey = filter_input(INPUT_POST, "agentKey");

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(product_name LIKE :search_key OR product_id LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }
    if (!empty($agentKey)) {
        $conditions[] = "agent_id = :agent_key";
        $parameters[':agent_key'] = $agentKey;
    }

    // Prepare the SQL query with the conditions
    $getproductsquery = "
        SELECT 
            COUNT(id) AS transactions,
            SUM(transaction_amount) AS totalSales,
            id, product_id, product_name, product_code, agent_name, agent_id, cash_in_status
        FROM 
            transaction_details 
        WHERE 
            trans_type = 'RECEIPT' 
            AND (transaction_status = 'active' OR transaction_status = 'approved')
            AND payment_mode = 'CASH'
            AND cash_in_status = 'Pending'
    ";

    if (!empty($conditions)) {
        $getproductsquery .= " AND " . implode(" AND ", $conditions);
    }

    $getproductsquery .= " GROUP BY product_id, product_name ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $totalrecords = $getproducts->rowCount();

    if ($totalrecords == 0) {
        echo json_encode([
            'numofrows' => $totalrecords
        ]);
    } else {
        $nestedData = [];
        $totalSales = 0;
        $transactions = 0;

        while ($row = $getproducts->fetch()) {
            $nestedData[] = $row;
            $totalSales += $row['totalSales'];
            $transactions += $row['transactions'];
        }

        echo json_encode([
            'details' => $nestedData,
            'numofrows' => $totalrecords,
            'totalSales' => $totalSales,
            'transactions' => $transactions
        ]);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
