<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
//header('Content-Type: application/json'); // Specify JSON response

// Start session
session_start();

try {
    // Include database configuration
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Create PDO instance with UTF-8 encoding
    $conn = new PDO("mysql:host=$servername;dbname=$database;charset=utf8mb4", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Retrieve session variables with checks
    if (!isset($_SESSION["username"], $_SESSION["userid"], $_SESSION["orgid"], $_SESSION["orgname"])) {
        echo json_encode(['status' => 'error', 'message' => 'Session variables missing.']);
        exit;
    }

    $agentname = $_SESSION["username"];
    $userloggedid = $_SESSION["userid"];
    $orgid = $_SESSION["orgid"];
    $orgname = $_SESSION["orgname"];

    // Fetch the last transaction
    $getServiceRequestQuery = "SELECT id, receipt_no FROM transaction_details ORDER BY id DESC LIMIT 1";
    $getServiceRequest = $conn->prepare($getServiceRequestQuery);
    $getServiceRequest->execute();
    $getServiceRequest->setFetchMode(PDO::FETCH_ASSOC);

    if ($getServiceRequest->rowCount() == 0) {
        echo json_encode(['status' => 'error', 'message' => 'No previous transactions found.']);
        exit;
    } else if ($getServiceRequest->rowCount() == 1) {
        $row = $getServiceRequest->fetch();
        $last_transaction_id = $row['id'];
        $last_transaction_receipt_no = $row['receipt_no'];

        // Sanitize and validate inputs
        $userid = filter_input(INPUT_POST, "agentId", FILTER_VALIDATE_INT);
        $fname = filter_input(INPUT_POST, "agentName", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $lname = filter_input(INPUT_POST, "agentName", FILTER_SANITIZE_FULL_SPECIAL_CHARS); // Ensure this is correct
        $email = 'mmc@mm.com'; // Hardcoded - ensure this is intentional
        $phone = filter_input(INPUT_POST, "agentPhone", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $deliveryaddress = 'Mongul Council'; // Hardcoded - ensure this is intentional
        $deliverylat = '28.8978979'; // Hardcoded - ensure this is intentional and valid
        $deliverylng = '15.8767879'; // Hardcoded - ensure this is intentional and valid
        $transtype = 'RECEIPT';
        $payment_mode = 'BANK';
        $debit_or_credit = 'Credit';
        $bankName = filter_input(INPUT_POST, "bankName", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $accountnumber = filter_input(INPUT_POST, "accountnumber", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $eposit_status = 'Pending Approval';
        $invoiceNumber = $last_transaction_receipt_no + 1; // Incremented
        $hiddenInvoiceNumber = '000000'; // Hardcoded - ensure this is intentional
        $transaction_reference = uniqid('d', true);
        $order_code = uniqid('o', true);
        $cartObject = filter_input(INPUT_POST, "productName", FILTER_SANITIZE_FULL_SPECIAL_CHARS); // Verify if this should be "orderDetails"
        $pacra = '0000000'; // Hardcoded - ensure this is intentional
        $tpin = '00000000'; // Hardcoded - ensure this is intentional
        $plotnumber = 'Mongu Council'; // Hardcoded - ensure this is intentional
        $area = 'Mongu Council'; // Hardcoded - ensure this is intentional
        $nrc = '000000'; // Hardcoded - ensure this is intentional
        $businessCategory = 'Mongu Council'; // Hardcoded - ensure this is intentional

        // Product details - replace deprecated FILTER_SANITIZE_STRING
        $productname = filter_input(INPUT_POST, "productName", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $productid = filter_input(INPUT_POST, "productId", FILTER_VALIDATE_INT);
        $productcode = filter_input(INPUT_POST, "productcode", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $category = filter_input(INPUT_POST, "productcategory", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $categorycode = filter_input(INPUT_POST, "productcategorycode", FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $total_quantity = filter_input(INPUT_POST, "units310", FILTER_VALIDATE_INT);
        $total_price = filter_input(INPUT_POST, "totalAmount", FILTER_VALIDATE_FLOAT);

        $depot = filter_input(INPUT_POST, "depotname", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $depotid = filter_input(INPUT_POST, "revenuePointId", FILTER_VALIDATE_INT);
        $depotcode = filter_input(INPUT_POST, "revenuePointId", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $depositId = filter_input(INPUT_POST, "depositId", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $depositSlipDate = filter_input(INPUT_POST, "depositSlipDate", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        // Validate required fields
        $required_fields = [
            'userid' => $userid,
            'fname' => $fname,
            'lname' => $lname,
            'phone' => $phone,
            'bankName' => $bankName,
            'accountnumber' => $accountnumber,
            'productname' => $productname,
            'productid' => $productid,
            'productcode' => $productcode,
            'category' => $category,
            'categorycode' => $categorycode,
            'total_quantity' => $total_quantity,
            'total_price' => $total_price,
            'depot' => $depot,
            'depotid' => $depotid,
            'depotcode' => $depotcode,
            'depositSlipDate' => $depositSlipDate,
            'depositId' => $depositId,
        ];

        foreach ($required_fields as $field => $value) {
            if (empty($value) && $value !== '0') {
                echo json_encode(['status' => 'error', 'message' => "Missing or invalid field: $field"]);
                exit;
            }
        }

        // Date and Time Calculations
        $d = strtotime("+1 hours");
        $transaction_date = date("Y-m-d", $d);
        $transaction_time = date("H:i:s", $d);
        $day = date('l', $d);

        $datex = new DateTime($transaction_date);
        $month = $datex->format('F'); // Full month name, e.g., January
        $week = $datex->format('W'); // Week number of the year
        $invoiceDueDate = $transaction_date; // As per your code

        // Prepare the INSERT query with named placeholders
        $insertnewuserQuery = "INSERT INTO transaction_details 
            (cfname, clname, cemail, cphone, product_name, product_id, product_code,
            product_category, product_category_code, transaction_amount, quantity, order_code, 
            transaction_reference, transaction_status, order_details, user_id, agent_name, 
            agent_id, trans_type, debit_or_credit, depot, depot_id, depot_code, 
            delivery_address, area, plot_no, nrc, lat, lng, transaction_date, 
            transaction_time, transaction_month, transaction_week, transaction_day, 
            receipt_no, invoiceNumber, receipt_date, payment_mode, bank_name, 
            bank_account_name, bank_account_number, bank_deposit_id, deposit_slip_date,deposit_status, business_category, pacra, tpin, org_name, org_id, sessionUserId)
            VALUES 
            (:fname, :lname, :email, :phone, :productname, :productid, :productcode, :category, 
            :categorycode, :total_price, :total_quantity, :order_code, :transaction_reference, 
            'active', :cartObject, :userid, :fname, :userid, :transtype, 
            :debit_or_credit, :depot, :depotid, :depotcode, :deliveryaddress, :area, :plotnumber, 
            :nrc, :deliverylat, :deliverylng, :transaction_date, :transaction_time, :month, 
            :week, :day, :invoiceNumber, :hiddenInvoiceNumber, :invoiceDueDate, :payment_mode, 
            :bankName, :bankName, :accountnumber, :depositid, :depositslipdate, 'Pending Approval', :businessCategory, :pacra, :tpin, :orgname, :orgid,:userloggedid)";
        
        $insertnewuser = $conn->prepare($insertnewuserQuery);
       // Bind parameters to the query
        $insertnewuser->bindParam(':fname', $fname);
        $insertnewuser->bindParam(':lname', $lname);
        $insertnewuser->bindParam(':email', $email);
        $insertnewuser->bindParam(':phone', $phone);
        $insertnewuser->bindParam(':productname', $productname);
        $insertnewuser->bindParam(':productid', $productid);
        $insertnewuser->bindParam(':productcode', $productcode);
        $insertnewuser->bindParam(':category', $category);
        $insertnewuser->bindParam(':categorycode', $categorycode);
        $insertnewuser->bindParam(':total_price', $total_price);
        $insertnewuser->bindParam(':total_quantity', $total_quantity);
        $insertnewuser->bindParam(':order_code', $order_code);
        $insertnewuser->bindParam(':transaction_reference', $transaction_reference);
        $insertnewuser->bindParam(':cartObject', $cartObject);
        $insertnewuser->bindParam(':userid', $userid);
        $insertnewuser->bindParam(':agentname', $agentname);
        $insertnewuser->bindParam(':userloggedid', $userloggedid);
        $insertnewuser->bindParam(':transtype', $transtype);
        $insertnewuser->bindParam(':debit_or_credit', $debit_or_credit);
        $insertnewuser->bindParam(':depot', $depot);
        $insertnewuser->bindParam(':depotid', $depotid);
        $insertnewuser->bindParam(':depotcode', $depotcode);
        $insertnewuser->bindParam(':deliveryaddress', $deliveryaddress);
        $insertnewuser->bindParam(':area', $area);
        $insertnewuser->bindParam(':plotnumber', $plotnumber);
        $insertnewuser->bindParam(':nrc', $nrc);
        $insertnewuser->bindParam(':deliverylat', $deliverylat);
        $insertnewuser->bindParam(':deliverylng', $deliverylng);
        $insertnewuser->bindParam(':transaction_date', $transaction_date);
        $insertnewuser->bindParam(':transaction_time', $transaction_time);
        $insertnewuser->bindParam(':month', $month);
        $insertnewuser->bindParam(':week', $week);
        $insertnewuser->bindParam(':day', $day);
        $insertnewuser->bindParam(':invoiceNumber', $invoiceNumber);
        $insertnewuser->bindParam(':hiddenInvoiceNumber', $hiddenInvoiceNumber);
        $insertnewuser->bindParam(':invoiceDueDate', $invoiceDueDate);
        $insertnewuser->bindParam(':payment_mode', $payment_mode);
        $insertnewuser->bindParam(':bankName', $bankName);
        $insertnewuser->bindParam(':accountnumber', $accountnumber);
        $insertnewuser->bindParam(':businessCategory', $businessCategory);
        $insertnewuser->bindParam(':pacra', $pacra);
        $insertnewuser->bindParam(':tpin', $tpin);
        $insertnewuser->bindParam(':orgname', $orgname);
        $insertnewuser->bindParam(':orgid', $orgid);
        $insertnewuser->bindParam(':depositid', $depositId);
        $insertnewuser->bindParam(':depositslipdate', $depositSlipDate);
        $insertnewuser->execute();
       
        
    if($insertnewUser = 1 ){
      
        $json_data = array(
          'status'=>'success',       
          'date'=>$transaction_date,
          'time'=>$transaction_time,
          'receiptnumber'=>$invoiceNumber,
          'day'=> $day,
          //'receipt'=>'created',
        );
       echo json_encode($json_data);  // send data as json format
       exit;
  
          } else {  
  
         // echo '<center><span class="" style="color:white;font-size:1.4em;font-family:segoe ui light;"> Something went wrong please try again later!</span></center>';
            $json_data = array(  
              'status'=>'failed'              
            );
           echo json_encode($json_data);  // send data as json format
           exit;
          }
        
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>