<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Ensure the session userid is an integer
 $userloggedid = (int) $_SESSION["userid"];
  
$getproductsquery = "SELECT rota.rota_id,rota.rota_code,rota.user_id,rota.depot,rota.depot_id,rota.depot_code,tblproduct.id,tblproduct.name,tblproduct.product_code,tblproduct.image,tblproduct.price,tblproduct.charge_rate,tblproduct.description,tblproduct.category,tblproduct.category_code,tblproduct.units,tblproduct.workAddress,tblproduct.lat_area,tblproduct.lng_area,tblproduct.radius,tblproduct.status,tblproduct.datemodified,tblproduct.org_name,tblproduct.org_id FROM tblproduct INNER JOIN rota ON tblproduct.id=rota.rota_code WHERE rota.user_id=$userloggedid AND tblproduct.status!='deleted' AND  rota.status='Active' ORDER BY tblproduct.name ASC";
 
$getproducts = $conn->prepare($getproductsquery);
$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        "details" => 'No Data'
    );
    echo json_encode($json_data);  // send data as json format
    exit;

} else if ($getproducts->rowCount() > 0) {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }

    $json_data = array(
        "details" => $nestedData,   // total data array
        'numofrows' => $totalrecords,
        'userid' => $userloggedid
    );

    echo json_encode($json_data);  // send data as json format
    exit;
}
?>
