<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $userloggedid = $_SESSION["userid"];

    // Retrieve and validate the start date
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    if (empty($startDateInput)) {
        throw new Exception("startDate parameter is empty");
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = date_create_from_format('Y-m-d', $endDateInput);
    
    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }
    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    if (isset($startDateInput) && empty($endDateInput)) {
        $getServiceRequestQuery = "SELECT SUM(transaction_details.transaction_amount) AS totalprice FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND cash_in_status!='approved' AND bank_deposit_id='nill' AND deposit_status='Pending' AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') AND transaction_date >= :start_date AND transaction_date <= CURDATE();";
     } elseif (empty($startDateInput) && isset($endDateInput)) {
        $getServiceRequestQuery = "SELECT SUM(transaction_details.transaction_amount) AS totalprice FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND cash_in_status!='approved' AND bank_deposit_id='nill' AND deposit_status='Pending' AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') AND transaction_date <= :end_date;";
     } elseif (isset($startDateInput) && isset($endDateInput)) {
        $getServiceRequestQuery = "SELECT SUM(transaction_details.transaction_amount) AS totalprice FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND cash_in_status!='approved' AND bank_deposit_id='nill' AND deposit_status='Pending' AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') AND transaction_date >= :start_date AND transaction_date <= :end_date;";
     }
    
    $getServiceRequest = $conn->prepare($getServiceRequestQuery);
    $getServiceRequest->bindParam(':uid', $userloggedid);
    $getServiceRequest->bindParam(':start_date', $startDateFormatted);
    $getServiceRequest->bindParam(':end_date', $endDateFormatted);
    $getServiceRequest->execute();
    $totalpriceRow = $getServiceRequest->fetch(PDO::FETCH_ASSOC);
    $totalprice = $totalpriceRow['totalprice'];

    // Execute query to get transaction details
    if (isset($startDateInput) && empty($endDateInput)) {
        $getDriversQuery = "SELECT id, cfname, clname, cphone, product_name, product_id, transaction_amount, quantity, transaction_reference, transaction_status, user_id, agent_name, agent_id, trans_type, delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, invoiceNumber, receipt_date, payment_mode, bank_name, bank_account_name, bank_account_number, bank_deposit_slip, bank_deposit_id, business_category, pacra, tpin FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND cash_in_status!='approved' AND bank_deposit_id='nill' AND deposit_status='Pending' AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') AND transaction_date >= :start_date AND transaction_date <= CURDATE();";
    } elseif (empty($startDateInput) && isset($endDateInput)) {
        $getDriversQuery = "SELECT id, cfname, clname, cphone, product_name, product_id, transaction_amount, quantity, transaction_reference, transaction_status, user_id, agent_name, agent_id, trans_type, delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, invoiceNumber, receipt_date, payment_mode, bank_name, bank_account_name, bank_account_number, bank_deposit_slip, bank_deposit_id, business_category, pacra, tpin FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND cash_in_status!='approved' AND bank_deposit_id='nill' AND deposit_status='Pending' AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') AND transaction_date <= :end_date;";
    } elseif (isset($startDateInput) && isset($endDateInput)) {
        $getDriversQuery = "SELECT id, cfname, clname, cphone, product_name, product_id, transaction_amount, quantity, transaction_reference, transaction_status, user_id, agent_name, agent_id, trans_type, delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, invoiceNumber, receipt_date, payment_mode, bank_name, bank_account_name, bank_account_number, bank_deposit_slip, bank_deposit_id, business_category, pacra, tpin FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND cash_in_status!='approved' AND bank_deposit_id='nill' AND deposit_status='Pending' AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') AND transaction_date >= :start_date AND transaction_date <= :end_date;";
    }
     
    $getDrivers = $conn->prepare($getDriversQuery);
    $getDrivers->bindParam(':uid', $userloggedid);
    $getDrivers->bindParam(':start_date', $startDateFormatted);
    $getDrivers->bindParam(':end_date', $endDateFormatted);
    
    $getDrivers->execute();

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        'total' => $totalprice,
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
