<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';
//$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);

//$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$getproductsquery = "SELECT COUNT(id) AS transactions,
                            SUM(transaction_amount) AS totalSales,
                            agent_name, agent_id,deposit_status,
                            SUM(CASE WHEN payment_mode = 'CASH' THEN transaction_amount ELSE 0 END) AS totalCash,
                            SUM(CASE WHEN payment_mode = 'MOMO' THEN transaction_amount ELSE 0 END) AS totalMomo,
                            SUM(CASE WHEN payment_mode = 'BANK' THEN transaction_amount ELSE 0 END) AS totalBank
                    FROM transaction_details 
                    WHERE 
                    trans_type='RECEIPT' 
                    AND payment_mode='CASH'
                    AND  deposit_status='Pending'
                    GROUP BY agent_id ORDER BY id ASC";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$agentData = array();

if ($getproducts->rowCount() > 0) {
    while ($row = $getproducts->fetch()) {
        $agentId = $row['agent_id'];
        $cashInStatus = $row['deposit_status'];

        if (!isset($agentData[$agentId])) {
            $agentData[$agentId] = array(
                'agent_id' => $agentId,
                'agent_name' => $row['agent_name'],
                'totalCashed' => 0,
                'totalNotCashed' => 0,
                'totalCash' => 0,
                'totalMomo' => 0,
                'totalBank' => 0,
                'transactions' => 0,
                 'totalSales' => 0, 
            );
        }

        if ($cashInStatus == 'Cashed In') {
            $agentData[$agentId]['totalCashed'] += $row['totalCash'];
        } elseif ($cashInStatus == 'Pending') {
            $agentData[$agentId]['totalNotCashed'] += $row['totalCash'];
        }

        $agentData[$agentId]['transactions'] += $row['transactions'];
        $agentData[$agentId]['totalSales'] += $row['totalSales'];
        $agentData[$agentId]['totalCash'] += $row['totalCash'];
        $agentData[$agentId]['totalMomo'] += $row['totalMomo'];
        $agentData[$agentId]['totalBank'] += $row['totalBank'];
    }
}

$totalAmountsCollected = array_sum(array_column($agentData, 'totalCash')) + array_sum(array_column($agentData, 'totalMomo')) + array_sum(array_column($agentData, 'totalBank'));
$totalCashed = array_sum(array_column($agentData, 'totalCashed'));
$totalNotCashed = array_sum(array_column($agentData, 'totalNotCashed'));

$jsonData = array(
    'details' => array_values($agentData),
    'numofrows' => count($agentData),
    'totalAmountsCollected' => $totalAmountsCollected,
    'totalCashed' => $totalCashed,
    'totalNotCashed' => $totalNotCashed
);

echo json_encode($jsonData);
exit;
?>
