<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];
    $depositslipid = filter_input(INPUT_POST, 'depositslipid', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $agentid = filter_input(INPUT_POST, 'agentid', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $bankname = filter_input(INPUT_POST, 'bankname', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $depositslip = filter_input(INPUT_POST, 'depositslip', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $status = 'Approved';

    // Prepare the SQL query with placeholders
    $updateQuery = "UPDATE `transaction_details` 
                    SET 
                        `transaction_status` = 'approved', 
                        `deposit_status` = :status, 
                        `approved_by` = :userloggedid 
                    WHERE 
                        `agent_id` = :agentid 
                        AND `bank_deposit_id` = :depositslipid 
                        AND `bank_account_name` = :bankname 
                        AND `bank_deposit_slip` = :depositslip
                        AND `deposit_status` = 'Pending Approval'";

    // Prepare the statement
    $updated = $conn->prepare($updateQuery);

    // Bind the parameters to the statement
    $updated->bindParam(':status', $status);
    $updated->bindParam(':userloggedid', $userloggedid);
    $updated->bindParam(':agentid', $agentid);
    $updated->bindParam(':depositslipid', $depositslipid);
    $updated->bindParam(':bankname', $bankname);
    $updated->bindParam(':depositslip', $depositslip);

    // Execute the statement
    if ($updated->execute()) {
        $json_data = [
            'status' => 'Approved'
        ];
    } else {
        $json_data = [
            'status' => 'Approval Failed!'
        ];
    }

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(['error' => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
