<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';
//$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);

//$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$agent_id=filter_input(INPUT_POST, "agentId");

$getproductsquery = "SELECT COUNT(id) AS transactions,
                            SUM(transaction_amount) AS totalSales,
                            product_name,product_id,product_code,agent_name, agent_id, cash_in_status,
                            SUM(CASE WHEN payment_mode = 'CASH' THEN transaction_amount ELSE 0 END) AS totalCash,
                            SUM(CASE WHEN payment_mode = 'MOMO' THEN transaction_amount ELSE 0 END) AS totalMomo,
                            SUM(CASE WHEN payment_mode = 'BANK' THEN transaction_amount ELSE 0 END) AS totalBank
                    FROM transaction_details 
                    WHERE 
                    trans_type='RECEIPT' 
                    AND (transaction_status='active' OR transaction_status='approved'  OR transaction_status='Cashed In')
                    AND agent_id='$agent_id'
                    GROUP BY product_id ORDER BY transaction_date DESC";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$agentData = array();

if ($getproducts->rowCount() > 0) {
    while ($row = $getproducts->fetch()) {
        $productId = $row['product_id'];
        $cashInStatus = $row['cash_in_status'];

        if (!isset($agentData[$productId])) {
            $agentData[$productId] = array(
                'product_id' => $productId,
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'agent_name' => $row['agent_name'],
                'agent_id' => $row['agent_id'],
                'totalCashed' => 0,
                'totalNotCashed' => 0,
                'totalCash' => 0,
                'totalMomo' => 0,
                'totalBank' => 0,
                'transactions' => 0,
                 'totalSales' => 0, 
            );
        }

        if ($cashInStatus == 'approved') {
            $agentData[$productId]['totalCashed'] += $row['totalCash'];
        } elseif ($cashInStatus == 'Pending') {
            $agentData[$productId]['totalNotCashed'] += $row['totalCash'];
        }

        $agentData[$productId]['transactions'] += $row['transactions'];
        $agentData[$productId]['totalSales'] += $row['totalSales'];
        $agentData[$productId]['totalCash'] += $row['totalCash'];
        $agentData[$productId]['totalMomo'] += $row['totalMomo'];
        $agentData[$productId]['totalBank'] += $row['totalBank'];
    }
}

$totalAmountsCollected = array_sum(array_column($agentData, 'totalCash')) + array_sum(array_column($agentData, 'totalMomo')) + array_sum(array_column($agentData, 'totalBank'));
$totalCashed = array_sum(array_column($agentData, 'totalCashed'));
$totalNotCashed = array_sum(array_column($agentData, 'totalNotCashed'));

$jsonData = array(
    'details' => array_values($agentData),
    'numofrows' => count($agentData),
    'totalAmountsCollected' => $totalAmountsCollected,
    'totalCashed' => $totalCashed,
    'totalNotCashed' => $totalNotCashed
);

echo json_encode($jsonData);
exit;
?>
