<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

    session_start();
    // Insert into the database after successful upload of the database
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Fetch input data securely
    $searchKey = filter_input(INPUT_POST, "searchKey0", FILTER_DEFAULT);
    $searchKey2 = filter_input(INPUT_POST, "searchKey2", FILTER_DEFAULT);
    $startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
    $endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);

    // Debugging: Check if required inputs are received correctly
    if (!$startDateInput || !$endDateInput) {
        echo json_encode(['error' => 'Missing required date inputs', 'startDate' => $startDateInput, 'endDate' => $endDateInput]);
        exit;
    }

    // Build conditions and parameters arrays
    $conditions = [];
    $parameters = [];

    // Add date range condition (always required)
    $conditions[] = "transaction_date BETWEEN :startDate AND :endDate";
    $parameters[':startDate'] = $startDateInput;
    $parameters[':endDate'] = $endDateInput;

    // Add transaction status condition (always required)
    $conditions[] = "(transaction_status = 'active' OR transaction_status = 'approved')";

    // Add searchKey condition only if not empty
    if (!empty($searchKey)) {
        $conditions[] = "(receipt_no LIKE :searchKey OR product_name LIKE :searchKey OR product_code LIKE :searchKey)";
        $parameters[':searchKey'] = '%' . $searchKey . '%';
    }

    // Add searchKey2 (user_id) condition only if not empty
    if (!empty($searchKey2)) {
        $conditions[] = "user_id = :searchKey2";
        $parameters[':searchKey2'] = $searchKey2;
    }

    // Additional query to fetch transaction details
    $getTransactionsQuery = "
    SELECT SUM(transaction_amount) AS receipt_total, id, cfname, clname, cemail, cphone, product_name, product_id, product_code,
           transaction_amount, quantity, transaction_reference, transaction_status, agent_name, agent_id,trans_type, 
           delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, offline_receipt,
           invoiceNumber, comment, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, 
           bank_deposit_id, business_category, pacra, tpin
    FROM transaction_details
    WHERE " . implode(" AND ", $conditions) . "
    GROUP BY id
    ORDER BY receipt_no DESC";

    $getTransactions = $conn->prepare($getTransactionsQuery);
    foreach ($parameters as $key => $value) {
        $getTransactions->bindValue($key, $value);
    }
    $getTransactions->execute(); 

    $getTransactions->setFetchMode(PDO::FETCH_ASSOC);

    if ($getTransactions->rowCount() == 0) {
        $json_data = array(
            'transactionsnumofrows' => 0,
            'transactionsDetails' => [] 
        );
        echo json_encode($json_data);
        exit;
    }

    $totalTransactionsRecords = $getTransactions->rowCount(); 
    $transactionsData = [];
    $totalAmount = 0;

    while ($rowT =  $getTransactions->fetch()) {
        $transactionsData[] = $rowT; 
        $totalAmount += $rowT['receipt_total'];
    }

    // Build conditions for deposit query
    $depositConditions = [];
    $depositParameters = [];

    // Add date range condition (always required)
    $depositConditions[] = "transaction_date BETWEEN :startDate AND :endDate";
    $depositParameters[':startDate'] = $startDateInput;
    $depositParameters[':endDate'] = $endDateInput;

    // Add transaction status condition (always required)
    $depositConditions[] = "(transaction_status = 'approved' OR transaction_status = 'active')";

    // Add searchKey2 (user_id) condition only if not empty
    if (!empty($searchKey2)) {
        $depositConditions[] = "user_id = :searchKey2";
        $depositParameters[':searchKey2'] = $searchKey2;
    }

    // First query to get deposit details
    $getDepositQuery = "
        SELECT bank_deposit_slip, bank_deposit_id
        FROM transaction_details 
        WHERE " . implode(" AND ", $depositConditions) . "
        GROUP BY bank_deposit_id";

    $getDeposit = $conn->prepare($getDepositQuery);
    foreach ($depositParameters as $key => $value) {
        $getDeposit->bindValue($key, $value);
    }
    $getDeposit->execute();

    $getDeposit->setFetchMode(PDO::FETCH_ASSOC);
    $depositDetails = [];

    while ($rowDeposit = $getDeposit->fetch()) {
        $depositDetails[] = array(
            'bank_deposit_slip' => $rowDeposit['bank_deposit_slip'],
            'bank_deposit_id' => $rowDeposit['bank_deposit_id']
        );
    }

    // Check for deposit details
    if (count($depositDetails) == 0) {
        $json_data = array(
            'numofrows' => 0,
            'depositDetails' => []
        );
        echo json_encode($json_data);
        exit;
    }

    // Build conditions for products query (reuse the same conditions)
    // Second query to get products and transactions
    $getproductsquery = "
    SELECT 
        product_id,
        product_name, 
        product_code, 
        bank_account_name, 
        bank_account_number,
        SUM(transaction_amount) AS totalSales,
        COUNT(id) AS transactions,
        SUM(quantity) AS totalQuantity 
    FROM transaction_details 
    WHERE " . implode(" AND ", $conditions) . "
    GROUP BY product_id, product_name
    ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
    foreach ($parameters as $key => $value) {
        $getproducts->bindValue($key, $value);
    }
    $getproducts->execute();

    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    if ($getproducts->rowCount() == 0) {
        $json_data = array(
            'numofrows' => 0,
            'details' => [],
            'depositDetails' => $depositDetails
        );
        echo json_encode($json_data);
        exit;
    }

    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
    }

    $json_data = array(
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'details' => $nestedData,
        'depositDetails' => $depositDetails,
        'numofrows' => $totalrecords,
        "transactionsDetails" => $transactionsData, 
        'totalAmount' => $totalAmount,
        'transactionsnumofrows' => $totalTransactionsRecords,
    );

    echo json_encode($json_data);  // send data as json format
    exit;

?>