<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

    session_start();
    // Insert into the database after successful upload of the database
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Fetch input data securely
   // $agent_id = filter_input(INPUT_POST, "agentId", FILTER_SANITIZE_NUMBER_INT); 
   // $startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
   // $endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);
   // $mainSearchInput = filter_input(INPUT_POST, "mainSearchInput", FILTER_DEFAULT);

    // First query to get deposit details
    $getDepositQuery = "
        SELECT bank_deposit_slip, bank_deposit_id
        FROM transaction_details 
        WHERE 
       transaction_status = 'approved' 
        AND deposit_status = 'Approved'   
        GROUP BY bank_deposit_id";

    $getDeposit = $conn->prepare($getDepositQuery);
   // $getDeposit->bindParam(':startDate', $startDateInput);
   // $getDeposit->bindParam(':endDate', $endDateInput);
   // $getDeposit->bindParam(':mainSearchInput', $mainSearchInput);
   // $getDeposit->bindParam(':agentid', $agent_id);
    $getDeposit->execute();

    $getDeposit->setFetchMode(PDO::FETCH_ASSOC);
    $depositDetails = [];

    while ($rowDeposit = $getDeposit->fetch()) {
        $depositDetails[] = array(
            'bank_deposit_slip' => $rowDeposit['bank_deposit_slip'],
            'bank_deposit_id' => $rowDeposit['bank_deposit_id']
        );
    }

    // Check for deposit details
    if (count($depositDetails) == 0) {
        $json_data = array(
            'numofrows' => 0,
            'depositDetails' => []
        );
        echo json_encode($json_data);
        exit;
    }

    // Second query to get products and transactions
    $getproductsquery = "
        SELECT 
            SUM(transaction_amount) AS totalSales,
            COUNT(id) AS transactions,
            product_name, 
            product_id, 
            product_code, 
            transaction_amount, 
            quantity, 
            bank_account_name, 
            bank_account_number 
        FROM transaction_details 
        WHERE 
        transaction_status = 'approved' 
        AND deposit_status = 'Approved'   
        GROUP BY product_id 
        ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
   // $getproducts->bindParam(':startDate', $startDateInput);
   // $getproducts->bindParam(':endDate', $endDateInput);
   // $getproducts->bindParam(':mainSearchInput', $mainSearchInput);
  //  $getproducts->bindParam(':agentid', $agent_id);
    $getproducts->execute();

    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    if ($getproducts->rowCount() == 0) {
        $json_data = array(
            'numofrows' => 0,
            'details' => [],
            'depositDetails' => $depositDetails
        );
        echo json_encode($json_data);
        exit;
    }

    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
    }

    $json_data = array(
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'details' => $nestedData,
        'depositDetails' => $depositDetails,
        'numofrows' => $totalrecords
    );

    echo json_encode($json_data);  // send data as json format
    exit;

?>
