<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

    session_start();
    // Insert into the database after successful upload of the database
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Fetch input data securely
   // $agent_id = filter_input(INPUT_POST, "agentId", FILTER_SANITIZE_NUMBER_INT); 
    $startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
    $endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);
  //  $mainSearchInput = filter_input(INPUT_POST, "mainSearchInput", FILTER_DEFAULT);

    // Query to get products and transactions
    $getproductsquery = "
        SELECT 
            depot, 
            depot_id, 
            SUM(CASE WHEN payment_mode = 'CASH' THEN transaction_amount ELSE 0 END) AS cashTotal,
            SUM(CASE WHEN payment_mode = 'DIGITAL' THEN transaction_amount ELSE 0 END) AS digitalTotal,
            COUNT(id) AS transactions,
            SUM(transaction_amount) AS totalSales,
            product_code, 
            quantity, 
            bank_account_name, 
            bank_account_number
        FROM transaction_details 
        WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active') 
        AND transaction_date BETWEEN :startDate AND :endDate 
        GROUP BY depot, depot_id
        ORDER BY depot ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':startDate', $startDateInput);
    $getproducts->bindParam(':endDate', $endDateInput);
   // $getproducts->bindParam(':mainSearchInput', $mainSearchInput);
  //  $getproducts->bindParam(':agentid', $agent_id);
    $getproducts->execute();

    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    if ($getproducts->rowCount() == 0) {
        $json_data = array(
            'numofrows' => 0,
            'details' => [], 
        );
        echo json_encode($json_data);
        exit;
    }

    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $totalCashCollected = 0;
    $totalDigitalCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
        $totalCashCollected += $row['cashTotal'];
        $totalDigitalCollected += $row['digitalTotal'];
    }

    $json_data = array(
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'totalCashCollected' => $totalCashCollected,
        'totalDigitalCollected' => $totalDigitalCollected,
        'details' => $nestedData, 
        'numofrows' => $totalrecords
    );

    echo json_encode($json_data);  // send data as json format
    exit;

?>
