<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
  //  $userloggedid = $_SESSION["userid"];

    // Retrieve and validate input
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $depotname =  filter_input(INPUT_POST, "depotname");
    $depotid = filter_input(INPUT_POST, "depotid");
    $productname =  filter_input(INPUT_POST, "productname");
    $productid = filter_input(INPUT_POST, "productid");
    if (empty($startDateInput)) {
        throw new Exception("startDate parameter is empty");
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();

    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }

    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare SQL conditions and parameters
    $conditions = [
        // "agent_id = :userloggedid",
        "transaction_date >= :start_date",
        "transaction_date <= :end_date",
        "depot = :depotname",
        "depot_id = :depotid",
        "product_name = :productname",
        "product_id = :productid"
    ];
    $parameters = [
        // ':userloggedid' => $userloggedid,
        ':start_date' => $startDateFormatted,
        ':end_date' => $endDateFormatted,
        ':depotname' => $depotname,
        ':depotid' => $depotid,
        ':productname' => $productname,
        ':productid' => $productid,
    ];

    if (!empty($searchKey)) {
        $conditions[] = "(receipt_no LIKE :search_key OR offline_receipt LIKE :search_key OR cfname LIKE :search_key OR clname LIKE :search_key OR cphone LIKE :search_key OR product_name LIKE :search_key OR product_code LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Query to fetch transaction details
    $getDriversQuery = "
        SELECT SUM(transaction_amount) AS receipt_total, id, cfname, clname, cemail, cphone, product_name, product_id, product_code,
               transaction_amount, quantity, transaction_reference, transaction_status, agent_name, agent_id,trans_type, depot,
               delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, offline_receipt,
               invoiceNumber, comment, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, 
               bank_deposit_id, business_category, pacra, tpin
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions) . "
        GROUP BY id
        ORDER BY receipt_no DESC";

    $getDrivers = $conn->prepare($getDriversQuery);

    // Bind parameters for the main query
    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    $getDrivers->execute();

    // Fetch transaction details
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Query to calculate total amount and count of IDs
    $sumAndCountQuery = "
        SELECT SUM(transaction_amount) AS total_amount, COUNT(id) AS total_count
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions);

    $sumAndCountStmt = $conn->prepare($sumAndCountQuery);

    // Bind parameters for the sum and count query
    foreach ($parameters as $key => $value) {
        $sumAndCountStmt->bindValue($key, $value);
    }

    $sumAndCountStmt->execute();

    $summary = $sumAndCountStmt->fetch(PDO::FETCH_ASSOC);

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        "summary" => [
            "total_amount" => $summary['total_amount'] ?? 0,
            "total_count" => $summary['total_count'] ?? 0,
        ],
    ];

    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
