var shoppingCart = (function() {
  let cart = [];

  // Constructor with balanceCF added
  function Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance, balanceCF) {
    this.name = name;
    this.price = parseFloat(price);
    this.charge_rate = parseFloat(charge_rate);
    this.count = parseFloat(count); // Supports decimal count
    this.id = id;
    this.productcode = productcode;
    this.category = category;
    this.categorycode = categorycode;
    this.depot = depot;
    this.depotid = depotid;
    this.depotcode = depotcode;
    this.total_charge = parseFloat(total_charge)-parseFloat(total_charge);
    this.balance_bf = parseFloat(balance_bf);
    this.balance = parseFloat(balance);
    this.balanceCF = parseFloat(balanceCF); // Initialize balanceCF
  }

  // Save cart to sessionStorage
  function saveCart() {
    sessionStorage.setItem('shoppingCart', JSON.stringify(cart));
  }

  // Load cart from sessionStorage
  function loadCart() {
    cart = JSON.parse(sessionStorage.getItem('shoppingCart')) || [];
  }

  if (sessionStorage.getItem("shoppingCart") != null) {
    loadCart();
  }

  const obj = {};

  // Add Item to Cart
  obj.addItemToCart = function(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance) {
    let item = new Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance, 0);
    item.balanceCF = calculateBalanceCF(item.balance_bf);
    cart.push(item);
    saveCart();
  };
// Remove all instances of an item from the cart by name
obj.removeItemFromCartAll = function(name) {
  cart = cart.filter(item => item.name !== name); // Remove all items with the specified name
  saveCart(); // Save updated cart to sessionStorage
};

  // Calculate balanceCF
  function calculateBalanceCF(balance_bf) {
    return parseFloat(balance_bf);
  }

  // Update item count
  obj.setCountForItem = function(name, newCount) {
    cart.forEach(item => {
      if (item.name === name) {
        item.count = parseFloat(newCount);
        const totalItemCost = item.price * item.count;
       // item.balanceCF = calculateBalanceCF(item.balance_bf, item.total_charge, totalItemCost);
        item.balanceCF = calculateBalanceCF(item.balance_bf);
      }
    });
    saveCart();
  };

  // Update total item cost and recalculate balanceCF
  obj.setTotalItemCost = function(name, newTotalCost) {
    cart.forEach(item => {
      if (item.name === name) {
        const newCount = parseFloat(newTotalCost) / item.price;
        item.count = newCount;
        item.balanceCF = calculateBalanceCF(item.balance_bf);
      }
    });
    saveCart();
  };

  // Clear the entire cart
  obj.clearCart = function() {
    cart = [];
    saveCart();
  };

  // List all items in the cart
  obj.listCart = function() {
    return cart.map(item => ({
      ...item,
      total: (item.price * item.count).toFixed(2),
      balanceCF: (isNaN(item.balanceCF) ? 0 : item.balanceCF).toFixed(2),
    }));
  };

  return obj;
})();

// *****************************************
// Triggers / Events
// *****************************************

// Utility function for debouncing
function debounce(func, delay) {
  let timer;
  return function(...args) {
    clearTimeout(timer);
    timer = setTimeout(() => func.apply(this, args), delay);
  };
}


// Clear cart button
 
$(document).on('click', '.clearReceiptItems', function() {
  shoppingCart.clearCart();
  displayCart(); 
});


// Handle changes in item count
$(document).on("input", ".show-cart .item-count", debounce(function() {
  const name = $(this).data('name');
  const count = parseFloat($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart();
}, 2300));

// Handle changes in total item cost
$(document).on("input", ".show-cart .item-total-cost", debounce(function() {
  const name = $(this).data('name');
  const totalCost = parseFloat($(this).val());
  shoppingCart.setTotalItemCost(name, totalCost);
  displayCart();
}, 2300));

// Display the cart
 function displayCart() {
  const cartArray = shoppingCart.listCart();
  let output = "";

  // Initialize totals
  let totalBalanceBroughttForward = 0,
      totalInvoicePrices = 0,
      totalInvoiceUnits = 0,
      totalBilledAmounts = 0,
      totalPaymentAmounts = 0,
      closingBalanceTotal = 0;

  // Generate HTML output and calculate totals
  cartArray.forEach(item => {
    const itemTotal = parseFloat(item.total); // Total cost per item
    const itemCount = parseFloat(item.count); // Quantity of the item
    const balanceCF = parseFloat(item.balanceCF); // Closing balance per item

    // Accumulate totals
    totalBalanceBroughttForward += parseFloat(item.balance_bf);
    totalInvoicePrices += item.price;
    totalInvoiceUnits += itemCount;
    totalBilledAmounts += itemTotal; // Accumulates total billed amounts
    totalPaymentAmounts += parseFloat(item.total_charge); // Correctly accumulate payment amounts
    closingBalanceTotal += balanceCF;

    // Append item row to the cart output
    output += `
      <div class="w3-col l12 m12 s12" style="float:left;padding-left:0px;">
        <div class="w3-col l7 m7 s8" style="float:left;padding-left:5px;text-align:left;">
          <b>${item.name}</b>
        </div>
        <div class="w3-col l2 m2 s1 w3-hide-small">K${item.price.toFixed(2)}</div>

        <div class="w3-col l1 m1 s1 w3-hide-small">
          <input type="number" step="0.001" class="item-count" data-name="${item.name}" 
                 value="${item.count.toFixed(2)}" style="background-color:transparent;border:none;outline:none;max-width:60px;">
        </div>
        
        <div class="w3-col l2 m2 s2">
          <input type="number" step="0.01" class="item-total-cost" data-name="${item.name}" 
                 value="${itemTotal.toFixed(2)}" style="background-color:transparent;border:none;outline:none;">
        </div> 
      </div>`;
  });

  // Render the cart items in the `.show-cart` div
  $('.show-cart').html(output);

  // Update totals in the corresponding summary divs
  const updateDiv = (selector, value) => {
    $(selector).html(`K${value.toFixed(2)}`);
  };

  updateDiv('.totalBalanceBroughttForward', totalBalanceBroughttForward);
  updateDiv('.totalInvoicePrices', totalInvoicePrices);
  updateDiv('.totalInvoiceUnits', totalInvoiceUnits);
  updateDiv('.totalBilledAmounts', totalBilledAmounts);
  updateDiv('.totalPaymentAmounts', totalPaymentAmounts); // Ensure this is correctly reflected
  updateDiv('.closingBalanceTotal', closingBalanceTotal);
}
// Initially display the cart
displayCart();

	// MAKING PAYMET FOR DUE IVOICES
	// MAKING PAYMET FOR DUE IVOICES



 
    // end of MAKING PAYMET FOR DUE IVOICES
    // end of MAKING PAYMET FOR DUE IVOICES

 
    // Listen for changes on checkboxes


// CLOSING DIV AND ADDING CHECKED ITEMS TO CART    
$(document).on('click', '.close_receipt_modal_div_1', function (event) {
  // Loop through all checked checkboxes inside #invoice_modal_div_2
  $('#invoice_modal_div_0').fadeIn('slow'); 
  $('.invoiceDivActions101').fadeIn('slow');
  $('#invoice_modal_div_1').fadeOut('slow'); 
 
});
// END OF CLOSING DIV AND ADDING CHECKED ITEMS TO CART 
// end of dding product to receipt


// MAKE PAYMENT
$(document).off('click', '.transact0').on('click','.transact0',function (event) {
transact101();
addProductToReceipt101(); // calling the function  addProductToReceipt101() from xd-assets/js/products.js file
});


// RECEIPT PAYMENT
function transact101() {
     let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    shoppingCart.clearCart(); 
    invoiceCart.clearCart();
     invoicePaymentCart.clearCart();
  
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;margin-top:-30px;"></div>');
     // modal acttion buttons
     $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span> <div id="invoicePaymentDiv02"><span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 penDiv101" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2 pen101" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
     // modal acttion buttons
 $('#invoice_modal_div_0').append(`
  <div class="w3-center w3-col l12 m12 s12 receiptTitles00">
  
       <div class="w3-center w3-col l12 m12 s12 org_logo_div"></div>
      <div class="w3-center w3-col l12 m12 s12"><b class="org_name" style="text-transform:uppercase"></b></div>
      <div class="w3-center w3-col l12 m12 s12 w3-hide-small pobox"></div>
      <div class="w3-center w3-col l12 m12 s12 w3-hide-small org_address" style="font-size: 0.7em;"></div>
      
      <div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:5px;color:var(--primnary-color);font-size:1.3em"><b>RECEIPT</b></div>
      <div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:0px;">
          
         <div id="invoiceDueDateDiv" class="w3-col l12 m12 s12" style="margin-left:5px;">
         <span id="receiptTitle00" style="margin-left:12px;font-weight:400;font-size:1em">No: </span>
            <span id="invoiceNumber" style="color:red;font-weight:400;font-size:1em">00</span>
          <span id="hiddenInvoiceNumber" class="clearOnTransactionSuccess" style="display:none;"></span>  
        
              Date: <input id="invoiceDueDate"  placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
           </div>
      </div>
  </div>
`);
  $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 receipt_modal_div_01"></div>');
  $('.receipt_modal_div_01').append('<div class="w3-col l8 m8 s12 clientDetailsDiv101" style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" id="addInvoiceClientDiv" style="cursor: pointer;margin-top:0px;"> <button id="addClientToInvoice0" type="button" style="float:left;font-weight:600;color:black;height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">CLIENT:</button></span><span class="w3-col l6 m6 s8 invoicedClientName0Div" style="margin-top:0px;font-weight: 600;"><span id="invoicedClientId0" class="clearOnTransactionSuccess" style="display: none;float:left;"></span><input id="invoicedClientName0" class="clearOnTransactionSuccess"  Placeholder="Enter Client name" type="text" style="float:left;border:none;background-color:transparent;outline:none;color:gray"/> </span><span class="w3-col l6 m6 s12" style="display:none;"><span id="invoicedClientName1" class="clearOnTransactionSuccess" style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="plotnumber07" Placeholder="Enter Plot No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;width:100px;"/><input id="invoicedClientAddress0" class="clearOnTransactionSuccess" Placeholder="Enter Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><input id="area07" Placeholder="Enter Area" type="text" class="w3-hide-small"  style="display:none;float:left;border:none;background-color:transparent;outline:none;"/></span><div class="w3-col l12 m12 s12"  style="margin-top:0px;"><input id="tpin07" Placeholder="Enter TPIN No:" class="w3-hide-small" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/><input id="nrc07" Placeholder="Enter Nrc No:" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/> </span><span class="w3-col l12 m12 s4 invoicedClientEmail0Div"  style="margin-top:0px;"><input id="invoicedClientEmail0" class="w3-hide-small" Placeholder="Enter Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 invoicedClientPhone0Div"  style="margin-top:0px;"><input id="invoicedClientPhone0" placeholder="Enter Phone No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
  $('.receipt_modal_div_01').append('<div class="w3-col l4 m4 s12 bankInvoiceDetailsDiv"><div class="w3-col l12 m12 s12 modeOfPaymentDiv0" style="margin-top:0px;"><select id="modeOfPayment" style="outline: none;margin-bottom:0px;color:black;float:left;margin-top:0px;border:none;font-weight:600;font-size:1em;background-color: transparent;text-indent: 0.01px;text-transform:capitalize;"><option value="MOMO">DIGITAL PAYMENT</option><option value="CASH">CASH PAYMENT</option><option value="BANK">BANK DEPOSIT</option><option value="BANK TRANSFER">BANK TRANSFER</option></select></div><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="float:left;color:gray;font-weight: 600;font-size:0.9em;margin-left: 7px;"><select id="bankname99" style="-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;background-color: transparent;border: none;outline: none;color:black;text-transform:capitalize;margin-left:5px;"><option>Select Bank</option></select></span></span><div class="w3-col l12 m12 s12 bankDepositSlipIdDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Ref/ID: </span><input id="bankDepositSlipId" class="clearOnTransactionSuccess" type="text" placeholder="Enter here" style="float:left;border:none;outline: none;font-size:0.9em;background-color:transparent;font-weight: 400;width:70%;"/></div><div class="w3-col l12 m12 s12 bankAccountNumberDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:1em">A/C: </span><span id="bankAccountNumber" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0262020000045</span></div><div class="w3-col l12 m12 s12 bankBranchDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Branch: </span><span id="bankBranch99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> Mongu Branch</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Phone: </span><span class="org_contacts" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 000 000000</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Email: </span><span class="org_email" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"></span></div></div>');

       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:5px;background-color:rgba(96, 146, 205,0.2);font-weight:600;"><div class="w3-col l7 m7 s8" id="addProductToReceipt101"><span style="padding:7px;cursor:pointer;">Item/Product <span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Amount</div></div>');
       $('#invoice_modal_div_0').append('<div class="show-cart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.1);padding-left:7px;border-left:1px solid rgba(96, 146, 205,0.2);border-right:1px solid rgba(96, 146, 205,0.2);"></div>');
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.2);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l7 m7 s8"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="display:none;">00</div><div class="w3-col l1 m1 s3  w3-hide-small" style="color:transparent;">00</div><div class="w3-col l2 m2 s2 totalBilledAmounts" style="color:red;">00</div></div>');
      
       $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101" style="display:none;"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
       $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Prepared by: <span class="preparedBy" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
      
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed
      
        $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> MAKE PAYMENT</span></span>');
        $('.bankDepositSlipIdDiv101').fadeOut('slow');
        $('.bankAccountNumberDiv101').fadeOut('slow');
        $('.bankBranchDiv101').fadeOut('slow');
        $('#bankname99').fadeOut('slow'); 

     /*
       $('.bankDepositSlipIdDiv101').fadeOut('slow');
      $('.bankAccountNumberDiv101').fadeOut('slow');
      $('.bankBranchDiv101').fadeOut('slow'); 
      $('#bankAccoutDiv101').fadeOut('slow'); 
      $('#bankname99').fadeOut('slow'); 
      */
      //fetch bank details 
    //  $('#bankname99').fadeIn('slow'); 
      $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
        $('#bankName').empty();
         $('#bankname99').empty();
         //.append('<option value="0">Select Bank</option>');
        $.each(data.details, function(i,cyberdesk) {
          $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-bankid="'+cyberdesk.bank_id+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
      });
         
        });     
    

        ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.org_name').empty().append(user.orgname);              
                $('.org_email').empty().append(user.org_email);
                $('.org_contacts').empty().append(user.org_contacts);
                $('.org_address').empty().append(user.org_address); 
                $('.pobox').empty().append(user.org_p_o_box);
                $('.preparedBy').empty().append(user.username); 
    
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                        class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        });
     
 
}
// END OF RECEIPT PAYMENT


/// POSTING TRANSACTION  /// POSTING TRANSACTION  /// POSTING TRANSACTION  /// POSTING TRANSACTION  /// POSTING TRANSACTION  /// POSTING TRANSACTION  /// POSTING TRANSACTION  /// POSTING TRANSACTION  

$(document).off('click', '.postTransaction101').on('click','.postTransaction101',function (event) {
postTransact101();
addProductToReceipt101(); // calling the function  addProductToReceipt101() from xd-assets/js/products.js file
});


function postTransact101() {
     let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    shoppingCart.clearCart(); 
    invoiceCart.clearCart();
     invoicePaymentCart.clearCart();
  
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;margin-top:-30px;"></div>');
     // modal acttion buttons
     $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span> <div id="postPaymentDiv02"><span class="postTransaction102" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> Post Transaction</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 penDiv101" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2 pen101" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
     // modal acttion buttons
 $('#invoice_modal_div_0').append(`
  <div class="w3-center w3-col l12 m12 s12 receiptTitles00">
  
       <div class="w3-center w3-col l12 m12 s12 org_logo_div"></div>
      <div class="w3-center w3-col l12 m12 s12"><b class="org_name" style="text-transform:uppercase"></b></div>
      <div class="w3-center w3-col l12 m12 s12 w3-hide-small pobox"></div>
      <div class="w3-center w3-col l12 m12 s12 w3-hide-small org_address" style="font-size: 0.7em;"></div>
      
      <div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:5px;color:var(--primnary-color);font-size:1.3em"><b>RECEIPT</b></div>
      <div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:0px;">
          
         <div id="invoiceDueDateDiv" class="w3-col l12 m12 s12" style="margin-left:5px;">
         <span id="receiptTitle00" style="margin-left:12px;font-weight:400;font-size:1em">No: </span>
            <span id="invoiceNumber" style="color:red;font-weight:400;font-size:1em">00</span>
          <span id="hiddenInvoiceNumber" class="clearOnTransactionSuccess" style="display:none;"></span>  
        
              Date: <input id="invoiceDueDate"  placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
           </div>
      </div>
  </div>
`);
  $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 receipt_modal_div_01"></div>');
  $('.receipt_modal_div_01').append('<div class="w3-col l8 m8 s12 clientDetailsDiv101" style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" id="addInvoiceClientDiv" style="cursor: pointer;margin-top:0px;"> <button id="addClientToInvoice0" type="button" style="float:left;font-weight:600;color:black;height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">CLIENT:</button></span><span class="w3-col l6 m6 s8 invoicedClientName0Div" style="margin-top:0px;font-weight: 600;"><span id="invoicedClientId0" class="clearOnTransactionSuccess" style="display: none;float:left;"></span><input id="invoicedClientName0" class="clearOnTransactionSuccess"  Placeholder="Enter Client name" type="text" style="float:left;border:none;background-color:transparent;outline:none;color:gray"/> </span><span class="w3-col l6 m6 s12" style="display:none;"><span id="invoicedClientName1" class="clearOnTransactionSuccess" style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="plotnumber07" Placeholder="Enter Plot No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;width:100px;"/><input id="invoicedClientAddress0" class="clearOnTransactionSuccess" Placeholder="Enter Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><input id="area07" Placeholder="Enter Area" type="text" class="w3-hide-small"  style="display:none;float:left;border:none;background-color:transparent;outline:none;"/></span><div class="w3-col l12 m12 s12"  style="margin-top:0px;"><input id="tpin07" Placeholder="Enter TPIN No:" class="w3-hide-small" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/><input id="nrc07" Placeholder="Enter Nrc No:" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/> </span><span class="w3-col l12 m12 s4 invoicedClientEmail0Div"  style="margin-top:0px;"><input id="invoicedClientEmail0" class="w3-hide-small" Placeholder="Enter Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 invoicedClientPhone0Div"  style="margin-top:0px;"><input id="invoicedClientPhone0" placeholder="Enter Phone No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
  $('.receipt_modal_div_01').append('<div class="w3-col l4 m4 s12 bankInvoiceDetailsDiv"><div class="w3-col l12 m12 s12 modeOfPaymentDiv0" style="margin-top:0px;"><select id="modeOfPayment" style="outline: none;margin-bottom:0px;color:black;float:left;margin-top:0px;border:none;font-weight:600;font-size:1em;background-color: transparent;text-indent: 0.01px;text-transform:capitalize;"><option value="CASH">CASH PAYMENT</option><option value="MOMO">DIGITAL PAYMENT</option><option value="BANK">BANK DEPOSIT</option><option value="BANK TRANSFER">BANK TRANSFER</option><option value="CREDIT">CREDIT</option></select></div><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="float:left;color:gray;font-weight: 600;font-size:0.9em;margin-left: 7px;"><select id="bankname99" style="-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;background-color: transparent;border: none;outline: none;color:black;text-transform:capitalize;margin-left:5px;"><option>Select Bank</option></select></span></span><div class="w3-col l12 m12 s12 bankDepositSlipIdDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Ref/ID: </span><input id="bankDepositSlipId" class="clearOnTransactionSuccess" type="text" placeholder="Enter here" style="float:left;border:none;outline: none;font-size:0.9em;background-color:transparent;font-weight: 400;width:70%;"/></div><div class="w3-col l12 m12 s12 bankAccountNumberDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:1em">A/C: </span><span id="bankAccountNumber" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0262020000045</span></div><div class="w3-col l12 m12 s12 bankBranchDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Branch: </span><span id="bankBranch99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> Mongu Branch</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Phone: </span><span class="org_contacts" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 000 000000</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Email: </span><span class="org_email" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"></span></div></div>');

       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:5px;background-color:rgba(96, 146, 205,0.2);font-weight:600;"><div class="w3-col l7 m7 s8" id="addProductToReceipt101"><span style="padding:7px;cursor:pointer;">Item/Product <span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Amount</div></div>');
       $('#invoice_modal_div_0').append('<div class="show-cart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.1);padding-left:7px;border-left:1px solid rgba(96, 146, 205,0.2);border-right:1px solid rgba(96, 146, 205,0.2);"></div>');
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.2);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l7 m7 s8"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="display:none;">00</div><div class="w3-col l1 m1 s3  w3-hide-small" style="color:transparent;">00</div><div class="w3-col l2 m2 s2 totalBilledAmounts" style="color:red;">00</div></div>');
      
       $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
       $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l7 m7 s12"style="float:left;margin-top: 0px;"><span class="w3-col l7 m7 s12"><select id="postRevenueCollector"  class="select2Styles" style="border: none !important;"><option>Select Collector </option></select></span> <span class="w3-col l5 m5 s12">  <select id="postRevenuePoint" class="select2Styles" style="border: none !important;"><option>Select Revenue Point </option></select></span></span><span class="w3-col l5 m5 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
      
      $.getJSON('xd-modules/admin-modules/backend/allStaff.php',function(data){

      $('#postRevenueCollector').empty().append('<option>Select User</option>');
      $.each(data.freelancedetails, function(i,freelance) {

      $('#postRevenueCollector').append('<option value="'+freelance.id+'" data-agentname="'+freelance.names+'">'+freelance.names+' ('+freelance.phone+')</option>');

      });

      });
      // gettig depot details
      $.getJSON('xd-modules/admin-modules/backend/depots.php',function(data){

      $('#postRevenuePoint').empty();
      $('#postRevenuePoint').append('<option value="0">Select Revenue Point</option>');
      $.each(data.details, function(i,cyberdesk) {
      $('#postRevenuePoint').append('<option value="'+cyberdesk.depot_id+'" data-depotname="'+cyberdesk.depot_name+'" data-depotcode="'+cyberdesk.depot_code+'">'+cyberdesk.depot_name+'</option>');
      });

      });
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed
      
        $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
        $('.bankDepositSlipIdDiv101').fadeOut('slow');
        $('.bankAccountNumberDiv101').fadeOut('slow');
        $('.bankBranchDiv101').fadeOut('slow');
        $('#bankname99').fadeOut('slow'); 
 
      //fetch bank details 
    //  $('#bankname99').fadeIn('slow'); 
      $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
        $('#bankName').empty();
         $('#bankname99').empty();
         //.append('<option value="0">Select Bank</option>');
        $.each(data.details, function(i,cyberdesk) {
          $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-bankid="'+cyberdesk.bank_id+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
      });
         
        });     
    

        ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.org_name').empty().append(user.orgname);              
                $('.org_email').empty().append(user.org_email);
                $('.org_contacts').empty().append(user.org_contacts);
                $('.org_address').empty().append(user.org_address); 
                $('.pobox').empty().append(user.org_p_o_box);
                $('.preparedBy').empty().append(user.username); 
    
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                        class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        });
     
 $('.select2Styles').select2({
  //  placeholder: "Select an option",
    allowClear: false,
    width: '100%',
    dropdownParent: $('#invoice_modal') // ensures dropdown appears inside modal
});

}

$(document).off('click', '.postTransaction102').on('click', '.postTransaction102', function (event) {
  event.preventDefault();
  event.stopPropagation();
    var itemTotalCost = $(".item-total-cost").val();

  $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Posting...</span></span>');
          
  // Gather data for the transaction
  var amount = $('.total-cart').html();
  var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var clientid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var fname = $("#invoicedClientName0").val().trim(); // Trim to remove spaces
  if (!fname) {fname = "General Customer";}
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html();
  var tpin = $("#tpin00").html();
 // var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val();
  var area = $("#area07").val();
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var payment_mode = $('#modeOfPayment').val();
  var bankAccountNumber = $('#bankAccountNumber').html();
  var bankDepositSlipId = $('#bankDepositSlipId').val();
  var bankName = $('#bankname99').val();
  var phone = $("#invoicedClientPhone0").val().trim(); // Trim to remove spaces
  if (!phone) {phone = "0000";}
  var invoiceNumber = $("#invoiceNumber").html();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var comment = $('#comment101').val();
   var agent_id = $('#postRevenueCollector').val();
   var agent_name = document.querySelector("#postRevenueCollector option:checked").dataset.agentname;
   var depot_id = $('#postRevenuePoint').val();
   var depot_name = document.querySelector("#postRevenuePoint option:checked").dataset.depotname;
    var depot_code = document.querySelector("#postRevenuePoint option:checked").dataset.depotcode;

  // Get the cart list from invoicePaymentCart
  var cartlist = invoicePaymentCart.listCart();
  if (!cartlist || cartlist.length === 0) {
      cartlist = shoppingCart.listCart(); // Fallback if the cart is empty
  }
  var cartlistDetails = JSON.stringify(cartlist);

  // Calculate total sum of items/products
var totalAmount = 0;
if (cartlist && cartlist.length > 0) {
    totalAmount = cartlist.reduce(function(sum, item) {
        // Change 'total_charge' to the correct property if needed
        return sum + (parseFloat(item.total) || 0);
    }, 0);
}
 
  // Ensure that necessary fields are populated
if (
  depot_id && depot_id !== '0' &&
  agent_id && agent_id !== '0' &&
  cartlistDetails && cartlistDetails !== '[]' && totalAmount > 0
) {
    
      var datastring = 'userid=' + userid + '&phone=' + phone + '&fname=' + fname +
                       '&lname=' + lname + '&email=' + email + '&orderDetails=' + cartlistDetails +
                       '&amount=' + amount + '&deliverylat=' + deliverylat + '&deliverylng=' + deliverylng +
                       '&deliveryaddress=' + deliveryaddress + '&transtype=' + transtype + '&invoiceNumber=' + invoiceNumber +'&hiddenInvoiceNumber=' + hiddenInvoiceNumber +
                       '&invoiceDueDate=' + invoiceDueDate + '&productid=' + productid + '&pacra=' + pacra +
                       '&tpin=' + tpin + '&plotnumber=' + plotnumber + '&area=' + area + '&nrc=' + nrc +
                       '&comment=' + comment + '&payment_mode=' + payment_mode + '&depot_name=' + depot_name+ '&depot_code=' + depot_code+ '&depot_id=' + depot_id + '&agent_name=' + agent_name + '&agent_id=' + agent_id+ '&bankName=' +bankName+ '&bankAccountNumber=' +bankAccountNumber+ '&bankDepositSlipId=' +bankDepositSlipId;

      $.ajax({
          data: datastring,
          url: "xd-modules/payment-processing/postTransaction.php",
          type: "POST"
      }).done(function (data) {
          var response = JSON.parse(data);

          if (response.status == 'created') {
            
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Success</span></span>');
             $(".invoiceDivActions101").hide();
          
            $("#topInvoiceNavContents").hide();
            $('#payment-btns-div01').hide();
            $('#invoiceNumber').empty();
            $('#invoiceNumber').append(response.receiptnumber);
            document.getElementById('invoiceDueDate').value = '';
            document.getElementById('invoiceDueDate').value = response.date;
          //  document.getElementById('trasactionTime34').value = '';
           // document.getElementById('trasactionTime34').value = response.time;
             setTimeout(function(){ 
                window.print(); 
                setTimeout(function(){ 
                  $(".invoiceDivActions101").show();
                  $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
               
               // $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Processing...</span></span>');
           }, 700);
            }, 200);


            transactions();

          } else {
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span>Failed try again!</span></span>');
    
          }
      }).fail(function (error) {
          reject('Server error: ' + error); 
      });

  } else {
      alert('Please ensure revenue collector, revenue point are selected and amount is not zero.');
      $('#invoicePaymentDiv02').empty().append('<span class="postTransaction102" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> Post Transaction</span></span>');
  }
 


});

 

/// END OF POSTING TRANSACTION/// END OF POSTING TRANSACTION/// END OF POSTING TRANSACTION/// END OF POSTING TRANSACTION/// END OF POSTING TRANSACTION/// END OF POSTING TRANSACTION/// END OF POSTING TRANSACTION
 //comment  section

 $(document).on('click','.pen101',function (event) {
  $('.penDiv101').empty('slow').append('<span class="fontx fx-edit-2 pen102" style="margin-top: -34px;color:green;"></span>');
  $('.commentDiv101').fadeIn('slow');
 });
 $(document).on('click','.pen102',function (event) {
  $('.penDiv101').empty('slow').append('<span class="fontx fx-edit-2 pen101" style="margin-top: -34px;"></span>');
  $('.commentDiv101').fadeOut('slow');
 });
  // selectig mode of paymet
     $(document).on('change keyup','#modeOfPayment',function (event) {
	   var modeOfPayment = $("#modeOfPayment").val(); 
        
      if(modeOfPayment=="CASH"){
        $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
         
        $('.bankDepositSlipIdDiv101').fadeOut('slow');
       $('.bankAccountNumberDiv101').fadeOut('slow');
        $('.bankBranchDiv101').fadeOut('slow'); 
       //  $('#bankAccoutDiv101').fadeOut('slow'); 
        $('#bankname99').fadeOut('slow'); 
         
        }else if(modeOfPayment=="BANK"){
               
          $('#invoicePaymentDiv02').empty().append('<span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
          $('.bankDepositSlipIdDiv101').fadeIn('slow');
          $('.bankAccountNumberDiv101').fadeIn('slow');
          $('.bankBranchDiv101').fadeIn('slow');
         
          $('#bankname99').fadeIn('slow'); 
          $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
            $('#bankName').empty();
            $.each(data.details, function(i,cyberdesk) {
              $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-bankid="'+cyberdesk.bank_id+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
          });
             
            });

            
            }else if(modeOfPayment=="MOMO"){
              $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
              $('.bankDepositSlipIdDiv101').fadeOut('slow');
              $('.bankAccountNumberDiv101').fadeOut('slow');
              $('.bankBranchDiv101').fadeOut('slow');
              $('#bankname99').fadeOut('slow'); 
            }else if(modeOfPayment=="BANK TRANSFER"){
              $('#invoicePaymentDiv02').empty().append('<span class="bankTransfer0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
              $('.bankDepositSlipIdDiv101').fadeIn('slow');
              $('.bankAccountNumberDiv101').fadeOut('slow');
              $('.bankBranchDiv101').fadeOut('slow');
              $('#bankname99').fadeIn('slow'); 
            }
    });
  

// close large modal
$(document).on('click','.closeLargeModal99',function (event) {
  $('#tempDiv00').remove();
  $('#generalmodalLarge').fadeOut();
 $('#generalmodalLargeMainDiv').show();
});

//bankrefid
$(document).on('click', '.bankdepositslip0', function(event){
  event.preventDefault();
  event.stopPropagation();
  var bankname = $(this).data('bankname');
  var bankaccountname = $(this).data('bankaccountname');
  var bankdepositslip = $(this).data('bankdepositslip');
  var bankdepositid = $(this).data('bankdepositid');
  $('#generalmodalLarge').fadeIn('slow');
  $('#div_title342').empty();
	$('#div_title342').append('<h4 style="margin-top:-7px;font-weight:600;">DEPOSIT SLIP DETAILS</h4>');
	$('#div_body342').empty();
  $('#div_body342').append('<b>'+bankname+'</b>: <span>'+bankaccountname+'</span><br/>');
  $('#div_body342').append('<b>Referece Id</b>: <span>'+bankdepositid+'</span>');
  $('#div_body342').append('<img src="xd-uploads/documents/deposits-slips/'+bankdepositslip+'" style="margin-top:20px;height:500px;width:100%;"/>');
  //$('#div_body342').append('<p id="closeModal876" style="background-color:transparent;color:green;height:35px;line-height:30px;width:100px;border-radius:15px;border:2px solid green;font-weight:600;cursor:pointer;">Send</p>');

});


  
 ///////////////// CASH TRANSACTION /////////////////////////// ///////////////// CASH TRANSACTION /////////////////////////// ///////////////// CASH TRANSACTION ///////////////////////////
///////////////// CASH TRANSACTION /////////////////////////// ///////////////// CASH TRANSACTION /////////////////////////// ///////////////// CASH TRANSACTION ///////////////////////////
 ///////////////// CASH TRANSACTION /////////////////////////// ///////////////// CASH TRANSACTION /////////////////////////// ///////////////// CASH TRANSACTION ///////////////////////////


// Function to fetch user data (agent_id and agent_name) from IndexedDB
function getUserIDUSERNAMEFromIndexedDB() {
  return new Promise((resolve, reject) => {
    openUserDB().then((db) => {
      const transaction = db.transaction(['user'], 'readonly');
      const store = transaction.objectStore('user');
      const request = store.getAll(); // Get all users from the store

      request.onsuccess = function() {
        if (request.result && request.result.length > 0) {
          // Resolve with both id and username as an object
          resolve({
            id: request.result[0].id,       // Assuming first record is the logged-in user
            username: request.result[0].username
          });
        } else {
          reject("No user data found in IndexedDB.");
        }
      };

      request.onerror = function(e) {
        reject(e.target.error);
      };
    }).catch((error) => {
      reject(error);
    });
  });
}

// Function to generate the offline receipt ID
// Function to generate the offline receipt ID
function generateOfflineReceipt(user_id) {
  const timestamp = new Date().getTime(); // Get current timestamp
  
  // Function to sum the digits of a given number (works for timestamp or UUID)
  function sumOfDigits(number) {
    // Ensure number is treated as a string and sum digits correctly
    const digits = number.toString().split('');
    return digits.reduce((acc, digit) => {
      const parsedDigit = parseInt(digit, 10);
      if (isNaN(parsedDigit)) {
        console.error(`Invalid digit found in ${number}: ${digit}`);
        return acc; // Skip invalid digits
      }
      return acc + parsedDigit;
    }, 0);
  }

  // Generate a UUID (for example, using version 4 UUID)
  function generateUUID() {
    // Simple function to simulate UUID generation
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
      var r = Math.random() * 16 | 0,
          v = c === 'x' ? r : (r & 0x3 | 0x8);
      return v.toString(16);
    });
  }

  // Sum of the digits of the current timestamp
  const timestampSum = sumOfDigits(timestamp);

  // Generate and sum the digits of a UUID
  const uuid = generateUUID();
  const uuidSum = sumOfDigits(uuid.replace(/-/g, '')); // Remove hyphens before summing

  // Ensure we don't have NaN values for timestamp or UUID sum
  if (isNaN(timestampSum) || isNaN(uuidSum)) {
    console.error("Invalid sum detected. timestampSum:", timestampSum, "uuidSum:", uuidSum);
    return; // Early return if NaN is found
  }

  // Combine user_id, timestamp sum, and UUID sum to generate the receipt number
  return user_id + '' + timestampSum + '' + uuidSum;
}
// Function to generate the offline receipt ID
 

// Function to store transaction offline in IndexedDB
 // Function to store transaction offline in IndexedDB

function ensureTransactionsStoreExists() {
  return new Promise((resolve, reject) => {
    // ⚠️ Use a version number one higher than your current DB version
    const request = indexedDB.open('transactionsDB', 3);

    request.onupgradeneeded = function (event) {
      const db = event.target.result;
      console.log('Running onupgradeneeded to add missing store…');

      // Only create if missing
      if (!db.objectStoreNames.contains('transactions')) {
        const store = db.createObjectStore('transactions', { keyPath: 'offline_receipt' });
        store.createIndex('agent_id', 'agent_id', { unique: false });
        store.createIndex('timestamp', 'timestamp', { unique: false });
        console.log('✅ Added new "transactions" store safely.');
      } else {
        console.log('✔️ "transactions" store already exists, no action needed.');
      }
    };

    request.onsuccess = function (event) {
      const db = event.target.result;
      console.log('Database opened successfully, stores:', db.objectStoreNames);
      db.close();
      resolve('Database upgraded and verified.');
    };

    request.onerror = function (event) {
      console.error('IndexedDB upgrade/open error:', event.target.error);
      reject(event.target.error);
    };
  });
}


function storeTransactionOffline(transactionData, agent_id, agent_name) {
  return new Promise((resolve, reject) => {
    // Open DB -- bump this version if you later add other stores/indexes
    const request = indexedDB.open('transactionsDB', 3);

    // onupgradeneeded: ensure the object store and indexes exist
    request.onupgradeneeded = function (e) {
      const db = e.target.result;
      console.log('onupgradeneeded event triggered, db version:', db.version);

      if (!db.objectStoreNames.contains('transactions')) {
        const store = db.createObjectStore('transactions', { keyPath: 'offline_receipt' });
        store.createIndex('agent_id', 'agent_id', { unique: false });
        store.createIndex('timestamp', 'timestamp', { unique: false });

        // If you want offline_receipt to be enforced as unique by the browser,
        // keeping it as keyPath already enforces uniqueness.
        console.log('Created "transactions" object store with keyPath offline_receipt');
      } else {
        console.log('"transactions" object store already exists');
      }
    };

    request.onsuccess = function (e) {
      const db = e.target.result;
      console.log('Database opened successfully', db.name, 'objectStores:', db.objectStoreNames);

      // Safety: ensure store exists before transaction (should be present after upgrade)
      if (!db.objectStoreNames.contains('transactions')) {
        db.close();
        const err = "Object store 'transactions' not found in DB.";
        console.error(err);
        return reject(err);
      }

      // Prevent re-entrancy / duplicate effects for this function in the same tick
      if (window.__storingOfflineTransaction) {
        console.warn('storeTransactionOffline already in progress — skipping duplicate call.');
        db.close();
        return reject('Already storing transaction (duplicate call).');
      }
      window.__storingOfflineTransaction = true;

      try {
        const tx = db.transaction(['transactions'], 'readwrite');
        const store = tx.objectStore('transactions');

        // Generate or sanitize offline_receipt
        // Assuming generateOfflineReceipt(agent_id) returns a string ID
        let offline_receipt;
        try {
          offline_receipt = generateOfflineReceipt(agent_id);
          if (!offline_receipt || typeof offline_receipt !== 'string') {
            throw new Error('generateOfflineReceipt returned invalid ID');
          }
        } catch (genErr) {
          console.error('generateOfflineReceipt error:', genErr);
          // fallback: create a safe timestamp-based id
          offline_receipt = 'OR-' + Date.now() + '-' + Math.random().toString(36).slice(2, 7);
          console.warn('Falling back to generated offline_receipt:', offline_receipt);
        }

        // Build the record exactly as you had it
        const transactionRecord = {
          offline_receipt: offline_receipt,
          agent_id: agent_id,
          agent_name: agent_name,
          amount: transactionData.amount,
          clientid: transactionData.clientid,
          fname: transactionData.fname,
          lname: transactionData.lname,
          email: transactionData.email,
          nrc: transactionData.nrc,
          area: transactionData.area,
          cartlistDetails: transactionData.cartlistDetails,
          businessCategory: transactionData.businessCategory,
          hiddenInvoiceNumber: transactionData.hiddenInvoiceNumber,
          deliverylat: transactionData.deliverylat,
          deliverylng: transactionData.deliverylng,
          deliveryaddress: transactionData.deliveryaddress,
          transtype: transactionData.transtype,
          invoiceNumber: transactionData.invoiceNumber,
          invoiceDueDate: transactionData.invoiceDueDate,
          productid: transactionData.productid,
          pacra: transactionData.pacra,
          tpin: transactionData.tpin,
          plotnumber: transactionData.plotnumber,
          phone: transactionData.phone,
          comment: transactionData.comment,
          payment_mode: transactionData.payment_mode,
          timestamp: new Date().getTime(),
          // small metadata useful for sync/trace
          _createdAtISO: new Date().toISOString(),
          _synced: false
        };

        // Add the record
        const addReq = store.add(transactionRecord);

        addReq.onsuccess = function () {
          console.log('Transaction stored offline successfully:', offline_receipt);

          // Mirror your original UI behavior but guard against duplicates using a small token
          const uiToken = '__invoiceOfflineStored_' + offline_receipt;
          if (!window[uiToken]) {
            window[uiToken] = true;

            // Update UI as you did
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span style="margin-top:-20px;"> Success</span></span>');
            $(".invoiceDivActions101").hide();
            $("#topInvoiceNavContents").hide();
            $('#payment-btns-div01').hide();

            $('#invoiceNumber').empty().append(offline_receipt);

            // Print after a short delay (as original)
            setTimeout(function () {
              try { window.print(); } catch (pErr) { console.warn('window.print error', pErr); }
            }, 100);

            // Restore UI after a short delay
            setTimeout(function () {
              $(".invoiceDivActions101").show();
              $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
            }, 700);

            // Refresh offline list (your function)
            try { appendOfflineTransactions(); } catch (err) { console.warn('appendOfflineTransactions error', err); }
          }

          // resolve with the offline_receipt so caller can use it
          resolve({ status: 'ok', offline_receipt: offline_receipt });
        };

        addReq.onerror = function (e) {
          console.error('Error storing transaction offline:', e.target ? e.target.error : e);
          reject(e.target ? e.target.error : 'Error storing transaction offline.');
        };

        // transaction-level handlers
        tx.oncomplete = function () {
          // close DB and clear re-entrancy flag
          try { db.close(); } catch (err) {}
          window.__storingOfflineTransaction = false;
          console.log('IndexedDB transaction complete.');
        };

        tx.onerror = function (event) {
          console.error('IndexedDB transaction error:', event.target ? event.target.error : event);
          // keep reject handled in addReq.onerror normally
        };

        tx.onabort = function (event) {
          console.warn('IndexedDB transaction aborted:', event);
        }

      } catch (outerErr) {
        window.__storingOfflineTransaction = false;
        try { db.close(); } catch (err) {}
        console.error('Unexpected error in storeTransactionOffline:', outerErr);
        reject(outerErr);
      }
    };

    request.onerror = function (e) {
      console.error('Error opening IndexedDB:', e.target ? e.target.error : e);
      reject('Error opening IndexedDB.');
    };
  });
}

// Function to send the transaction to the server (when online)  hiddenInvoiceNumber
function sendTransactionToServer(transactionData, agent_id, agent_name) {
  return new Promise((resolve, reject) => {
      var datastring = 'userid=' + transactionData.userid + '&phone=' + transactionData.phone + '&fname=' + transactionData.fname +
                       '&lname=' + transactionData.lname + '&email=' + transactionData.email + '&orderDetails=' + transactionData.cartlistDetails +
                       '&amount=' + transactionData.amount + '&deliverylat=' + transactionData.deliverylat + '&deliverylng=' + transactionData.deliverylng +
                       '&deliveryaddress=' + transactionData.deliveryaddress + '&transtype=' + transactionData.transtype + '&invoiceNumber=' + transactionData.invoiceNumber +'&hiddenInvoiceNumber=' + transactionData.hiddenInvoiceNumber +
                       '&invoiceDueDate=' + transactionData.invoiceDueDate + '&productid=' + transactionData.productid + '&pacra=' + transactionData.pacra +
                       '&tpin=' + transactionData.tpin + '&plotnumber=' + transactionData.plotnumber + '&area=' + transactionData.area + '&nrc=' + transactionData.nrc +
                       '&comment=' + transactionData.comment + '&payment_mode=' + transactionData.payment_mode + '&offline_receipt=' + transactionData.offline_receipt;

      $.ajax({
          data: datastring,
          url: "xd-modules/payment-processing/cashTransact.php",
          type: "POST"
      }).done(function (data) {
          var response = JSON.parse(data);

          if (response.status == 'created') {
            
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Success</span></span>');
             $(".invoiceDivActions101").hide();
          
            $("#topInvoiceNavContents").hide();
            $('#payment-btns-div01').hide();
            $('#invoiceNumber').empty();
            $('#invoiceNumber').append(response.receiptnumber);
            document.getElementById('invoiceDueDate').value = '';
            document.getElementById('invoiceDueDate').value = response.date;
          //  document.getElementById('trasactionTime34').value = '';
           // document.getElementById('trasactionTime34').value = response.time;
             setTimeout(function(){ 
                window.print(); 
                setTimeout(function(){ 
                  $(".invoiceDivActions101").show();
                  $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
               
               // $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Processing...</span></span>');
           }, 700);
            }, 200);


            transactions();

          } else {
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span>Failed try again!</span></span>');
    
          }
      }).fail(function (error) {
          reject('Server error: ' + error); 
      });
  });
}


// sendTransactionToServer
// Function to send the transaction to the server (when online)
function sendDigitalPayTransactionToServer(transactionData, agent_id, agent_name) {
  return new Promise((resolve, reject) => {
      var datastring = 'userid=' + transactionData.userid + '&phone=' + transactionData.phone + '&fname=' + transactionData.fname +
                       '&lname=' + transactionData.lname + '&email=' + transactionData.email + '&orderDetails=' + transactionData.cartlistDetails +
                       '&amount=' + transactionData.amount + '&deliverylat=' + transactionData.deliverylat + '&deliverylng=' + transactionData.deliverylng +
                       '&deliveryaddress=' + transactionData.deliveryaddress + '&transtype=' + transactionData.transtype + '&invoiceNumber=' + transactionData.invoiceNumber +
                       '&invoiceDueDate=' + transactionData.invoiceDueDate + '&productid=' + transactionData.productid + '&pacra=' + transactionData.pacra +
                       '&tpin=' + transactionData.tpin + '&plotnumber=' + transactionData.plotnumber + '&area=' + transactionData.area + '&nrc=' + transactionData.nrc +
                       '&comment=' + transactionData.comment + '&payment_mode=' + transactionData.payment_mode + '&offline_receipt=' + transactionData.offline_receipt;

      $.ajax({
          data: datastring,
          url: "xd-modules/payment-processing/momoPay.php",
          type: "POST",
          timeout: 180000, // 3 minutes in ms
      }).done(function (data) {
          var response = JSON.parse(data);

          if (response.status == 'created') {
            
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgb(9, 167, 30);"><span> Success</span></span>');
             $(".invoiceDivActions101").hide();
          
            $("#topInvoiceNavContents").hide();
            $('#payment-btns-div01').hide();
            $('#invoiceNumber').empty();
            $('#invoiceNumber').append(response.receiptnumber);
            document.getElementById('invoiceDueDate').value = '';
            document.getElementById('invoiceDueDate').value = response.date;
          //  document.getElementById('trasactionTime34').value = '';
           // document.getElementById('trasactionTime34').value = response.time;
               setTimeout(function(){ 
                  window.print(); 
              }, 100);
            setTimeout(function(){ 
                  $(".invoiceDivActions101").show();
                  $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> Make Payment </span></span>');
               
               // $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Processing...</span></span>');
           }, 300);


            transactions();

          } else {
            $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span>Failed try again!</span></span>');
    
          }
      }).fail(function (error) {
          reject('Server error: ' + error); 
      });
  });
}  
// MOMO TRANSACTION
// Event listener for the momo transaction button
$(document).off('click', '.momoTransact0').on('click', '.momoTransact0', function (event) {
  event.preventDefault();
  event.stopPropagation();
  $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Processing...</span></span>');
          
  // Gather data for the transaction
  var amount = $('.total-cart').html();
  var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var clientid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var fname = $("#invoicedClientName0").val().trim(); // Trim to remove spaces
  if (!fname) {fname = "General Customer";}
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html();
  var tpin = $("#tpin00").html();
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val();
  var area = $("#area07").val();
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var payment_mode = 'CASH';
  var phone = $("#invoicedClientPhone0").val().trim(); // Trim to remove spaces
  //if (!phone) {phone = "0000";}
  var invoiceNumber = $("#invoiceNumber").html();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var comment = $('#comment101').val();

  // Get the cart list from invoicePaymentCart
  var cartlist = invoicePaymentCart.listCart();
  if (!cartlist || cartlist.length === 0) {
      cartlist = shoppingCart.listCart(); // Fallback if the cart is empty
  }
  var cartlistDetails = JSON.stringify(cartlist);

  var totalAmount = 0;
if (cartlist && cartlist.length > 0) {
    totalAmount = cartlist.reduce(function(sum, item) {
        // Change 'total_charge' to the correct property if needed
        return sum + (parseFloat(item.total) || 0);
    }, 0);
}
  // Ensure that necessary fields are populated
  if (phone !== '' && cartlistDetails !== '' && cartlistDetails !== '[]' && totalAmount > 0) {
    getUserIDUSERNAMEFromIndexedDB().then(function (user) {
          const agent_id = user.id;       // Get user ID from IndexedDB (or user DB)
          const agent_name = user.username; // Get username from IndexedDB (or user DB)

          const transactionData = {
              userid: userid,
              phone: phone,
              clientid: clientid,
              fname: fname,
              lname: lname,
              email: email,
              amount: amount,
              cartlistDetails: cartlistDetails,
              businessCategory: businessCategory,
              deliverylat: deliverylat,
              deliverylng: deliverylng,
              deliveryaddress: deliveryaddress,
              transtype: transtype,
              invoiceNumber: invoiceNumber,
              invoiceDueDate: invoiceDueDate,
              hiddenInvoiceNumber:hiddenInvoiceNumber,
              productid: productid,
              pacra: pacra,
              tpin: tpin,
              plotnumber: plotnumber,
              area: area,
              nrc: nrc,
              comment: comment,
              payment_mode: payment_mode,
          };

          if (isOnline()) {
              // If online, send the transaction to the server
              transactionData.offline_receipt = generateOfflineReceipt(agent_id); // Generate offline receipt with user ID and timestamp
              sendDigitalPayTransactionToServer(transactionData, agent_id, agent_name).then(function (response) {
                  console.log('Transaction sent to server:', response);
                  // Handle response, e.g., update UI or show success message
              }).catch(function (error) {
                  console.error('Failed to send transaction:', error);
                  // Handle error, e.g., show an error message
              });
          } else {

            // set receipt mode of paynment to cash
            $('#modeOfPayment').empty().append('<option value="CASH">Cash payment</option><option value="MOMO">Digital Payment</option><option value="BANK">Bank Deposit</option><option value="BANK TRANSFER">Bank Transfer</option>');
              // If offline, store the transaction locally
              storeTransactionOffline(transactionData, agent_id, agent_name).then(function (message) {
                  console.log(message);
                  // Handle offline storage success, e.g., show confirmation message
              }).catch(function (error) {
                  console.error('Failed to store transaction offline:', error);
                  // Handle error, e.g., show an error message
              });
          }
      }).catch(function (error) {
          console.error('Error fetching user details:', error);
          // Handle error fetching user details from IndexedDB
      });
  } else {
      alert('Ensure phone number is not empty and amount is not zero!');
      $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> MAKE PAYMENT</span></span>');
       
  }
});
  //MOMO TRASACTION



// Event listener for the cash transaction button
$(document).off('click', '.cashTransact01').on('click', '.cashTransact01', function (event) {
  event.preventDefault();
  event.stopPropagation(); 
    var itemTotalCost = $(".item-total-cost").val();
 

  $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Processing...</span></span>');
          
  // Gather data for the transaction
  var amount = $('.total-cart').html();
  var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var clientid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var fname = $("#invoicedClientName0").val().trim(); // Trim to remove spaces
  if (!fname) {fname = "General Customer";}
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html();
  var tpin = $("#tpin00").html();
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val();
  var area = $("#area07").val();
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var payment_mode = 'CASH';
  var phone = $("#invoicedClientPhone0").val().trim(); // Trim to remove spaces
  if (!phone) {phone = "0000";}
  var invoiceNumber = $("#invoiceNumber").html();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var comment = $('#comment101').val();

  // Get the cart list from invoicePaymentCart
  var cartlist = invoicePaymentCart.listCart();
  if (!cartlist || cartlist.length === 0) {
      cartlist = shoppingCart.listCart(); // Fallback if the cart is empty
  }
  var cartlistDetails = JSON.stringify(cartlist);
// Calculate total sum of items/products
var totalAmount = 0;
if (cartlist && cartlist.length > 0) {
    totalAmount = cartlist.reduce(function(sum, item) {
        // Change 'total_charge' to the correct property if needed
        return sum + (parseFloat(item.total) || 0);
    }, 0);
}
  // Ensure that necessary fields are populated
  if (totalAmount > 0) {
    getUserIDUSERNAMEFromIndexedDB().then(function (user) {
          const agent_id = user.id;       // Get user ID from IndexedDB (or user DB)
          const agent_name = user.username; // Get username from IndexedDB (or user DB)

          const transactionData = {
              userid: userid,
              phone: phone,
              clientid: clientid,
              fname: fname,
              lname: lname,
              email: email,
              amount: amount,
              cartlistDetails: cartlistDetails,
              businessCategory: businessCategory,
              deliverylat: deliverylat,
              deliverylng: deliverylng,
              deliveryaddress: deliveryaddress,
              transtype: transtype,
              invoiceNumber: invoiceNumber,
              invoiceDueDate: invoiceDueDate,
              hiddenInvoiceNumber:hiddenInvoiceNumber,
              productid: productid,
              pacra: pacra,
              tpin: tpin,
              plotnumber: plotnumber,
              area: area,
              nrc: nrc,
              comment: comment,
              payment_mode: payment_mode,
          };

          if (isOnline()) {
              // If online, send the transaction to the server
              transactionData.offline_receipt = generateOfflineReceipt(agent_id); // Generate offline receipt with user ID and timestamp
              sendTransactionToServer(transactionData, agent_id, agent_name).then(function (response) {
                  console.log('Transaction sent to server:', response);
                  // Handle response, e.g., update UI or show success message
              }).catch(function (error) {
                  console.error('Failed to send transaction:', error);
                  // Handle error, e.g., show an error message
              });
          } else {

              // If offline, store the transaction locally
              ensureTransactionsStoreExists().then(() => {
              storeTransactionOffline(transactionData, agent_id, agent_name).then(function (message) {
                  console.log(message);
                  // Handle offline storage success, e.g., show confirmation message
              }).catch(function (error) {
                  console.error('Failed to store transaction offline:', error);
                  // Handle error, e.g., show an error message
              });
                });

          }
      }).catch(function (error) {
          console.error('Error fetching user details:', error);
          // Handle error fetching user details from IndexedDB
      });
  } else {
      alert('Amount can not be zero!');
      $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
               
  }
 


});


// Check if the user is online or offline
function isOnline() {
  return navigator.onLine;
}

let syncInterval = null;

// Function to start syncing every 15s (only if online)
function startSyncInterval() {
  if (syncInterval) return; // prevent duplicates
  if (!isOnline()) {
    console.log('User is offline, sync not started.');
    return;
  }

  console.log('🟢 Online — starting sync interval.');
  syncInterval = setInterval(() => {
    syncOfflineTransactions()
      .then(msg => console.log('✅', msg))
      .catch(err => console.error('❌', err));
  }, 15000); // 15 seconds
}

// Function to stop syncing
function stopSyncInterval() {
  if (syncInterval) {
    clearInterval(syncInterval);
    syncInterval = null;
    console.log('🔴 Sync interval stopped.');
  }
}

// Start the sync loop only if online initially
if (isOnline()) {
  startSyncInterval();
} else {
  console.log('User is offline — showing offline transactions.');
  appendOfflineTransactions();
}

// Listen for online/offline changes
window.addEventListener('offline', () => {
  console.log('⚠️ User went offline — stopping sync.');
  stopSyncInterval();
  appendOfflineTransactions();
});

window.addEventListener('online', () => {
  console.log('✅ User back online — restarting sync.');
  startSyncInterval();
});


 
const request = indexedDB.open('transactionsDB', 3);

request.onupgradeneeded = function (e) {
    const db = e.target.result;
    const oldVersion = e.target.transaction ? e.target.transaction.db.version : "N/A";
    console.log('Upgrading database from version ' + oldVersion + ' to ' + db.version);

    let store;
    if (!db.objectStoreNames.contains('transactions')) {
        store = db.createObjectStore('transactions', { keyPath: 'offline_receipt' });
        store.createIndex('agent_id', 'agent_id', { unique: false });
        store.createIndex('timestamp', 'timestamp', { unique: false });
        store.createIndex('offline_receipt', 'offline_receipt', { unique: false });
    } else {
        store = e.currentTarget.transaction.objectStore('transactions');
        console.log('Object store "transactions" already exists.');

        if (!store.indexNames.contains('offline_receipt')) {
            store.createIndex('offline_receipt', 'offline_receipt', { unique: false });
        }
    }
};

request.onsuccess = function (e) {
    const db = e.target.result;
    console.log('Database opened successfully.');
};

request.onerror = function (e) {
    console.error('Error opening IndexedDB:', e.target.error);
};


function syncOfflineTransactions() {
  return new Promise((resolve, reject) => {
      const request = indexedDB.open('transactionsDB', 3);

      request.onsuccess = function (e) {
          const db = e.target.result;
          const transaction = db.transaction(['transactions'], 'readonly');
          const store = transaction.objectStore('transactions');

          const allTransactionsRequest = store.getAll();

          allTransactionsRequest.onsuccess = function () {
              const transactions = allTransactionsRequest.result;

              if (transactions.length > 0) {
                  transactions.sort((a, b) => a.timestamp - b.timestamp);

                  const batchSize = 30;
                  let batchStartIndex = 0;

                  function sendBatch() {
                      const batch = transactions.slice(batchStartIndex, batchStartIndex + batchSize);

                      const formattedTransactions = batch.map(transaction => ({
                          userid: transaction.agent_id,
                          phone: transaction.phone,
                          agent_name: transaction.agent_name,
                          clientid: transaction.clientid,
                          fname: transaction.fname,
                          lname: transaction.lname,
                          businessCategory: transaction.businessCategory,
                          hiddenInvoiceNumber: transaction.hiddenInvoiceNumber,
                          email: transaction.email,
                          orderDetails: JSON.parse(transaction.cartlistDetails),
                          deliverylat: transaction.deliverylat,
                          deliverylng: transaction.deliverylng,
                          deliveryaddress: transaction.deliveryaddress,
                          transtype: transaction.transtype,
                          invoiceNumber: transaction.invoiceNumber,
                          invoiceDueDate: transaction.invoiceDueDate,
                          plotnumber: transaction.plotnumber,
                          area: transaction.area,
                          pacra: transaction.pacra,
                          tpin: transaction.tpin,
                          nrc: transaction.nrc,
                          comment: transaction.comment,
                          payment_mode: transaction.payment_mode,
                          offline_receipt: transaction.offline_receipt
                      }));

                      $.ajax({
                          url: "xd-modules/payment-processing/syncTransactions.php",
                          type: "POST",
                          contentType: "application/json",
                          data: JSON.stringify({ transactions: formattedTransactions }),
                          success: function (response) {
                            
                              response = typeof response === 'string' ? JSON.parse(response) : response;

                              if (response.status === 'success' || response.status === 'exists') {
                                  console.log('Batch processed successfully. Status:', response.status);

                                  let receiptsToDelete = [];

                                  if (response.offline_receipt && Array.isArray(response.offline_receipt)) {
                                      receiptsToDelete = response.offline_receipt;
                                  }

                                  if (receiptsToDelete.length > 0) {
                                      console.log('Receipts to delete:', receiptsToDelete);
                                      deleteOfflineTransactions(receiptsToDelete)
                                          .then(() => {
                                              batchStartIndex += batchSize;
                                              if (batchStartIndex < transactions.length) {
                                                  sendBatch();
                                              } else {
                                                  resolve('All transactions synced and cleared.');
                                              }
                                          })
                                          .catch(err => {
                                              reject('Error deleting offline transactions: ' + err);
                                          });
                                  } else {
                                      console.log('No receipts to delete.');
                                      resolve('No receipts to delete after sync.');
                                  }
                              } else {
                                  reject('Failed to process transactions. Response status: ' + response.status);
                              }


                          },
                          error: function (err) {
                              reject('Error syncing transactions: ' + err);
                          }
                      });
                  }

                  sendBatch();
              } else {
                  resolve('No offline transactions to sync.');
              }
          };

          allTransactionsRequest.onerror = function () {
              reject('Error retrieving transactions from IndexedDB.');
          };
      };

      request.onerror = function () {
          reject('Error opening IndexedDB.');
      };
  });
}

 function deleteOfflineTransactions(offlineReceipts) {
  return new Promise((resolve, reject) => {
    const request = indexedDB.open('transactionsDB', 3);

    request.onsuccess = function (e) {
      const db = e.target.result;
      const transaction = db.transaction(['transactions'], 'readwrite');
      const store = transaction.objectStore('transactions');

      let deleteCount = 0;

      offlineReceipts.forEach(receipt => {
        const deleteReq = store.delete(receipt); // offline_receipt is the keyPath
        deleteReq.onsuccess = () => {
          deleteCount++;
          console.log(`✅ Deleted offline transaction: ${receipt}`);
        };
        deleteReq.onerror = (err) => {
          console.error(`❌ Error deleting receipt ${receipt}`, err);
        };
      });

      transaction.oncomplete = function () {
        console.log(`🧹 Deleted ${deleteCount} offline transaction(s)`);
        resolve('Transactions with offline_receipt(s) deleted successfully');
        appendOfflineTransactions(); // refresh UI if needed
      };

      transaction.onerror = function (event) {
        reject('Error deleting offline transactions: ' + event.target.error);
      };
    };

    request.onerror = function () {
      reject('Error opening IndexedDB for deletion.');
    };
  });
}



  ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS//////////////
 ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS//////////////

 function appendOfflineTransactions() {
  // Define mainBody
  $('#page-title3434').empty();
  $('#page-options').empty();
  $('#page-options').append('<span style="font-weight:400;font-size:1em;margin-top:-7px;"><select id="transactionSelect0" style="text-transform:uppercase;border:none;background-color:transparent;color:gray;outline:none;"><option value="All">My Transactions</option></select><span id="record01" class="topNavTotals" style="font-size:0.8em;background-color:transparent;padding:3px;border-radius:8%;width:;color:gray;">0</span></span>');
  let today = new Date().toISOString().slice(0, 10);

  $('#transactionSelect0').empty();
  $('#transactionSelect0').append('<option class="transactionSelect001" value="All">My Transactions</option><option class="transactionSelect001" value="findTransactioin101">Find Transactions</option><option value="collectionSummary101" class="collectionSummary101">Collection Summary</option>');
 
        // this script trims long title texts
  $('#sub_top_nav').empty();
  $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s3 w3-center"><input id="searchAgentTransactions" type="text" placeholder="Search..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s3 w3-center w3-hide-small" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-filter" style="color:gray;margin-top:5px;"></span><select id="transactionsStatus89" style="background-color:transparent;border:none;outline:none;color:rgba(96, 146, 205,1);"><option>All</option></select></span><div/></div><div class="w3-col l5 m5 s9" style="padding-left:7px;padding-top:3px;color:gray;background-color:;"><span style="float:right;"><input type="date" value="'+today+'" id="transactionStartDate" style="color:rgba(96, 146, 205,1);border:none;outline:none;font-weight:100;background-color:transparent;max-width:115px;"/><input type="date" value="'+today+'" id="transactionsEndDate" style="color:rgba(96, 146, 205,1);border:none;outline:none;font-weight:100;background-color:transparent;max-width:115px;"/></span></div>');
  $('#sub_top_nav').append('<ul id="tabs" class="tabs" style="margin-top:30px;"><li class="invoices0">Invoices</li><li class="trasactions0"  style="color:rgba(96, 146, 205,1);background-color:#fff;border:1px solid rgba(96, 146, 205,1);border-radius:10px;">Trasactions</li><li  class="collectionSummary101">Summary</li><li  class="deposits0">Deposit</li><li class="revenueTasks">Tasks</li></ul>');
  
          
  $('#right_nav_options0').empty();
  $('#record01').empty();
  $('#main-body').empty();
  const mainBody = document.querySelector('#main-body');
  if (!mainBody) {
      console.error('Error: #main-body element not found in the DOM.');
      return;
  }

  // Open transactionsDB
  const transactionsRequest = indexedDB.open('transactionsDB', 3);

  transactionsRequest.onsuccess = function (e) {
      const transactionsDB = e.target.result;

      // Open userDB
      const usersRequest = indexedDB.open('userDB', 3);

      usersRequest.onsuccess = function (e) {
          const usersDB = e.target.result;

          // Start a transaction for userDB
          const usersTransaction = usersDB.transaction(['user'], 'readonly');
          const usersStore = usersTransaction.objectStore('user');

          // Retrieve the current user
          const currentUserRequest = usersStore.getAll();

          currentUserRequest.onsuccess = function () {
              const users = currentUserRequest.result;

              if (!users || users.length === 0) {
                  console.error('No user is logged in.');
                  return;
              }

              const currentUser = users[0]; // Assuming the first user is the logged-in user
              console.log('Logged-in user:', currentUser);

              const agentId = currentUser.id;

              // Start a transaction for transactionsDB
              const transactionsTransaction = transactionsDB.transaction(['transactions'], 'readonly');
              const transactionsStore = transactionsTransaction.objectStore('transactions');

              // Retrieve all transactions
              const allTransactionsRequest = transactionsStore.getAll();

              allTransactionsRequest.onsuccess = function () {
                  const transactions = allTransactionsRequest.result;

                  console.log('All Transactions:', transactions);

                  const filteredTransactions = transactions.filter(
                      transaction => transaction.agent_id === agentId
                  );

                  console.log('Filtered Transactions:', filteredTransactions);

                  if (filteredTransactions.length === 0) {
                      // No offline transactions found, display the message with username and phone
                      mainBody.innerHTML = `
                          <p style="padding: 10px;color:gray;">
                              Hello <span style="color:#6092cd;">${currentUser.username}</span>, No offline transactions found for you. 
                              Click the top icons to transact or better still swipe from right to left.
                          </p> 
                      `;
                      return;
                  }

                  filteredTransactions.sort((a, b) => b.timestamp - a.timestamp);
                  filteredTransactions.forEach(transaction => {
                      // Check if cartlistDetails exists and is an array
                      let totalAmount = 0;

                      // Check if cartlistDetails exists and is a stringified JSON
                      if (typeof transaction.cartlistDetails === 'string') {
                          try {
                              transaction.cartlistDetails = JSON.parse(transaction.cartlistDetails);
                          } catch (error) {
                              console.error('Error parsing cartlistDetails:', error);
                              return;
                          }
                      }

                      // Now process the cartlistDetails (which should now be an array of objects)
                      if (Array.isArray(transaction.cartlistDetails)) {
                          totalAmount = transaction.cartlistDetails.reduce((sum, item) => {
                              const price = parseFloat(item.price);  
                              const count = parseInt(item.count, 10); 
                              if (isNaN(price) || isNaN(count)) {
                                  console.error('Invalid price or count:', item);  
                                  return sum; 
                              }
                              return sum + (price * count);  
                          }, 0);
                      }

                      const date = new Date(transaction.timestamp);
                      const formattedDate = date.toLocaleString();

                      const transactionHTML = `
                          <div class="inner-data-div w3-col l12 m12 s12" style="cursor:pointer"
                               data-receiptnumber="${transaction.offline_receipt}"
                               data-userid="${transaction.agent_id}" 
                               data-names="${transaction.fname} ${transaction.lname}"
                               data-phone="${transaction.phone}">
                              <div class="w3-col l1 m1 s8"><b style="margin-left:6px;">
                                  <span class="w3-hide-large w3-hide-medium" style="color:rgba(96, 146, 205,1)">Receipt No: </span>
                                  <span style="color:red;">${transaction.offline_receipt}</span></b> 
                              </div>
                              <div class="w3-col l1 m1 s3" style="font-weight:400;color:rgba(96, 146, 205,1);">
                                  <span> K${totalAmount.toFixed(2)}</span>
                              </div>
                              <div class="w3-col l4 m4 s8" style="padding-left:5px;"> ${transaction.fname} ${transaction.lname}</div>
                              <div class="w3-col l2 m2 s4" style="font-weight:400;">
                                  <a href="https://wa.me/26${transaction.phone}" target="_blank" style="text-decoration:none;margin-right:5px;margin-top:2px;">
                                      <img src="xd-assets/img/whatsApp_icon.png" style="height:20px;width:20px;"/>${transaction.phone}</a>
                              </div>
                              <div class="w3-col l3 m3 s8">
                                  <span style="font-weight:400;color:;margin-left:7px;">
                                    ${formattedDate}
                                  </span>
                              </div>
                              <div class="w3-col l1 m1 s4" style="color:gray;">Pending Sync</div>
                          </div>
                      `;
                  
                      mainBody.insertAdjacentHTML('beforeend', transactionHTML);
                  });
                  
                  console.log('Offline transactions appended to the DOM.');
              };

              allTransactionsRequest.onerror = function () {
                  console.error('Error retrieving transactions:', allTransactionsRequest.error);
              };
          };

          currentUserRequest.onerror = function () {
              console.error('Error retrieving current user:', currentUserRequest.error);
          };
      };

      usersRequest.onerror = function () {
          console.error('Error opening userDB:', usersRequest.error);
      };
  };

  transactionsRequest.onerror = function () {
      console.error('Error opening transactionsDB:', transactionsRequest.error);
  };
}


 /////// END DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS//////////////
  /////// END DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS////////////// ///////DISPLAYING LOCAL TRANSACTIONS//////////////
// end CASH TRANSACTION PAYMENT


////BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK  TRANSFER/// BANK
 
$(document).off('click', '.bankTransfer0').on('click', '.bankTransfer0', function(event) {

  event.preventDefault();
  event.stopPropagation();
  // Get the file input
  //alert('alert');
  var fileInput = $('#depositslipfile');
  var file = fileInput[0].files[0]; // File may be undefined if no file is selected
 
  // Retrieve other necessary data
  var amount = $('.total-cart').html();
 // var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10); // Fetch and convert to integer
  var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;

  var fname = $("#invoicedClientName0").val();
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var productid = $("#productid").html();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var phone = $("#invoicedClientPhone0").val();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var bankDepositSlipId = $('#bankDepositSlipId').val();
  var bankId = document.querySelector("#bankname99 option:checked").dataset.bankid;
  var bankAccountName = $('#bankname99').val();
  var myBankAccountNumber44 = document.querySelector("#bankname99 option:checked").dataset.accountnumber;
  var bankName = $('#bankname99').val();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var comment = $('#comment101').val();
  // Get the cart list from invoicePaymentCart
var cartlist = invoicePaymentCart.listCart();

// Check if cartlist is empty or null
if (!cartlist || cartlist.length === 0) { 
    // If empty or null, fall back to shoppingCart
    cartlist = shoppingCart.listCart();
}

// Convert the cart list to a JSON string
var cartlistDetails = JSON.stringify(cartlist);


  if (phone != '' && cartlistDetails != '' && bankDepositSlipId != '' && bankAccountName != '' && bankName != '' && myBankAccountNumber44 !='' && bankId !='') {
      // Create FormData object for file and other data
      var formData = new FormData();
      
      // Only append the file if it exists
      if (file) {
          formData.append('field-upload', file);
      }

      formData.append('userid', userid);
      formData.append('phone', phone);
      formData.append('fname', fname);
      formData.append('lname', lname);
      formData.append('email', email);
      formData.append('orderDetails', cartlistDetails);
      formData.append('amount', amount);
      formData.append('deliverylat', deliverylat);
      formData.append('deliverylng', deliverylng);
      formData.append('deliveryaddress', deliveryaddress);
      formData.append('transtype', transtype);
      formData.append('invoiceDueDate', invoiceDueDate);
      formData.append('bankDepositSlipId', bankDepositSlipId);
      formData.append('bankAccountName', bankAccountName);
      formData.append('bankName', bankName);
      formData.append('productid', productid);
      formData.append('businessCategory', businessCategory);
      formData.append('pacra', pacra);
      formData.append('tpin', tpin);
      formData.append('plotnumber', plotnumber);
      formData.append('area', area);
      formData.append('nrc', nrc);
      formData.append('hiddenInvoiceNumber', hiddenInvoiceNumber);
      formData.append('bankId', bankId);
      formData.append('myBankAccountNumber44', myBankAccountNumber44); 
      formData.append('comment', comment);
 
      $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Processing...</span></span>');
      // AJAX request with progress
      $.ajax({
          url: "xd-modules/payment-processing/bankTransfer.php",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          xhr: function() {
              var xhr = new XMLHttpRequest();
              xhr.upload.addEventListener('progress', function(event) {
                  if (event.lengthComputable) {
                      var percentComplete = Math.round((event.loaded / event.total) * 100);
                      // Update the progress in the div
                      $('.transactProgress043').text('Uploading: ' + percentComplete + '%');
                  }
              }, false);
              return xhr;
          },
      }).done(function(data) {
          var response = JSON.parse(data);
          if (response.status == 'created') { 

            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Success</span></span>');
           $(".invoiceDivActions101").hide();
            
              $("#topInvoiceNavContents").hide();
              $('#payment-btns-div01').hide();
              $('#invoiceNumber').empty();
              $('#invoiceNumber').append(response.receiptnumber);
              document.getElementById('invoiceDueDate').value = '';
              document.getElementById('invoiceDueDate').value = response.date;
             // document.getElementById('trasactionTime34').value = '';
             // document.getElementById('trasactionTime34').value = response.time;
             
               setTimeout(function(){ 
                  window.print(); 
                  setTimeout(function(){ 
                    $(".invoiceDivActions101").show();
                    $('#invoicePaymentDiv02').empty().append('<span class="bankTransfer0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
                   }, 700);
              }, 200);
              transactions();

          } else {

            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);">Failed! try again</span></span>');
    
          }
      });
  } else {
      alert('Please fill in all data...deposit slip id or reference!');
  }
});
//// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER /////// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER /////// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER /////// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER//// ENDOF BANK TRANSFER ///

/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
$(document).off('click', '.bankTransact0').on('click', '.bankTransact0', function(event) {

  event.preventDefault();
  event.stopPropagation();
  // Get the file input
  //alert('alert');
  var fileInput = $('#depositslipfile');
  var file = fileInput[0].files[0]; // File may be undefined if no file is selected
  if (!file) {
    alert('Please upload a bank deposit slip before submitting. Click the file icon to capture and upload.');
    return; // Stop the click handler
}
  // Retrieve other necessary data
  var amount = $('.total-cart').html();
 // var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10); // Fetch and convert to integer
  var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;

  var fname = $("#invoicedClientName0").val();
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var productid = $("#productid").html();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var phone = $("#invoicedClientPhone0").val();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var bankDepositSlipId = $('#bankDepositSlipId').val();
  var bankId = document.querySelector("#bankname99 option:checked").dataset.bankid;
  var bankAccountName = $('#bankname99').val();
  var myBankAccountNumber44 = document.querySelector("#bankname99 option:checked").dataset.accountnumber;
  var bankName = $('#bankname99').val();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var comment = $('#comment101').val();
  // Get the cart list from invoicePaymentCart
var cartlist = invoicePaymentCart.listCart();

// Check if cartlist is empty or null
if (!cartlist || cartlist.length === 0) { 
    // If empty or null, fall back to shoppingCart
    cartlist = shoppingCart.listCart();
}

// Convert the cart list to a JSON string
var cartlistDetails = JSON.stringify(cartlist);


  if (phone != '' && cartlistDetails != '' && bankDepositSlipId != '' && bankAccountName != '' && bankName != '' && myBankAccountNumber44 !='' && bankId !='') {
      // Create FormData object for file and other data
      var formData = new FormData();
      
      // Only append the file if it exists
      if (file) {
          formData.append('field-upload', file);
      }

      formData.append('userid', userid);
      formData.append('phone', phone);
      formData.append('fname', fname);
      formData.append('lname', lname);
      formData.append('email', email);
      formData.append('orderDetails', cartlistDetails);
      formData.append('amount', amount);
      formData.append('deliverylat', deliverylat);
      formData.append('deliverylng', deliverylng);
      formData.append('deliveryaddress', deliveryaddress);
      formData.append('transtype', transtype);
      formData.append('invoiceDueDate', invoiceDueDate);
      formData.append('bankDepositSlipId', bankDepositSlipId);
      formData.append('bankAccountName', bankAccountName);
      formData.append('bankName', bankName);
      formData.append('productid', productid);
      formData.append('businessCategory', businessCategory);
      formData.append('pacra', pacra);
      formData.append('tpin', tpin);
      formData.append('plotnumber', plotnumber);
      formData.append('area', area);
      formData.append('nrc', nrc);
      formData.append('hiddenInvoiceNumber', hiddenInvoiceNumber);
      formData.append('bankId', bankId);
      formData.append('myBankAccountNumber44', myBankAccountNumber44); 
      formData.append('comment', comment);
 
      $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Processing...</span></span>');
      // AJAX request with progress
      $.ajax({
          url: "xd-modules/payment-processing/bankTransact.php",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          xhr: function() {
              var xhr = new XMLHttpRequest();
              xhr.upload.addEventListener('progress', function(event) {
                  if (event.lengthComputable) {
                      var percentComplete = Math.round((event.loaded / event.total) * 100);
                      // Update the progress in the div
                      $('.transactProgress043').text('Uploading: ' + percentComplete + '%');
                  }
              }, false);
              return xhr;
          },
      }).done(function(data) {
          var response = JSON.parse(data);
          if (response.status == 'created') { 

            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Success</span></span>');
           $(".invoiceDivActions101").hide();
            
              $("#topInvoiceNavContents").hide();
              $('#payment-btns-div01').hide();
              $('#invoiceNumber').empty();
              $('#invoiceNumber').append(response.receiptnumber);
              document.getElementById('invoiceDueDate').value = '';
              document.getElementById('invoiceDueDate').value = response.date;
             // document.getElementById('trasactionTime34').value = '';
             // document.getElementById('trasactionTime34').value = response.time;
             
               setTimeout(function(){ 
                  window.print(); 
                  setTimeout(function(){ 
                    $(".invoiceDivActions101").show();
                    $('#invoicePaymentDiv02').empty().append('<span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
                   }, 700);
              }, 200);
              transactions();

          } else {

            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);">Failed! try again</span></span>');
    
          }
      });
  } else {
      alert('Please fill in all data...deposit slip id or reference!');
  }
});
//// END OF TRANSACTING BY BANK
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT

//bankTransact02
$(document).on('submit', '#depositslipform', function(event){
  event.preventDefault();
  event.stopPropagation();
   var invoiceNumber01 = $('#invoiceNumber01').val();
   
  var extension = $('#imageInput').val().split('.').pop().toLowerCase();
   
  if(extension != ''){
      if(jQuery.inArray(extension, ['gif','png','jpg','jpeg']) == -1)
      {
          alert("Invalid Image File");
          $('#imageInput').val('');
          return false;
      }
  }	
    
  
  if(extension != '')
  {
   $('#payment-btns-div01').empty();
   $('#payment-btns-div01').append('<center><p>Uploading...</p></center>');
        
      $.ajax({
          url:"xd-modules/payment-processing/uploadDepositSlip.php",
          method:'POST',
          data:new FormData(this),
          contentType:false,
          processData:false,
          catche:false,
          success:function(data)
          {
          
          var postStatus = JSON.parse(data);
             
             
                if(postStatus.status=='uploaded'){
                
              $("#depositslipform").trigger('reset'); //jquery
              $("#topInvoiceNavContents").hide();
              $("#topResponse98").empty();
              $("#topResponse98").append('Payment succesful!');  
              $('#payment-btns-div01').empty();
              $('#payment-btns-div01').append('<a href="" id="closeDepositSlipProcess" class="w3-col l12 m12 s12" style="color:white;"><p style="background-color:white;width:100px;color:rgba(96, 146, 205,1);padding:7px;border-radius:4px;">CLose</p></a>');     
                  
            } else{
              $("#depositslipform").trigger('reset'); //jquery
              
              
             }
                     
              
              
                
          }
      });
  }
  else
  {
  
            // $('#upload_media_form0946').hide();
             $('#status44').empty();
             $('#status44').append('Please fill in all data!');
                
  }
});
/// opting out of uploadig deposit slip
$(document).on('click', '#bankTransact03', function(event){
 // alert('you can upload or capture deposit slip later ');
  shoppingCart.clearCart();
  displayCart();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
  setTimeout(function(){
   // location.reload();
	}, 500);
});
/// opting out of uploadig deposit slip

//closeDepositSlipProcess
$(document).on('click','#closeDepositSlipProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
  $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty(); 
//  $("#payment-btns-div0").hide();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  shoppingCart.clearCart();
  displayCart();
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 //$('#invoiceNumber').empty();
 //$('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});

 


$(document).on('change keyup','#bankname99',function (event) {
  var accountnumber = document.querySelector("#bankname99 option:checked").dataset.accountnumber;
  var sortcode = document.querySelector("#bankname99 option:checked").dataset.sortcode;
  var branch = document.querySelector("#bankname99 option:checked").dataset.branch;
  $('#bankAccountNumber').empty().append(accountnumber);
  $('#bankSortCode99').empty().append(sortcode);
  $('#bankBranch99').empty().append(branch);
});
// closing the invoice_modal

$(document).on('click', '.close_invoice_modal', function(event){
   $('#invoice_modal').fadeOut('slow'); 
});

// end of closing the invoice_modal


// CLOSING invoice_modal_div_0    
$(document).on('click', '.close_invoice_modal_div_1', function (event) {
// Loop through all checked checkboxes inside #invoice_modal_div_2
$('#invoice_modal_div_0').fadeIn('slow'); 
$('.invoiceDivActions101').fadeIn('slow');
$('#invoice_modal_div_1').fadeOut('slow'); 

});
// END OF CLOSING invoice_modal_div_0

// adding client to invoice
$(document).on('click','#addClientToInvoice0',function (event) {
  addClientToInvoice();
  });
function addClientToInvoice() {
           $('#invoice_modal_div_0').fadeOut('slow'); 
           $('.invoiceDivActions101').fadeOut('slow');
           $('#invoice_modal_div_1').fadeIn('slow'); 
           $('#invoice_modal_div_1').empty().append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoice_modal_div_1 w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l10 m10 s10" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchUsersForInvoicing77" type="text" placeholder="Search clients..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0,0,0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l1 m1 s1" style="padding-top: 5px;"><span class="fontx fx-more-vertical" style="color:rgba(96, 146, 205,1);font-size:1.3em;"></span></div></div>');
         
          $('#invoice_modal_div_1').append('<div id="invoice_modal_div_2" style="margin-top:50px"></div>');
          $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
           
           
            $.getJSON('xd-modules/agent-module/backend/allClients.php',function(data){
        
            $('#invoice_modal_div_2').empty();
            $.each(data.freelancedetails, function(i,cyberdesk) {
             
            //  $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l12 m12 s12" id="addClientToInvoice1" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
               $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l12 m12 s12" id="addClientToInvoice1" data-address="'+cyberdesk.address+'" data-id="'+cyberdesk.id+'" data-phone="'+cyberdesk.phone+'" data-email="'+cyberdesk.email+'" data-names="'+cyberdesk.names+'" data-businesscategory="'+cyberdesk.category_name+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-nrc="'+cyberdesk.nrc+'" data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'"><div class="w3-col l12 m12 s12"><span class="w3-col l4 m4 s10" style="padding-left:7px;font-weight:600;color:gray;"><img src="'+cyberdesk.avatar+'" style="height:22px;width:22px;border-radius:5px;margin-top:2px;"/> <span>'+cyberdesk.names+'</span> <a href="https://wa.me/26'+cyberdesk.phone+'"  target="_blank" class="w3-hide-large w3-hide-medium" style="text-decoration:none;font-weight:200;float:right;">'+cyberdesk.phone+'</a></span><span class="w3-col l2 m2 s4 w3-hide-small" style="padding-left:5px;color:#6092cd"><a href="https://wa.me/26'+cyberdesk.phone+'"  target="_blank" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/whatsApp_icon.png"style="height:15px;width:15px;"/> '+cyberdesk.phone+'</a></span></span><span class="w3-col l3 m3 s7 w3-hide-small"><span class="fontx fx-mail" style="margin-left:5px;"></span> <span style="cursor:pointer;color:var(--primary-color);"> '+cyberdesk.email+'</span></span><span class="w3-col l2 m2 s12 w3-hide-small"> '+cyberdesk.nrc+'</span><span class="w3-col l1 m1 s2"><select class="innerDivClientSelectKey inner-data-more-actions"><option value="select-actions">Select Action</option><option value="view-more-details"  data-id="'+cyberdesk.id+'" data-avatar="'+cyberdesk.avatar+'" data-name="'+cyberdesk.names+'" data-email="'+cyberdesk.email+'" data-phone="'+cyberdesk.phone+'" data-address="'+cyberdesk.address+'" data-area="'+cyberdesk.depot_name+'"  data-depotid="'+cyberdesk.depot_id+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-status="'+cyberdesk.status+'" data-businesscategory="'+cyberdesk.business_category+'" data-businesscategoryname="'+cyberdesk.category_name+'" data-usertype="'+cyberdesk.user_type+'" data-nrc="'+cyberdesk.nrc+'">Account Details</option><option value="client-invoices" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.names+'">Invoices</option><option value="client-products" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.names+'">Products/Services</option><option value="client-statemnts">View Statements</option><option value="send-email">Send Email</option><option value="send-whatsapp">WhatsApp</option></select><input type="checkbox" name="invoicecheckbox101" class="inner-data-checkbox hideOnPrint" value="'+cyberdesk.id+'" data-phone="'+cyberdesk.phone+'" data-names="'+cyberdesk.names+'" data-email="'+cyberdesk.email+'"/></div></div>');
			
              
            });
        
               //$('#invoiceAddClients').append('<div id="backToInvoice0" class="fontx fx-arrow-right" style="position:fixed;height:40px;width:40px;border-radius:50%;color:#fff;background-color: rgba(96, 146, 205,1);line-height:40px;right:10%;bottom:8%;cursor: pointer;"></div></div>');
            
          });
        
        };
     
 $(document).on('change keyup','.searchUsersForInvoicing77',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchUsersForInvoicing77").val()=='') {	
	//addInvoiceClient()
  } else{ 
	 var searchKey = $(".searchUsersForInvoicing77").val(); 
	 datastring='searchKey='+searchKey;
   $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
            
	 $.ajax({
				  
		   data:datastring,
	   url: "xd-modules/agent-module/backend/allClients.php",
		   type: "POST"
	   
	  }).done (function(data) {
	  var details0 = JSON.parse(data);
    $('#invoice_modal_div_2').empty();
	$.each(details0.freelancedetails, function(i,cyberdesk) {
	    $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l12 m12 s12" id="addClientToInvoice1" data-address="'+cyberdesk.address+'" data-id="'+cyberdesk.id+'" data-phone="'+cyberdesk.phone+'" data-email="'+cyberdesk.email+'" data-names="'+cyberdesk.names+'" data-businesscategory="'+cyberdesk.category_name+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-nrc="'+cyberdesk.nrc+'" data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'"><div class="w3-col l12 m12 s12"><span class="w3-col l4 m4 s10" style="padding-left:7px;font-weight:600;color:gray;"><img src="'+cyberdesk.avatar+'" style="height:22px;width:22px;border-radius:5px;margin-top:2px;"/> <span>'+cyberdesk.names+'</span> <a href="https://wa.me/26'+cyberdesk.phone+'"  target="_blank" class="w3-hide-large w3-hide-medium" style="text-decoration:none;font-weight:200;float:right;">'+cyberdesk.phone+'</a></span><span class="w3-col l2 m2 s4 w3-hide-small" style="padding-left:5px;color:#6092cd"><a href="https://wa.me/26'+cyberdesk.phone+'"  target="_blank" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/whatsApp_icon.png"style="height:15px;width:15px;"/> '+cyberdesk.phone+'</a></span></span><span class="w3-col l3 m3 s7 w3-hide-small"><span class="fontx fx-mail" style="margin-left:5px;"></span> <span style="cursor:pointer;color:var(--primary-color);"> '+cyberdesk.email+'</span></span><span class="w3-col l2 m2 s12 w3-hide-small"> '+cyberdesk.nrc+'</span><span class="w3-col l1 m1 s2"><select class="innerDivClientSelectKey inner-data-more-actions"><option value="select-actions">Select Action</option><option value="view-more-details"  data-id="'+cyberdesk.id+'" data-avatar="'+cyberdesk.avatar+'" data-name="'+cyberdesk.names+'" data-email="'+cyberdesk.email+'" data-phone="'+cyberdesk.phone+'" data-address="'+cyberdesk.address+'" data-area="'+cyberdesk.depot_name+'"  data-depotid="'+cyberdesk.depot_id+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-status="'+cyberdesk.status+'" data-businesscategory="'+cyberdesk.business_category+'" data-businesscategoryname="'+cyberdesk.category_name+'" data-usertype="'+cyberdesk.user_type+'" data-nrc="'+cyberdesk.nrc+'">Account Details</option><option value="client-invoices" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.names+'">Invoices</option><option value="client-products" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.names+'">Products/Services</option><option value="client-statemnts">View Statements</option><option value="send-email">Send Email</option><option value="send-whatsapp">WhatsApp</option></select><input type="checkbox" name="invoicecheckbox101" class="inner-data-checkbox hideOnPrint" value="'+cyberdesk.id+'" data-phone="'+cyberdesk.phone+'" data-names="'+cyberdesk.names+'" data-email="'+cyberdesk.email+'"/></div></div>');
			          	 	   
	  });
	 
	}); 	
	
  } 
  
		  
});
        
        $(document).on('click','#addClientToInvoice1',function (event) { 
          $('#invoice_modal_div_0').fadeIn('slow'); 
          $('.invoiceDivActions101').fadeIn('slow');
          $('#invoice_modal_div_1').fadeOut('slow');
          var id = $(this).data('id'); 
          var names = $(this).data('names'); 
          var address = $(this).data('address');
           var email = $(this).data('email'); 
           var phone = $(this).data('phone'); 
           var pacra =$(this).data('pacra');
           var tpin =$(this).data('tpin');
           var nrc = $(this).data('nrc'); 
           var area =$(this).data('pacra');
           var plotnumber =$(this).data('plotnumber');
           var businessCategory=$(this).data('businesscategory');
           //var plotnumber =$(this).data('tpin');
           $('#invoicedClientId0').empty();
           $('#invoicedClientId0').append(id);
           document.getElementById('invoicedClientName0').vallue='';
           document.getElementById('invoicedClientName0').value=names;
           $('#invoicedClientName1').empty();
           $('#invoicedClientName1').append(names);
           document.getElementById('invoicedClientAddress0').value='';
           document.getElementById('invoicedClientAddress0').value=address;
           document.getElementById('plotnumber07').value='';
           document.getElementById('plotnumber07').value= plotnumber;
           document.getElementById('area07').value='';
           document.getElementById('area07').value=area;
           document.getElementById('nrc07').vallue='';
           document.getElementById('nrc07').vallue=nrc;
           document.getElementById('invoicedClientEmail0').value='';
           document.getElementById('invoicedClientEmail0').value=email;
            $('#invoicedClientId0').empty();
           $('#invoicedClientId0').append(id);
           $('#pacra00').empty();
           $('#pacra00').append(pacra); 
           document.getElementById('tpin07').value='';
           document.getElementById('tpin07').value=tpin;
            $('#businesscategory00').empty();
           $('#businesscategory00').append(businessCategory);
          document.getElementById('invoicedClientPhone0').value ='';
          document.getElementById('invoicedClientPhone0').value = phone;
            
        });
        // end of adding client to invoicee

 