<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../xd-assets/backend/config/dbconfig.php';
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON data']);
    exit;
}

$responses = [];

foreach ($data['transactions'] as $transaction) {
    $userloggedid = $_SESSION["userid"];
    $orgid = $_SESSION["orgid"];
    $orgname = $_SESSION["orgname"];

    $offline_receipt = isset($transaction['offline_receipt']) ? $transaction['offline_receipt'] : null;

    // Check if offline_receipt exists
    if ($offline_receipt) {
        $checkStmt = $conn->prepare("SELECT 1 FROM transaction_details WHERE offline_receipt = :offline_receipt");
        $checkStmt->bindParam(':offline_receipt', $offline_receipt);
        $checkStmt->execute();

        if ($checkStmt->fetch()) {
            // Exists, skip insert
            $responses[] = [
                'status' => 'exists',
                'offline_receipt' => $offline_receipt,
                'message' => 'Offline receipt already exists.'
            ];
            continue; // skip to next transaction
        }
    }

    try {
        $conn->beginTransaction();

        // Insert into receipts
        $r = $conn->prepare("INSERT INTO receipts (issuer_id, org_id) VALUES (:a, :o)");
        $r->execute([':a' => $userloggedid, ':o' => $orgid]);
        $invoiceNumber = $conn->lastInsertId();
        $invoiceNumber2 = 0;
        // Prepare transaction details
        $transaction_reference = uniqid('d', true);
        $order_code = uniqid('o', true);
        $payment_mode = 'CASH';
        $debit_or_credit = 'Credit';
        $bankName = 'CASH';
        $bankAccountName = 'CASH';
        $d = strtotime("+2 hours");
        $transaction_date = date("Y-m-d", $d);
        $transaction_time = date("H:i:s", $d);
        $day = date('l', strtotime($transaction_date));
        $month = date('F', strtotime($transaction_date));
        $week = date('W', strtotime($transaction_date));
        $invoiceDueDate = $transaction_date;

        // Include inventory update function ONCE before the loop
        if (file_exists('update_inventory_after_sale.php')) {
        require_once 'update_inventory_after_sale.php';
        }
        foreach ($transaction['orderDetails'] as $item) {
            $insertQuery = "INSERT INTO transaction_details (
                cfname, clname, cemail, cphone,
                product_name, product_id, product_code,
                product_category, product_category_code,
                balance_bf, transaction_amount, transaction_balance,
                quantity, order_code, transaction_reference,
                transaction_status, user_id, agent_name, agent_id,
                trans_type, debit_or_credit, depot, depot_id, depot_code,
                delivery_address, area, plot_no, nrc, lat, lng,
                transaction_date, transaction_time, transaction_month,
                transaction_week, transaction_day, receipt_no, invoiceNumber,
                offline_receipt, comment, receipt_date,
                payment_mode, bank_name, bank_account_name,
                business_category, pacra, tpin, org_name, org_id, sessionUserId
            ) VALUES (
                :cfname, :clname, :cemail, :cphone,
                :product_name, :product_id, :product_code,
                :product_category, :product_category_code,
                :balance_bf, :transaction_amount, :transaction_balance,
                :quantity, :order_code, :transaction_reference,
                'active', :user_id, :agent_name, :agent_id,
                :trans_type, :debit_or_credit, :depot, :depot_id, :depot_code,
                :delivery_address, :area, :plot_no, :nrc, :lat, :lng,
                :transaction_date, :transaction_time, :transaction_month,
                :transaction_week, :transaction_day, :receipt_no, :invoiceNumber,
                :offline_receipt, :comment, :receipt_date,
                :payment_mode, :bank_name, :bank_account_name,
                :business_category, :pacra, :tpin, :org_name, :org_id, :sessionUserId
            )";

            $stmt = $conn->prepare($insertQuery);
            $stmt->execute([
                ':cfname' => $transaction['fname'] ?? null,
                ':clname' => $transaction['lname'] ?? null,
                ':cemail' => $transaction['email'] ?? null,
                ':cphone' => $transaction['phone'] ?? null,
                ':product_name' => $item["name"],
                ':product_id' => $item["id"],
                ':product_code' => $item["productcode"],
                ':product_category' => $item["category"],
                ':product_category_code' => $item["categorycode"],
                ':balance_bf' => $item["balance_bf"],
                ':transaction_amount' => $item["total"],
                ':transaction_balance' => $item["balanceCF"],
                ':quantity' => $item["count"],
                ':order_code' => $order_code,
                ':transaction_reference' => $transaction_reference,
                ':user_id' => $transaction['clientid'] ?? null,
                ':agent_name' => $transaction['agent_name'] ?? null,
                ':agent_id' => $transaction['userid'] ?? null,
                ':trans_type' => $transaction['transtype'] ?? null,
                ':debit_or_credit' => $debit_or_credit,
                ':depot' => $item["depot"],
                ':depot_id' => $item["depotid"],
                ':depot_code' => $item["depotcode"],
                ':delivery_address' => $transaction['deliveryaddress'] ?? null,
                ':area' => $transaction['area'] ?? null,
                ':plot_no' => $transaction['plotnumber'] ?? null,
                ':nrc' => $transaction['nrc'] ?? null,
                ':lat' => $transaction['deliverylat'] ?? null,
                ':lng' => $transaction['deliverylng'] ?? null,
                ':transaction_date' => $transaction_date,
                ':transaction_time' => $transaction_time,
                ':transaction_month' => $month,
                ':transaction_week' => $week,
                ':transaction_day' => $day,
                ':receipt_no' => $invoiceNumber,
                ':invoiceNumber' => $invoiceNumber2,
                ':offline_receipt' => $offline_receipt,
                ':comment' => $transaction['comment'] ?? null,
                ':receipt_date' => $invoiceDueDate,
                ':payment_mode' => $payment_mode,
                ':bank_name' => $bankName,
                ':bank_account_name' => $bankAccountName,
                ':business_category' => $transaction['businessCategory'] ?? null,
                ':pacra' => $transaction['pacra'] ?? null,
                ':tpin' => $transaction['tpin'] ?? null,
                ':org_name' => $orgname,
                ':org_id' => $orgid,
                ':sessionUserId' => $userloggedid
            ]);

            // --- Update billing_subscription balances (logic from cashTransact.php) ---
            $userid = $transaction['clientid'] ?? null;
            $productid = $item['id'];
            $total = $item['total'];
            if ($userid && $productid && $total > 0) {
                // Fetch all open invoices for this client and product
                $fetchInvoicesQuery = "SELECT b_id, invoice_no, balance \
                                       FROM billing_subscription \
                                       WHERE client_id = :userid \
                                       AND product_id = :productid\
                                       AND balance != 0\
                                       ORDER BY invoice_no ASC";
                $fetchInvoices = $conn->prepare($fetchInvoicesQuery);
                $fetchInvoices->bindParam(':userid', $userid, PDO::PARAM_INT);
                $fetchInvoices->bindParam(':productid', $productid, PDO::PARAM_INT);
                $fetchInvoices->execute();
                $invoices = $fetchInvoices->fetchAll(PDO::FETCH_ASSOC);

                $remainingTotal = $total;
                if (!empty($invoices)) {
                    foreach ($invoices as $invoice) {
                        $invoice_id = $invoice['b_id'];
                        $current_balance = $invoice['balance'];
                        if ($remainingTotal <= 0) break;
                        if ($remainingTotal >= $current_balance) {
                            $remainingTotal -= $current_balance;
                            $new_balance = 0;
                        } else {
                            $new_balance = $current_balance - $remainingTotal;
                            $remainingTotal = 0;
                        }
                        $updateInvoiceQuery = "UPDATE billing_subscription \
                                               SET balance = :new_balance \
                                               WHERE b_id = :invoice_id";
                        $updateInvoice = $conn->prepare($updateInvoiceQuery);
                        $updateInvoice->bindParam(':new_balance', $new_balance, PDO::PARAM_INT);
                        $updateInvoice->bindParam(':invoice_id', $invoice_id, PDO::PARAM_INT);
                        $updateInvoice->execute();
                    }
                    if ($remainingTotal > 0) {
                        $fetchLatestInvoiceQuery = "SELECT invoice_no, balance\
                                                    FROM billing_subscription \
                                                    WHERE client_id = :userid \
                                                    AND product_id = :productid \
                                                    ORDER BY invoice_no DESC LIMIT 1";
                        $fetchLatestInvoice = $conn->prepare($fetchLatestInvoiceQuery);
                        $fetchLatestInvoice->bindParam(':userid', $userid, PDO::PARAM_INT);
                        $fetchLatestInvoice->bindParam(':productid', $productid, PDO::PARAM_INT);
                        $fetchLatestInvoice->execute();
                        $latestInvoice = $fetchLatestInvoice->fetch(PDO::FETCH_ASSOC);
                        if ($latestInvoice) {
                            $latestInvoiceNo = $latestInvoice['invoice_no'];
                            $latestBalance = $latestInvoice['balance'];
                            $newBalance = $latestBalance - $remainingTotal;
                            $updateLatestInvoiceQuery = "UPDATE billing_subscription \
                                                         SET balance = :newBalance \
                                                         WHERE client_id = :userid \
                                                         AND product_id = :productid \
                                                         AND invoice_no = :latestInvoiceNo";
                            $updateLatestInvoice = $conn->prepare($updateLatestInvoiceQuery);
                            $updateLatestInvoice->bindParam(':newBalance', $newBalance, PDO::PARAM_INT);
                            $updateLatestInvoice->bindParam(':userid', $userid, PDO::PARAM_INT);
                            $updateLatestInvoice->bindParam(':productid', $productid, PDO::PARAM_INT);
                            $updateLatestInvoice->bindParam(':latestInvoiceNo', $latestInvoiceNo, PDO::PARAM_INT);
                            $updateLatestInvoice->execute();
                        }
                    }
                }
            }
            // --- End billing_subscription update ---

                // ========================================
        // ✅ UPDATE INVENTORY PER PRODUCT (INSIDE LOOP)
        // ========================================
            if (function_exists('updateInventoryAfterSale')) {
            try {
            $inventoryResult = updateInventoryAfterSale(
            $conn, 
            $item,
            $receiptNumber, 
            $userloggedid, 
            $orgid, 
            $transaction_date
            );

            if ($inventoryResult !== null && isset($inventoryResult['status']) && $inventoryResult['status'] === 'success') {
            error_log("✓ Inventory updated for product: $productname (ID: $productid)");
            } else if ($inventoryResult !== null && isset($inventoryResult['message'])) {
            error_log("⚠ Inventory warning for product $productname: " . $inventoryResult['message']);
            } else {
            error_log("ℹ Inventory skipped for product $productname (ID: $productid) — not in stock");
            }

            } catch (Throwable $e) {
            error_log("❌ Inventory update failed for product $productname: " . $e->getMessage());
            }
            }

        // ========================================
        // END OF INVENTORY UPDATE
        // ========================================
        }

        $conn->commit();

        $responses[] = [
            'status' => 'created',
            'offline_receipt' => $offline_receipt,
            'receiptnumber' => $invoiceNumber
        ];

    } catch (Exception $e) {
        $conn->rollBack();
        $responses[] = [
            'status' => 'error',
            'offline_receipt' => $offline_receipt,
            'message' => $e->getMessage()
        ];
    }
}
// Collect receipts that were successfully created or already existed
$receiptsToDelete = array_column(
    array_filter($responses, fn($r) => in_array($r['status'], ['created', 'exists'])),
    'offline_receipt'
);

// Send a structured response
echo json_encode([
    'status' => 'success',
    'offline_receipt' => $receiptsToDelete,
    'details' => $responses
]);

?>
