<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../xd-assets/backend/config/dbconfig.php';

$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


$agentname = filter_input(INPUT_POST, "agent_name");
$userloggedid =filter_input(INPUT_POST, "agent_id");
$orgid = $_SESSION["orgid"] ?? null;
$orgname = $_SESSION["orgname"] ?? null;

if (empty($agentname) || empty($userloggedid) || empty($orgid)) {
    echo json_encode(array('status' => 'error', 'message' => 'Session data is missing or incomplete'));
    exit;
}


try {
    
$conn->beginTransaction(); // <--- Start the transaction here
$cartObject          = filter_input(INPUT_POST,"orderDetails",FILTER_UNSAFE_RAW);
$cartArray           = json_decode($cartObject, true);
$amount              = 0;
$phone = filter_input(INPUT_POST, "phone");
$fname = filter_input(INPUT_POST, "fname");


  // --- USER AND INVOICE CREATION IN THE EVENT THE USERS/INOINCE DOES NOT EXIST---
    if (file_exists('client_invoice_checks.php')) {
        require_once 'client_invoice_checks.php';
    }

    // --- Step 1: Create invoices for recurring products (if function exists) ---
    $invoiceResult = null;
    if (function_exists('createRecurringInvoices')) {
        try {
            $invoiceResult = createRecurringInvoices($conn, $cartArray, $phone, $userloggedid, $orgid, $orgname, $fname);
        } catch (Throwable $e) {
            error_log("Invoice creation failed: " . $e->getMessage());
            // Continue with receipt processing even if invoice creation fails
        }
    }
  // --- USER AND INVOICE CREATION IN THE EVENT THE USERS/INOINCE DOES NOT EXIST---

  
$receiptInsert = $conn->prepare("INSERT INTO receipts (amount,issuer_id, org_id) VALUES (:amount, :agent_id, :org_id)");
$receiptInsert->bindParam(':org_id', $orgid, PDO::PARAM_INT);
$receiptInsert->bindParam(':agent_id', $userloggedid, PDO::PARAM_INT);
$receiptInsert->bindParam(':amount', $amount, PDO::PARAM_INT);
$receiptInsert->execute();
// Get the auto-incremented ID
$receiptNumber = $conn->lastInsertId();
//$formattedReceiptNumber = 'RPT-' . str_pad($receiptNumber, 8, '0', STR_PAD_LEFT);
$invoiceNumber = $receiptNumber; // Use the auto-incremented ID as the invoice number

    $userid = filter_input(INPUT_POST, "userid");
   // $amount = filter_input(INPUT_POST, "amount");
    $fname = filter_input(INPUT_POST, "fname");
    $lname = filter_input(INPUT_POST, "lname");
    $email = filter_input(INPUT_POST, "email");
    $phone = filter_input(INPUT_POST, "phone");
    $deliveryaddress = filter_input(INPUT_POST, "deliveryaddress");
    $deliverylat = filter_input(INPUT_POST, "deliverylat");
    $deliverylng = filter_input(INPUT_POST, "deliverylng");
    $transtype = filter_input(INPUT_POST, "transtype");
    $paymentMode = filter_input(INPUT_POST, "payment_mode"); 

    if($paymentMode==='MOMO'){
     $payment_mode='DIGITAL';
      $bankName = filter_input(INPUT_POST, "bankName");
      $bankAccountName = filter_input(INPUT_POST, "bankName");
      $bankAccountNumber  = filter_input(INPUT_POST, "bankAccountNumber");
        $bankDepositSlipId = 0;
    }elseif($paymentMode==='CASH'){
      $payment_mode='CASH';
      $bankName = 'CASH';
      $bankAccountName = 'CASH';
      $bankDepositSlipId = 0;
    }else if($paymentMode==='BANK'){
     $payment_mode='BANK DEPOSIT';
      $bankName = filter_input(INPUT_POST, "bankName");
      $bankAccountName = filter_input(INPUT_POST, "bankName");
      $bankAccountNumber  = filter_input(INPUT_POST, "bankAccountNumber");
      $bankDepositSlipId = filter_input(INPUT_POST, "bankDepositSlipId");
    }else if($paymentMode==='BANK TRANSFER'){
      $payment_mode='BANK TRANSFER';
      $bankName = filter_input(INPUT_POST, "bankName");
      $bankAccountName = filter_input(INPUT_POST, "bankName");
      $bankAccountNumber  = filter_input(INPUT_POST, "bankAccountNumber");
        $bankDepositSlipId = 0;
    }

    $debit_or_credit = 'Credit';
    $depot = filter_input(INPUT_POST, "depot_name");
    $depotid = filter_input(INPUT_POST, "depot_id");
    $depotcode = filter_input(INPUT_POST, "depot_code");
    $hiddenInvoiceNumber = filter_input(INPUT_POST, "hiddenInvoiceNumber");
    $invoiceDueDate = filter_input(INPUT_POST, "invoiceDueDate");
    $transaction_reference = uniqid('d', true);
    $order_code = uniqid('o', true);
   // $cartObject = filter_input(INPUT_POST, "orderDetails");
    $pacra = filter_input(INPUT_POST, "pacra");
    $tpin = filter_input(INPUT_POST, "tpin");
    $plotnumber = filter_input(INPUT_POST, "plotnumber");
    $area = filter_input(INPUT_POST, "area");
    $nrc = filter_input(INPUT_POST, "nrc");
    $businessCategory = filter_input(INPUT_POST, "businessCategory");
    $comment = filter_input(INPUT_POST, "comment");
    $d = strtotime("+2 hours");
    $transaction_date = date("Y-m-d", $d);
    $transaction_time = date("H:i:s", $d);
    $day = date('l', strtotime($transaction_date));
    $datex = new DateTime($transaction_date);
    $month = $datex->format('F');
    $week = $datex->format('W');

    $productname = '';
    $category = '';
    $item_price = 0;
    $total_quantity = 0;
    $total_price = 0;
    $productid = 0;
    $productcode = 0;
    $categorycode = 0;

    $balanceCF = 0;

    foreach (json_decode($cartObject, true) as $item) {

        $productname = $item["name"];
        $category = $item["category"];
        $total_quantity = $item["count"];
        $total_price = ($item["price"] * $item["count"]);
        $productid = $item["id"];
        $productcode = $item["productcode"];
        $categorycode = $item["categorycode"]; 
        $balance_bf = $item["balance_bf"];
        $balance = $item["balance"];
        $balanceCF = $item["balanceCF"];
        $total = $item["total"]; 

        $insertnewuserQuery = "INSERT INTO `transaction_details` (`cfname`, `clname`, `cemail`, `cphone`, `product_name`, `product_id`, `product_code`,`product_category`,`product_category_code`, `balance_bf`, `transaction_amount`, `transaction_balance`,`quantity`, `order_code`, `transaction_reference`, `transaction_status`, `order_details`, `user_id`, `agent_name`, `agent_id`, `trans_type`, `debit_or_credit`,`depot`,`depot_id`,`depot_code`,`delivery_address`,`area`,`plot_no`,`nrc`,`lat`,`lng`,`transaction_date`, `transaction_time`, `transaction_month`, `transaction_week`, `transaction_day`, `receipt_no`, `invoiceNumber`, `comment`, `receipt_date`, `payment_mode`, `bank_name`, `bank_account_name`, `bank_account_number`, `bank_deposit_id`, `business_category`, `pacra`, `tpin`,`org_name`,`org_id`)
        VALUES ('$fname', '$lname', '$email', '$phone', '$productname', '$productid', '$productcode', '$category', '$categorycode', '$balance_bf', '$total', '$balanceCF', '$total_quantity', '$order_code', '$transaction_reference', 'active', '$cartObject', '$userid', '$agentname', '$userloggedid', '$transtype', '$debit_or_credit', '$depot','$depotid','$depotcode','$deliveryaddress','$area','$plotnumber','$nrc', '$deliverylat', '$deliverylng', '$transaction_date', '$transaction_time', '$month', '$week','$day', '$invoiceNumber', '$hiddenInvoiceNumber', '$comment', '$invoiceDueDate', '$payment_mode', '$bankName', '$bankAccountName', '$bankAccountNumber', '$bankDepositSlipId', '$businessCategory', '$pacra', '$tpin','$orgname','$orgid');";
        $insertnewUser = $conn->prepare($insertnewuserQuery);
        $insertnewUser->execute();
        // UPDATING THE BILLING AND SUBSCRIPTION TABLE
        $fetchInvoicesQuery = "SELECT b_id, invoice_no, balance 
                               FROM billing_subscription 
                               WHERE client_id = :userid 
                               AND product_id = :productid
                               AND balance != 0
                               ORDER BY invoice_no ASC";
        $fetchInvoices = $conn->prepare($fetchInvoicesQuery);
        $fetchInvoices->bindParam(':userid', $userid, PDO::PARAM_INT);
        $fetchInvoices->bindParam(':productid', $productid, PDO::PARAM_INT);
        $fetchInvoices->execute();
        $invoices = $fetchInvoices->fetchAll(PDO::FETCH_ASSOC);

        if (!empty($invoices)) {
            $remainingTotal = $total;

            foreach ($invoices as $invoice) {
                $invoice_id = $invoice['b_id'];
                $current_balance = $invoice['balance'];

                if ($remainingTotal <= 0) {
                    break;
                }

                if ($remainingTotal >= $current_balance) {
                    $remainingTotal -= $current_balance;
                    $new_balance = 0;
                } else {
                    $new_balance = $current_balance - $remainingTotal;
                    $remainingTotal = 0;
                }

                $updateInvoiceQuery = "UPDATE billing_subscription 
                                       SET balance = :new_balance 
                                       WHERE b_id = :invoice_id";
                $updateInvoice = $conn->prepare($updateInvoiceQuery);
                $updateInvoice->bindParam(':new_balance', $new_balance, PDO::PARAM_INT);
                $updateInvoice->bindParam(':invoice_id', $invoice_id, PDO::PARAM_INT);
                $updateInvoice->execute();
            }

            if ($remainingTotal > 0) {
                $fetchLatestInvoiceQuery = "SELECT invoice_no, balance
                                            FROM billing_subscription 
                                            WHERE client_id = :userid 
                                            AND product_id = :productid 
                                            ORDER BY invoice_no DESC LIMIT 1";
                $fetchLatestInvoice = $conn->prepare($fetchLatestInvoiceQuery);
                $fetchLatestInvoice->bindParam(':userid', $userid, PDO::PARAM_INT);
                $fetchLatestInvoice->bindParam(':productid', $productid, PDO::PARAM_INT);
                $fetchLatestInvoice->execute();
                $latestInvoice = $fetchLatestInvoice->fetch(PDO::FETCH_ASSOC);

                if ($latestInvoice) {
                    $latestInvoiceNo = $latestInvoice['invoice_no'];
                    $latestBalance = $latestInvoice['balance'];
                    $newBalance = $latestBalance - $remainingTotal;

                    $updateLatestInvoiceQuery = "UPDATE billing_subscription 
                                                 SET balance = :newBalance 
                                                 WHERE client_id = :userid 
                                                 AND product_id = :productid 
                                                 AND invoice_no = :latestInvoiceNo";
                    $updateLatestInvoice = $conn->prepare($updateLatestInvoiceQuery);
                    $updateLatestInvoice->bindParam(':newBalance', $newBalance, PDO::PARAM_INT);
                    $updateLatestInvoice->bindParam(':userid', $userid, PDO::PARAM_INT);
                    $updateLatestInvoice->bindParam(':productid', $productid, PDO::PARAM_INT);
                    $updateLatestInvoice->bindParam(':latestInvoiceNo', $latestInvoiceNo, PDO::PARAM_INT);
                    $updateLatestInvoice->execute();
                }
            }
        }
    }

    // Commit the transaction
    $conn->commit();

    echo json_encode([
        'status' => 'created',
        'receiptnumber' => $invoiceNumber,
        'date' => date("Y-m-d"),
        'time' => date("H:i:s"),
        'day' => date('l')
    ]);
} catch (Exception $e) {
    // Rollback the transaction only if it was started
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }

    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    exit;
}
?>
