<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
session_start();

//— Load DB config
require_once '../../xd-assets/backend/config/dbconfig.php';

//— Connect to database
try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['status'=>'error','message'=>'DB connect failed: '.$e->getMessage()]);
    exit;
}

//— Verify session
$agentname    = $_SESSION["username"] ?? null;
$userloggedid = $_SESSION["userid"]   ?? null;
$orgid        = $_SESSION["orgid"]    ?? null;
$orgname      = $_SESSION["orgname"]  ?? null;
if (!$agentname || !$userloggedid || !$orgid) {
    echo json_encode(['status'=>'error','message'=>'Session incomplete']);
    exit;
}

//— Read & sanitize inputs
$cartObject          = filter_input(INPUT_POST,"orderDetails",FILTER_UNSAFE_RAW);
$cartArray           = json_decode($cartObject, true);
$amount              = 0;
if (is_array($cartArray)) {
    foreach ($cartArray as $item) {
        $amount += floatval($item['total'] ?? 0);
    }
}
$userid              = filter_input(INPUT_POST,"userid",FILTER_VALIDATE_INT);
$fname = trim(filter_input(INPUT_POST,"fname",FILTER_DEFAULT) ?? '');
$lname               = trim(filter_input(INPUT_POST,"lname",FILTER_DEFAULT));
$email               = filter_input(INPUT_POST,"email",FILTER_SANITIZE_EMAIL);
$phone               = trim(filter_input(INPUT_POST,"phone",FILTER_DEFAULT));
$deliveryaddress     = trim(filter_input(INPUT_POST,"deliveryaddress",FILTER_DEFAULT));
$deliverylat         = trim(filter_input(INPUT_POST,"deliverylat",FILTER_DEFAULT));
$deliverylng         = trim(filter_input(INPUT_POST,"deliverylng",FILTER_DEFAULT));
$transtype           = trim(filter_input(INPUT_POST,"transtype",FILTER_DEFAULT));
$hiddenInvoiceNumber = filter_input(INPUT_POST,"hiddenInvoiceNumber",FILTER_VALIDATE_INT);
$invoiceDueDate      = trim(filter_input(INPUT_POST,"invoiceDueDate",FILTER_DEFAULT));
$pacra               = trim(filter_input(INPUT_POST,"pacra",FILTER_DEFAULT));
$tpin                = trim(filter_input(INPUT_POST,"tpin",FILTER_DEFAULT));
$plotnumber          = trim(filter_input(INPUT_POST,"plotnumber",FILTER_DEFAULT));
$area                = trim(filter_input(INPUT_POST,"area",FILTER_DEFAULT));
$nrc                 = trim(filter_input(INPUT_POST,"nrc",FILTER_DEFAULT));
$businessCategory    = trim(filter_input(INPUT_POST,"businessCategory",FILTER_DEFAULT) ?? '');
$comment             = trim(filter_input(INPUT_POST,"comment",FILTER_DEFAULT));

//— Prepare transaction metadata
$transaction_reference = uniqid('d', true);
$order_code            = uniqid('o', true);
$transaction_date      = date("Y-m-d", strtotime("+2 hours"));
$transaction_time      = date("H:i:s", strtotime("+2 hours"));
$day                   = date('l', strtotime($transaction_date));
$month                 = date("F", strtotime($transaction_date));
$week                  = date("W", strtotime($transaction_date));

//— Fetch CGrate credentials
$stmt = $conn->prepare("
    SELECT public_key, private_key
      FROM api_details
     WHERE details_name='CGRATE ZAMBIA'
       AND currency='KWACHA'
       AND status='Active'
     LIMIT 1
");
$stmt->execute();
$api = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$api) {
    echo json_encode(['status'=>'error','message'=>'API credentials not found']);
    exit;
}
$cgrateUser = $api['public_key'];
$cgratePass = $api['private_key'];



//// SCRIPT COMES HERE THAT SENDS THE PAYMENT REQUEST TO CGRATE AND PROCESS THE RESPONSE $cgrateUser = $api['public_key'], $cgratePass = $api['private_key'], $phone, AND $amount and get a response   

 
// —— Call AWS payment gateway (your cgrate.php on EC2)
 // Prepare the payload for the payment request
$payload = [
    'phone' => $phone,
    'amount' => round($amount, 2),
    'public_key' => $cgrateUser,
    'private_key' => $cgratePass,
    'order_code' => $order_code,
    'client_ref' => $transaction_reference
];

// Send the payment request to cgrate.php
$awsUrl = 'https://payments.cyberdesk.live/cgrate.php';
$ch = curl_init($awsUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => http_build_query($payload),
    CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
    CURLOPT_CONNECTTIMEOUT => 30,
    CURLOPT_TIMEOUT => 60
]);
$awsResp = curl_exec($ch);
$awsErr = curl_errno($ch) ? curl_error($ch) : null;
$awsCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Handle transport errors
if ($awsErr) {
    echo json_encode(['status' => 'error', 'message' => 'Gateway transport error: ' . $awsErr]);
    exit;
}
if ($awsCode < 200 || $awsCode >= 300) {
    echo json_encode(['status' => 'error', 'message' => 'Gateway HTTP ' . $awsCode, 'body' => $awsResp]);
    exit;
}

// Decode the JSON response from cgrate.php
$awsJson = json_decode($awsResp, true);
if (!is_array($awsJson)) {
    echo json_encode(['status' => 'error', 'message' => 'Non-JSON response from gateway', 'body' => $awsResp]);
    exit;
}

// Check for successful payment
if ($awsJson['responseCode'] !== '0') {
    echo json_encode(['status' => 'error', 'message' => 'Payment failed: ' . $awsJson['responseMessage']]);
    exit;
}

// Proceed with database insertion
 
//— Payment succeeded: perform DB work
//— Payment succeeded: perform DB work
try {
    $conn->beginTransaction();

    // Insert receipt
    $r = $conn->prepare("INSERT INTO receipts (issuer_id, org_id) VALUES (:a,:o)");
    $r->execute([':a'=>$userloggedid,':o'=>$orgid]);
    $invoiceNumber = $conn->lastInsertId();

    // Insert transaction_details
    foreach ($cartArray as $item) {
        $t = $conn->prepare("
            INSERT INTO transaction_details (
                cfname, clname, cemail, cphone, product_name, product_id, product_code,
                product_category, product_category_code, balance_bf, transaction_amount,
                transaction_balance, quantity, order_code, transaction_reference,
                transaction_status, order_details, user_id, agent_name, agent_id,
                trans_type, debit_or_credit, depot, depot_id, depot_code,
                delivery_address, area, plot_no, nrc, lat, lng,
                transaction_date, transaction_time, transaction_month, transaction_week,
                transaction_day, receipt_no, invoiceNumber, comment, receipt_date,
                payment_mode, bank_name, bank_account_name, business_category,
                pacra, tpin, org_name, org_id
            ) VALUES (
                :fn,:ln,:em,:ph,:pn,:pid,:pcode,
                :cat,:cc,:bf,:ta,:tb,:qty,:oc,:tr,
                'active',:od,:uid,:an,:ai,
                :tt,'Credit',:dep,:depid,:depcode,
                :addr,:ar,:pl,:nr,:lt,:lg,
                :td,:ttm,:mo,:wk,:dy,:r,:iin,
                :cmt,:rd,'DIGITAL','DIGITAL','DIGITAL',
                :bc,:pa,:tp,:on,:oi
            )
        ");
        $t->execute([
            ':fn'=>$fname,':ln'=>$lname,':em'=>$email,':ph'=>$phone,
            ':pn'=>$item['name'],':pid'=>$item['id'],':pcode'=>$item['productcode'],
            ':cat'=>$item['category'],':cc'=>$item['categorycode'],':bf'=>$item['balance_bf'],
            ':ta'=>$item['total'],':tb'=>$item['balanceCF'],':qty'=>$item['count'],
            ':oc'=>$order_code,':tr'=>$transaction_reference,':od'=>$cartObject,
            ':uid'=>$userid,':an'=>$agentname,':ai'=>$userloggedid,':tt'=>$transtype,
            ':dep'=>$item['depot'],':depid'=>$item['depotid'],':depcode'=>$item['depotcode'],
            ':addr'=>$deliveryaddress,':ar'=>$area,':pl'=>$plotnumber,':nr'=>$nrc,
            ':lt'=>$deliverylat,':lg'=>$deliverylng,
            ':td'=>$transaction_date,':ttm'=>$transaction_time,
            ':mo'=>$month,':wk'=>$week,':dy'=>$day,
            ':r'=>$invoiceNumber,':iin'=>$hiddenInvoiceNumber,
            ':cmt'=>$comment,':rd'=>$invoiceDueDate,
            ':bc'=>$businessCategory,':pa'=>$pacra,':tp'=>$tpin,
            ':on'=>$orgname,':oi'=>$orgid
        ]);


        // Update billing_subscription
        // For each item in the cart, update the billing_subscription table to reflect the payment made.
        // The code below selects all billing_subscription records for the client and product with a non-zero balance, ordered by invoice number.
        // It then deducts the payment amount from the oldest balances first (FIFO), updating each record's balance accordingly.
        // If there is any remaining payment amount after clearing all positive balances, it deducts the remainder from the most recent invoice.
        // This ensures that the payment is applied to the oldest outstanding invoices first, and any excess is subtracted from the latest invoice.
        $f = $conn->prepare("
            SELECT b_id,balance FROM billing_subscription
            WHERE client_id=:uid AND product_id=:pid AND balance<>0
            ORDER BY invoice_no ASC
        ");
        $f->execute([':uid'=>$userid,':pid'=>$item['id']]);
        $remaining = floatval($item['total'] ?? 0);
        foreach ($f->fetchAll(PDO::FETCH_ASSOC) as $inv) {
            if ($remaining <= 0) break;
            if ($remaining >= $inv['balance']) {
                $remaining -= $inv['balance'];
                $newBal = 0;
            } else {
                $newBal = $inv['balance'] - $remaining;
                $remaining = 0;
            }
            $u = $conn->prepare("UPDATE billing_subscription SET balance=:nb WHERE b_id=:bid");
            $u->execute([':nb'=>$newBal,':bid'=>$inv['b_id']]);
        }
        if ($remaining > 0) {
            $fl = $conn->prepare("
                SELECT invoice_no,balance FROM billing_subscription
                WHERE client_id=:uid AND product_id=:pid
                ORDER BY invoice_no DESC LIMIT 1
            ");
            $fl->execute([':uid'=>$userid,':pid'=>$item['id']]);
            if ($li = $fl->fetch(PDO::FETCH_ASSOC)) {
                $ul = $conn->prepare("
                    UPDATE billing_subscription
                       SET balance = balance - :rem
                     WHERE client_id=:uid AND product_id=:pid AND invoice_no=:ino
                ");
                $ul->execute([
                    ':rem'=>$remaining,
                    ':uid'=>$userid,
                    ':pid'=>$item['id'],
                    ':ino'=>$li['invoice_no']
                ]);
            }
        } //end of updating billing_subscription datABASE

    }



  // --- USER AND INVOICE CREATION IN THE EVENT THE USERS/INOINCE DOES NOT EXIST---
    if (file_exists('client_invoice_checks.php')) {
        require_once 'client_invoice_checks.php';
    }

    // --- Step 1: Create invoices for recurring products (if function exists) ---
    $invoiceResult = null;
    if (function_exists('createRecurringInvoices')) {
        try {
            $invoiceResult = createRecurringInvoices($conn, $cartArray, $phone, $userloggedid, $orgid, $orgname, $fname);
        } catch (Throwable $e) {
            error_log("Invoice creation failed: " . $e->getMessage());
            // Continue with receipt processing even if invoice creation fails
        }
    }
  // --- USER AND INVOICE CREATION IN THE EVENT THE USERS/INOINCE DOES NOT EXIST---



    // Commit
    $conn->commit();

    echo json_encode([
         'status' => 'created',
        'message' => 'Payment successful and recorded',
        'receiptnumber' => $invoiceNumber,
        'paymentID' => $awsJson['paymentID'],
        'amount' => $amount,
        'date' => date("Y-m-d"),
        'time' => date("H:i:s"),
        'day' => date('l')
    ]);
} catch (Exception $e) {
    $conn->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'DB error after payment: ' . $e->getMessage()
    ]);
}