<?php
/**
 * lenco_webhook.php - Integrated with transaction_details table
 * URL: https://www.cyberdesk.live/lenco/lenco_webhook.php
 */

// Database configuration
$dbHost = 'localhost';
$dbName = 'xybejmiv_cyberdesk_demo'; // CHANGE THIS
$dbUser = 'xybejmiv_cyberdesk_demo';   // CHANGE THIS
$dbPass = 'xybejmiv_cyberdesk_demo';   // CHANGE THIS



// Lenco webhook secret
$webhookSecret = 'c9590e700cfadce50899febae76c3a814a2de1b1e284bd0709d39574028b8d77';

// Log file
$logFile = __DIR__ . '/webhook_logs.txt';

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 0);

// Logging function
function logWebhook($message) {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message\n";
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

// Get raw POST data
$payload = file_get_contents('php://input');
logWebhook("=== NEW WEBHOOK RECEIVED ===");
logWebhook("Payload: " . $payload);

// Get signature
$signature = $_SERVER['HTTP_X_LENCO_SIGNATURE'] ?? '';
logWebhook("Signature received: " . $signature);

// Verify signature
$expectedSignature = hash_hmac('sha256', $payload, $webhookSecret);
logWebhook("Expected signature: " . $expectedSignature);

if ($signature !== $expectedSignature) {
    logWebhook("ERROR: Invalid signature!");
    http_response_code(401);
    echo json_encode(['error' => 'Invalid signature']);
    exit;
}

logWebhook("✓ Signature verified successfully");

// Parse data
$data = json_decode($payload, true);

if (!$data) {
    logWebhook("ERROR: Invalid JSON payload");
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

$event = $data['event'] ?? null;
$paymentData = $data['data'] ?? null;

logWebhook("Event type: " . $event);
logWebhook("Payment reference: " . ($paymentData['reference'] ?? 'N/A'));

// Database connection
try {
    $pdo = new PDO(
        "mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    logWebhook("✓ Database connected");
} catch (PDOException $e) {
    logWebhook("ERROR: Database connection failed: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

// Handle events
switch ($event) {
    case 'collection.successful':
        handleSuccessfulPayment($pdo, $paymentData);
        break;
        
    case 'collection.failed':
        handleFailedPayment($pdo, $paymentData);
        break;
        
    case 'collection.pending':
        handlePendingPayment($pdo, $paymentData);
        break;
        
    default:
        logWebhook("Unhandled event: $event");
}

// Return success
http_response_code(200);
echo json_encode(['received' => true]);
logWebhook("=== WEBHOOK PROCESSED SUCCESSFULLY ===\n");

// ============================================
// EVENT HANDLERS
// ============================================

function handleSuccessfulPayment($pdo, $data) {
    logWebhook("Processing SUCCESSFUL payment...");
    
    $reference = $data['reference'];
    $lencoReference = $data['lencoReference'];
    $amount = $data['amount'];
    $phone = $data['mobileMoneyDetails']['phone'] ?? '';
    $accountName = $data['mobileMoneyDetails']['accountName'] ?? '';
    $operator = $data['mobileMoneyDetails']['operator'] ?? '';
    $completedAt = $data['completedAt'];
    
    try {
        // Check if transaction already exists
        $stmt = $pdo->prepare("
            SELECT id, transaction_status 
            FROM transaction_details 
            WHERE transaction_reference = ?
        ");
        $stmt->execute([$reference]);
        $existing = $stmt->fetch();
        
        if ($existing) {
            // Update existing transaction
            logWebhook("Updating existing transaction ID: " . $existing['id']);
            
            $updateStmt = $pdo->prepare("
                UPDATE transaction_details 
                SET 
                    transaction_status = 'completed',
                    payment_mode = 'MOBILE MONEY',
                    cash_in_status = 'Completed',
                    deposit_status = 'Approved',
                    comment = CONCAT(comment, ' | Lenco Ref: ', ?),
                    receipt_date = ?,
                    cashing_timestamp = ?
                WHERE transaction_reference = ?
            ");
            
            $updateStmt->execute([
                $lencoReference,
                date('Y-m-d', strtotime($completedAt)),
                date('Y-m-d H:i:s', strtotime($completedAt)),
                $reference
            ]);
            
            logWebhook("✓ Transaction updated successfully");
            
        } else {
            // Insert new transaction
            logWebhook("Creating new transaction record");
            
            $insertStmt = $pdo->prepare("
                INSERT INTO transaction_details (
                    cfname,
                    cphone,
                    product_name,
                    transaction_amount,
                    transaction_reference,
                    transaction_status,
                    order_code,
                    trans_type,
                    debit_or_credit,
                    transaction_date,
                    transaction_time,
                    transaction_month,
                    transaction_week,
                    transaction_day,
                    payment_mode,
                    cash_in_status,
                    deposit_status,
                    comment,
                    receipt_date,
                    cashing_timestamp
                ) VALUES (
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                )
            ");
            
            $now = new DateTime();
            
            $insertStmt->execute([
                $accountName,                           // cfname
                $phone,                                 // cphone
                'Mobile Money Payment',                 // product_name
                $amount,                                // transaction_amount
                $reference,                             // transaction_reference
                'completed',                            // transaction_status
                'ORD-' . time(),                       // order_code
                'PAYMENT',                              // trans_type
                'Credit',                               // debit_or_credit
                $now->format('Y-m-d'),                 // transaction_date
                $now->format('H:i:s'),                 // transaction_time
                $now->format('F'),                     // transaction_month
                $now->format('W'),                     // transaction_week
                $now->format('l'),                     // transaction_day
                'MOBILE MONEY',                         // payment_mode
                'Completed',                            // cash_in_status
                'Approved',                             // deposit_status
                'Paid via ' . ucfirst($operator) . ' Mobile Money | Lenco: ' . $lencoReference, // comment
                date('Y-m-d', strtotime($completedAt)), // receipt_date
                date('Y-m-d H:i:s', strtotime($completedAt)) // cashing_timestamp
            ]);
            
            logWebhook("✓ New transaction created with ID: " . $pdo->lastInsertId());
        }
        
        // Optional: Send notification email/SMS here
        // sendPaymentNotification($phone, $amount, $reference);
        
        logWebhook("✓ Successful payment processed: Ref=$reference, Amount=ZMW $amount");
        
    } catch (PDOException $e) {
        logWebhook("ERROR: Database error: " . $e->getMessage());
    }
}

function handleFailedPayment($pdo, $data) {
    logWebhook("Processing FAILED payment...");
    
    $reference = $data['reference'];
    $reason = $data['reasonForFailure'] ?? 'Unknown reason';
    
    try {
        $stmt = $pdo->prepare("
            UPDATE transaction_details 
            SET 
                transaction_status = 'failed',
                cash_in_status = 'Failed',
                deposit_status = 'Rejected',
                comment = CONCAT(comment, ' | Payment failed: ', ?)
            WHERE transaction_reference = ?
        ");
        
        $stmt->execute([$reason, $reference]);
        
        logWebhook("✓ Failed payment updated: Ref=$reference, Reason=$reason");
        
    } catch (PDOException $e) {
        logWebhook("ERROR: " . $e->getMessage());
    }
}

function handlePendingPayment($pdo, $data) {
    logWebhook("Processing PENDING payment...");
    
    $reference = $data['reference'];
    
    try {
        $stmt = $pdo->prepare("
            UPDATE transaction_details 
            SET 
                transaction_status = 'pending',
                cash_in_status = 'Pending',
                deposit_status = 'Pending'
            WHERE transaction_reference = ?
        ");
        
        $stmt->execute([$reference]);
        
        logWebhook("✓ Pending payment updated: Ref=$reference");
        
    } catch (PDOException $e) {
        logWebhook("ERROR: " . $e->getMessage());
    }
}

?>