<?php
/**
 * lenco_payment.php - Integrated with transaction_details table
 */

// Database configuration
$dbHost = 'localhost';
$dbName = 'xybejmiv_cyberdesk_demo'; // CHANGE THIS
$dbUser = 'xybejmiv_cyberdesk_demo';   // CHANGE THIS
$dbPass = 'xybejmiv_cyberdesk_demo';   // CHANGE THIS

// Lenco API credentials  
$apiSecret = '4675c9f131c4d3f208512b4e464fdec4f840253c84cc064ad7c96c455b9a78c9';
$baseUrl = 'https://api.lenco.co/access/v2';

error_reporting(E_ALL);
ini_set('display_errors', 0);
header('Content-Type: application/json');

// Database connection function
function getDBConnection() {
    global $dbHost, $dbName, $dbUser, $dbPass;
    try {
        return new PDO(
            "mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4",
            $dbUser,
            $dbPass,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
    } catch (PDOException $e) {
        error_log("Database connection error: " . $e->getMessage());
        return null;
    }
}

// ============================================
// 1. INITIATE PAYMENT
// ============================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'initiate') {
    
    $amount = floatval($_POST['amount']);
    $phoneInput = $_POST['phone'];
    
    // Optional: Get customer details if provided
    $customerName = $_POST['customer_name'] ?? 'General Customer';
    $customerEmail = $_POST['customer_email'] ?? '';
    $productName = $_POST['product_name'] ?? 'Mobile Money Payment';
    $userId = $_POST['user_id'] ?? 0;
    
    // Generate unique reference
    $reference = 'PAY-' . time() . '-' . bin2hex(random_bytes(4));
    $orderCode = 'o' . uniqid() . '.' . mt_rand(10000000, 99999999);
    
    // Clean and format phone number
    $phone = preg_replace('/[^0-9]/', '', $phoneInput);
    
    if (substr($phone, 0, 3) === '260') {
        $phone = '0' . substr($phone, 3);
    } elseif (substr($phone, 0, 1) !== '0') {
        $phone = '0' . $phone;
    }
    
    // Validate format
    if (strlen($phone) !== 10 || substr($phone, 0, 1) !== '0') {
        echo json_encode([
            'success' => false,
            'message' => 'Invalid phone format. Must be 10 digits starting with 0'
        ]);
        exit;
    }
    
    // Detect operator
    $prefix = substr($phone, 0, 3);
    $operatorMap = [
        '096' => 'mtn',
        '076' => 'mtn', 
        '097' => 'airtel',
        '077' => 'airtel',
        '095' => 'zamtel',
        '075' => 'zamtel'
    ];
    
    if (!isset($operatorMap[$prefix])) {
        echo json_encode([
            'success' => false,
            'message' => 'Invalid mobile operator prefix',
            'valid_prefixes' => 'MTN: 096/076, Airtel: 097/077, Zamtel: 095/075'
        ]);
        exit;
    }
    
    $operator = $operatorMap[$prefix];
    
    // ============================================
    // INSERT INTO DATABASE BEFORE API CALL
    // ============================================
    $pdo = getDBConnection();
    if ($pdo) {
        try {
            $now = new DateTime();
            
            $stmt = $pdo->prepare("
                INSERT INTO transaction_details (
                    cfname,
                    cemail,
                    cphone,
                    product_name,
                    transaction_amount,
                    transaction_reference,
                    order_code,
                    transaction_status,
                    trans_type,
                    debit_or_credit,
                    transaction_date,
                    transaction_time,
                    transaction_month,
                    transaction_week,
                    transaction_day,
                    payment_mode,
                    cash_in_status,
                    deposit_status,
                    user_id,
                    comment
                ) VALUES (
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                )
            ");
            
            $stmt->execute([
                $customerName,                          // cfname
                $customerEmail,                         // cemail
                $phone,                                 // cphone
                $productName,                           // product_name
                $amount,                                // transaction_amount
                $reference,                             // transaction_reference
                $orderCode,                            // order_code
                'pending',                              // transaction_status
                'PAYMENT',                              // trans_type
                'Credit',                               // debit_or_credit
                $now->format('Y-m-d'),                 // transaction_date
                $now->format('H:i:s'),                 // transaction_time
                $now->format('F'),                     // transaction_month
                $now->format('W'),                     // transaction_week
                $now->format('l'),                     // transaction_day
                'MOBILE MONEY',                         // payment_mode
                'Pending',                              // cash_in_status
                'Pending',                              // deposit_status
                $userId,                                // user_id
                'Payment initiated via ' . ucfirst($operator) // comment
            ]);
            
            $transactionId = $pdo->lastInsertId();
            error_log("Transaction created in DB with ID: $transactionId");
            
        } catch (PDOException $e) {
            error_log("Database insert error: " . $e->getMessage());
            // Continue with payment even if DB insert fails
        }
    }
    
    // ============================================
    // CALL LENCO API
    // ============================================
    $url = $baseUrl . '/collections/mobile-money';
    $headers = [
        'Authorization: Bearer ' . $apiSecret,
        'Content-Type: application/json',
        'Accept: application/json'
    ];
    
    $payload = json_encode([
        'amount' => $amount,
        'phone' => $phone,
        'operator' => $operator,
        'reference' => $reference,
        'currency' => 'ZMW',
        'country' => 'zm'
    ]);
    
    error_log("Lenco Request: " . $payload);
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => true
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);
    
    error_log("Lenco Response ($httpCode): " . $response);
    
    if ($curlError) {
        // Update DB with error
        if ($pdo && isset($transactionId)) {
            $stmt = $pdo->prepare("
                UPDATE transaction_details 
                SET transaction_status = 'failed',
                    comment = CONCAT(comment, ' | Error: ', ?)
                WHERE id = ?
            ");
            $stmt->execute([$curlError, $transactionId]);
        }
        
        echo json_encode([
            'success' => false,
            'message' => 'Connection error: ' . $curlError
        ]);
        exit;
    }
    
    $responseData = json_decode($response, true);
    
    if ($httpCode == 200 || $httpCode == 201) {
        // Update DB with Lenco reference
        if ($pdo && isset($transactionId)) {
            $lencoRef = $responseData['data']['lencoReference'] ?? '';
            $stmt = $pdo->prepare("
                UPDATE transaction_details 
                SET comment = CONCAT(comment, ' | Lenco Ref: ', ?)
                WHERE id = ?
            ");
            $stmt->execute([$lencoRef, $transactionId]);
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'Payment initiated successfully',
            'reference' => $reference,
            'operator' => $operator,
            'phone' => $phone,
            'transaction_id' => $transactionId ?? null,
            'data' => $responseData
        ]);
    } else {
        // Update DB with failure
        if ($pdo && isset($transactionId)) {
            $errorMsg = $responseData['message'] ?? 'Unknown error';
            $stmt = $pdo->prepare("
                UPDATE transaction_details 
                SET transaction_status = 'failed',
                    cash_in_status = 'Failed',
                    comment = CONCAT(comment, ' | Failed: ', ?)
                WHERE id = ?
            ");
            $stmt->execute([$errorMsg, $transactionId]);
        }
        
        echo json_encode([
            'success' => false,
            'message' => $responseData['message'] ?? 'Payment failed',
            'httpCode' => $httpCode,
            'errorCode' => $responseData['errorCode'] ?? null,
            'operator' => $operator,
            'phone' => $phone,
            'error' => $responseData
        ]);
    }
    
    exit;
}

// ============================================
// 2. VERIFY PAYMENT
// ============================================
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'verify') {
    
    $reference = $_GET['reference'];
    
    $url = $baseUrl . '/collections/status/' . $reference;
    $headers = [
        'Authorization: Bearer ' . $apiSecret,
        'Accept: application/json'
    ];
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_TIMEOUT => 30
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode == 200) {
        $responseData = json_decode($response, true);
        
        if ($responseData && $responseData['status'] === true) {
            $paymentStatus = $responseData['data']['status'];
            
            // Update database with current status
            $pdo = getDBConnection();
            if ($pdo) {
                try {
                    $dbStatus = 'pending';
                    $cashInStatus = 'Pending';
                    
                    if ($paymentStatus === 'successful') {
                        $dbStatus = 'completed';
                        $cashInStatus = 'Completed';
                    } elseif ($paymentStatus === 'failed') {
                        $dbStatus = 'failed';
                        $cashInStatus = 'Failed';
                    }
                    
                    $stmt = $pdo->prepare("
                        UPDATE transaction_details 
                        SET transaction_status = ?,
                            cash_in_status = ?
                        WHERE transaction_reference = ?
                    ");
                    $stmt->execute([$dbStatus, $cashInStatus, $reference]);
                    
                } catch (PDOException $e) {
                    error_log("Verification DB update error: " . $e->getMessage());
                }
            }
            
            echo json_encode([
                'success' => true,
                'status' => $paymentStatus,
                'amount' => $responseData['data']['amount'],
                'currency' => $responseData['data']['currency'],
                'reference' => $responseData['data']['reference'],
                'lencoReference' => $responseData['data']['lencoReference'] ?? null,
                'data' => $responseData['data']
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Payment not found'
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Verification failed',
            'httpCode' => $httpCode
        ]);
    }
    
    exit;
}

echo json_encode([
    'success' => false,
    'message' => 'Invalid request'
]);
?>