<?php
/**
 * lenco_payment.php
 * THIS IS THE ONLY PHP FILE YOU NEED!
 * Place this file in the same folder as your HTML file
 */

// Your Lenco API credentials
$apiSecret = '4675c9f131c4d3f208512b4e464fdec4f840253c84cc064ad7c96c455b9a78c9';
$baseUrl = 'https://api.lenco.co/access/v2';

// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 0); // Don't display errors to user
header('Content-Type: application/json');

// ============================================
// 1. INITIATE PAYMENT
// ============================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'initiate') {
    
    $amount = floatval($_POST['amount']);
    $phone = $_POST['phone'];
    
    // Generate unique reference
    $reference = 'PAY-' . time() . '-' . bin2hex(random_bytes(4));
    
    // Format phone number
    $phone = preg_replace('/[^0-9+]/', '', $phone);
    if (substr($phone, 0, 1) === '0') {
        $phone = '+260' . substr($phone, 1);
    } elseif (substr($phone, 0, 3) === '260') {
        $phone = '+' . $phone;
    } elseif (substr($phone, 0, 4) !== '+260') {
        $phone = '+260' . $phone;
    }
    
    // Prepare API request
    $url = $baseUrl . '/collections/mobile-money';
    $headers = [
        'Authorization: Bearer ' . $apiSecret,
        'Content-Type: application/json'
    ];
    
    $payload = json_encode([
        'amount' => $amount,
        'phoneNumber' => $phone,
        'reference' => $reference,
        'currency' => 'ZMW',
        'country' => 'zm'
    ]);
    
    // Make request to Lenco
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);
    
    // Handle response
    if ($curlError) {
        echo json_encode([
            'success' => false,
            'message' => 'Connection error: ' . $curlError
        ]);
        exit;
    }
    
    $responseData = json_decode($response, true);
    
    if ($httpCode == 200 || $httpCode == 201) {
        echo json_encode([
            'success' => true,
            'message' => 'Payment initiated',
            'reference' => $reference,
            'data' => $responseData
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => $responseData['message'] ?? 'Payment initiation failed',
            'httpCode' => $httpCode,
            'error' => $responseData
        ]);
    }
    
    exit;
}

// ============================================
// 2. VERIFY PAYMENT
// ============================================
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'verify') {
    
    $reference = $_GET['reference'];
    
    // Prepare API request
    $url = $baseUrl . '/collections/status/' . $reference;
    $headers = [
        'Authorization: Bearer ' . $apiSecret
    ];
    
    // Make request to Lenco
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    // Handle response
    if ($httpCode == 200) {
        $responseData = json_decode($response, true);
        
        if ($responseData && $responseData['status'] === true) {
            echo json_encode([
                'success' => true,
                'status' => $responseData['data']['status'],
                'amount' => $responseData['data']['amount'],
                'currency' => $responseData['data']['currency'],
                'reference' => $responseData['data']['reference'],
                'lencoReference' => $responseData['data']['lencoReference'] ?? null,
                'data' => $responseData['data']
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Payment not found'
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Verification failed',
            'httpCode' => $httpCode
        ]);
    }
    
    exit;
}

// ============================================
// If no valid action, return error
// ============================================
echo json_encode([
    'success' => false,
    'message' => 'Invalid request'
]);
?>