document.addEventListener("DOMContentLoaded", function () {
    const chatButton = document.getElementById("chatButton");
    const chatWindow = document.getElementById("chatWindow");
    const closeChat = document.getElementById("closeChat");
    const attachFile = document.getElementById("attachFile");
    const fileInput = document.getElementById("fileInput");
    const emojiButton = document.getElementById("emojiButton");
    const voiceButton = document.getElementById("voiceButton");
  
    let isDragging = false;
    let offsetX, offsetY;
  
    // Open Chat Window
    chatButton.addEventListener("click", function () {
    $('.chat-footer').hide();
    $('.chat-contacts-div').fadeIn('slow');
      if (!isDragging) {
        chatWindow.style.transform = chatWindow.style.transform === "scale(1)" ? "scale(0)" : "scale(1)";
      }
      getMessengerChatsContacts();
  
    });
  
    closeChat.addEventListener("click", function () {
      $('.chat-contacts-div').hide();
      chatWindow.style.transform = "scale(0)";
    });
  
    // Drag Start
    chatButton.addEventListener("mousedown", function (e) {
      isDragging = true;
      offsetX = e.clientX - chatButton.getBoundingClientRect().left;
      offsetY = e.clientY - chatButton.getBoundingClientRect().top;
      chatButton.style.transition = "none"; // Disable transition while dragging
   
    });
  
    // Drag Move
    document.addEventListener("mousemove", function (e) {
      if (isDragging) {
        let x = e.clientX - offsetX;
        let y = e.clientY - offsetY;
        chatButton.style.left = `${x}px`;
        chatButton.style.top = `${y}px`;
      }
    });
  
    // Drag End
    document.addEventListener("mouseup", function () {
      isDragging = false;
      chatButton.style.transition = "0.3s ease-in-out"; // Re-enable transition after dragging
    });
  
    // File Attachment
    attachFile.addEventListener("click", function () {
      fileInput.click();
    });
  
    fileInput.addEventListener("change", function () {
      alert("File selected: " + fileInput.files[0].name);
    });
  
    // Emoji Button (Placeholder Action)
    emojiButton.addEventListener("click", function () {
      alert("Emoji Picker coming soon! 😊");
    });
  
    // Voice Button (Placeholder Action)
    voiceButton.addEventListener("click", function () {
      alert("Voice Recording feature coming soon! 🎤");
    });
  
    // Close chat when clicking outside (on mobile)
    document.addEventListener("click", function (event) {
      if (!chatWindow.contains(event.target) && !chatButton.contains(event.target)) {
        chatWindow.style.transform = "scale(0)";
      }
    });
  });

  // Fix chat-footer position on mobile when keyboard is open
  function adjustChatFooterMobile() {
    var chatFooter = document.querySelector('.chat-footer');
    var chatInput = document.getElementById('chatInput');
    if (!chatFooter || !chatInput) return;

    function setFooterAbsolute() {
      chatFooter.style.position = 'absolute';
      chatFooter.style.bottom = '0';
      chatFooter.style.width = '100%';
      chatFooter.style.zIndex = '99999';
      // Optionally scroll chat window up
      var chatWindow = document.getElementById('chatWindow');
      if (chatWindow) chatWindow.scrollTop = chatWindow.scrollHeight;
    }
    function setFooterFixed() {
      chatFooter.style.position = 'fixed';
      chatFooter.style.bottom = '';
      chatFooter.style.width = '';
      chatFooter.style.zIndex = '';
    }

    chatInput.addEventListener('focus', function() {
      if (window.innerWidth < 768) setFooterAbsolute();
    });
    chatInput.addEventListener('blur', function() {
      setFooterFixed();
    });
  }
  document.addEventListener('DOMContentLoaded', adjustChatFooterMobile);
  
  ////////// SEARCH INPUT SCRIPTS//////
  document.addEventListener("DOMContentLoaded", function () {
    const searchIcon = document.getElementById("searchIcon");
    const closeSearch = document.getElementById("closeSearch");
    const searchContainer = document.getElementById("searchContainer");
    const searchInput = document.getElementById("chatSearchInput");
    const closeChat = document.getElementById("closeChat");
    const chatTitle = document.querySelector(".chat-title");
    const chatDropDown = document.querySelector(".chatDropDown");
    const filterIcons = document.querySelectorAll(".filter-icon"); 
  
    // Expand search bar
    searchIcon.addEventListener("click", function () {
      searchContainer.classList.add("expanded");
      searchInput.focus();
      closeChat.style.display = "none"; // Hide close button
      chatTitle.style.display = "none"; // Hide chat title
     // chatDropDown.style.display = "none"; // Hide dropdown menu
  
    });
  
    // Close search
    closeSearch.addEventListener("click", function () {
      searchContainer.classList.remove("expanded");
      searchInput.value = "";
  
      // Show hidden elements
      closeChat.style.display = "inline";
      chatTitle.style.display = "inline";
      chatDropDown.style.display = "inline";
      chatDropDown.style.display = "inline";
  
      // Hide filter icons
      filterIcons.forEach(icon => icon.style.display = "none");
    });
  
    // Show filter icons when search is active
    searchInput.addEventListener("focus", function () {
      filterIcons.forEach(icon => icon.style.display = "inline");
    });
  
    // Unique Dropdown Menu
    const chatMenuIcon = document.getElementById("chatMenuIcon");
  
    chatMenuIcon.addEventListener("click", function () {
      chatDropDown.classList.toggle("chatDropdownActive");
    });
  
    // Close dropdown if clicked outside
    document.addEventListener("click", function (event) {
      if (!chatDropDown.contains(event.target) && event.target !== chatMenuIcon) {
        chatDropDown.classList.remove("chatDropdownActive");
      }
    });
  });
  
  
  
/////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS ////////
/////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS ////////
const tabs = document.querySelectorAll(".chatTab");
const contactsDiv = document.getElementById("chatContactsDiv");
const tabsContainer = document.getElementById("chatTabsList");

let currentTabIndex = 0;

function activateTab(index) {
    tabs.forEach(tab => tab.classList.remove("activeTab"));
    tabs[index].classList.add("activeTab");
    contactsDiv.innerHTML = `<p>${tabs[index].dataset.content}</p>`;
    tabs[index].scrollIntoView({ behavior: "smooth", inline: "center" });
}

tabs.forEach((tab, index) => {
    tab.addEventListener("click", () => {
        currentTabIndex = index;
        activateTab(currentTabIndex);
    });
});

let touchStartX = 0;
let touchEndX = 0;

tabsContainer.addEventListener("touchstart", (e) => {
    touchStartX = e.changedTouches[0].screenX;
});

tabsContainer.addEventListener("touchend", (e) => {
    touchEndX = e.changedTouches[0].screenX;
    if (touchStartX - touchEndX > 50 && currentTabIndex < tabs.length - 1) {
        currentTabIndex++;
    } else if (touchEndX - touchStartX > 50 && currentTabIndex > 0) {
        currentTabIndex--;
    }
    activateTab(currentTabIndex);
});

activateTab(0); // Initialize first tab as active
 
/////// END OF  CHAT TABLLIST SCRIPTS /////////////// END OF  CHAT TABLLIST SCRIPTS /////////////// END OF  CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS ////////
/////// END OF CHAT TABLLIST SCRIPTS /////////////// END OF  CHAT TABLLIST SCRIPTS /////////////// END OF  CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS /////////////// CHAT TABLLIST SCRIPTS ////////

  


  ///////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM///////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
  ///////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM///////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
  ///////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM///////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
  ///////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM///////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
 ///////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM///////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
 
 $(document).on('change keyup','#chatSearchInput',function (event) {
  getMessengerChatsContacts();
});
 
 var contactsInterval = null;

  function getMessengerChatsContacts() { 
      var searchKey = $("#chatSearchInput").val();  
  
      var datastring = 'searchKey=' + searchKey;
  
      $.ajax({
          data: datastring,
          url: "xd-modules/messenger-module/backend/getChatContacts.php",
          type: "POST"
      }).done(function (data) {
          try {
              var details = JSON.parse(data);
              $('.chat-contacts-div').empty();
              $.each(details.details, function (i, freelance) {
                var defaultAvatar = "logo.png"; // Default avatar image path
                var avatarSrc = (freelance.avatar && freelance.avatar.trim() !== "") ? freelance.avatar : defaultAvatar;
            
                // Parse the gps_timestamp and calculate the time difference
                var gpsTimestamp = new Date(freelance.gps_timestamp); // Convert to Date object
                var currentTime = new Date(); // Current time
                var timeDifference = (currentTime - gpsTimestamp) / 1000; // Difference in seconds

                // Determine if the user is online
                var isOnline = timeDifference <= 40; // Check if the timestamp is within the last 30 seconds

                // Add or remove the 'user-is-online' class based on the time difference
                var onlineClass = isOnline ? "user-is-online" : "";


                

                if(freelance.last_message_status === 'sent'){
                 
                  $('.chat-contacts-div').append(`
                    <div data-id="${freelance.id}" data-avatar="${avatarSrc}" data-names="${freelance.names}" class="contactLisItem w3-col l12 m12 s12" style="cursor:pointer">
                        <div class="w3-col l2 m2 s2">
                            <center>
                                <img src="${avatarSrc}" class="chat-contacts-div-avatar ${onlineClass}"  
                                    onerror="this.onerror=null; this.src='${defaultAvatar}';" />
                            </center>
                        </div>
                        <div class="w3-col l10 m10 s10">
                            <span class="w3-col l12 m12 s12" style="padding-left:7px;font-weight:600;color:gray;">
                                <span>${freelance.names}</span> 
                                <i style="float:right;font-weight:100;height:17px;min-width:17px;background-color:var(--primary-color);border-radius:50%;color:white;line-height:12px;padding:3px;margin:5px;">${freelance.unseen_messages}</i> 
                                <i style="float:right;font-weight:100;">${freelance.role}</i>
                            </span>
                            <span class="w3-col l12 m12 s12">
                               <span id="last_message_status"><span style="float:left;font-size:0.8em;color:gray;">√</span></span>
                              <span class="contact_last_message">${freelance.last_message}</span>
                            </span>
                        </div>
                    </div>`);

                }else if(freelance.last_message_status === 'delivered'){
                  $('.chat-contacts-div').append(`
                    <div data-id="${freelance.id}" data-avatar="${avatarSrc}" data-names="${freelance.names}" class="contactLisItem w3-col l12 m12 s12" style="cursor:pointer">
                        <div class="w3-col l2 m2 s2">
                            <center>
                                <img src="${avatarSrc}" class="chat-contacts-div-avatar ${onlineClass}" 
                                    onerror="this.onerror=null; this.src='${defaultAvatar}';" />
                            </center>
                        </div>
                        <div class="w3-col l10 m10 s10">
                            <span class="w3-col l12 m12 s12" style="padding-left:7px;font-weight:600;color:gray;">
                                <span>${freelance.names}</span> 
                                <i style="float:right;font-weight:100;height:17px;min-width:17px;background-color:var(--primary-color);border-radius:50%;color:white;line-height:12px;padding:3px;margin:5px;">${freelance.unseen_messages}</i> 
                                <i style="float:right;font-weight:100;">${freelance.role}</i>
                            </span>
                            <span class="w3-col l12 m12 s12">
                               <span id="last_message_status"><span style="float:left;font-size:0.8em;color:gray;">√√</span></span>
                               <span class="contact_last_message">${freelance.last_message}</span>
                            </span>
                        </div>
                    </div>`);
                }else if(freelance.last_message_status === 'seen'){
                  $('.chat-contacts-div').append(`
                    <div data-id="${freelance.id}" data-avatar="${avatarSrc}" data-names="${freelance.names}" class="contactLisItem w3-col l12 m12 s12" style="cursor:pointer">
                        <div class="w3-col l2 m2 s2">
                            <center>
                                <img src="${avatarSrc}" class="chat-contacts-div-avatar ${onlineClass}"
                                    onerror="this.onerror=null; this.src='${defaultAvatar}';" />
                            </center>
                        </div>
                        <div class="w3-col l10 m10 s10">
                            <span class="w3-col l12 m12 s12" style="padding-left:7px;font-weight:600;color:gray;">
                                <span>${freelance.names}</span> 
                                <i style="float:right;font-weight:100;height:17px;min-width:17px;background-color:var(--primary-color);border-radius:50%;color:white;line-height:12px;padding:3px;margin:5px;">${freelance.unseen_messages}</i> 
                                <i style="float:right;font-weight:100;">${freelance.role}</i>
                            </span>
                            <span class="w3-col l12 m12 s12">
                               <span id="last_message_status"><span style="float:left;font-size:0.8em;color:#5078b8;">√√</span></span>
                                <span class="contact_last_message">${freelance.last_message}</span>
                            </span>
                        </div>
                    </div>`);
                
                }else{

                  // Access gps_timestamp from the details object
                var gpsTimestamp = new Date(freelance.gps_timestamp); // Convert to Date object
                var currentTime = new Date(); // Current time
                var timeDifference = (currentTime - gpsTimestamp) / 1000; // Difference in seconds

                // Determine the user's status based on the time difference
                let userStatus;
                if (timeDifference <= 60) {
                    userStatus = "Online"; // User is online within the last 60 seconds
                } else if (timeDifference <= 3600) {
                    const minutes = Math.floor(timeDifference / 60); // Convert seconds to minutes
                    userStatus = `Last seen ${minutes} minute${minutes > 1 ? "s" : ""} ago`; // Append "minute(s) ago"
                } else if (timeDifference <= 172800) { // 172800 seconds = 48 hours
                    const hours = Math.floor(timeDifference / 3600); // Convert seconds to hours
                    userStatus = `Last seen ${hours} hour${hours > 1 ? "s" : ""} ago`; // Append "hour(s) ago"
                } else {
                    const days = Math.floor(timeDifference / 86400); // Convert seconds to days
                    userStatus = `Last seen ${days} day${days > 1 ? "s" : ""} ago`; // Append "day(s) ago"
                }
                  $('.chat-contacts-div').append(`
                    <div data-id="${freelance.id}" data-avatar="${avatarSrc}" data-names="${freelance.names}" class="contactLisItem w3-col l12 m12 s12" style="cursor:pointer">
                        <div class="w3-col l2 m2 s2">
                            <center>
                                <img src="${avatarSrc}" class="chat-contacts-div-avatar ${onlineClass}" 
                                    onerror="this.onerror=null; this.src='${defaultAvatar}';" />
                            </center>
                        </div>
                        <div class="w3-col l10 m10 s10">
                            <span class="w3-col l12 m12 s12" style="padding-left:7px;font-weight:600;color:gray;">
                                <span>${freelance.names}</span> 
                                <i style="float:right;font-weight:100;height:17px;min-width:17px;background-color:var(--primary-color);border-radius:50%;color:white;line-height:12px;padding:3px;margin:5px;">${freelance.unseen_messages}</i> 
                                <i style="float:right;font-weight:100;">${freelance.role}</i>
                            </span>
                            <span class="w3-col l12 m12 s12">
                               <span class="contact_last_message">${userStatus}</span>
                            </span>
                        </div>
                    </div>`);

                }
              


                document.querySelectorAll('.contact_last_message').forEach(function (element) {
                  const maxLength = 30;  // Set the maximum number of characters you want to display
                  let message = element.textContent || element.innerText;  // Get the message text
              
                  if (message.length > maxLength) {
                      message = message.substring(0, maxLength) + '...';  // Trim the message and add ellipsis
                  }
              
                  element.textContent = message;  // Update the element's text with the truncated message
              });
              
                  
             
            });
            
          } catch (e) {
              console.error("Error parsing JSON:", e);
          }
      });
  }
  
  // Function to check if chat-contacts-div is actually visible
  function isChatContactsVisible() {
      var chatContacts = $('.chat-contacts-div');
      return chatContacts.length > 0 && chatContacts.css('display') !== 'none' && chatContacts.width() > 0 && chatContacts.height() > 0;
  }
  
  // Start fetching contacts only when chat contacts div is visible
  function startContactsInterval() {
      if (contactsInterval) return; // Avoid duplicate intervals
  
      contactsInterval = setInterval(function () {
          if (isChatContactsVisible()) {
              getMessengerChatsContacts();
          } else {
              stopContactsInterval();
          }
      }, 15000); // Fetch contacts every 5 seconds
  }
  
  // Stop fetching contacts when div is not visible
  function stopContactsInterval() {
      if (contactsInterval) {
          clearInterval(contactsInterval);
          contactsInterval = null;
      }
  }
  
  // Monitor visibility changes every second and control interval dynamically
  setInterval(function () {
      if (isChatContactsVisible()) {
          startContactsInterval();
      } else {
          stopContactsInterval();
      }
  }, 1000);
  
  ///////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
   ///////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
   ///////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
   ///////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
   ///////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
  

/// closeChatBody
$(document).on('click','#closeChatBody',function (event) {
    $('#chatClosingDiv').empty().append('<span id="closeChat" class="close-chat fontx fx-arrow-left"></span>');
    $('.chatTabsList').fadeIn('slow');
     $('.chat-contacts-div').fadeIn('slow');
     $('.chat-body').fadeOut('slow'); 
     $('.chat-footer').hide(); 
    $('#chatDropdownMenu').empty().append('<li>My Account</li><li>Creat Group</li>');
  //  $('.chatButton').fadeIn('slow'); 
  $('#chatTitle').empty().append('<div><span id="chatAvataElement"><img src="logo.png" style="height:40px;width:40px;border-radius:50%;  display: inline;" /></span></div><div class="chat-user-details"><span id="chatUserNames" class="chat-user-name">CyberChat</span><span id="chatUserStatus" class="chat-user-status">Live chatting</span></div>');
  getMessengerChatsContacts();
});

  ///contactLisItem
  $(document).on('click', '.contactLisItem', function (event) {
    var chatMateId = $(this).data('id'); 
    var avatar = $(this).data('avatar'); 
    var names = $(this).data('names'); 
    $('#chatUserNames').empty().append('<span id="messengerChatMate" data-id="'+chatMateId+'">'+names+'</span>');

    $('#chatClosingDiv').empty().append('<span id="closeChatBody" class="fontx fx-arrow-left" style="cursor:pointer;font-size:1.3em;"></span>');
    $('.chatTabsList').fadeOut('fast');
    $('.chat-contacts-div').fadeOut('fast');
    $('.chat-body').fadeIn('fast'); 
    $('.chat-footer').show(); 
    $('#chatDropdownMenu').empty().append('<li id="chatMateProfile">Profile Details</li><li>Export Chats</li><li>Meetings</li><li>Share data</li><li>Settings</li>');

    $('#chatAvataElement').empty().append(
      '<img src="' + avatar + '?t=' + new Date().getTime() + '" id="chatImageAvatar" ' +
      'style="height:35px;width:35px;border-radius:50%; display: inline-block; vertical-align: middle;" />'
  );
  
   
    $('.chat-bubble-container').empty().append('<span class="loader"></span>')
    var datastring = 'chatMateId=' + chatMateId + '&names=' + names;

    $.ajax({
        data: datastring,
        url: "xd-modules/messenger-module/backend/get_chats.php", 
        type: "POST"
    }).done(function (data) {
        try {
           
            var details = JSON.parse(data);
            $('.chat-bubble-container').empty();

            $.each(details.details, function (i, messages) { 
             
                if (messages.receiver_id !== undefined && parseInt(chatMateId) === parseInt(messages.receiver_id)) {
                    $('.chat-bubble-container').append('<div class="sent-message"><div class="message-text">'+messages.message_text+'</div><div class="message-status"><span class="message-status-sent">√√</span></div><div class="chatSenderTimeStamp">'+messages.created_at+'</div><div class="message-tail"></div></div>');
                    
                } else if (messages.sender_id !== undefined && parseInt(chatMateId) === parseInt(messages.sender_id)){
                   $('.chat-bubble-container').append('<div class="received-message"><div class="message-text">'+messages.message_text+'</div><div class="message-status"></div><div class="chatReceiverTimeStamp">'+messages.created_at+'</div> <div class="message-tail"></div></div>');
              
                }
              // Scroll chat to bottom after messages are loaded
              $('.chat-body').scrollTop($('.chat-body')[0].scrollHeight);
                

            });
        } catch (e) {
            console.error("Error parsing JSON:", e);
        }
    });

});





//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
// Function to send message
function sendMessage() {
  const chatMessage = document.getElementById("chatInput").value;
  const receiverId = $('#messengerChatMate').data('id');

  $('.chat-bubble-container').append('<div class="sent-message"><div class="message-text">' + chatMessage + '</div><div class="message-status"><span class="message-status-sent">√</span></div><div class="chatSenderTimeStamp"></div><div class="message-tail"></div></div>');

  fetch("xd-modules/messenger-module/backend/send_message.php", {
      method: "POST",
      body: new URLSearchParams({ receiver_id: receiverId, chatMessage: chatMessage }),
      headers: { "Content-Type": "application/x-www-form-urlencoded" }
  })
  .then(res => res.json())
  .then(data => {
      if (data.status === "Success") {
          document.getElementById("chatInput").value = '';
          var chatBody = $('.chat-body');  
          chatBody.scrollTop(chatBody[0].scrollHeight);
      } else {
          alert("Error: " + data.message);
      }
  });
}

// Event listener for the send message button
document.getElementById("messengerSendMessageButton").addEventListener("click", sendMessage);

// Event listener for the Enter key press
document.getElementById("chatInput").addEventListener("keydown", function(event) {
  if (event.key === "Enter") {
      event.preventDefault();  // Prevent the default action (new line in input field)
      sendMessage();  // Call sendMessage function
  }
});
// Event listener for the chat input field
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
 //////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
//////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER //////////////////////////// SEND MESSAGE TO USER ////////////////
 

  /////////// FUNCTIOON TO GET MESSAGES /////////////////////// FUNCTIOON TO GET MESSAGES /////////////////////// FUNCTIOON TO GET MESSAGES /////////////////////// FUNCTIOON TO GET MESSAGES ////////////
   
  var chatInterval;

  function getChatMateMessages() {
      if (!$('.chat-body').is(':visible')) {
          clearInterval(chatInterval);
          chatInterval = null;
          return;
      }
  
      var chatMateId = $('#messengerChatMate').data('id');
      var datastring = 'chatMateId=' + chatMateId;
      var chatBody = $('.chat-body'); // Chat container
      var previousScrollHeight = chatBody[0].scrollHeight; // Store current scroll height
      var currentScrollTop = chatBody.scrollTop(); // Get current scroll position
  
      // Check if the user is near the bottom
      var isNearBottom = currentScrollTop + chatBody.innerHeight() >= previousScrollHeight - 100;
  
      $.ajax({
          data: datastring,
          url: "xd-modules/messenger-module/backend/get_chats.php",
          type: "POST"
      }).done(function (data) {
          try {
              var details = JSON.parse(data);
              $('.chat-bubble-container').empty();

                    // Access gps_timestamp from the details object
            var gpsTimestamp = new Date(details.gps_timestamp); // Convert to Date object
            var currentTime = new Date(); // Current time
            var timeDifference = (currentTime - gpsTimestamp) / 1000; // Difference in seconds

            // Determine the user's status based on the time difference
            let userStatus;
            if (timeDifference <= 60) {
                userStatus = "Online"; // User is online within the last 60 seconds
            } else if (timeDifference <= 3600) {
                const minutes = Math.floor(timeDifference / 60); // Convert seconds to minutes
                userStatus = `Last seen ${minutes} minute${minutes > 1 ? "s" : ""} ago`; // Append "minute(s) ago"
            } else if (timeDifference <= 172800) { // 172800 seconds = 48 hours
                const hours = Math.floor(timeDifference / 3600); // Convert seconds to hours
                userStatus = `Last seen ${hours} hour${hours > 1 ? "s" : ""} ago`; // Append "hour(s) ago"
            } else {
                const days = Math.floor(timeDifference / 86400); // Convert seconds to days
                userStatus = `Last seen ${days} day${days > 1 ? "s" : ""} ago`; // Append "day(s) ago"
            }

            // Append the user status to the chat header
            $('#chatUserStatus').empty().append(userStatus);

              $.each(details.details, function (i, messages) {
                //message_receipt_status
                  if (messages.receiver_id !== undefined && parseInt(chatMateId) === parseInt(messages.receiver_id)) {

                   // alert(messages.message_receipt_status);
                    if(messages.message_receipt_status === 'sent'){

                      $('.chat-bubble-container').append('<div class="sent-message"><div class="message-text">' + messages.message_text + '</div><div class="message-status"><span class="message-status-delivered">√</span></div><div class="chatSenderTimeStamp">' + messages.created_at + '</div><div class="message-tail"></div></div>');
                   
                    }else if(messages.message_receipt_status === 'delivered'){

                      $('.chat-bubble-container').append('<div class="sent-message"><div class="message-text">' + messages.message_text + '</div><div class="message-status"><span class="message-status-delivered">√√</span></div><div class="chatSenderTimeStamp">' + messages.created_at + '</div><div class="message-tail"></div></div>');
                    
                    }else if(messages.message_receipt_status === 'seen'){

                      $('.chat-bubble-container').append('<div class="sent-message"><div class="message-text">' + messages.message_text + '</div><div class="message-status"><span class="message-status-delivered" style="color:white">√√</span></div><div class="chatSenderTimeStamp">' + messages.created_at + '</div><div class="message-tail"></div></div>');
                    
                    }

                 } else if (messages.sender_id !== undefined && parseInt(chatMateId) === parseInt(messages.sender_id)) {
                      $('.chat-bubble-container').append('<div class="received-message"><div class="message-text">' + messages.message_text + '</div><div class="message-status"></div><div class="chatReceiverTimeStamp">' + messages.created_at + '</div> <div class="message-tail"></div></div>');
                  }
              });
  
              // After new messages load, check again if user was near bottom
              var newScrollHeight = chatBody[0].scrollHeight;
              if (isNearBottom) {
                  chatBody.scrollTop(newScrollHeight); // Scroll to bottom if user was near it
              }
  
          } catch (e) {
              console.error("Error parsing JSON:", e);
          }
      });
  }
  
  // **Function to Start Interval Only When Chat is Visible**
  function startChatInterval() {
      if (chatInterval) return; // Avoid duplicate intervals
  
      chatInterval = setInterval(function () {
          getChatMateMessages();
      }, 5000);
  }
  
  // **Monitor Visibility Changes**
  setInterval(function () {
      if ($('.chat-body').is(':visible')) {
          startChatInterval();
      } else {
          clearInterval(chatInterval);
          chatInterval = null;
      }
  }, 1000); // Check visibility every second
  
 
/////////// END OF FUNCTIOON TO GET MESSAGES /////////////////////// END OF FUNCTIOON TO GET MESSAGES /////////////////////// END OF FUNCTIOON TO GET MESSAGES /////////////////////// END OF FUNCTIOON TO GET MESSAGES ////////////



////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
 ////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
 
// Show profile when clicking profile button
$(document).on('click', '#chatMateProfile', function() {
    const chatMateId = $('#messengerChatMate').data('id');
    showProfile(chatMateId);
});

function showProfile(chatMateId) {
  //  $('.chat-body').html('<div class="profile-loading">Loading profile...</div>');

    $.ajax({
        data: { chatMateId: chatMateId },
        url: "xd-modules/messenger-module/backend/chat_mate_profile.php",
        type: "POST",
        dataType: "json"
    })
    .done(function(response) {
        if (response.status === 'success') {
            const user = response.user;

            // Remove any existing modal first
            $('#chatMateProfileModal').remove();

            // Create modal outside chat window
            const modalHTML = `
                <div id="chatMateProfileModal" class="w3-modal" style="
                    display:flex;
                    justify-content:center;
                    align-items:center;
                    background: rgba(0,0,0,0.6);
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    z-index: 999999999999999999999999999999;
                ">
                    <div class="w3-modal-content" style="
                        background: white;
                        border-radius: 10px;
                        padding: 20px;
                        width: 320px;
                        position: relative;
                        animation: fadeIn 0.3s ease-in-out;
                    ">
                        <span id="closeProfileModal" style="
                            position: absolute;
                            top: 10px;
                            right: 15px;
                            font-size: 20px;
                            cursor: pointer;
                            color: #333;
                        ">&times;</span>

                        <div style="text-align:center;">
                            <img src="${user.avatar}" onerror="this.src='default-avatar.png'" style="width:80px;height:80px;border-radius:50%;object-fit:cover;">
                            <h3 style="margin:10px 0;">${user.names}</h3>
                            <p style="color:gray;">${user.role}</p>
                        </div>
                        <div style="margin-top:15px;text-align:left;">
                            <p><strong>Email:</strong> ${user.email}</p>
                            <p><strong>Phone:</strong> ${user.phone}</p>
                            <p><strong>Address:</strong> ${user.address}</p>
                        </div>
                        <button id="closeProfileModalBtn" style="
                            margin-top:20px;
                            width:100%;
                            background:var(--primary-color);
                            color:white;
                            border:none;
                            padding:10px;
                            border-radius:6px;
                            cursor:pointer;
                        ">Close</button>
                    </div>
                </div>
            `;

            // Append to body (outside chat)
            $('body').append(modalHTML);

            $('#chatMateProfileModal').fadeIn(200);
        }
    })
    .fail(function() {
        $('.chat-body').html('<div class="profile-error">Error loading profile</div>');
    });
}

// ✅ Proper modal close handling
$(document).on('click', '#closeProfileModal, #closeProfileModalBtn', function(e) {
    e.preventDefault();
    e.stopPropagation(); // prevents chat close event
    $('#chatMateProfileModal').fadeOut(200, function() {
        $(this).remove();
    });
});

// ✅ Prevent clicks inside modal from closing chat or propagating
$(document).on('click', '#chatMateProfileModal .w3-modal-content', function(e) {
    e.stopPropagation();
});

// ✅ Optional: clicking outside modal closes modal only
$(document).on('click', '#chatMateProfileModal', function(e) {
    if ($(e.target).is('#chatMateProfileModal')) {
        $('#chatMateProfileModal').fadeOut(200, function() {
            $(this).remove();
        });
    }
});

////////////end of chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
////////////end of chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
////////////end of chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
////////////end of chatMateProfile/////////////////////////////chatMateProfile/////////////////////////////chatMateProfile/////////////////
