<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Ensure user is logged in
if (!isset($_SESSION["userid"])) {
    echo json_encode(["status" => "Failed", "error" => "User not logged in"]);
    exit;
}

try {
    // Establish PDO connection
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["status" => "Failed", "error" => "Database connection error"]);
    exit;
}
 
    // Sending a new message
     $receiver_id = filter_input(INPUT_POST, "receiver_id", FILTER_SANITIZE_NUMBER_INT);
     $chatMessages = filter_input(INPUT_POST, "chatMessage", FILTER_UNSAFE_RAW); 
     $messageType = 'text';
 
     // Apply htmlspecialchars for security (prevent XSS)
     $chatMessages = htmlspecialchars($chatMessages, ENT_QUOTES, 'UTF-8');
 
    if (empty($receiver_id) || empty($chatMessages)) {
        echo json_encode(["status" => "Failed", "error" => "Invalid input"]);
        exit;
    }

    // Insert into messages table
    $conn->beginTransaction();
    try {
        $insertMessageQuery = "INSERT INTO messages (sender_id, receiver_id, message_text, message_type, org_name, org_id) 
                               VALUES (:userloggedid, :receiver_id, :chatMessage, :messageType, :orgname, :orgid)";

        $insertStmt = $conn->prepare($insertMessageQuery);
        $insertStmt->bindParam(':userloggedid', $_SESSION["userid"]);
        $insertStmt->bindParam(':receiver_id', $receiver_id);
        $insertStmt->bindParam(':chatMessage', $chatMessages);
        $insertStmt->bindParam(':messageType', $messageType);
        $insertStmt->bindParam(':orgname', $_SESSION["orgname"]);
        $insertStmt->bindParam(':orgid', $_SESSION["orgid"]);
        $insertStmt->execute();

        // Get the last inserted message ID
        $message_id = $conn->lastInsertId();

        // Insert into message_receipts table (status: "sent")
        $insertReceiptQuery = "INSERT INTO message_receipts (message_id, receiver_id, sender_id,status, updated_at,org_id) 
                               VALUES (:message_id, :receiver_id, :userloggedid, 'sent', NOW(), :orgid)";

        $insertReceiptStmt = $conn->prepare($insertReceiptQuery);
        $insertReceiptStmt->bindParam(':message_id', $message_id);
        $insertReceiptStmt->bindParam(':receiver_id', $receiver_id);
        $insertReceiptStmt->bindParam(':userloggedid', $_SESSION["userid"]);
        $insertReceiptStmt->bindParam(':orgid', $_SESSION["orgid"]);
        $insertReceiptStmt->execute();

        // Commit the transaction
        $conn->commit();

        echo json_encode(["status" => "Success", "message_id" => $message_id]);
    } catch (PDOException $e) {
        $conn->rollBack();
        echo json_encode(["status" => "Failed", "error" => $e->getMessage()]);
    }
  

exit;
?>
