<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];
    $orgid = $_SESSION["orgid"];

    //update user timestamp
    $insertnewuserQuery = "UPDATE `users` SET `gps_timestamp`= CURRENT_TIMESTAMP WHERE id=:userid";
    $insertnewUser = $conn->prepare($insertnewuserQuery);
    $insertnewUser->bindParam(':userid',$userloggedid);
    $insertnewUser->execute();

    // Query to update message_receipts table
    $updateMessageReceiptQuery = "
    UPDATE message_receipts
    SET status = 'delivered', updated_at = NOW()
    WHERE status = 'Sent' AND receiver_id = :userloggedid AND org_id = :orgid";

    // Prepare and execute the update query
    $updateMessageReceipt = $conn->prepare($updateMessageReceiptQuery);
    $updateMessageReceipt->bindParam(':userloggedid', $userloggedid, PDO::PARAM_INT);
    $updateMessageReceipt->bindParam(':orgid', $orgid, PDO::PARAM_INT);
    $updateMessageReceipt->execute();
 
    // Get the total count of unseen messages across all users
    $unseenMessagesQuery = "
    SELECT COUNT(*) AS total_unseen
    FROM message_receipts
    WHERE receiver_id = :userloggedid
      AND org_id = :orgid
      AND status != 'seen'";

    $unseenMessagesStmt = $conn->prepare($unseenMessagesQuery);
    $unseenMessagesStmt->bindParam(':userloggedid', $userloggedid, PDO::PARAM_INT);
    $unseenMessagesStmt->bindParam(':orgid', $orgid, PDO::PARAM_INT);
    $unseenMessagesStmt->execute();
    $unseenMessagesResult = $unseenMessagesStmt->fetch(PDO::FETCH_ASSOC);
    $totalUnseenMessages = $unseenMessagesResult['total_unseen'] ?? 0;

    // Return JSON response
    echo json_encode([
       // "details" => $contacts,
      //  "numofrows" => count($contacts),
        "total_unseen_messages" => $totalUnseenMessages
    ]);
    exit;

} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
