<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"]; 
    $orgid = $_SESSION["orgid"];
    $chateMateId = filter_input(INPUT_POST, "chatMateId");

    // Query to update message_receipts table
    $updateMessageReceiptQuery = "
    UPDATE message_receipts
    SET status = 'seen'
    WHERE receiver_id = :userloggedid AND org_id = :orgid";

    // Prepare and execute the update query
    $updateMessageReceipt = $conn->prepare($updateMessageReceiptQuery);
    $updateMessageReceipt->bindParam(':userloggedid', $userloggedid, PDO::PARAM_INT);
    $updateMessageReceipt->bindParam(':orgid', $orgid, PDO::PARAM_INT);
    $updateMessageReceipt->execute();

    // Query to fetch messages and include the status from message_receipts
     // Query construction to fetch messages and include the status from message_receipts
     $getMessagesQuery = "
     SELECT m.id, m.sender_id, m.receiver_id, m.message_text, m.message_type, m.created_at, m.org_name, m.org_id, mr.status AS message_receipt_status
     FROM messages m
     LEFT JOIN message_receipts mr ON mr.message_id = m.id AND mr.receiver_id = :chat_mate_id AND mr.sender_id = :userloggedid AND mr.org_id = :orgid
     WHERE m.org_id = :orgid 
     AND (m.sender_id = :userloggedid AND m.receiver_id = :chat_mate_id OR m.sender_id = :chat_mate_id AND m.receiver_id = :userloggedid)
     ORDER BY m.created_at ASC LIMIT 1000";
 
     $getMessages = $conn->prepare($getMessagesQuery); 
     $getMessages->bindParam(':chat_mate_id', $chateMateId);   
     $getMessages->bindParam(':orgid', $orgid); 
     $getMessages->bindParam(':userloggedid', $userloggedid); 
     $getMessages->execute();

    // Fetch results
    $jobdetails = $getMessages->fetchAll(PDO::FETCH_ASSOC);

    // Query to fetch gps_timestamp from the users table
    $getGpsTimestampQuery = "
    SELECT gps_timestamp
    FROM users
    WHERE id = :chat_mate_id";

    $getGpsTimestamp = $conn->prepare($getGpsTimestampQuery);
    $getGpsTimestamp->bindParam(':chat_mate_id', $chateMateId, PDO::PARAM_INT);
    $getGpsTimestamp->execute();

    // Fetch gps_timestamp
    $gpsTimestamp = $getGpsTimestamp->fetch(PDO::FETCH_ASSOC);

    // Return results in JSON format
    echo json_encode([
        "details" => $jobdetails,
        "gps_timestamp" => $gpsTimestamp['gps_timestamp'] ?? null,
        'numofrows' => count($jobdetails)
    ]);
    exit;

} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
