<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];
    $orgid = $_SESSION["orgid"];

    $searchKey=filter_input(INPUT_POST, "searchKey");

    $conditions = [];
    $parameters = [];

    if (!empty($searchKey)) {
    $conditions[] = "(u.names LIKE :search_key OR u.phone LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
    }
    $whereClause = !empty($conditions) ? "WHERE " . implode(" AND ", $conditions) . " AND u.id != :userloggedid" : "WHERE u.id != :userloggedid";

    // Update message_receipts table
    $updateMessageReceiptQuery = "
    UPDATE message_receipts
    SET status = 'delivered', updated_at = NOW()
    WHERE status = 'sent' AND receiver_id = :userloggedid AND org_id = :orgid";

    $updateMessageReceipt = $conn->prepare($updateMessageReceiptQuery);
    $updateMessageReceipt->bindParam(':userloggedid', $userloggedid, PDO::PARAM_INT);
    $updateMessageReceipt->bindParam(':orgid', $orgid, PDO::PARAM_INT);
    $updateMessageReceipt->execute();

    // Query to fetch users, last message, status, and unseen message count
 $getContactsQuery = "
    SELECT 
        u.id, u.email, u.names, u.phone, u.avatar, u.role, u.status, u.gps_timestamp,
        MAX(m.created_at) AS last_message_time,
        (
            SELECT COUNT(*) 
            FROM message_receipts mr 
            WHERE mr.receiver_id = :userloggedid 
              AND mr.sender_id = u.id 
              AND mr.org_id = :orgid 
              AND mr.status != 'seen'
        ) AS unseen_messages,
        (
            SELECT m.message_text
            FROM messages m
            WHERE ((m.sender_id = u.id AND m.receiver_id = :userloggedid) 
                OR (m.sender_id = :userloggedid AND m.receiver_id = u.id))
              AND m.org_id = :orgid
            ORDER BY m.created_at DESC
            LIMIT 1
        ) AS last_message,
        (
            SELECT mr.status
            FROM message_receipts mr
            WHERE mr.message_id = (
                SELECT m.id
                FROM messages m
                WHERE ((m.sender_id = u.id AND m.receiver_id = :userloggedid) 
                    OR (m.sender_id = :userloggedid AND m.receiver_id = u.id))
                  AND m.org_id = :orgid
                ORDER BY m.created_at DESC
                LIMIT 1
            )
            LIMIT 1
        ) AS last_message_status
    FROM users u
    LEFT JOIN messages m 
        ON (u.id = m.sender_id OR u.id = m.receiver_id) 
        AND (m.sender_id = :userloggedid OR m.receiver_id = :userloggedid)
    INNER JOIN (
        SELECT user_id FROM clients WHERE org_id = :orgid
        UNION
        SELECT user_id FROM workforce WHERE org_id = :orgid
    ) cw ON cw.user_id = u.id
    $whereClause
    GROUP BY u.id
    ORDER BY last_message_time DESC, u.names ASC
";


    $getContacts = $conn->prepare($getContactsQuery);
    foreach ($parameters as $key => $value) {
        $getContacts->bindValue($key, $value);
    }
    $getContacts->bindParam(':userloggedid', $userloggedid, PDO::PARAM_INT);
    $getContacts->bindParam(':orgid', $orgid, PDO::PARAM_INT);
    $getContacts->execute();

    // Fetch results
    $contacts = $getContacts->fetchAll(PDO::FETCH_ASSOC);

    // Get total unseen messages for the user
    $unseenMessagesQuery = "
    SELECT COUNT(*) AS total_unseen
    FROM message_receipts
    WHERE receiver_id = :userloggedid
      AND org_id = :orgid
      AND status != 'seen'";

    $unseenMessagesStmt = $conn->prepare($unseenMessagesQuery);
    $unseenMessagesStmt->bindParam(':userloggedid', $userloggedid, PDO::PARAM_INT);
    $unseenMessagesStmt->bindParam(':orgid', $orgid, PDO::PARAM_INT);
    $unseenMessagesStmt->execute();
    $unseenMessagesResult = $unseenMessagesStmt->fetch(PDO::FETCH_ASSOC);
    $totalUnseenMessages = $unseenMessagesResult['total_unseen'] ?? 0;

    // Return JSON response
    echo json_encode([
        "details" => $contacts,
        "numofrows" => count($contacts),
        "total_unseen_messages" => $totalUnseenMessages
    ]);
    exit;

} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
