function  warehouseStockHeader(){
  let today = new Date().toISOString().slice(0, 10);
  $('#page-options').empty(); 
  $('#page-options').append('<select class="warehouseProductSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="productList">All Stock</option><option value="sto">All Stock By Type</option><option value="stockBywarehouse">Stock By Warehouse</option></select> <span id="record01" class="topNavTotals"></span>');
 $('#right_nav_options0').empty();
  $('#right_nav_options0').append('<a href="#" id="bankAccountDepositIconDiv" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file depositSlipIcon1"></span></a>');

  $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
  $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102  w3-hide-small top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
 $('#right_nav_options0').append('<div id="exportTransactioins" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-share-2"></span></div>');
 $('#right_nav_options0').append('<div  class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
   $('#right_nav_options0').append('<div  class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-upload"></span></div>');
  $('#right_nav_options0').append('<div  class="w3-hide-small top-right-navigation-icons101 initialStockBalance101"><span class="fontx fx-plus"></span></div>');
  
  $('#sub_top_nav').empty(); 
 
$('#sub_top_nav').empty();

$('#sub_top_nav').append(`
  <div id="searchContainer0" class="w3-col l12 m12 s12 w3-center">

    <!-- Search Icon -->
    <div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top:5px;">
      <span class="fontx fx-search" style="color:gray;font-size:1.5em;"></span>
    </div>

    <!-- Search Input -->
    <div class="w3-col l3 m3 s7 w3-center">
      <input id="searchProductWarehouse101" 
             type="text" 
             placeholder="Type to search..." 
             style="font-weight:400;outline:none;color:black;border:none;width:100%;height:30px;background-color:transparent;padding-left:7px;" />
    </div>

    <!-- Warehouse Filter -->
    <div class="w3-col l1 m1 s2 w3-center" style="padding-top:5px;">
      <span style="float:right;">
        <span class="fontx fx-home" style="color:var(--primary-color);margin-top:5px;"></span>
        <select id="warehouse_filter" class="reduceSizeOnSmallScreen"  
                style="background-color:transparent;border:none;outline:none;color:gray;">
          <option value="">Warehouses</option>
        </select>
      </span>
    </div>

    <!-- Stock Status Filter -->
    <div class="w3-col l1 m1 s2 w3-center" style="padding-top:5px;">
      <span style="float:right;">
        <span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span>
        <select id="stock_status_filter" class="reduceSizeOnSmallScreen"  
                style="background-color:transparent;border:none;outline:none;color:gray;">
          <option value="">All Status</option>
          <option value="normal">Normal</option>
          <option value="low">Low Stock</option>
          <option value="out">Out of Stock</option>
          <option value="overstock">Overstock</option>
        </select>
      </span>
    </div>

    <!-- Category Filter -->
    <div class="w3-col l1 m1 s2 w3-center" style="padding-top:5px;">
      <span style="float:right;">
        <span class="fontx fx-tag" style="color:var(--primary-color);margin-top:5px;"></span>
        <select id="category_filter" class="reduceSizeOnSmallScreen"  
                style="background-color:transparent;border:none;outline:none;color:gray;">
          <option value="">Categories</option>
        </select>
      </span>
    </div>

    <!-- Date Filters -->
    <div class="w3-col l5 m5 s12 w3-center" style="padding-left:7px;padding-top:3px;color:gray;">
      <span style="float:right; display:flex; gap:5px; justify-content:flex-end; align-items:center;">
        <input type="date" value="${today}" id="revenueReportStartDate" 
               class="reduceSizeOnSmallScreen" 
               style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;" />
        <input type="date" value="${today}" id="revenueReportEndDate" 
               class="reduceSizeOnSmallScreen" 
               style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;" />
      </span>
    </div>

  </div>
`);

  // $('.createButton').addClass('addWarehouseProduct101');
  $('.createButton').empty().append('<a href="#" class="fontx fx-plus initialStockBalance101"> Add/Create</a>');
 }
// Load warehouses on click
$(document).on('click', '.stockLevels101', async function() {
    warehouseStockHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
 loadStockLevels();
});

 // Trigger search on keyup/change
$(document).on('keyup change', '#searchProductWarehouse101', function () { 
    const searchKey = $("#searchProductWarehouse101").val().trim();
    const selectKey = $(".warehouseProductSelectKey101").val();

    if (selectKey === "productList") {
        warehouseProducts(searchKey); // searchKey can be empty
    }
});
 // Enhanced Professional Stock Levels Module
function loadStockLevels() {
    const container = $("#main-body");
    container.html('<div style="text-align:center;padding:50px;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:var(--primary-color);"></i><p>Loading stock levels...</p></div>');

    // Get filter values
    const warehouse = $('#warehouse_filter').val() || '';
    const category = $('#category_filter').val() || '';
    const stockStatus = $('#stock_status_filter').val() || '';
    const search = $('#search_filter').val() || '';

    $.ajax({
        url: "xd-modules/inventory/stock-management/backend/stock_levels.php",
        type: "GET",
        data: {
            warehouse_id: warehouse,
            category: category,
            stock_status: stockStatus,
            search: search
        },
        dataType: "json",
        success: function (data) {
            container.empty();

            if (data.success && data.data.length > 0) {
                // Summary Cards
                renderSummaryCards(container, data.summary);
 

                // Data Table
                renderStockTable(container, data.data);

                // Initialize Select2 and other plugins
                initializeComponents();

            } else {
                container.html(`
                    <div style="text-align:center;padding:50px;">
                        <span class="fontx fx-inbox" style="font-size:4em;color:#ccc;"></span>
                        <h3 style="color:gray;">No Stock Records Found</h3>
                        <p style="color:gray;">Try adjusting your filters or add initial stock balance.</p>
                        <button class="initialStockBalance101" style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">
                            Set Initial Stock
                        </button>
                    </div>
                `);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error loading stock levels:", error);
            container.html(`
                <div style="text-align:center;padding:50px;color:red;">
                    <span class="fontx fx-alert-triangle" style="font-size:3em;"></span>
                    <h3>Error Loading Stock Levels</h3>
                    <p>${error}</p>
                    <button onclick="loadStockLevels()" style="background-color:#f44336;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
                        Retry
                    </button>
                </div>
            `);
        }
    });
}

// Render Summary Cards
function renderSummaryCards(container, summary) {
    container.append(`
        <div class="w3-row" style="margin-bottom:10px;margin-top:10px;">
            <!-- Total Products -->
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, gray 0%, white 100%););color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Products</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.total_products || 0}</h2>
                        </div>
                        <span class="fontx fx-box w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
 <!-- Out of Stock -->
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Out of Stock</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.out_of_stock_count || 0}</h2>
                        </div>
                        <span class="fontx fx-x-circle w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>

         

            <!-- Low Stock Items -->
            <div class="w3-col l2 m3 s4" style="padding:5px;">
                <div style="background:linear-gradient(135deg, gray 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                         <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Low Stock</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.low_stock_count || 0}</h2>
                        </div>
                        <span class="fontx fx-alert-triangle w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
   <!-- Total Stock Value -->
            <div class="w3-col l4 m6 s8" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Stock Value</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">K${parseFloat(summary?.total_value || 0).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</h2>
                        </div>
                        <span class="fontx fx-dollar-sign" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
           
        </div>
    `);
}

 
// Render Stock Table
function renderStockTable(container, data) {
    container.append(`
        <div style="background:transparent;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <!-- Table Header -->
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" style="font-weight:600;background:#f5f5f5;padding:15px 10px;">
                <div class="w3-col l2 m2 s12">Stock Name</div>
                <div class="w3-col l2 m2 s12" style="text-align:center;">Warehouse</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">On Hand</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Allocated</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Available</div>
                <div class="w3-col l1 m1 s12">Unit Cost</div>
                <div class="w3-col l1 m1 s12">Stock Value</div>
                <div class="w3-col l2 m2 s12" style="text-align:center;">Reorder Level</div>
                <div class="w3-col l1 m1 s12" style="display:none;;">Last Updated</div>
                <div class="w3-col l1 m1 s12 hideOnPrint" style="text-align:center;">Actions</div>
            </div>

            <!-- Table Body -->
            <div id="stock_table_body"></div>
        </div>
    `);

    // Populate rows
    const tbody = $('#stock_table_body');
    data.forEach((stock, index) => {
        const stockStatus = getStockStatus(stock);
        const statusBadge = getStatusBadge(stockStatus);
       // const rowClass = index % 2 === 0 ? 'background:transparent;' : 'background:transparent';

        tbody.append(`
            <div class="inner-data-div w3-col l12 m12 s12 stock-row" 
                 data-id="${stock.balance_id}">
                
                 <div class="w3-col l1 m1 s2">
                <img src="${stock.image}" class="w3-hide-small" style="color:gray;border-radius:5px;height:30px;width:30px;"/>
                 <img src="${stock.image}" class="w3-hide-large w3-hide-medium"  style="color:gray;border-radius:5px;height:60px;width:100%;"/>
                </div>

             
                <div class="w3-col l11 m11 s10" style="padding-left:5px;"> 
             
                <div class="w3-col l2 m2 s12" style="padding-left:5px;float:left;">
                 <div style="font-weight:600;color:var(--primary-color);"> <span class="w3-hide-small" style="color:gray;">${stock.product_code}</span> ${stock.name}</div>
                 </div>
                     <!-- Warehouse -->
                <div class="w3-col l2 m2 s4 w3-hide-small">
                    <span style="background:#e3f2fd;padding-left:3px;padding-right:3px;border-radius:3px;font-size:0.85em;float:left;">
                        ${stock.warehouse_name || 'N/A'}
                    </span>
                </div>

                <!-- Quantities -->
                <div class="w3-col l1 m1 s9 w3-hide-small" style="font-weight:600;float:left;">
                    ${parseFloat(stock.quantity_on_hand).toFixed(2)}
                </div>
                <div class="w3-col l1 m1 s12 w3-hide-small" style="float:left;">
                    ${parseFloat(stock.quantity_allocated).toFixed(2)}
                </div>
                <div class="w3-col l1 m1 s9" style="float:left;font-weight:600;color:${stockStatus === 'out' ? 'red' : stockStatus === 'low' ? 'orange' : 'green'};">
                  <span class="w3-hide-large w3-hide-medium" style="color:gray;">Avail.: </span>  ${parseFloat(stock.quantity_available).toFixed(2)}
                </div>

                <!-- Costs -->
                <div class="w3-col l1 m1 s6 w3-hide-small">
                    K${parseFloat(stock.average_cost || 0).toFixed(2)}
                </div>
                <div class="w3-col l1 m1 s7 w3-hide-small" style="float:left;font-weight:600;color:var(--primary-color);float:left;">
                  K${parseFloat(stock.total_value || 0).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}
                </div>

                <!-- Status Badge -->
                <div class="w3-col l2 m2 s12 w3-hide-small" style="text-align:center;">
                 ${statusBadge}  ${stock.reorder_level}   
                </div>

                <!-- Last Updated -->
                <div class="w3-col l1 m1 s12 s12 w3-hide-small" style="display:none;text-align:center;font-size:0.85em;color:gray;">
                    ${stock.last_movement_date ? formatDate(stock.last_movement_date) : '-'}
                </div>

                <!-- Actions -->
                
                <div class="w3-col l1 m1 s3">
                <select class="innerDivProductSelectKey inner-data-more-actions2 hideOnPrint" 
                data-id="${stock.product_id}" data-stockbalance-id="${stock.balance_id}">
                <option value="select-actions">⚙️ Actions</option>
                <option value="view-details">📊 Product Details</option>
                <option value="adjust">🧮 Adjust Stock</option>
                <option value="transfer">🔄 Transfer</option>
                <option value="movement-history">📋 Movement History</option>
                <option value="reorder">🛒 Reorder</option>
                <option value="delete">🗑️ Delete</option>
                <option value="activate">✅ Activate</option>
                <option value="suspend">🚫 Suspend</option>
                </select>
                </div>
                    
                </div>

            

               
            </div>
        `);
    });

    // Pagination (if needed)
    if (data.length > 50) {
        container.append(`
            <div style="text-align:center;padding:20px;">
                <button style="background:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
                    Load More
                </button>
            </div>
        `);
    }
}

// Helper: Get stock status
function getStockStatus(stock) {
    const available = parseFloat(stock.quantity_available);
    const reorder = parseFloat(stock.reorder_level || 0);
    
    if (available <= 0) return 'out';
    if (available <= reorder) return 'low';
    if (reorder > 0 && available > (reorder * 3)) return 'overstock';
    return 'normal';
}

// Helper: Get status badge HTML
function getStatusBadge(status) {
    const badges = {
        'out': '<span style="background:#f44336;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">OUT</span>',
        'low': '<span style="background:#ff9800;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">LOW</span>',
        'normal': '<span style="background:#4caf50;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">OK</span>',
        'overstock': '<span style="background:#2196f3;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">HIGH</span>'
    };
    return badges[status] || badges.normal;
}

// Helper: Format date
function formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    const now = new Date();
    const diffDays = Math.floor((now - date) / (1000 * 60 * 60 * 24));
    
    if (diffDays === 0) return 'Today';
    if (diffDays === 1) return 'Yesterday';
    if (diffDays < 7) return `${diffDays}d ago`;
    return date.toLocaleDateString('en-GB', {day: '2-digit', month: 'short'});
}

// Load warehouses for filter
function loadWarehousesFilter() {
    $.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
        if (data.success && data.details) {
            $.each(data.details, function(i, warehouse) {
                $('#warehouse_filter').append(`<option value="${warehouse.id}">${warehouse.warehouse_name}</option>`);
            });
        }
    });
}

// Load categories for filter
function loadCategoriesFilter() {
    // Get unique categories from products
    $.getJSON('xd-modules/inventory/backend/get_categories.php', function(data) {
        if (data.success && data.categories) {
            $.each(data.categories, function(i, category) {
                $('#category_filter').append(`<option value="${category}">${category}</option>`);
            });
        }
    });
}

// Initialize components
function initializeComponents() {
    // Initialize Select2 if available
    if (typeof $.fn.select2 === 'function') {
        $('.select2-filter').select2({
            minimumResultsForSearch: 5,
            width: '100%'
        });
    }
}
 

// Handle action dropdown
$(document).on('change', '.innerDivProductSelectKey', function() {
    const action = $(this).val();
    const balanceId = $(this).data('stockbalance-id');
    const productId = $(this).data('id');
    
    if (!action) return;
    
    switch(action) {
        case 'view-stock-details':
            viewStockDetails(productId, balanceId);
            break;
        case 'adjust':
            adjustStock(productId, balanceId);
            break;
        case 'transfer':
            transferStock(productId, balanceId);
            break;
        case 'movement-history':
            viewMovementHistory(productId);
            break;
        case 'reorder':
            createReorderFromStock(productId);
            break;
    }
    
    // Reset dropdown
    $(this).val('');
});

// Action handlers (implement these)
function viewStockDetails(productId, balanceId) {
    alert('View details for product: ' + productId);
    // TODO: Show modal with detailed stock info
}

function adjustStock(productId, balanceId) {
    alert('Adjust stock for product: ' + productId);
    // TODO: Open stock adjustment form
}

function transferStock(productId, balanceId) {
    alert('Transfer stock for product: ' + productId);
    // TODO: Open stock transfer form
}

function viewMovementHistory(productId) {
    alert('Movement history for product: ' + productId);
    // TODO: Show movement history
}

function createReorderFromStock(productId) {
    alert('Create reorder for product: ' + productId);
    // TODO: Create purchase requisition/PO
}
 
 

// Trigger to open initial stock balance entry modal
$(document).on('click', '#initialStockBalance101, .initialStockBalance101', function(event) {
    event.preventDefault();
    event.stopPropagation(); 
    createInitialStockBalance();
});

function createInitialStockBalance() {
    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
     
    // Modal header
    $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span><span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">SET INITIAL STOCK BALANCE</span></div>');
    
    $('#invoice_modal').append('<form method="post" id="stock_balance_form" style="margin-top:40px;"><div class="main-body-full-div w3-col l12 m12 s12" style="padding:20px;"></div></form>');
    
    // Form content
    $('.main-body-full-div').empty().append(`
        <div id="stock_balance_entry_form">
            
            <!-- Instructions -->
            <div style="background-color:#e3f2fd;padding:15px;border-radius:8px;margin-bottom:20px;border-left:4px solid var(--primary-color);">
                <h4 style="margin:0 0 10px 0;color:var(--primary-color);">
                    <span class="fontx fx-info"></span> Instructions
                </h4>
                <p style="margin:5px 0;font-size:0.95em;">
                    • This form sets the <strong>starting quantities</strong> for your products in each warehouse,supplier.
                     Use this ONCE to initialize your inventory with current stock on hand and
                     after setup, use Goods Receipt (GRN) to add new stock from suppliers.
                    You can add multiple products at once - click "Add Another Product" button
                </p>
            </div>

            <!-- Warehouse Supplier Selection -->
            <div style="margin-bottom:20px;padding:15px;background-color:#f5f5f5;border-radius:8px;">
                <label style="display:block;font-weight:bold;margin-bottom:10px;color:#333;">
                    <span class="fontx fx-home"></span> Select Warehouse & Supplier
                </label>

                 <div class="w3-col l12 m12 s12">
                 <div class="w3-col l6 m6 s12">
                  <select id="warehouse_select" name="warehouse_id" class="select2Styles" style="width:50%;" required>
                    <option value="">-- Select Warehouse --</option>
                </select>
                 </div>
                  <div class="w3-col l6 m6 s12">
                  <select id="supplier_select" name="suplier_id" class="select2Styles" style="width:50%;" required>
                    <option value="">-- Select Supplier --</option>
                </select>
                 </div>
               
                
                 </div>

              

                <small style="color:gray;display:block;margin-top:5px;">Choose the warehouse where this stock is physically located mandatory. You can choose different supplier for different warehouses and products. Supplier selection is optional</small>
            </div>

            <!-- Products Entry Section -->
            <div id="products_section" style="margin-bottom:20px;">
                <h4 style="color:var(--primary-color);margin-bottom:15px;">
                    <span class="fontx fx-box"></span> Products & Quantities
                </h4>
                
                <div id="products_container">
                    <!-- Product rows will be added here -->
                </div>
                
                <button type="button" id="add_product_row" style="background-color:#4caf50;color:white;border:none;padding:10px 20px;border-radius:5px;cursor:pointer;margin-top:10px;">
                    <span class="fontx fx-plus"></span> Add Another Product
                </button>
            </div>

            <!-- Notes -->
            <div style="margin-bottom:20px;">
                <label style="display:block;font-weight:bold;margin-bottom:10px;color:#333;">
                    Notes (Optional)
                </label>
                <textarea id="notes" name="notes" rows="3" style="width:100%;padding:10px;border:1px solid #ddd;border-radius:5px;" placeholder="e.g., Physical count conducted on 2024-10-15"></textarea>
            </div>

            <!-- Summary Section -->
            <div id="summary_section" style="background-color:#fff3cd;padding:15px;border-radius:8px;margin-bottom:20px;display:none;">
                <h4 style="margin:0 0 10px 0;color:#856404;">Summary</h4>
                <p style="margin:5px 0;">Total Products: <strong id="total_products">0</strong></p>
                <p style="margin:5px 0;">Total Quantity: <strong id="total_quantity">0</strong></p>
                <p style="margin:5px 0;">Estimated Value: <strong>K<span id="total_value">0.00</span></strong></p>
            </div>

            <!-- Action Buttons -->
            <div style="text-align:right;padding-top:20px;border-top:2px solid #eee;">
                <button type="button" class="close_invoice_modal" style="background-color:#9e9e9e;color:white;border:none;padding:12px 30px;border-radius:5px;cursor:pointer;margin-right:10px;">
                    Cancel
                </button>
                <button type="button" id="save_initial_stock_btn" style="background-color:var(--primary-color);color:white;border:none;padding:12px 30px;border-radius:5px;cursor:pointer;">
                    <span class="fontx fx-save"></span> Save Stock Balance
                </button>
            </div>
        </div>
    `);

    // Load warehouses
    $.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
        if(data.success && data.details) {
            $.each(data.details, function(i, warehouse) {
                $('#warehouse_select').append(`<option value="${warehouse.id}">${warehouse.warehouse_name} (${warehouse.warehouse_code})</option>`);
            });
        }
    });
      // Load warehouses
    $.getJSON('xd-modules/inventory/procurement/backend/allSuppliers.php', function(data) {
        if(data.success && data.details) {
            $.each(data.details, function(i, supplier) {
                $('#supplier_select').append(`<option value="${supplier.id}">${supplier.warehouse_name} (${supplier.phone})</option>`);
            });
        }
    });

    // Initialize Select2
    $('.select2Styles').select2({
        allowClear: true,
        width: '100%',
        dropdownParent: $('#invoice_modal')
    });

    // Add first product row automatically
    setTimeout(function() {
        addProductRow();
    }, 500);

    // Show modal
    $('#invoice_modal').fadeIn('slow').css('display', 'block');
}

// Counter for unique row IDs
let productRowCounter = 0;

// Add product row
function addProductRow() {
    productRowCounter++;
    const rowId = 'product_row_' + productRowCounter;
    
    const rowHtml = `
        <div class="product-row" id="${rowId}" style="background-color:#f9f9f9;padding:15px;border-radius:8px;margin-bottom:15px;border:1px solid #ddd;position:relative;">
            
            <!-- Remove button -->
            <button type="button" class="remove_product_row" data-row-id="${rowId}" style="position:absolute;top:10px;right:10px;background-color:#f44336;color:white;border:none;width:30px;height:30px;border-radius:50%;cursor:pointer;font-weight:bold;">×</button>
            
            <div class="w3-row">
                <!-- Product Selection -->
                <div class="w3-col l4 m6 s12" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Product *</label>
                    <select class="product_select select2Styles" name="products[${productRowCounter}][product_id]" data-row="${productRowCounter}" style="width:100%;" required>
                        <option value="">-- Select Product --</option>
                    </select>
                </div>
                 <!-- Lead time -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Lead Time</label>
                    <input type="number" class="lead_time_input" name="lead_time" min="0" step="0.01" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;" required>
                </div>
                <!-- Quantity -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Quantity *</label>
                    <input type="number" class="quantity_input" name="products[${productRowCounter}][quantity]" data-row="${productRowCounter}" min="0" step="0.01" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;" required>
                </div>
                
                <!-- Unit Cost -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Unit Cost (K)</label>
                    <input type="number" class="unit_cost_input" name="products[${productRowCounter}][unit_cost]" data-row="${productRowCounter}" min="0" step="0.01" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
               
            
                
                <!-- Total Value (Auto-calculated) -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Total Value</label>
                    <input type="text" class="total_value_display" readonly style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="K 0.00">
                </div>
            </div>
            
            
            <div class="w3-row" style="margin-top:10px;">

             <!-- Stock  Allocated -->
                <div class="w3-col l3 m12 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Stock  Allocated</label>
                    <input type="text" class="stock_allocated_input" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="00">
                </div>
                 <!-- Available Stock  -->
                <div class="w3-col l2 m12 s6" style="padding:5px;display:none;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Available Stock</label>
                    <input type="text" class="avalible_stock_input" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="00">
                </div>
               <!-- Reorder Level -->
                <div class="w3-col l3 m12 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Reorder Level</label>
                    <input type="text" class="stock_reorder_level_input" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="00">
                </div>
              <div class="w3-col l2 m12 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Reorder Point</label>
                    <input type="text" class="stock_reorder_point_input" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="00">
                </div>
                 <!-- Max Stock Level -->
                <div class="w3-col l3 m12 s12" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Max Stock</label>
                    <input type="text" class="stock_max_stock_level_input" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="00">
                </div>
               
                
              
                
            </div>
 
            <div class="w3-row" style="margin-top:10px;">
              
                 <div class="w3-col l3 m12 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Batch/Lot Number (Optional)</label>
                    <input type="text" name="products[${productRowCounter}][batch_number]" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
                <div class="w3-col l2 m12 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Expiry Date (Optional)</label>
                    <input type="date" name="products[${productRowCounter}][expiry_date]" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
               <!-- Notes -->
            
                <div class="w3-col l7 m12 s12" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Notes</label>
                    <input type="text" name="products[${productRowCounter}][notes]" placeholder="e.g., From physical count" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
            </div>
        </div>
    `;
    
    $('#products_container').append(rowHtml);
    
    // Load products for this select
    loadProductsForSelect(productRowCounter);
    
    // Re-initialize Select2 for new dropdowns
    $('.select2Styles').select2({
        allowClear: true,
        width: '100%',
        dropdownParent: $('#invoice_modal')
    });
    
    // Calculate total when quantity or unit cost changes
    updateRowCalculations();
}

// Load products for select dropdown
function loadProductsForSelect(rowNum) {
    $.getJSON('xd-modules/inventory/stock-management/backend/get_products.php', function(data) {
        if(data.success && data.details) {
            const selectElement = $(`.product_select[data-row="${rowNum}"]`);
            $.each(data.details, function(i, product) {
                selectElement.append(`
                    <option value="${product.id}" 
                            data-price="${product.price}" 
                            data-code="${product.product_code}">
                        ${product.name} (${product.product_code})
                    </option>
                `);
            });
        }
    });
}

// Remove product row
$(document).on('click', '.remove_product_row', function() {
    const rowId = $(this).data('row-id');
    if ($('.product-row').length > 1) {
        $('#' + rowId).fadeOut(300, function() {
            $(this).remove();
            updateSummary();
        });
    } else {
        alert('You must have at least one product!');
    }
});

// Add another product row
$(document).on('click', '#add_product_row', function() {
    addProductRow();
});

// Auto-fill unit cost when product is selected
$(document).on('change', '.product_select', function() {
    const selectedOption = $(this).find('option:selected');
    const price = selectedOption.data('price');
    const rowNum = $(this).data('row');
    
    if (price) {
        $(`.unit_cost_input[data-row="${rowNum}"]`).val(price);
    }
    
    updateRowCalculations();
});

// Update calculations when quantity or unit cost changes
function updateRowCalculations() {
    $(document).on('input', '.quantity_input, .unit_cost_input', function() {
        const rowNum = $(this).data('row');
        const quantity = parseFloat($(`.quantity_input[data-row="${rowNum}"]`).val()) || 0;
        const unitCost = parseFloat($(`.unit_cost_input[data-row="${rowNum}"]`).val()) || 0;
        const total = quantity * unitCost;
        
        $(`.total_value_display[data-row="${rowNum}"]`).val('K ' + total.toFixed(2));
        
        updateSummary();
    });
}

// Update summary section
function updateSummary() {
    let totalProducts = $('.product-row').length;
    let totalQuantity = 0;
    let totalValue = 0;
    
    $('.quantity_input').each(function() {
        totalQuantity += parseFloat($(this).val()) || 0;
    });
    
    $('.product-row').each(function() {
        const rowNum = $(this).find('.quantity_input').data('row');
        const quantity = parseFloat($(`.quantity_input[data-row="${rowNum}"]`).val()) || 0;
        const unitCost = parseFloat($(`.unit_cost_input[data-row="${rowNum}"]`).val()) || 0;
        totalValue += quantity * unitCost;
    });
    
    $('#total_products').text(totalProducts);
    $('#total_quantity').text(totalQuantity.toFixed(2));
    $('#total_value').text(totalValue.toFixed(2));
    
    if (totalProducts > 0) {
        $('#summary_section').slideDown();
    }
}

// Save initial stock balance
$(document).on('click', '#save_initial_stock_btn', function(event) {
    event.preventDefault();
    
    // Validate warehouse selection
    if (!$('#warehouse_select').val()) {
        alert('Please select a warehouse!');
        return;
    }
    
    // Validate at least one product
    if ($('.product-row').length === 0) {
        alert('Please add at least one product!');
        return;
    }
    
    // Validate all required fields
    let isValid = true;
    $('.product_select').each(function() {
        if (!$(this).val()) {
            alert('Please select a product for all rows!');
            isValid = false;
            return false;
        }
    });
    
    if (!isValid) return;
    
    $('.quantity_input').each(function() {
        if (!$(this).val() || parseFloat($(this).val()) <= 0) {
            alert('Please enter valid quantities for all products!');
            isValid = false;
            return false;
        }
    });
    
    if (!isValid) return;
    
    // Collect data
    const warehouseId = $('#warehouse_select').val();
    const supplierId = $('#supplier_select').val();
    const notes = $('#notes').val();
    const products = [];
    
    $('.product-row').each(function() {
        const rowNum = $(this).find('.product_select').data('row');
        const productId = $(`.product_select[data-row="${rowNum}"]`).val();
        const quantity = parseFloat($(`.quantity_input[data-row="${rowNum}"]`).val());
        const unitCost = parseFloat($(`.unit_cost_input[data-row="${rowNum}"]`).val()) || 0;
        const batchNumber = $(`input[name="products[${rowNum}][batch_number]"]`).val();
        const expiryDate = $(`input[name="products[${rowNum}][expiry_date]"]`).val();
        const itemNotes = $(`input[name="products[${rowNum}][notes]"]`).val();
        const avalible_stock  = parseFloat($(`.avalible_stock_input`).val()) || 0;
        const stock_allocated = parseFloat($(`.stock_allocated_input`).val()) || 0;
        const maxStockLevel  = parseFloat($(`.stock_max_stock_level_input`).val()) || 0;
        const  reorderLevel  = parseFloat($(`.stock_reorder_level_input`).val()) || 0;
        const  reorderPoint  = parseFloat($(`.stock_reorder_point_input`).val()) || 0;
        products.push({
            product_id: productId,
            quantity: quantity,
            unit_cost: unitCost,
            batch_number: batchNumber,
            expiry_date: expiryDate,
            notes: itemNotes,
            max_stock_level: maxStockLevel,
            reorder_level: reorderLevel,
            reorder_point: reorderPoint,
            stock_allocated: stock_allocated,
            avalible_stock: avalible_stock,
        });
    });
    
    const stockData = {
        warehouse_id: warehouseId,
        supplier_id: supplierId,
        movement_type: "opening_balance",
        notes: notes,
        products: products,
        org_id: sessionStorage.getItem('org_id') || '',
        user_id: sessionStorage.getItem('user_id') || ''
    };
    
    // Show loading
    $('#save_initial_stock_btn').html('<i class="fa fa-spinner fa-spin"></i> Saving...').prop('disabled', true);
    
    // Submit to backend
    $.ajax({
        url: 'xd-modules/inventory/stock-management/backend/create_initial_stock.php',
        type: 'POST',
        data: JSON.stringify(stockData),
        contentType: 'application/json',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
               // alert('Initial stock balance saved successfully!\n\n' +
                 //     'Products processed: ' + response.products_processed + '\n' +
                  //    'Total movements created: ' + response.movements_created);
               // $('.close_invoice_modal').click();
                
                // Optionally refresh stock list
                
                  $('#save_initial_stock_btn').html('<i class="fontx fx-thumbs-up"></i> Created. Create Another!').prop('disabled', true);
             loadStockLevels();
              setTimeout(function () { 
               $('#save_initial_stock_btn').html('<span class="fontx fx-save"></span> Save Stock Balance').prop('disabled', false);
            
            }, 3000);


            } else {
                alert('Error: ' + (response.message || 'Failed to save stock balance'));
                $('#save_initial_stock_btn').html('<span class="fontx fx-save"></span> Save Stock Balance').prop('disabled', false);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error:', xhr.responseText);
            alert('Error saving stock balance: ' + error);
            $('#save_initial_stock_btn').html('<span class="fontx fx-save"></span> Save Stock Balance').prop('disabled', false);
        }
    });
});

// Close modal
$(document).on('click', '.close_invoice_modal', function() {
    $('#invoice_modal').fadeOut('slow', function() {
        $(this).remove();
    });
});