// Handle stock movements menu click
$(document).on('click', '.stockMovements101', function() {
  stockMovementsHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
 loadStockMovements();
});

// Stock Movements Header
 function stockMovementsHeader() {
    let today = new Date().toISOString().slice(0, 10);
    
    $('#page-options').empty(); 
    $('#page-options').append(`
        <select class="movementsFilterSelect" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;">
            <option value="all">All Movements</option>
            <option value="inbound">Inbound Only</option>
            <option value="outbound">Outbound Only</option>
            <option value="transfer">Transfers Only</option>
            <option value="adjustment">Adjustments Only</option>
        </select>
        <span id="movementsCount" class="topNavTotals"></span>
    `);
    
    $('#right_nav_options0').empty();
    $('#right_nav_options0').append(`
        <div class="top-right-navigation-icons101 w3-hide-small">
            <input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/>
        </div>
        <div class="w3-hide-small mainPrintBtn102 top-right-navigation-icons101">
            <span class="fontx fx-printer"></span>
        </div>
        <div id="exportMovements" class="w3-hide-small top-right-navigation-icons101">
            <span class="fontx fx-share-2"></span>
        </div>
        <div class="downloadData w3-hide-small top-right-navigation-icons101">
            <span class="fontx fx-download"></span>
        </div>
        <div class="createMovementBtn w3-hide-small top-right-navigation-icons101">
            <span class="fontx fx-plus"></span>
        </div>
    `);
    
    $('#sub_top_nav').empty();
    $('#sub_top_nav').append(`
        <!-- Search Container - FIRST and separate -->
        <div id="searchContainerMovements" class="w3-col l12 m12 s12 w3-center" style="margin-bottom:15px;">
            <!-- Search -->
            <div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top:5px;">
                <span class="fontx fx-search" style="color:gray;font-size:1.5em;"></span>
            </div>
            <div class="w3-col l3 m3 s7 w3-center">
                <input id="searchMovements" type="text" placeholder="Search movements..." 
                       style="font-weight:400;outline:none;color:black;border:none;width:100%;height:30px;background-color:transparent;padding-left:7px;" />
            </div>
            
            <!-- Warehouse Filter -->
            <div class="w3-col l3 m3 s2 w3-center" style="padding-top:5px;">
                <span style="float:right;">
                    <span class="fontx fx-home" style="color:var(--primary-color);margin-top:5px;"></span>
                    <select id="warehouse_movement_filter" class="reduceSizeOnSmallScreen"  
                            style="background-color:transparent;border:none;outline:none;color:gray;">
                        <option value="">All Warehouses</option>
                    </select>
                </span>
            </div>
            
            <!-- Date Range -->
            <div class="w3-col l5 m5 s12 w3-center" style="padding-left:7px;padding-top:3px;color:gray;">
                <span style="float:right; display:flex; gap:5px; justify-content:flex-end; align-items:center;">
                    <input type="date" value="2025-10-01" id="movementStartDate" 
                           class="reduceSizeOnSmallScreen" 
                           style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;" />
                    <input type="date" value="2025-10-31" id="movementEndDate" 
                           class="reduceSizeOnSmallScreen" 
                           style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;" />
                </span>
            </div>
        </div>

        <!-- Cyber Horizontal Scroll - SECOND with filter buttons -->
        <div class="cyber-horizontal-scroll hideOnPrint">
            <button class="movementFilterBtn active" data-filter="all">
                All Movements
            </button>
            <button class="movementFilterBtn" data-filter="inbound">
                Inbound
            </button>
            <button class="movementFilterBtn" data-filter="outbound">
                Outbound
            </button>
            <button class="movementFilterBtn" data-filter="transfer">
                Transfers
            </button>
            <button class="movementFilterBtn" data-filter="adjustment">
                Adjustments
            </button>
            <button class="movementFilterBtn" data-filter="pending">
                Pending
            </button>
            <button class="movementFilterBtn" data-filter="completed">
                Completed
            </button>
        </div>
    `);
    
    // Load warehouses filter
    loadWarehousesMovementFilter();
    
    // Add click handlers for filter buttons

}

// Load Stock Movements
function loadStockMovements() {
    const container = $("#main-body");
    container.html('<div style="text-align:center;padding:50px;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:var(--primary-color);"></i><p>Loading stock movements...</p></div>');

    // Get filter values
    const movementType = $('#movement_type_filter').val() || '';
    const warehouse = $('#warehouse_movement_filter').val() || '';
    const status = $('#status_movement_filter').val() || '';
    const startDate = $('#movementStartDate').val() || '';
    const endDate = $('#movementEndDate').val() || '';
    const search = $('#searchMovements').val() || '';

    $.ajax({
        url: "xd-modules/inventory/stock-management/backend/stock_movements.php",
        type: "GET",
        data: {
            movement_type: movementType,
            warehouse_id: warehouse,
            status: status,
            start_date: startDate,
            end_date: endDate,
            search: search
        },
        dataType: "json",
        success: function (data) {
            container.empty();

            if (data.success && data.data.length > 0) {
                // Summary Cards
                renderMovementSummaryCards(container, data.summary);
                
                // Movements Table
                renderMovementsTable(container, data.data);
                
                // Update count
                $('#movementsCount').text(`(${data.data.length} records)`);

            } else {
                container.html(`
                    <div style="text-align:center;padding:50px;">
                        <span class="fontx fx-inbox" style="font-size:4em;color:#ccc;"></span>
                        <h3 style="color:gray;">No Stock Movements Found</h3>
                        <p style="color:gray;">Try adjusting your filters or create a new movement.</p>
                        <button class="createMovementBtn" style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">
                            Create Movement
                        </button>
                    </div>
                `);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error loading stock movements:", error);
            container.html(`
                <div style="text-align:center;padding:50px;color:red;">
                    <span class="fontx fx-alert-triangle" style="font-size:3em;"></span>
                    <h3>Error Loading Stock Movements</h3>
                    <p>${error}</p>
                    <button onclick="loadStockMovements()" style="background-color:#f44336;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
                        Retry
                    </button>
                </div>
            `);
        }
    });
}

// Render Movement Summary Cards
function renderMovementSummaryCards(container, summary) {
    container.append(`
        <div class="w3-row" style="margin-bottom:10px;margin-top:10px;">
            <!-- Total Movements -->
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #667eea 0%, #764ba2 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Movements</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.total_movements || 0}</h2>
                        </div>
                        <span class="fontx fx-repeat w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Inbound Movements -->
            <div class="w3-col l2 m3 s4" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Inbound</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.inbound_count || 0}</h2>
                        </div>
                        <span class="fontx fx-arrow-down-left w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Outbound Movements -->
            <div class="w3-col l2 m3 s4" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #fa709a 0%, #fee140 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Outbound</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.outbound_count || 0}</h2>
                        </div>
                        <span class="fontx fx-arrow-up-right w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Pending Movements -->
            <div class="w3-col l2 m3 s4" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Pending</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.pending_count || 0}</h2>
                        </div>
                        <span class="fontx fx-clock w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Total Value -->
            <div class="w3-col l3 m6 s8" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);color:#333;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Value</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">K${parseFloat(summary?.total_value || 0).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</h2>
                        </div>
                        <span class="fontx fx-dollar-sign" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
        </div>
    `);
}

// Render Movements Table
function renderMovementsTable(container, data) {
    container.append(`
        <div style="background:transparent;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <!-- Table Header -->
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" style="font-weight:600;background:#f5f5f5;padding:15px 10px;">
                <div class="w3-col l1 m1 s12">Movement Code</div>
                <div class="w3-col l1 m1 s12">Type</div>
                <div class="w3-col l2 m2 s12">Product</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Quantity</div>
                <div class="w3-col l1 m1 s12">From Location</div>
                <div class="w3-col l1 m1 s12">To Location</div>
                <div class="w3-col l1 m1 s12">Reference</div>
                <div class="w3-col l1 m1 s12">Date</div>
                <div class="w3-col l1 m1 s12">Status</div>
                <div class="w3-col l2 m2 s12" style="text-align:center;">Actions</div>
            </div>

            <!-- Table Body -->
            <div id="movements_table_body"></div>
        </div>
    `);

    // Populate rows
    const tbody = $('#movements_table_body');
    data.forEach((movement, index) => {
        const statusBadge = getMovementStatusBadge(movement.status);
        const typeBadge = getMovementTypeBadge(movement.movement_type);
        
        tbody.append(`
            <div class="inner-data-div w3-col l12 m12 s12 movement-row" data-id="${movement.id}">
                
                <!-- Movement Code -->
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:var(--primary-color);">
                    ${movement.movement_code}
                </div>
                
                <!-- Movement Type -->
                <div class="w3-col l1 m1 s12">
                    ${typeBadge}
                </div>
                
                <!-- Product -->
                <div class="w3-col l2 m2 s12">
                    <div style="font-weight:600;">${movement.product_name}</div>
                    <small style="color:gray;">${movement.product_code}</small>
                </div>
                
                <!-- Quantity -->
                <div class="w3-col l1 m1 s12" style="text-align:center;font-weight:600;">
                    ${parseFloat(movement.quantity).toFixed(2)}
                </div>
                
                <!-- From Location -->
                <div class="w3-col l1 m1 s12">
                    ${movement.from_warehouse_name || '-'}
                    ${movement.from_zone_id ? `<br><small>Zone: ${movement.from_zone_name}</small>` : ''}
                </div>
                
                <!-- To Location -->
                <div class="w3-col l1 m1 s12">
                    ${movement.to_warehouse_name || '-'}
                    ${movement.to_zone_id ? `<br><small>Zone: ${movement.to_zone_name}</small>` : ''}
                </div>
                
                <!-- Reference -->
                <div class="w3-col l1 m1 s12">
                    ${movement.reference_type && movement.reference_id ? 
                        `${movement.reference_type}: ${movement.reference_id}` : 
                        '-'}
                </div>
                
                <!-- Date -->
                <div class="w3-col l1 m1 s12">
                    ${formatDate(movement.movement_date)}
                </div>
                
                <!-- Status -->
                <div class="w3-col l1 m1 s12">
                    ${statusBadge}
                </div>
                
                <!-- Actions -->
                <div class="w3-col l2 m2 s12" style="text-align:center;">
                    <select class="movementActionsSelect" data-id="${movement.id}">
                        <option value="">Actions</option>
                        <option value="view">View Details</option>
                        ${movement.status === 'pending' ? '<option value="approve">Approve</option>' : ''}
                        ${movement.status === 'approved' ? '<option value="complete">Complete</option>' : ''}
                        ${movement.status === 'pending' ? '<option value="cancel">Cancel</option>' : ''}
                        <option value="print">Print</option>
                    </select>
                </div>
                
            </div>
        `);
    });
}

// Helper: Get movement status badge
function getMovementStatusBadge(status) {
    const badges = {
        'pending': '<span style="background:#ff9800;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">PENDING</span>',
        'approved': '<span style="background:#2196f3;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">APPROVED</span>',
        'completed': '<span style="background:#4caf50;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">COMPLETED</span>',
        'cancelled': '<span style="background:#f44336;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">CANCELLED</span>'
    };
    return badges[status] || badges.pending;
}

// Helper: Get movement type badge
function getMovementTypeBadge(type) {
    const badges = {
        'inbound': '<span style="background:#4caf50;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">INBOUND</span>',
        'outbound': '<span style="background:#f44336;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">OUTBOUND</span>',
        'transfer': '<span style="background:#2196f3;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">TRANSFER</span>',
        'adjustment': '<span style="background:#ff9800;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">ADJUSTMENT</span>',
        'return': '<span style="background:#9c27b0;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">RETURN</span>',
        'damage': '<span style="background:#795548;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">DAMAGE</span>'
    };
    return badges[type] || '<span style="background:gray;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">UNKNOWN</span>';
}

// Load warehouses for movement filter
function loadWarehousesMovementFilter() {
    $.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
        if (data.success && data.details) {
            $.each(data.details, function(i, warehouse) {
                $('#warehouse_movement_filter').append(`<option value="${warehouse.id}">${warehouse.warehouse_name}</option>`);
            });
        }
    });
}

// Handle movement actions
$(document).on('change', '.movementActionsSelect', function() {
    const action = $(this).val();
    const movementId = $(this).data('id');
    
    if (!action) return;
    
    switch(action) {
        case 'view':
            viewMovementDetails(movementId);
            break;
        case 'approve':
            approveMovement(movementId);
            break;
        case 'complete':
            completeMovement(movementId);
            break;
        case 'cancel':
            cancelMovement(movementId);
            break;
        case 'print':
            printMovement(movementId);
            break;
    }
    
    // Reset dropdown
    $(this).val('');
});

// Action handlers for movements
function viewMovementDetails(movementId) {
    alert('View movement details: ' + movementId);
    // TODO: Show modal with movement details
}

function approveMovement(movementId) {
    if (confirm('Are you sure you want to approve this movement?')) {
        updateMovementStatus(movementId, 'approved');
    }
}

function completeMovement(movementId) {
    if (confirm('Are you sure you want to mark this movement as completed?')) {
        updateMovementStatus(movementId, 'completed');
    }
}

function cancelMovement(movementId) {
    if (confirm('Are you sure you want to cancel this movement?')) {
        updateMovementStatus(movementId, 'cancelled');
    }
}

function printMovement(movementId) {
    alert('Print movement: ' + movementId);
    // TODO: Generate printable movement document
}

// Update movement status
function updateMovementStatus(movementId, status) {
    $.ajax({
        url: 'xd-modules/inventory/stock-management/backend/update_movement_status.php',
        type: 'POST',
        data: {
            movement_id: movementId,
            status: status,
            user_id: sessionStorage.getItem('user_id')
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert(`Movement ${status} successfully!`);
                loadStockMovements(); // Refresh the list
            } else {
                alert('Error: ' + (response.message || 'Failed to update movement'));
            }
        },
        error: function(xhr, status, error) {
            console.error('Error updating movement:', error);
            alert('Error updating movement: ' + error);
        }
    });
}

// Create new movement (triggered by create button)
$(document).on('click', '.createMovementBtn', function() {
    createStockMovement();
});

function createStockMovement() {
    // TODO: Implement create movement modal similar to initial stock balance
    alert('Create new stock movement functionality to be implemented');
    // This would open a modal to create inbound/outbound/transfer movements
}