// Handle stock adjustments menu click
$(document).on('click', '.stockAdjustments101', function() {
    stockAdjustmentsHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
    loadStockAdjustments();
});

// Stock Adjustments Header
function stockAdjustmentsHeader() {
    $('#page-options').empty(); 
    $('#page-options').append(`
        <select class="adjustmentsFilterSelect" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;">
            <option value="all">All Adjustments</option>
            <option value="pending_approval">Pending Approval</option>
            <option value="approved">Approved</option>
            <option value="completed">Completed</option>
        </select>
        <span id="adjustmentsCount" class="topNavTotals"></span>
    `);
    
    $('#right_nav_options0').empty();
    $('#right_nav_options0').append(`
        <div class="top-right-navigation-icons101 w3-hide-small">
            <input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/>
        </div>
        <div class="w3-hide-small mainPrintBtn102 top-right-navigation-icons101">
            <span class="fontx fx-printer"></span>
        </div>
        <div id="exportAdjustments" class="w3-hide-small top-right-navigation-icons101">
            <span class="fontx fx-share-2"></span>
        </div>
        <div class="downloadData w3-hide-small top-right-navigation-icons101">
            <span class="fontx fx-download"></span>
        </div>
        <div class="createAdjustmentBtn w3-hide-small top-right-navigation-icons101">
            <span class="fontx fx-plus"></span>
        </div>
    `);
    
    $('#sub_top_nav').empty();
    $('#sub_top_nav').append(`
        <!-- Search Container -->
        <div id="searchContainerAdjustments" class="w3-col l12 m12 s12 w3-center" style="margin-bottom:15px;">
            <!-- Search -->
            
            <div class="w3-col l2 m2 s7 w3-center"> 
                <input id="searchAdjustments" type="text" placeholder="Search adjustments..." 
                       style="font-weight:400;outline:none;color:black;border:none;width:100%;height:30px;background-color:transparent;padding-left:7px;" />
            </div>
            
            <!-- Adjustment Type Filter -->
            <div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;">
                <span style="float:right;">
                    <span class="fontx fx-filter" style="color:var(--primary-color);margin-top:5px;"></span>
                    <select id="adjustment_type_filter" class="reduceSizeOnSmallScreen"  
                            style="background-color:transparent;border:none;outline:none;color:gray;">
                        <option value="">All Types</option>
                        <option value="physical_count">Physical Count</option>
                        <option value="damage">Damage</option>
                        <option value="theft">Theft</option>
                        <option value="expiry">Expiry</option>
                        <option value="quality">Quality</option>
                        <option value="correction">Correction</option>
                        <option value="write_off">Write Off</option>
                        <option value="found">Found</option>
                    </select>
                </span>
            </div>
            
            <!-- Warehouse Filter -->
            <div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;">
                <span style="float:right;">
                    <span class="fontx fx-home" style="color:var(--primary-color);margin-top:5px;"></span>
                    <select id="warehouse_adjustment_filter" class="reduceSizeOnSmallScreen"  
                            style="background-color:transparent;border:none;outline:none;color:gray;">
                        <option value="">All Warehouses</option>
                    </select>
                </span>
            </div>
            
            <!-- Status Filter -->
            <div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;">
                <span style="float:right;">
                    <span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span>
                    <select id="status_adjustment_filter" class="reduceSizeOnSmallScreen"  
                            style="background-color:transparent;border:none;outline:none;color:gray;">
                        <option value="">All Status</option>
                        <option value="draft">Draft</option>
                        <option value="pending_approval">Pending</option>
                        <option value="approved">Approved</option>
                        <option value="rejected">Rejected</option>
                        <option value="completed">Completed</option>
                    </select>
                </span>
            </div>
            
            <!-- Date Range -->
            <div class="w3-col l4 m4 s12 w3-center" style="padding-left:7px;padding-top:3px;color:gray;">
                <span style="float:right; display:flex; gap:5px; justify-content:flex-end; align-items:center;">
                    <input type="date" value="2025-10-01" id="adjustmentStartDate" 
                           class="reduceSizeOnSmallScreen" 
                           style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;" />
                    <input type="date" value="2025-10-31" id="adjustmentEndDate" 
                           class="reduceSizeOnSmallScreen" 
                           style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;" />
                </span>
            </div>
        </div>

        <!-- Cyber Horizontal Scroll -->
        <div class="cyber-horizontal-scroll hideOnPrint">
            <button class="adjustmentFilterBtn active" data-filter="all">
                All Adjustments
            </button>
            <button class="adjustmentFilterBtn" data-filter="pending_approval">
                Pending Approval
            </button>
            <button class="adjustmentFilterBtn" data-filter="approved">
                Approved
            </button>
            <button class="adjustmentFilterBtn" data-filter="completed">
                Completed
            </button>
            <button class="adjustmentFilterBtn" data-filter="draft">
                Draft
            </button>
        </div>
    `);
    
    // Load warehouses filter
    loadWarehousesAdjustmentFilter();
    
    // Add click handlers for filter buttons
    $('.cyber-horizontal-scroll').on('click', 'button', function() {
        $('.cyber-horizontal-scroll button').removeClass('active');
        $(this).addClass('active');
        
        const filter = $(this).data('filter');
        applyAdjustmentFilter(filter);
    });
    
    // Add event handlers for search and filters
    $('#searchAdjustments').on('input', function() {
        setTimeout(() => {
            loadStockAdjustments();
        }, 500);
    });
    
    $('#adjustment_type_filter, #warehouse_adjustment_filter, #status_adjustment_filter, #adjustmentStartDate, #adjustmentEndDate').on('change', function() {
        loadStockAdjustments();
    });
}

// Load warehouses for adjustment filter
function loadWarehousesAdjustmentFilter() {
    $.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
        if (data.success && data.details) {
            const selectElement = $('#warehouse_adjustment_filter');
            $.each(data.details, function(i, warehouse) {
                selectElement.append(`<option value="${warehouse.id}">${warehouse.warehouse_name}</option>`);
            });
        }
    });
}

// Apply adjustment filter
function applyAdjustmentFilter(filter) {
    let status = '';
    
    switch(filter) {
        case 'all':
            status = '';
            break;
        case 'pending_approval':
            status = 'pending_approval';
            break;
        case 'approved':
            status = 'approved';
            break;
        case 'completed':
            status = 'completed';
            break;
        case 'draft':
            status = 'draft';
            break;
    }
    
    $('#status_adjustment_filter').val(status);
    loadStockAdjustments();
}

// Load stock adjustments
function loadStockAdjustments() {
    const container = $("#main-body");
    container.html('<div style="text-align:center;padding:50px;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:var(--primary-color);"></i><p>Loading stock adjustments...</p></div>');

    // Get filter values
    const adjustmentType = $('#adjustment_type_filter').val() || '';
    const warehouse = $('#warehouse_adjustment_filter').val() || '';
    const status = $('#status_adjustment_filter').val() || '';
    const startDate = $('#adjustmentStartDate').val() || '';
    const endDate = $('#adjustmentEndDate').val() || '';
    const search = $('#searchAdjustments').val() || '';

    $.ajax({
        url: "xd-modules/inventory/stock-management/backend/stock_adjustments.php",
        type: "GET",
        data: {
            adjustment_type: adjustmentType,
            warehouse_id: warehouse,
            status: status,
            start_date: startDate,
            end_date: endDate,
            search: search
        },
        dataType: "json",
        success: function (data) {
            container.empty();

            if (data.success && data.data.length > 0) {
                // Summary Cards
                renderAdjustmentSummaryCards(container, data.summary);
                
                // Adjustments Table
                renderAdjustmentsTable(container, data.data);
                
                // Update count
                $('#adjustmentsCount').text(`(${data.data.length} records)`);

            } else {
                container.html(`
                    <div style="text-align:center;padding:50px;">
                        <span class="fontx fx-inbox" style="font-size:4em;color:#ccc;"></span>
                        <h3 style="color:gray;">No Stock Adjustments Found</h3>
                        <p style="color:gray;">Try adjusting your filters or create a new adjustment.</p>
                        <button class="createAdjustmentBtn" style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">
                            Create Adjustment
                        </button>
                    </div>
                `);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error loading stock adjustments:", error);
            container.html(`
                <div style="text-align:center;padding:50px;color:red;">
                    <span class="fontx fx-alert-triangle" style="font-size:3em;"></span>
                    <h3>Error Loading Stock Adjustments</h3>
                    <p>${error}</p>
                    <button onclick="loadStockAdjustments()" style="background-color:#f44336;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
                        Retry
                    </button>
                </div>
            `);
        }
    });
}


// Handle create adjustment button click
$(document).on('click', '.createAdjustmentBtn', function() {
    createStockAdjustment();
});

function createStockAdjustment() {
    $('#external_page_contents').empty().append('<div id="adjustment_modal" class="w3-modal w3-center" style="padding:0px;background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
     
    // Modal header
    $('#adjustment_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" style="height:40px;color:gray;"><span class="close_adjustment_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span><span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">CREATE STOCK ADJUSTMENT</span></div>');
    
    $('#adjustment_modal').append('<form method="post" id="adjustment_form" style="margin-top:40px;"><div class="main-body-full-div w3-col l12 m12 s12" style="padding:20px;"></div></form>');
    
    // Form content
    $('.main-body-full-div').empty().append(`
        <div id="adjustment_entry_form">
            
            <!-- Instructions -->
            <div style="background-color:#e3f2fd;padding:15px;border-radius:8px;margin-bottom:20px;border-left:4px solid var(--primary-color);">
                <h4 style="margin:0 0 10px 0;color:var(--primary-color);">
                    <span class="fontx fx-info"></span> Create Stock Adjustment
                </h4>
                <p style="margin:5px 0;font-size:0.95em;">
                    • Adjustments correct inventory discrepancies between system and physical counts<br>
                    • Requires approval before affecting stock levels<br>
                    • All adjustments are logged for audit purposes
                </p>
            </div>

            <!-- Basic Information -->
            <div style="margin-bottom:20px;padding:15px;background-color:#f5f5f5;border-radius:8px;">
                <label style="display:block;font-weight:bold;margin-bottom:10px;color:#333;">
                    <span class="fontx fx-edit"></span> Adjustment Details *
                </label>
                
                <div class="w3-row">
                    <div class="w3-col l4 m6 s12" style="padding:5px;">
                        <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Adjustment Type *</label>
                        <select id="adjustment_type" name="adjustment_type" class="select2Styles" style="width:100%;" required>
                            <option value="">-- Select Type --</option>
                            <option value="physical_count">Physical Count</option>
                            <option value="damage">Damage</option>
                            <option value="theft">Theft</option>
                            <option value="expiry">Expiry</option>
                            <option value="quality">Quality Issue</option>
                            <option value="correction">Data Correction</option>
                            <option value="write_off">Write Off</option>
                            <option value="found">Found Stock</option>
                        </select>
                    </div>
                    
                    <div class="w3-col l4 m6 s12" style="padding:5px;">
                        <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Warehouse *</label>
                        <select id="adjustment_warehouse_id" name="warehouse_id" class="select2Styles" style="width:100%;" required>
                            <option value="">-- Select Warehouse --</option>
                        </select>
                    </div>
                    
                    <div class="w3-col l4 m6 s12" style="padding:5px;">
                        <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Adjustment Date *</label>
                        <input type="date" id="adjustment_date" name="adjustment_date" value="${new Date().toISOString().slice(0,10)}" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;" required>
                    </div>
                </div>
                
                <div class="w3-row" style="margin-top:10px;">
                    <div class="w3-col l12 m12 s12" style="padding:5px;">
                        <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Reason *</label>
                        <textarea id="adjustment_reason" name="reason" rows="3" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;" placeholder="Explain why this adjustment is needed..." required></textarea>
                    </div>
                </div>
            </div>

            <!-- Products Section -->
            <div style="margin-bottom:20px;padding:15px;background-color:#f5f5f5;border-radius:8px;">
                <h4 style="color:var(--primary-color);margin-bottom:15px;">
                    <span class="fontx fx-box"></span> Products to Adjust
                </h4>
                
                <div id="adjustment_products_container">
                    <!-- Product rows will be added here -->
                </div>
                
                <button type="button" id="add_adjustment_product" style="background-color:#4caf50;color:white;border:none;padding:10px 20px;border-radius:5px;cursor:pointer;margin-top:10px;">
                    <span class="fontx fx-plus"></span> Add Product
                </button>
            </div>

            <!-- Summary Section -->
            <div id="adjustment_summary" style="background-color:#fff3cd;padding:15px;border-radius:8px;margin-bottom:20px;display:none;">
                <h4 style="margin:0 0 10px 0;color:#856404;">Adjustment Summary</h4>
                <p style="margin:5px 0;">Total Products: <strong id="adjustment_total_products">0</strong></p>
                <p style="margin:5px 0;">Total Value Impact: <strong>K<span id="adjustment_total_value">0.00</span></strong></p>
                <p style="margin:5px 0;">Status: <strong id="adjustment_status">Draft</strong></p>
            </div>

            <!-- Action Buttons -->
            <div style="text-align:right;padding-top:20px;border-top:2px solid #eee;">
                <button type="button" class="close_adjustment_modal" style="background-color:#9e9e9e;color:white;border:none;padding:12px 30px;border-radius:5px;cursor:pointer;margin-right:10px;">
                    Cancel
                </button>
                <button type="button" id="save_adjustment_draft" style="background-color:#ff9800;color:white;border:none;padding:12px 30px;border-radius:5px;cursor:pointer;margin-right:10px;">
                    <span class="fontx fx-save"></span> Save as Draft
                </button>
                <button type="button" id="submit_adjustment_approval" style="background-color:var(--primary-color);color:white;border:none;padding:12px 30px;border-radius:5px;cursor:pointer;">
                    <span class="fontx fx-send"></span> Submit for Approval
                </button>
            </div>
        </div>
    `);

    // Load warehouses
    loadWarehousesForAdjustment();
    
    // Load products
    loadProductsForAdjustment();

    // Initialize Select2
    $('.select2Styles').select2({
        allowClear: true,
        width: '100%',
        dropdownParent: $('#adjustment_modal')
    });

    // Add first product row
    setTimeout(function() {
        addAdjustmentProductRow();
    }, 500);

    // Show modal
    $('#adjustment_modal').fadeIn('slow').css('display', 'block');
}

// Load warehouses for adjustment
function loadWarehousesForAdjustment() {
    $.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
        if(data.success && data.details) {
            const selectElement = $('#adjustment_warehouse_id');
            $.each(data.details, function(i, warehouse) {
                selectElement.append(`<option value="${warehouse.id}">${warehouse.warehouse_name} (${warehouse.warehouse_code})</option>`);
            });
        }
    });
}

// Counter for adjustment product rows
let adjustmentProductRowCounter = 0;

// Add adjustment product row
function addAdjustmentProductRow() {
    adjustmentProductRowCounter++;
    const rowId = 'adjustment_product_row_' + adjustmentProductRowCounter;
    
    const rowHtml = `
        <div class="adjustment-product-row" id="${rowId}" style="background-color:#f9f9f9;padding:15px;border-radius:8px;margin-bottom:15px;border:1px solid #ddd;position:relative;">
            
            <!-- Remove button -->
            <button type="button" class="remove_adjustment_product_row" data-row-id="${rowId}" style="position:absolute;top:10px;right:10px;background-color:#f44336;color:white;border:none;width:30px;height:30px;border-radius:50%;cursor:pointer;font-weight:bold;">×</button>
            
            <div class="w3-row">
                <!-- Product Selection -->
                <div class="w3-col l3 m6 s12" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Product *</label>
                    <select class="adjustment_product_select select2Styles" name="products[${adjustmentProductRowCounter}][product_id]" data-row="${adjustmentProductRowCounter}" style="width:100%;" required>
                        <option value="">-- Select Product --</option>
                    </select>
                </div>
                
                <!-- Current Stock -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Current Stock</label>
                    <input type="text" class="current_stock_display" data-row="${adjustmentProductRowCounter}" readonly style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="Loading...">
                </div>
                
                <!-- System Quantity -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">System Qty</label>
                    <input type="number" class="system_quantity_input" name="products[${adjustmentProductRowCounter}][system_quantity]" data-row="${adjustmentProductRowCounter}" step="0.001" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;" readonly>
                </div>
                
                <!-- Physical Quantity -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Physical Qty *</label>
                    <input type="number" class="physical_quantity_input" name="products[${adjustmentProductRowCounter}][physical_quantity]" data-row="${adjustmentProductRowCounter}" min="0" step="0.001" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;" required>
                </div>
                
                <!-- Adjustment Quantity -->
                <div class="w3-col l2 m3 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Adjustment</label>
                    <input type="text" class="adjustment_quantity_display" data-row="${adjustmentProductRowCounter}" readonly style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="0.000">
                </div>
            </div>
            
            <div class="w3-row" style="margin-top:10px;">
                <!-- Unit Cost -->
                <div class="w3-col l3 m4 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Unit Cost (K)</label>
                    <input type="number" class="unit_cost_input" name="products[${adjustmentProductRowCounter}][unit_cost]" data-row="${adjustmentProductRowCounter}" min="0" step="0.01" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
                
                <!-- Value Impact -->
                <div class="w3-col l3 m4 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Value Impact</label>
                    <input type="text" class="value_impact_display" readonly style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;background-color:#f0f0f0;font-weight:bold;" value="K 0.00">
                </div>
                
                <!-- Batch Number -->
                <div class="w3-col l3 m4 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Batch Number</label>
                    <input type="text" class="batch_number_input" name="products[${adjustmentProductRowCounter}][batch_number]" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
                
                <!-- Notes -->
                <div class="w3-col l3 m4 s6" style="padding:5px;">
                    <label style="display:block;font-weight:bold;margin-bottom:5px;font-size:0.9em;">Notes</label>
                    <input type="text" name="products[${adjustmentProductRowCounter}][notes]" placeholder="Reason for this item" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:5px;">
                </div>
            </div>
        </div>
    `;
    
    $('#adjustment_products_container').append(rowHtml);
    
    // Load products for this select
    loadProductsForAdjustmentSelect(adjustmentProductRowCounter);
    
    // Re-initialize Select2 for new dropdowns
    $('.select2Styles').select2({
        allowClear: true,
        width: '100%',
        dropdownParent: $('#adjustment_modal')
    });
    
    // Setup event handlers for this row
    setupAdjustmentRowEvents(adjustmentProductRowCounter);
}

// Load products for adjustment select
function loadProductsForAdjustment() {
    $.getJSON('xd-modules/inventory/stock-management/backend/get_products.php', function(data) {
        if(data.success && data.details) {
            window.adjustmentProducts = data.details;
        }
    });
}

function loadProductsForAdjustmentSelect(rowNum) {
    if (window.adjustmentProducts) {
        const selectElement = $(`.adjustment_product_select[data-row="${rowNum}"]`);
        $.each(window.adjustmentProducts, function(i, product) {
            selectElement.append(`
                <option value="${product.id}" data-price="${product.price}" data-code="${product.product_code}">
                    ${product.name} (${product.product_code})
                </option>
            `);
        });
    }
}

// Setup event handlers for adjustment row
function setupAdjustmentRowEvents(rowNum) {
    const warehouseId = $('#adjustment_warehouse_id').val();
    
    // When product is selected, load current stock
    $(`.adjustment_product_select[data-row="${rowNum}"]`).on('change', function() {
        const productId = $(this).val();
        if (productId && warehouseId) {
            loadCurrentStockForAdjustment(productId, warehouseId, rowNum);
        }
    });
    
    // When physical quantity changes, calculate adjustment
    $(`.physical_quantity_input[data-row="${rowNum}"]`).on('input', function() {
        calculateAdjustmentForRow(rowNum);
        updateAdjustmentSummary();
    });
    
    // When unit cost changes, calculate value impact
    $(`.unit_cost_input[data-row="${rowNum}"]`).on('input', function() {
        calculateValueImpactForRow(rowNum);
        updateAdjustmentSummary();
    });
}

// Load current stock for adjustment
function loadCurrentStockForAdjustment(productId, warehouseId, rowNum) {
    $.ajax({
        url: 'xd-modules/inventory/stock-management/backend/get_current_stock.php',
        type: 'GET',
        data: {
            product_id: productId,
            warehouse_id: warehouseId
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                const stock = response.data;
                $(`.current_stock_display[data-row="${rowNum}"]`).val(stock.quantity_on_hand);
                $(`.system_quantity_input[data-row="${rowNum}"]`).val(stock.quantity_on_hand);
                
                // Auto-fill unit cost if available
                if (stock.average_cost > 0) {
                    $(`.unit_cost_input[data-row="${rowNum}"]`).val(stock.average_cost);
                }
                
                // Trigger calculation
                calculateAdjustmentForRow(rowNum);
            }
        },
        error: function() {
            $(`.current_stock_display[data-row="${rowNum}"]`).val('Error');
        }
    });
}

// Calculate adjustment for a row
function calculateAdjustmentForRow(rowNum) {
    const systemQty = parseFloat($(`.system_quantity_input[data-row="${rowNum}"]`).val()) || 0;
    const physicalQty = parseFloat($(`.physical_quantity_input[data-row="${rowNum}"]`).val()) || 0;
    const adjustmentQty = physicalQty - systemQty;
    
    $(`.adjustment_quantity_display[data-row="${rowNum}"]`).val(adjustmentQty.toFixed(3));
    
    // Color code based on adjustment type
    const display = $(`.adjustment_quantity_display[data-row="${rowNum}"]`);
    if (adjustmentQty > 0) {
        display.css('color', '#4caf50'); // Green for increase
    } else if (adjustmentQty < 0) {
        display.css('color', '#f44336'); // Red for decrease
    } else {
        display.css('color', '#666'); // Gray for no change
    }
    
    calculateValueImpactForRow(rowNum);
}

// Calculate value impact for a row
function calculateValueImpactForRow(rowNum) {
    const adjustmentQty = parseFloat($(`.adjustment_quantity_display[data-row="${rowNum}"]`).val()) || 0;
    const unitCost = parseFloat($(`.unit_cost_input[data-row="${rowNum}"]`).val()) || 0;
    const valueImpact = adjustmentQty * unitCost;
    
    const display = $(`.value_impact_display[data-row="${rowNum}"]`);
    display.val('K ' + valueImpact.toFixed(2));
    
    // Color code based on value impact
    if (valueImpact > 0) {
        display.css('color', '#4caf50'); // Green for positive impact
    } else if (valueImpact < 0) {
        display.css('color', '#f44336'); // Red for negative impact
    } else {
        display.css('color', '#666'); // Gray for no impact
    }
}

// Update adjustment summary
function updateAdjustmentSummary() {
    let totalProducts = $('.adjustment-product-row').length;
    let totalValueImpact = 0;
    
    $('.adjustment-product-row').each(function() {
        const valueText = $(this).find('.value_impact_display').val();
        const value = parseFloat(valueText.replace('K ', '')) || 0;
        totalValueImpact += value;
    });
    
    $('#adjustment_total_products').text(totalProducts);
    $('#adjustment_total_value').text(totalValueImpact.toFixed(2));
    
    if (totalProducts > 0) {
        $('#adjustment_summary').slideDown();
    }
}

// Remove adjustment product row
$(document).on('click', '.remove_adjustment_product_row', function() {
    const rowId = $(this).data('row-id');
    if ($('.adjustment-product-row').length > 1) {
        $('#' + rowId).fadeOut(300, function() {
            $(this).remove();
            updateAdjustmentSummary();
        });
    } else {
        alert('You must have at least one product!');
    }
});

// Add another product row
$(document).on('click', '#add_adjustment_product', function() {
    addAdjustmentProductRow();
});

// Warehouse change event - update all product stocks
$(document).on('change', '#adjustment_warehouse_id', function() {
    const warehouseId = $(this).val();
    $('.adjustment-product-row').each(function() {
        const rowNum = $(this).find('.adjustment_product_select').data('row');
        const productId = $(this).find('.adjustment_product_select').val();
        if (productId && warehouseId) {
            loadCurrentStockForAdjustment(productId, warehouseId, rowNum);
        }
    });
});


// Save adjustment as draft
$(document).on('click', '#save_adjustment_draft', function() {
    saveStockAdjustment('draft');
});

// Submit adjustment for approval
$(document).on('click', '#submit_adjustment_approval', function() {
    saveStockAdjustment('pending_approval');
});

// Save stock adjustment
function saveStockAdjustment(status) {
    // Validate form
    const adjustmentType = $('#adjustment_type').val();
    const warehouseId = $('#adjustment_warehouse_id').val();
    const adjustmentDate = $('#adjustment_date').val();
    const reason = $('#adjustment_reason').val();

    if (!adjustmentType || !warehouseId || !adjustmentDate || !reason) {
        alert('Please fill in all required fields!');
        return;
    }

    // Validate products
    let hasValidProducts = false;
    $('.adjustment-product-row').each(function() {
        const productId = $(this).find('.adjustment_product_select').val();
        const physicalQty = $(this).find('.physical_quantity_input').val();
        if (productId && physicalQty) {
            hasValidProducts = true;
        }
    });

    if (!hasValidProducts) {
        alert('Please add at least one product with physical quantity!');
        return;
    }

    // Collect products data
    const products = [];
    $('.adjustment-product-row').each(function() {
        const rowNum = $(this).find('.adjustment_product_select').data('row');
        const productId = $(`.adjustment_product_select[data-row="${rowNum}"]`).val();
        const systemQty = parseFloat($(`.system_quantity_input[data-row="${rowNum}"]`).val()) || 0;
        const physicalQty = parseFloat($(`.physical_quantity_input[data-row="${rowNum}"]`).val()) || 0;
        const unitCost = parseFloat($(`.unit_cost_input[data-row="${rowNum}"]`).val()) || 0;
        const batchNumber = $(`input[name="products[${rowNum}][batch_number]"]`).val();
        const notes = $(`input[name="products[${rowNum}][notes]"]`).val();

        products.push({
            product_id: productId,
            system_quantity: systemQty,
            physical_quantity: physicalQty,
            unit_cost: unitCost,
            batch_number: batchNumber,
            notes: notes
        });
    });

    // Prepare adjustment data
    const adjustmentData = {
        adjustment_type: adjustmentType,
        warehouse_id: warehouseId,
        adjustment_date: adjustmentDate,
        reason: reason,
        notes: $('#adjustment_notes').val() || '',
        products: products,
        status: status,
        user_id: sessionStorage.getItem('user_id') || '',
        user_name: sessionStorage.getItem('user_name') || '',
        org_id: sessionStorage.getItem('org_id') || '',
        org_name: sessionStorage.getItem('org_name') || ''
    };

    // Show loading
    const saveBtn = status === 'draft' ? '#save_adjustment_draft' : '#submit_adjustment_approval';
    $(saveBtn).html('<i class="fa fa-spinner fa-spin"></i> Saving...').prop('disabled', true);

    // Submit to backend
    $.ajax({
        url: 'xd-modules/inventory/stock-management/backend/create_stock_adjustment.php',
        type: 'POST',
        data: JSON.stringify(adjustmentData),
        contentType: 'application/json',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                const message = status === 'draft' 
                    ? 'Adjustment saved as draft successfully!' 
                    : 'Adjustment submitted for approval successfully!';
                
                alert(message);
                $('.close_adjustment_modal').click();
                loadStockAdjustments(); // Refresh the adjustments list
            } else {
                alert('Error: ' + (response.message || 'Failed to save adjustment'));
                $(saveBtn).html(status === 'draft' ? '<span class="fontx fx-save"></span> Save as Draft' : '<span class="fontx fx-send"></span> Submit for Approval').prop('disabled', false);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error:', xhr.responseText);
            alert('Error saving adjustment: ' + error);
            $(saveBtn).html(status === 'draft' ? '<span class="fontx fx-save"></span> Save as Draft' : '<span class="fontx fx-send"></span> Submit for Approval').prop('disabled', false);
        }
    });
}

// Close adjustment modal
$(document).on('click', '.close_adjustment_modal', function() {
    $('#adjustment_modal').fadeOut('slow', function() {
        $(this).remove();
    });
});

// Render adjustment summary cards
function renderAdjustmentSummaryCards(container, summary) {
    container.append(`
        <div class="w3-row" style="margin-bottom:10px;margin-top:10px;">
            <!-- Total Adjustments -->
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #667eea 0%, #764ba2 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Adjustments</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.total_adjustments || 0}</h2>
                        </div>
                        <span class="fontx fx-edit w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Pending Approval -->
            <div class="w3-col l2 m3 s4" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Pending Approval</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.pending_count || 0}</h2>
                        </div>
                        <span class="fontx fx-clock w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Draft Adjustments -->
            <div class="w3-col l2 m3 s4" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);color:#333;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Draft</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">${summary?.draft_count || 0}</h2>
                        </div>
                        <span class="fontx fx-file w3-hide-small" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
            
            <!-- Value Impact -->
            <div class="w3-col l3 m6 s8" style="padding:5px;">
                <div style="background:linear-gradient(135deg, #fad0c4 0%, #ffd1ff 100%);color:#333;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <div>
                            <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Value Impact</p>
                            <h2 style="margin:10px 0 0 0;font-size:2em;">K${parseFloat(summary?.total_value_impact || 0).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</h2>
                        </div>
                        <span class="fontx fx-dollar-sign" style="font-size:3em;opacity:0.3;"></span>
                    </div>
                </div>
            </div>
        </div>
    `);
}

// Render adjustments table
function renderAdjustmentsTable(container, data) {
    container.append(`
        <div style="background:transparent;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <!-- Table Header -->
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" style="font-weight:600;background:#f5f5f5;padding:15px 10px;">
                <div class="w3-col l2 m2 s12">Adjustment #</div>
                <div class="w3-col l1 m1 s12">Type</div>
                <div class="w3-col l2 m2 s12">Warehouse</div>
                <div class="w3-col l1 m1 s12">Items</div>
                <div class="w3-col l1 m1 s12">Value Impact</div>
                <div class="w3-col l1 m1 s12">Date</div>
                <div class="w3-col l1 m1 s12">Status</div>
                <div class="w3-col l2 m2 s12">Created By</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Actions</div>
            </div>

            <!-- Table Body -->
            <div id="adjustments_table_body"></div>
        </div>
    `);

    // Populate rows
    const tbody = $('#adjustments_table_body');
    data.forEach((adjustment, index) => {
        const statusBadge = getAdjustmentStatusBadge(adjustment.status);
        const typeBadge = getAdjustmentTypeBadge(adjustment.adjustment_type);
        
        tbody.append(`
            <div class="inner-data-div w3-col l12 m12 s12 adjustment-row" data-id="${adjustment.id}">
                
                <!-- Adjustment Number -->
                <div class="w3-col l2 m2 s12" style="font-weight:600;color:var(--primary-color);">
                    ${adjustment.adjustment_number}
                </div>
                
                <!-- Adjustment Type -->
                <div class="w3-col l1 m1 s12">
                    ${typeBadge}
                </div>
                
                <!-- Warehouse -->
                <div class="w3-col l2 m2 s12">
                    ${adjustment.warehouse_name || 'N/A'}
                </div>
                
                <!-- Items Count -->
                <div class="w3-col l1 m1 s12" style="text-align:center;">
                    ${adjustment.total_items || 0}
                </div>
                
                <!-- Value Impact -->
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:${adjustment.total_value_impact >= 0 ? '#4caf50' : '#f44336'};">
                    K${parseFloat(adjustment.total_value_impact || 0).toFixed(2)}
                </div>
                
                <!-- Date -->
                <div class="w3-col l1 m1 s12">
                    ${formatDate(adjustment.adjustment_date)}
                </div>
                
                <!-- Status -->
                <div class="w3-col l1 m1 s12">
                    ${statusBadge}
                </div>
                
                <!-- Created By -->
                <div class="w3-col l2 m2 s12">
                    ${adjustment.created_by_name || 'System'}
                </div>
                
                <!-- Actions -->
                <div class="w3-col l1 m1 s12" style="text-align:center;">
                    <select class="adjustmentActionsSelect" data-id="${adjustment.id}">
                        <option value="">Actions</option>
                        <option value="view">View Details</option>
                        ${adjustment.status === 'draft' ? '<option value="edit">Edit</option>' : ''}
                        ${adjustment.status === 'draft' ? '<option value="submit">Submit for Approval</option>' : ''}
                        ${adjustment.status === 'pending_approval' ? '<option value="approve">Approve</option>' : ''}
                        ${adjustment.status === 'pending_approval' ? '<option value="reject">Reject</option>' : ''}
                        ${adjustment.status === 'approved' ? '<option value="complete">Complete</option>' : ''}
                        <option value="print">Print</option>
                    </select>
                </div>
                
            </div>
        `);
    });
}

// Helper: Get adjustment status badge
function getAdjustmentStatusBadge(status) {
    const badges = {
        'draft': '<span style="background:#9e9e9e;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">DRAFT</span>',
        'pending_approval': '<span style="background:#ff9800;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">PENDING</span>',
        'approved': '<span style="background:#2196f3;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">APPROVED</span>',
        'completed': '<span style="background:#4caf50;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">COMPLETED</span>',
        'rejected': '<span style="background:#f44336;color:white;padding:3px 10px;border-radius:12px;font-size:0.8em;font-weight:600;">REJECTED</span>'
    };
    return badges[status] || badges.draft;
}

// Helper: Get adjustment type badge
function getAdjustmentTypeBadge(type) {
    const badges = {
        'physical_count': '<span style="background:#2196f3;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">COUNT</span>',
        'damage': '<span style="background:#f44336;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">DAMAGE</span>',
        'theft': '<span style="background:#ff5722;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">THEFT</span>',
        'expiry': '<span style="background:#ff9800;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">EXPIRY</span>',
        'quality': '<span style="background:#9c27b0;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">QUALITY</span>',
        'correction': '<span style="background:#607d8b;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">CORRECTION</span>',
        'write_off': '<span style="background:#795548;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">WRITE OFF</span>',
        'found': '<span style="background:#4caf50;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">FOUND</span>'
    };
    return badges[type] || '<span style="background:gray;color:white;padding:3px 8px;border-radius:10px;font-size:0.7em;font-weight:600;">UNKNOWN</span>';
}