function  warehouseProductsHeader(){
  let today = new Date().toISOString().slice(0, 10);
  $('#page-options').empty(); 
  $('#page-options').append('<select class="warehouseProductSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="productList">All Stock</option><option value="stockBCategory">Stock By Category</option><option value="stockByWarehouse">Stock By Warehouse</option></select> <span id="record01" class="topNavTotals"></span>');
 $('#right_nav_options0').empty();
  $('#right_nav_options0').append('<a href="#" id="bankAccountDepositIconDiv" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file depositSlipIcon1"></span></a>');
 
  $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
  $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102  w3-hide-small top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
 $('#right_nav_options0').append('<div id="exportTransactioins" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-share-2"></span></div>');
 $('#right_nav_options0').append('<div  class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
   $('#right_nav_options0').append('<div class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-upload"></span></div>');
  $('#right_nav_options0').append('<div class="top-right-navigation-icons101 addWarehouseProduct101"><span class="fontx fx-plus"></span></div>');
   $('#right_nav_options0').append('<div class="top-right-navigation-icons101 initialStockBalance101"><span class="fontx fx-edit-2"></span></div>');
  
  $('#sub_top_nav').empty(); 
  $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s7 w3-center"><input id="searchProductWarehouse101" type="text" placeholder="Type to search..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span><select id="revenueReportDisplayType" class="reduceSizeOnSmallScreen"  style="background-color:transparent;border:none;outline:none;color:gray;"><option value="Charts">Charts</option><option value="Normal">Normal</option><option value="Display All">Display All</option><option value="Map">Map</option></select></span><div/></div><div class="w3-col l5 m5 s3 w3-center" style="padding-left:7px;padding-top:3px;color:gray;background-color:;"><span style="float:right;"><input type="date" value="'+today+'" id="revenueReportStartDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/><input type="date" value="'+today+'" id="revenueReportEndDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/></span></div>');

 }
// Load warehouses on click
$(document).on('click', '.warehouseProducts101', async function() {
    warehouseProductsHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
   // await  warehouseProducts();
    loadStockLevels();
});
 


// Fetch products (optional searchKey)
 
// Fetch products (optional searchKey)
async function warehouseProducts(searchKey = '') { 
    try {
        const url = `xd-modules/inventory/stock-management/backend/get_products.php?search=${encodeURIComponent(searchKey)}`;
        const response = await fetch(url);
        const data = await response.json();

        const container = $('#main-body');
        container.empty();

        if (!data.success) {
            container.append('<p style="color:red;">' + data.message + '</p>');
            return;
        }

        // Header
        container.append(`
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" style="font-weight:600;">
                <div class="w3-col l3 m3 s12">Name</div>
                <div class="w3-col l1 m1 s12">Category</div>
              <div class="w3-col l1 m1 s12">Cost</div>
                <div class="w3-col l1 m1 s12">Selling</div>
                <div class="w3-col l1 m1 s12">Quantity</div>

                 <div class="w3-col l1 m1 s12">Reorder Level</div>
                  <div class="w3-col l1 m1 s12">Allocated</div>
                 <div class="w3-col l1 m1 s12">Available</div>
                <div class="w3-col l1 m1 s12">Stock Value</div>
                <div class="w3-col l1 m1 s1 hideOnPrint">Action</div>
            </div>
        `);

        // Data rows
        data.details.forEach(p => {
            container.append(`
                <div class="inner-data-div w3-col l12 m12 s12" style="cursor:pointer; border-bottom:1px solid #ddd; padding:0px 0;">
                    <div class="w3-col l3 m3 s12" style="padding-left:5px;color:var(--primary-color);">
                        <span class="w3-col l1 m1 s12"><img src="${p.image}" style="color:gray;border-radius:5px;height:30px;width:30px;"/></span>
                         <span class="w3-col l11 m11 s12" style="color:var(--primary-color); font-weight:600;padding-left:10px;"> <span style="color:gray;">${p.product_code}</span> ${p.name}
                    </div>
                   
                    <div class="w3-col l1 m1 s12">${p.category || '----'}</div> 
                    <div class="w3-col l1 m1 s12">${p.cost ? '$' + parseFloat(p.price).toFixed(2) : '----'}</div>
                    <div class="w3-col l1 m1 s12">${p.price ? '$' + parseFloat(p.price).toFixed(2) : '----'}</div>
                    <div class="w3-col l1 m1 s12">${p.quantity_on_hand ?? '----'}</div>

                      <div class="w3-col l1 m1 s12" style="color:red;">${p.reorder_level ?? '---'}</div> 
                    <div class="w3-col l1 m1 s12">${p.quantity_allocated ? '$' + parseFloat(p.quantity_allocated).toFixed(2) : '----'}</div>
                     <div class="w3-col l1 m1 s12" style="color:green;">${p.quantity_available ? '$' + parseFloat(p.quantity_available).toFixed(2) : '----'}</div>
                    <div class="w3-col l1 m1 s12" style="color:var(--primary-color);">${p.total_value ? '$' + parseFloat(p.total_value).toFixed(2) : '----'}</div> 
                    <div class="w3-col l1 m1 s2">
                        <select class="innerDivProductSelectKey inner-data-more-actions2 hideOnPrint" data-id="${p.id}">
                            <option value="select-actions">More</option>
                            <option value="view-details">Details</option> 
                            <option value="delete">Delete</option>
                            <option value="activate">Activate</option>
                            <option value="suspend">Suspend</option>
                        </select>
                    </div>
                </div>
            `);
        });

    } catch (err) {
        console.error(err);
        $('#main-body').html('<p style="color:red;">Failed to load products.</p>');
    }
}
// Handle dropdown actions
$(document).on('change', '.innerDivProductSelectKey', async function() {
    const action = $(this).val();
    const productId = $(this).data('id');

    if (action === 'view-details') {
        await showWarehouseProductDetails(productId);
    } else if (action === 'delete') {
        if (confirm('Are you sure you want to delete this product?')) {
            alert(`Deleting Product ID: ${productId}`);
        }
    } else if (action === 'activate') {
        alert(`Activating product ID: ${productId}`);
    } else if (action === 'suspend') {
        alert(`Suspending product ID: ${productId}`);
    }

    $(this).val('select-actions'); // Reset dropdown
});

 
async function showWarehouseProductDetails(id) {
    try {
        const response = await fetch(`xd-modules/inventory/stock-management/backend/get_product_details.php?id=${id}`);
        const data = await response.json();

        if (!data.success) {
            alert('Failed to load product details.');
            return;
        }

        const product = data.details;

        // Reset and create modal
        $('#external_page_contents').empty().append(`
            <div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>
        `);

        // Modal header
        $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span><span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">PRODUCT DETAILS</span></div>');

        $('#invoice_modal').append('<form method="post" id="product_form" enctype="multipart/form-data" style="margin-top:40px;"><div class="main-body-left-div w3-col l7 m7 s12"></div><div class="main-body-right-div w3-col l5 m5 s12"></div></form>');

        // LEFT SIDE - Image
        $('.main-body-left-div').empty();
        $('.main-body-left-div').append(`<div class="image-container"><img id="productImage" src="${product.image || 'logo.png'}" alt="product picture" class="image101" style="width:100%;"><div class="image-centered productImageUpload" style="display:none;"><span class="fontx fx-camera" style="font-size:1.5em;"></span></div></div>`);

        // RIGHT SIDE - Form fields (read-only)
        $('.main-body-right-div').empty().append(`
            <div id="create_product_form" style="padding:10px;padding-bottom:50px;">
                <h4 style="color:var(--primary-color);margin-bottom:10px;margin-top:0;">Basic Information</h4>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="product_code" name="product_code" value="${product.product_code || ''}" readonly>
                    <label for="product_code" class="label-name"><span class="content-name">Product Code/SKU *</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="product_name" name="product_name" value="${product.name || ''}" readonly>
                    <label for="product_name" class="label-name"><span class="content-name">Product Name *</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <textarea id="description" name="description" rows="3" style="width:100%;padding:10px;border:1px solid #ddd;border-radius:5px;" readonly>${product.description || ''}</textarea>
                    <label style="font-size:0.9em;color:gray;">Product Description</label>
                </div>
                <select id="category" name="category" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" disabled>
                    <option value="">${product.category || 'Select Category *'}</option>
                </select>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="sub_category" name="sub_category" value="${product.sub_category || ''}" readonly>
                    <label for="sub_category" class="label-name"><span class="content-name">Sub-Category (Optional)</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="brand" name="brand" value="${product.product_brand || ''}" readonly>
                    <label for="brand" class="label-name"><span class="content-name">Brand/Manufacturer</span></label>
                </div>
                <h4 style="color:var(--primary-color);margin-bottom:10px;margin-top:20px;">Product Type</h4>
                <select id="product_type" name="product_type" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" disabled>
                    <option value="">${product.product_type || 'Select Product Type *'}</option>
                </select>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="tracking_type" name="tracking_type" value="${product.tracking_type || ''}" readonly>
                    <label for="tracking_type" class="label-name"><span class="content-name">Tracking Type</span></label>
                </div>
                <h4 style="color:var(--primary-color);margin-bottom:10px;margin-top:20px;">Pricing</h4>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="cost_price" name="cost_price" value="${product.cost_price || ''}" readonly>
                    <label for="cost_price" class="label-name"><span class="content-name">Cost Price</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="selling_price" name="selling_price" value="${product.price || ''}" readonly>
                    <label for="selling_price" class="label-name"><span class="content-name">Selling Price</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="tax_rate" name="tax_rate" value="${product.tax_rate || ''}" readonly>
                    <label for="tax_rate" class="label-name"><span class="content-name">Tax Rate (%)</span></label>
                </div>
                <select id="currency" name="currency" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" disabled>
                    <option value="">${product.currency || 'Currency'}</option>
                </select>
                <h4 style="color:var(--primary-color);margin-bottom:10px;margin-top:20px;">Units & Measurements</h4>
                <select id="unit_of_measure" name="unit_of_measure" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" disabled>
                    <option value="">${product.units || 'Unit of Measure *'}</option>
                </select>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="weight" name="weight" value="${product.weight || ''}" readonly>
                    <label for="weight" class="label-name"><span class="content-name">Weight (Kg)</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="dimensions" name="dimensions" value="${product.dimensions || ''}" readonly>
                    <label for="dimensions" class="label-name"><span class="content-name">Dimensions</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="barcode" name="barcode" value="${product.barcode || ''}" readonly>
                    <label for="barcode" class="label-name"><span class="content-name">Barcode</span></label>
                </div>
                <h4 style="color:var(--primary-color);margin-bottom:10px;margin-top:20px;">Inventory Management</h4>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="reorder_level" name="reorder_level" value="${product.reorder_level || ''}" readonly>
                    <label for="reorder_level" class="label-name"><span class="content-name">Reorder Point/Level</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="max_stock_level" name="max_stock_level" value="${product.max_stock_level || ''}" readonly>
                    <label for="max_stock_level" class="label-name"><span class="content-name">Maximum Stock Level</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="lead_time" name="lead_time" value="${product.lead_time || ''}" readonly>
                    <label for="lead_time" class="label-name"><span class="content-name">Lead Time</span></label>
                </div>
                <select id="supplier_id" name="supplier_id" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" disabled>
                    <option value="">${product.supplier_name || 'Preferred Supplier'}</option>
                </select>
                <h4 style="color:var(--primary-color);margin-bottom:10px;margin-top:20px;">Additional Information</h4>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="color" name="color" value="${product.color || ''}" readonly>
                    <label for="color" class="label-name"><span class="content-name">Color/Variant</span></label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="number" id="warranty_period" name="warranty_period" value="${product.warranty_period || ''}" readonly>
                    <label for="warranty_period" class="label-name"><span class="content-name">Warranty Period (Months)</span></label>
                </div>
                <select id="status" name="status" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" disabled>
                    <option value="">${product.status || 'Status'}</option>
                </select>
            </div>
        `);

        // Initialize Select2 for disabled dropdowns
        $('.select2Styles').select2({
            allowClear: false,
            width: '100%',
            dropdownParent: $('#invoice_modal')
        });

        // Show modal
        $('#invoice_modal').fadeIn('slow').css('display', 'block');

    } catch (error) {
        console.error(error);
        alert('Error loading product details.');
    }
}
 
async function showWarehouseProductDetails(id) {
    try {
        const response = await fetch(`xd-modules/inventory/stock-management/backend/get_product_details.php?id=${id}`);
        const data = await response.json();

        if (!data.success) {
            alert('Failed to load product details.');
            return;
        }

        const product = data.details;

    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
     
    // Modal header
    $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span><span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">PRODUCT DETAILS</span></div>');
    
    $('#invoice_modal').append('<form method="post" id="product_form" enctype="multipart/form-data" style="margin-top:40px;"><div class="main-body-left-div w3-col l7 m7 s12"></div><div class="main-body-right-div w3-col l5 m5 s12"></div></form>');
    
    // LEFT SIDE - Image upload
    $('.main-body-left-div').empty(); 
    $('.main-body-left-div').append(`
        <div class="image-container">
        <img id="productImage" src="${product.image || 'logo.png'}" alt="product picture" class="image101 productImage" style="width:100%;">
        <div class="image-centered-left" style="background-color:rgba(0,0,0,0.3);height:40px;width:40px;line-height:40px;border-radius:50%;padding:5px;cursor:pointer;"><span class="fontx fx-chevron-left" style="font-size:1.5em;"></span></div>
        <div class="image-centered productImageUpload"><span class="fontx fx-camera" style="font-size:1.5em;"></span></div>
        <div class="image-centered-right"  style="background-color:rgba(0,0,0,0.3);height:40px;width:40px;line-height:40px;border-radius:50%;padding:5px;cursor:pointer"><span class="fontx fx-chevron-right" style="font-size:1.5em;"></span></div>
        
        </div>`);
   
    $('.main-body-left-div').append('<input type="file" id="productImageInput" style="display: none;" accept="image/*">');

    // RIGHT SIDE - Form fields
   
    $('.main-body-right-div').empty().append(`
        <div class="w3-col l12 m12 s12" id="create_product_form" style="padding:10px;padding-bottom:50px;">
           
          
            <!-- SECTION 1: BASIC INFORMATION -->
           
            <div class="w3-col l12 m12 s12">
              <div class="input-cont w3-col l4 m4 s3">
                <input type="text" value="${product.product_code}" id="product_code" name="product_code"  autocomplete="off" required>
                <label for="product_code" class="label-name">
                    <span class="content-name">Code/SKU *</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l8 m8 s9">
                <input type="text" value="${product.name}" id="product_name" name="product_name"  autocomplete="off" required>
                <label for="product_name" class="label-name">
                    <span class="content-name">Product Name *</span>
                </label>
            </div>
            </div>
         
            
            <div class="input-cont l12 m12 s12" style="width:100%;">
                <textarea id="description" name="description" rows="3" style="width:100%;padding:10px;border:1px solid #ddd;border-radius:5px;">${product.description}</textarea>
                <label style="font-size:0.9em;color:gray;">Product Description</label>
            </div>
            
            <!-- Category -->
            <select id="category" name="category" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" required>
                <option value="${product.category}">Category: ${product.category}</option>
                <option value="Electronics">Electronics</option>
                <option value="Food & Beverages">Food & Beverages</option>
                <option value="Stationery">Stationery</option>
                <option value="Furniture">Furniture</option>
                <option value="Medical">Medical</option>
                <option value="Clothing">Clothing</option>
                <option value="Hardware">Hardware</option>
                <option value="Other">Other</option>
            </select>
             
                <div class="input-cont w3-col l6 m6 s12">
                <input type="text" id="sub_category" name="sub_category" value="${product.sub_category}" autocomplete="off">
                <label for="sub_category" class="label-name">
                    <span class="content-name">Sub-Category (Optional)</span>
                </label>
            </div>
            <!-- SECTION 2: PRODUCT TYPE & TRACKING -->
               <div class="input-cont w3-col l6 m6 s12">
                <input type="text" id="brand" name="brand" value="${product.product_brand}" autocomplete="off">
                <label for="brand" class="label-name">
                    <span class="content-name">Brand/Manufacturer</span>
                </label>
            </div>
            <select id="product_type" name="product_type" class="select2Styles w3-col l12 m12 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="${product.product_type}">Product Type:  ${product.product_type}</option>
                <option value="tangible">Tangible (Physical Product)</option>
                <option value="intangible">Intangible (Service/Digital)</option>
                <option value="kit">Kit/Bundle</option>
            </select>
            
            <select id="tracking_type" name="tracking_type" class="select2Styles w3-col l12 m12 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="${product.tracking_type || ''}">Tracking: ${product.tracking_type || ''}</option>
                <option value="standard" selected>Standard (Count quantity only)</option>
                <option value="batch">Batch Tracking (Medicine, Food)</option>
                <option value="serial">Serial Tracking (Laptops, Phones)</option>
            </select>
            
            <!-- SECTION 3: PRICING -->
            
            <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.cost_price}" type="number" id="cost_price" name="cost_price" step="0.01" autocomplete="off" required>
                <label for="cost_price" class="label-name">
                    <span class="content-name">Buying/Cost Price *</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.price}" type="number" id="selling_price" name="selling_price" step="0.01" autocomplete="off" required>
                <label for="selling_price" class="label-name">
                    <span class="content-name">Selling Price *</span>
                </label>
            </div>
            
           
            
            <select id="currency" name="currency" class="select2Styles w3-col l6 m6 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="${product.currency}"  selected>${product.currency}</option> 
            <option value="ZMW" selected>ZMW (Zambian Kwacha)</option>
                <option value="USD">USD (US Dollar)</option>
                <option value="EUR">EUR (Euro)</option>
                <option value="GBP">GBP (British Pound)</option>
            </select>
            
            <!-- SECTION 4: UNITS & MEASUREMENTS -->
           
            <select id="unit_of_measure" name="unit_of_measure" class="select2Styles w3-col l6 m6 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="${product.units}">Unit: ${product.units}</option>
                <option value="piece">Piece/Unit</option>
                <option value="box">Box/Carton</option>
                <option value="pack">Pack</option>
                <option value="kg">Kilogram (Kg)</option>
                <option value="gram">Gram (g)</option>
                <option value="litre">Litre (L)</option>
                <option value="ml">Millilitre (ml)</option>
                <option value="meter">Meter (m)</option>
                <option value="cm">Centimeter (cm)</option>
                <option value="dozen">Dozen</option>
                <option value="set">Set</option>
            </select>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.weight || ''}"  type="number" id="weight" name="weight" step="0.01" autocomplete="off">
                <label for="weight" class="label-name">
                    <span class="content-name">Weight (Kg)</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.dimensions}" type="text" id="dimensions" name="dimensions" autocomplete="off" placeholder="L x W x H (cm)">
                <label for="dimensions" class="label-name">
                    <span class="content-name">Dimensions (cm)</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.barcode}" type="text" id="barcode" name="barcode" value="00000" autocomplete="off">
                <label for="barcode" class="label-name">
                    <span class="content-name">Barcode</span>
                </label>
            </div> 
            
            <!-- SECTION 6: ADDITIONAL INFO -->
           
            <div class="input-cont w3-col l6 m6 s6">
                <input type="text" id="color" name="color" value="${product.color || ''}"  autocomplete="off">
                <label for="color" class="label-name">
                    <span class="content-name">Color/Variant (Optional)</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.warranty_period || ''}"  type="number" id="warranty_period" name="warranty_period" step="1" autocomplete="off">
                <label for="warranty_period" class="label-name">
                    <span class="content-name">Warranty (Months)</span>
                </label>
            </div>
             <div class="input-cont w3-col l6 m6 s6">
                <input value="${product.tax_rate || ''}"  type="number" id="tax_rate" name="tax_rate" step="0.01" autocomplete="off">
                <label for="tax_rate" class="label-name">
                    <span class="content-name">Tax Rate (%)</span>
                </label>
            </div>
            <!-- Status -->
            <select id="status" name="status" class="select2Styles w3-col l6 m6 s12" style="border:none;outline:none;background-color:transparent;" required>
               <option value="${product.status}" selected>Status: ${product.status}</option>
                <option value="active" selected>Active (Can be sold)</option>
                <option value="inactive">Inactive (Cannot be sold)</option>
            </select>
            
           
            <!-- Submit Button -->
            <div id="submitDiv" style="margin-top:20px;">
                <button id="create_product_btn" type="button" style="background-color:var(--primary-color);cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;">
                   Update Product
                </button>
            </div>
        </div>
    `);

    // Load suppliers for dropdown
    $.getJSON('xd-modules/inventory/stock-management/backend/list_suppliers.php', function(data) {
        if(data.success && data.details) {
            $.each(data.details, function(i, supplier) {
                $('#supplier_id').append(`<option value="${supplier.id}">${supplier.supplier_name}</option>`);
            });
        }
    });

    // Initialize Select2
    $('.select2Styles').select2({
        allowClear: true,
        width: '100%',
        dropdownParent: $('#invoice_modal')
    });

    // Handle image upload
    $('.productImageUpload').on('click', function() {
        $('#productImageInput').click();
    });

    $('#productImageInput').on('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#productImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
     });

       } catch (error) {
        console.error(error);
        alert('Error loading product details.');
    }

    // Show modal
    $('#invoice_modal').fadeIn('slow').css('display', 'block');
}

/// END OF SHOWING PRODUCT DETAILS

///CREATE PRODUCTS
$(document).on('click', '.addWarehouseProduct101', function(event) {
    event.preventDefault();
    event.stopPropagation(); 
     createWarehouseProduct101();
});

 function createWarehouseProduct101() {
    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
     
    // Modal header
    $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span><span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">CREATE PRODUCT</span></div>');
    
    $('#invoice_modal').append('<form method="post" id="product_form" enctype="multipart/form-data" style="margin-top:40px;"><div class="main-body-left-div w3-col l7 m7 s12"></div><div class="main-body-right-div w3-col l5 m5 s12"></div></form>');
    
    // LEFT SIDE - Image upload
    $('.main-body-left-div').empty(); 
    $('.main-body-left-div').append(`
        <div class="image-container">
        <img id="productImage" src="logo.png" alt="product picture" class="image101 productImage" style="width:100%;">
        <div class="image-centered-left" style="background-color:rgba(0,0,0,0.3);height:40px;width:40px;line-height:40px;border-radius:50%;padding:5px;cursor:pointer;"><span class="fontx fx-chevron-left" style="font-size:1.5em;"></span></div>
        <div class="image-centered productImageUpload"><span class="fontx fx-camera" style="font-size:1.5em;"></span></div>
        <div class="image-centered-right"  style="background-color:rgba(0,0,0,0.3);height:40px;width:40px;line-height:40px;border-radius:50%;padding:5px;cursor:pointer"><span class="fontx fx-chevron-right" style="font-size:1.5em;"></span></div>
        
        </div>`);
   
    $('.main-body-left-div').append('<input type="file" id="productImageInput" style="display: none;" accept="image/*">');

    // RIGHT SIDE - Form fields
   
    $('.main-body-right-div').empty().append(`
        <div class="w3-col l12 m12 s12" id="create_product_form" style="padding:10px;padding-bottom:50px;">
           
          
            <!-- SECTION 1: BASIC INFORMATION -->
           
            <div class="w3-col l12 m12 s12">
              <div class="input-cont w3-col l4 m4 s3">
                <input type="text" id="product_code" name="product_code"  autocomplete="off" required>
                <label for="product_code" class="label-name">
                    <span class="content-name">Code/SKU *</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l8 m8 s9">
                <input type="text" id="product_name" name="product_name"  autocomplete="off" required>
                <label for="product_name" class="label-name">
                    <span class="content-name">Product Name *</span>
                </label>
            </div>
            </div>
         
            
            <div class="input-cont l12 m12 s12" style="width:100%;">
                <textarea id="description" name="description" rows="3" style="width:100%;padding:10px;border:1px solid #ddd;border-radius:5px;"></textarea>
                <label style="font-size:0.9em;color:gray;">Product Description</label>
            </div>
            
            <!-- Category -->
            <select id="category" name="category" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" required>
                <option value="Other">Select Category *</option>
                <option value="Electronics">Electronics</option>
                <option value="Food & Beverages">Food & Beverages</option>
                <option value="Stationery">Stationery</option>
                <option value="Furniture">Furniture</option>
                <option value="Medical">Medical</option>
                <option value="Clothing">Clothing</option>
                <option value="Hardware">Hardware</option>
                <option value="Other">Other</option>
            </select>
             
                <div class="input-cont w3-col l6 m6 s12">
                <input type="text" id="sub_category" name="sub_category" value="Other" autocomplete="off">
                <label for="sub_category" class="label-name">
                    <span class="content-name">Sub-Category (Optional)</span>
                </label>
            </div>
            <!-- SECTION 2: PRODUCT TYPE & TRACKING -->
               <div class="input-cont w3-col l6 m6 s12">
                <input type="text" id="brand" name="brand" value="Other" autocomplete="off">
                <label for="brand" class="label-name">
                    <span class="content-name">Brand/Manufacturer</span>
                </label>
            </div>
            <select id="product_type" name="product_type" class="select2Styles w3-col l12 m12 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="tangible">Select Product Type *</option>
                <option value="tangible">Tangible (Physical Product)</option>
                <option value="intangible">Intangible (Service/Digital)</option>
                <option value="kit">Kit/Bundle</option>
            </select>
            
            <select id="tracking_type" name="tracking_type" class="select2Styles w3-col l12 m12 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="standard">How to Track This Product? *</option>
                <option value="standard" selected>Standard (Count quantity only)</option>
                <option value="batch">Batch Tracking (Medicine, Food)</option>
                <option value="serial">Serial Tracking (Laptops, Phones)</option>
            </select>
            
            <!-- SECTION 3: PRICING -->
            
            <div class="input-cont w3-col l6 m6 s6">
                <input type="number" id="cost_price" name="cost_price" step="0.01" autocomplete="off" required>
                <label for="cost_price" class="label-name">
                    <span class="content-name">Buying/Cost Price *</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input type="number" id="selling_price" name="selling_price" step="0.01" autocomplete="off" required>
                <label for="selling_price" class="label-name">
                    <span class="content-name">Selling Price *</span>
                </label>
            </div>
            
           
            
            <select id="currency" name="currency" class="select2Styles w3-col l6 m6 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="ZMW" selected>ZMW (Zambian Kwacha)</option>
                <option value="USD">USD (US Dollar)</option>
                <option value="EUR">EUR (Euro)</option>
                <option value="GBP">GBP (British Pound)</option>
            </select>
            
            <!-- SECTION 4: UNITS & MEASUREMENTS -->
           
            <select id="unit_of_measure" name="unit_of_measure" class="select2Styles w3-col l6 m6 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="Piece">Unit of Measure *</option>
                <option value="piece">Piece/Unit</option>
                <option value="box">Box/Carton</option>
                <option value="pack">Pack</option>
                <option value="kg">Kilogram (Kg)</option>
                <option value="gram">Gram (g)</option>
                <option value="litre">Litre (L)</option>
                <option value="ml">Millilitre (ml)</option>
                <option value="meter">Meter (m)</option>
                <option value="cm">Centimeter (cm)</option>
                <option value="dozen">Dozen</option>
                <option value="set">Set</option>
            </select>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input type="number" id="weight" value="0" name="weight" step="0.01" autocomplete="off">
                <label for="weight" class="label-name">
                    <span class="content-name">Weight (Kg)</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input type="text" id="dimensions" name="dimensions" value="L x W x H" autocomplete="off" placeholder="L x W x H (cm)">
                <label for="dimensions" class="label-name">
                    <span class="content-name">Dimensions (cm)</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input type="text" id="barcode" name="barcode" value="00000" autocomplete="off">
                <label for="barcode" class="label-name">
                    <span class="content-name">Barcode</span>
                </label>
            </div> 
            
            <!-- SECTION 6: ADDITIONAL INFO -->
           
            <div class="input-cont w3-col l6 m6 s6">
                <input type="text" id="color" name="color" value="None" autocomplete="off">
                <label for="color" class="label-name">
                    <span class="content-name">Color/Variant (Optional)</span>
                </label>
            </div>
            
            <div class="input-cont w3-col l6 m6 s6">
                <input type="number" id="warranty_period" name="warranty_period" value="1" step="1" autocomplete="off">
                <label for="warranty_period" class="label-name">
                    <span class="content-name">Warranty (Months)</span>
                </label>
            </div>
             <div class="input-cont w3-col l6 m6 s6">
                <input type="number" id="tax_rate" name="tax_rate" step="0.01" value="16" autocomplete="off">
                <label for="tax_rate" class="label-name">
                    <span class="content-name">Tax Rate (%)</span>
                </label>
            </div>
            <!-- Status -->
            <select id="status" name="status" class="select2Styles w3-col l6 m6 s12" style="border:none;outline:none;background-color:transparent;" required>
                <option value="active" selected>Active (Can be sold)</option>
                <option value="inactive">Inactive (Cannot be sold)</option>
            </select>
            
           
            <!-- Submit Button -->
            <div id="submitDiv" style="margin-top:20px;">
                <button id="create_product_btn" type="button" style="background-color:var(--primary-color);cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;">
                    Create Product
                </button>
            </div>
        </div>
    `);

    // Load suppliers for dropdown
    $.getJSON('xd-modules/inventory/stock-management/backend/list_suppliers.php', function(data) {
        if(data.success && data.details) {
            $.each(data.details, function(i, supplier) {
                $('#supplier_id').append(`<option value="${supplier.id}">${supplier.supplier_name}</option>`);
            });
        }
    });

    // Initialize Select2
    $('.select2Styles').select2({
        allowClear: true,
        width: '100%',
        dropdownParent: $('#invoice_modal')
    });

    // Handle image upload
    $('.productImageUpload').on('click', function() {
        $('#productImageInput').click();
    });

    $('#productImageInput').on('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#productImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });

    // Show modal
    $('#invoice_modal').fadeIn('slow').css('display', 'block');
}

// Handle form submission
 // Handle form submission with image upload
$(document).on('click', '#create_product_btn', function(event) {
    event.preventDefault();
    
    // Validate required fields
    if (!$('#product_code').val() || !$('#product_name').val() || !$('#category').val() || 
        !$('#product_type').val() || !$('#selling_price').val() || 
        !$('#unit_of_measure').val()) {
        alert('Please fill in all required fields marked with *');
        return;
    }

    // Create FormData object for file upload
    const formData = new FormData();
    
    // Add form fields
    formData.append('product_code', $('#product_code').val());
    formData.append('name', $('#product_name').val());
    formData.append('description', $('#description').val());
    formData.append('category', $('#category').val());
    formData.append('sub_category', $('#sub_category').val());
    formData.append('product_brand', $('#brand').val());
    formData.append('product_type', $('#product_type').val());
    formData.append('tracking_type', $('#tracking_type').val());
    formData.append('price', $('#selling_price').val());
    formData.append('cost_price', $('#cost_price').val());
    formData.append('tax_rate', $('#tax_rate').val() || 0);
    formData.append('currency', $('#currency').val());
    formData.append('units', $('#unit_of_measure').val());
    formData.append('weight', $('#weight').val() || '');
    formData.append('dimensions', $('#dimensions').val() || '');
    formData.append('barcode', $('#barcode').val() || '');
   // formData.append('stock_count', $('#stock_count').val());
   // formData.append('stock_allocated', $('#stock_allocated').val());
   // formData.append('reorder_level', $('#reorder_level').val());
   // formData.append('max_stock_level', $('#max_stock_level').val() || '');
   // formData.append('lead_time', $('#lead_time').val() || 0);
   // formData.append('supplier_id', $('#supplier_id').val() || '');
    formData.append('color', $('#color').val() || '');
    formData.append('warranty_period', $('#warranty_period').val() || '');
    formData.append('status', $('#status').val());
  
    // Add image file if selected
    const imageFile = $('#productImageInput')[0].files[0];
    if (imageFile) {
        formData.append('product_image', imageFile);
    }

    // Show loading state
    $('#create_product_btn').html('<i class="fa fa-spinner fa-spin"></i> Creating...').prop('disabled', true);

    // Submit to backend using FormData (no contentType/processData for file upload)
    $.ajax({
        url: 'xd-modules/inventory/stock-management/backend/create_product.php',
        type: 'POST',
        data: formData,
        processData: false,  // Don't process the data
        contentType: false,  // Don't set contentType (let browser set it with boundary)
        dataType: 'json',
        success: function(response) {
            if (response.success) {
               // alert('Product created successfully!\nProduct ID: ' + response.product_id + '\nProduct Code: ' + response.product_code);
                $('#submitDiv').empty().append('<button type="button" style="background-color:green;cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;margin-top:0px;">Product Created  </button>');
               //warehouseProducts();
               
                 
               
            setTimeout(function () { 
           $('.invoice_modal').fadeIn(createInitialStockBalance(), 'slow'); // Show modal 
           // $('.close_invoice_modal').click(); // Close modal
            $('.invoice_modal').fadeOut('slow'); // Close modal
            }, 1000);
              
               
            } else {
                alert('Error: ' + (response.message || 'Failed to create product'));
                $('#create_product_btn').html('Create Product').prop('disabled', false);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            alert('Error creating product: ' + error);
            $('#create_product_btn').html('Create Product').prop('disabled', false);
        }
    });
});

// Handle image preview
$(document).on('click', '.productImageUpload', function() {
    $('#productImageInput').click();
});

$(document).on('change', '#productImageInput', function(e) {
    const file = e.target.files[0];
    if (file) {
        // Validate file size (5MB max)
        if (file.size > 5 * 1024 * 1024) {
            alert('Image size too large! Maximum 5MB allowed.');
            $(this).val(''); // Clear the input
            return;
        }
        
        // Validate file type
        const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp'];
        if (!allowedTypes.includes(file.type)) {
            alert('Invalid file type! Only JPG, PNG, GIF, and WEBP are allowed.');
            $(this).val(''); // Clear the input
            return;
        }
        
        // Show preview
        const reader = new FileReader();
        reader.onload = function(e) {
            $('#productImage').attr('src', e.target.result);
        }
        reader.readAsDataURL(file);
    }
});

// Click handler to trigger avatar file input
$(document).on('click', '.userAvatar101', function() {
    $('#avatarImageInput101').click();
});

// Handle avatar image preview and compression when file is selected
$(document).on('change', '#avatarImageInput101', function() {
    const file = this.files[0];
    if (file) {
        // Validate file type
        if (!file.type.startsWith('image/')) {
            alert('Please select an image file');
            return;
        }
        
        // Compress and preview the image
        compressImage(file, 0.7, 800, 600).then(compressedFile => {
            // Show preview
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#userAvatarImage').attr('src', e.target.result);
            };
            reader.readAsDataURL(compressedFile);
            
            // Store compressed file for form submission
            $(this)[0].compressedFile = compressedFile;
            
            console.log('Original file:', file.name, 'Size:', (file.size / 1024).toFixed(2) + ' KB');
            console.log('Compressed file:', compressedFile.name, 'Size:', (compressedFile.size / 1024).toFixed(2) + ' KB');
            console.log('Compression ratio:', ((1 - compressedFile.size / file.size) * 100).toFixed(1) + '%');
        }).catch(error => {
            console.error('Error compressing image:', error);
            alert('Error processing image. Please try another file.');
        });
    }
});

// Image compression function
function compressImage(file, quality = 0.7, maxWidth = 800, maxHeight = 600) {
    return new Promise((resolve, reject) => {
        const canvas = document.createElement('canvas');
        const ctx = canvas.getContext('2d');
        const img = new Image();
        
        img.onload = function() {
            // Calculate new dimensions
            let { width, height } = img;
            
            // Maintain aspect ratio while fitting within max dimensions
            if (width > height) {
                if (width > maxWidth) {
                    height = (height * maxWidth) / width;
                    width = maxWidth;
                }
            } else {
                if (height > maxHeight) {
                    width = (width * maxHeight) / height;
                    height = maxHeight;
                }
            }
            
            // Set canvas dimensions
            canvas.width = width;
            canvas.height = height;
            
            // Draw and compress
            ctx.drawImage(img, 0, 0, width, height);
            
            // Convert to blob
            canvas.toBlob((blob) => {
                if (blob) {
                    // Create a new File object with compressed data
                    const compressedFile = new File([blob], file.name, {
                        type: 'image/jpeg',
                        lastModified: Date.now()
                    });
                    resolve(compressedFile);
                } else {
                    reject(new Error('Canvas to Blob conversion failed'));
                }
            }, 'image/jpeg', quality);
        };
        
        img.onerror = () => reject(new Error('Image load failed'));
        img.src = URL.createObjectURL(file);
    });
}

