<?php
header('Content-Type: application/json');
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$response = ['success' => false, 'data' => [], 'summary' => []];

try {
    // Use your existing connection
    $pdo = $conn;
    
    // Get filter parameters
    $movement_type = $_GET['movement_type'] ?? '';
    $warehouse_id = $_GET['warehouse_id'] ?? '';
    $status = $_GET['status'] ?? '';
    $start_date = $_GET['start_date'] ?? ''; 
    $end_date = $_GET['end_date'] ?? '';
    $search = $_GET['search'] ?? '';
    
    // Build WHERE clause - start with no filters to see all data
    $where_conditions = ["1=1"];
    $params = [];
    
    // Only add filters if they have values
    if (!empty($movement_type)) {
        $where_conditions[] = "sm.movement_type = ?";
        $params[] = $movement_type;
    }
    
    if (!empty($warehouse_id)) {
        $where_conditions[] = "(sm.from_warehouse_id = ? OR sm.to_warehouse_id = ?)";
        $params[] = $warehouse_id;
        $params[] = $warehouse_id;
    }
    
    if (!empty($status)) {
        $where_conditions[] = "sm.status = ?";
        $params[] = $status;
    }
    
    if (!empty($start_date)) {
        $where_conditions[] = "DATE(sm.movement_date) >= ?";
        $params[] = $start_date;
    }
    
    if (!empty($end_date)) {
        $where_conditions[] = "DATE(sm.movement_date) <= ?";
        $params[] = $end_date;
    }
    
    if (!empty($search)) {
        $where_conditions[] = "(p.name LIKE ? OR p.product_code LIKE ? OR sm.movement_code LIKE ? OR sm.batch_number LIKE ?)";
        $search_term = "%$search%";
        $params[] = $search_term;
        $params[] = $search_term;
        $params[] = $search_term;
        $params[] = $search_term;
    }
    
    $where_sql = implode(" AND ", $where_conditions);
    
    // DEBUG: Show what filters are being used
    $response['debug_filters'] = [
        'where_sql' => $where_sql,
        'params' => $params,
        'received_filters' => [
            'movement_type' => $movement_type,
            'warehouse_id' => $warehouse_id,
            'status' => $status,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'search' => $search
        ]
    ];
    
    // Main query
    $sql = "
        SELECT 
            sm.id,
            sm.movement_code,
            sm.movement_type,
            sm.reference_type,
            sm.reference_id,
            sm.quantity,
            sm.unit_cost,
            sm.total_cost,
            sm.batch_number,
            sm.movement_date,
            sm.status,
            sm.reason,
            sm.notes,
            sm.created_at,
            
            p.id as product_id,
            p.name as product_name,
            p.product_code,
            
            fw.id as from_warehouse_id,
            fw.warehouse_name as from_warehouse_name,
            
            tw.id as to_warehouse_id,
            tw.warehouse_name as to_warehouse_name,
            
            u.names as processed_by_name
            
        FROM stock_movement sm
        LEFT JOIN tblproduct p ON sm.product_id = p.id
        LEFT JOIN warehouse fw ON sm.from_warehouse_id = fw.id
        LEFT JOIN warehouse tw ON sm.to_warehouse_id = tw.id
        LEFT JOIN users u ON sm.processed_by = u.id
        WHERE $where_sql
        ORDER BY sm.movement_date DESC, sm.created_at DESC
        LIMIT 500
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $movements = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $response['data'] = $movements;
    $response['success'] = true;
    
    // Summary query
    $summary_sql = "
        SELECT 
            COUNT(*) as total_movements,
            SUM(CASE WHEN movement_type = 'inbound' THEN 1 ELSE 0 END) as inbound_count,
            SUM(CASE WHEN movement_type = 'outbound' THEN 1 ELSE 0 END) as outbound_count,
            SUM(CASE WHEN movement_type = 'transfer' THEN 1 ELSE 0 END) as transfer_count,
            SUM(CASE WHEN movement_type = 'adjustment' THEN 1 ELSE 0 END) as adjustment_count,
            SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_count,
            SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved_count,
            SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed_count,
            COALESCE(SUM(total_cost), 0) as total_value
        FROM stock_movement sm
        WHERE $where_sql
    ";
    
    $summary_stmt = $pdo->prepare($summary_sql);
    $summary_stmt->execute($params);
    $summary = $summary_stmt->fetch(PDO::FETCH_ASSOC);
    
    $response['summary'] = $summary;
    
} catch (PDOException $e) {
    $response['error'] = "Database error: " . $e->getMessage();
} catch (Exception $e) {
    $response['error'] = "Error: " . $e->getMessage();
}

echo json_encode($response);
?>