<?php 
header('Content-Type: application/json');
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $group_by = isset($_POST['group_by']) ? trim($_POST['group_by']) : '';
    $groupByClause = '';
    if ($group_by !== '') {
        // Only allow safe columns to group by
        $allowedGroupBy = ['p.id', 'p.name'];
        if (in_array($group_by, $allowedGroupBy)) {
            $groupByClause = " GROUP BY $group_by ";
        }
    } else {
        $groupByClause = " GROUP BY sb.id";
    }

    // 1️⃣ Fetch detailed stock data
    $sql = "
        SELECT 
            sb.id AS balance_id,
            p.id AS product_id,
            p.name,
            p.product_code, 
            p.image,
            p.price,
            w.warehouse_name,
            sb.quantity_on_hand,
            sb.quantity_allocated,
            sb.quantity_available,
            sb.reorder_level,
            sb.average_cost,
            (sb.quantity_available * sb.average_cost) AS total_value,
            sb.last_movement_date
        FROM stock_balance sb
        INNER JOIN tblproduct p ON sb.product_id = p.id
        INNER JOIN warehouse w ON sb.warehouse_id = w.id
        $groupByClause
        ORDER BY p.name ASC
    ";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $stocks = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 2️⃣ Calculate summary metrics
    $total_products = count($stocks);
    $total_value = 0;
    $low_stock_count = 0;
    $out_of_stock_count = 0;

    foreach ($stocks as $s) {
        $total_value += $s['total_value'] ?? 0;
        if ($s['quantity_available'] <= 0) {
            $out_of_stock_count++;
        } elseif ($s['quantity_available'] <= ($s['reorder_level'] ?? 0)) {
            $low_stock_count++;
        }
    }

    echo json_encode([
        "success" => true,
        "data" => $stocks,
        "summary" => [
            "total_products" => $total_products,
            "total_value" => $total_value,
            "low_stock_count" => $low_stock_count,
            "out_of_stock_count" => $out_of_stock_count
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "message" => "Error: " . $e->getMessage()
    ]);
}
