<?php
header('Content-Type: application/json');
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$response = ['success' => false, 'data' => [], 'summary' => []];

try {
    // Get filter parameters
    $adjustment_type = $_GET['adjustment_type'] ?? '';
    $warehouse_id = $_GET['warehouse_id'] ?? '';
    $status = $_GET['status'] ?? '';
    $start_date = $_GET['start_date'] ?? '';
    $end_date = $_GET['end_date'] ?? '';
    $search = $_GET['search'] ?? '';
    
    // Use your existing connection
    $pdo = $conn;
    
    // Build WHERE clause
    $where_conditions = ["1=1"];
    $params = [];
    
    if (!empty($adjustment_type)) {
        $where_conditions[] = "sa.adjustment_type = ?";
        $params[] = $adjustment_type;
    }
    
    if (!empty($warehouse_id)) {
        $where_conditions[] = "sa.warehouse_id = ?";
        $params[] = $warehouse_id;
    }
    
    if (!empty($status)) {
        $where_conditions[] = "sa.status = ?";
        $params[] = $status;
    }
    
    if (!empty($start_date)) {
        $where_conditions[] = "DATE(sa.adjustment_date) >= ?";
        $params[] = $start_date;
    }
    
    if (!empty($end_date)) {
        $where_conditions[] = "DATE(sa.adjustment_date) <= ?";
        $params[] = $end_date;
    }
    
    if (!empty($search)) {
        $where_conditions[] = "(sa.adjustment_number LIKE ? OR p.name LIKE ? OR p.product_code LIKE ?)";
        $search_term = "%$search%";
        $params[] = $search_term;
        $params[] = $search_term;
        $params[] = $search_term;
    }
    
    $where_sql = implode(" AND ", $where_conditions);
    
    // Main query to get adjustments
    $sql = "
        SELECT 
            sa.id,
            sa.adjustment_number,
            sa.adjustment_type,
            sa.adjustment_date,
            sa.reason,
            sa.notes,
            sa.total_value_impact,
            sa.status,
            sa.created_by,
            sa.approved_by,
            sa.approved_date,
            sa.created_at,
            
            w.id as warehouse_id,
            w.warehouse_name,
            
            creator.names as created_by_name,
            approver.names as approved_by_name,
            
            COUNT(sai.id) as total_items,
            SUM(ABS(sai.adjustment_quantity * sai.unit_cost)) as total_impact
            
        FROM stock_adjustment sa
        LEFT JOIN warehouse w ON sa.warehouse_id = w.id
        LEFT JOIN users creator ON sa.created_by = creator.id
        LEFT JOIN users approver ON sa.approved_by = approver.id
        LEFT JOIN stock_adjustment_item sai ON sa.id = sai.adjustment_id
        WHERE $where_sql
        GROUP BY sa.id
        ORDER BY sa.adjustment_date DESC, sa.created_at DESC
        LIMIT 500
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $adjustments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Summary query
    $summary_sql = "
        SELECT 
            COUNT(*) as total_adjustments,
            SUM(CASE WHEN status = 'draft' THEN 1 ELSE 0 END) as draft_count,
            SUM(CASE WHEN status = 'pending_approval' THEN 1 ELSE 0 END) as pending_count,
            SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved_count,
            SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed_count,
            SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected_count,
            COALESCE(SUM(total_value_impact), 0) as total_value_impact
        FROM stock_adjustment sa
        WHERE $where_sql
    ";
    
    $summary_stmt = $pdo->prepare($summary_sql);
    $summary_stmt->execute($params);
    $summary = $summary_stmt->fetch(PDO::FETCH_ASSOC);
    
    $response['success'] = true;
    $response['data'] = $adjustments;
    $response['summary'] = $summary;
    
} catch (PDOException $e) {
    $response['error'] = "Database error: " . $e->getMessage();
} catch (Exception $e) {
    $response['error'] = "Error: " . $e->getMessage();
}

echo json_encode($response);
?>