<?php
session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

header('Content-Type: application/json');

$workflowType = $_GET['type'] ?? 'PURCHASE_REQUISITION';
$orgId = $_SESSION['orgid'] ?? null;

$response = ['success' => false, 'steps' => []];

try {
    // 1️⃣ Get active workflow for this organization and type
    $stmt = $conn->prepare("
        SELECT id 
        FROM workflows 
        WHERE org_id = :org_id 
          AND workflow_type = :type 
          AND is_active = 1 
        LIMIT 1
    ");
    $stmt->execute([':org_id' => $orgId, ':type' => $workflowType]);
    $workflow = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$workflow) {
        throw new Exception("No active workflow found for type: $workflowType");
    }

    $workflowId = $workflow['id'];

    // 2️⃣ Get all workflow steps
    $query = "
        SELECT id, step_order, role, is_final 
        FROM workflow_steps 
        WHERE workflow_id = :workflow_id 
        ORDER BY step_order ASC
    ";
    $stmt2 = $conn->prepare($query);
    $stmt2->execute([':workflow_id' => $workflowId]);
    $steps = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    // 3️⃣ Ensure workflow_approvals table has records for each step
    $insertApproval = $conn->prepare("
        INSERT INTO workflow_approvals (workflow_id, step_id, approval_status)
        SELECT :workflow_id, :step_id, 'Pending'
        WHERE NOT EXISTS (
            SELECT 1 FROM workflow_approvals 
            WHERE workflow_id = :workflow_id 
              AND step_id = :step_id
        )
    ");

    foreach ($steps as $step) {
        $insertApproval->execute([
            ':workflow_id' => $workflowId,
            ':step_id' => $step['id']
        ]);
    }

    // 4️⃣ Fetch workflow steps along with approval info
    $stmt3 = $conn->prepare("
        SELECT 
            ws.id,
            ws.step_order,
            ws.role,
            ws.is_final,
            wa.approval_status,
            wa.approved_by,
            wa.approved_at
        FROM workflow_steps ws
        LEFT JOIN workflow_approvals wa 
            ON ws.id = wa.step_id AND wa.workflow_id = ws.workflow_id
        WHERE ws.workflow_id = :workflow_id
        ORDER BY ws.step_order ASC
    ");
    $stmt3->execute([':workflow_id' => $workflowId]);
    $stepsWithStatus = $stmt3->fetchAll(PDO::FETCH_ASSOC);

    // 5️⃣ Respond
    $response = [
        'success' => true,
        'workflow_id' => $workflowId,
        'steps' => $stepsWithStatus
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>
