<?php
/**
 * List/Get All Products (Dynamic Filters)
 * File: xd-modules/admin-modules/inventory/backend/list_products.php
 */

session_start();
header('Content-Type: application/json');
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$response = [
    'success' => false,
    'message' => '',
    'details' => []
];

try {
    $org_id = $_SESSION['orgid'] ?? null;
    if (!$org_id) throw new Exception('Organization ID not found in session');

    // Optional filters from GET
    $filters = [
        'is_active' => isset($_GET['is_active']) ? trim($_GET['is_active']) : null,
        'depot_id' => isset($_GET['depot_id']) ? trim($_GET['depot_id']) : null,
        'search' => isset($_GET['search']) ? trim($_GET['search']) : null,
        'category' => isset($_GET['category']) ? trim($_GET['category']) : null,
        'product_type' => isset($_GET['product_type']) ? trim($_GET['product_type']) : null
    ];

    // Base SQL
    $sql = "SELECT 
       p.id, p.name, p.product_code, p.image, p.price, p.charge_rate, p.quantity, p.reorder_level, p.cost,p.description, p.color, p.weight, p.dimensions, p.images, p.videos, p.category, p.category_code, p.sub_category, p.coa_type, p.units, p.product_type, p.product_brand, p.barcode, p.lead_time, p.date_of_manufacture, p.expiry_date, p.product_location, p.depot_id, p.penalty_code, p.workAddress, p.lat_area, p.lng_area, p.radius, p.path, p.user_id, p.department, p.status, p.due_date, p.due_time, p.supplier_name, p.supplier_id, p.datemodified, p.org_name, p.org_id, p.sessionUserId,
       sb.id AS balance_id,
       SUM(sb.quantity_on_hand) AS quantity_on_hand,
       SUM(sb.quantity_allocated) AS quantity_allocated,
       SUM(sb.quantity_available) AS quantity_available,
       sb.average_cost,
       (SUM(sb.quantity_available) * sb.average_cost) AS total_value,
       sb.last_movement_date,
       w.warehouse_name
    FROM tblproduct p
    LEFT JOIN stock_balance sb ON sb.product_id = p.id
    LEFT JOIN warehouse w ON sb.warehouse_id = w.id
    WHERE p.org_id = :org_id";

    $params = ['org_id' => $org_id];

    // Dynamically add filters
    if (!empty($filters['search'])) {
        $sql .= " AND (p.name LIKE :search OR p.product_code LIKE :search OR p.category LIKE :search OR p.description LIKE :search)";
        $params['search'] = '%' . $filters['search'] . '%';
    }
    if (!empty($filters['is_active'])) {
        $sql .= " AND p.status = :status";
        $params['status'] = $filters['is_active'] ? 'active' : 'inactive';
    }
    if (!empty($filters['depot_id'])) {
        $sql .= " AND p.depot_id = :depot_id";
        $params['depot_id'] = $filters['depot_id'];
    }

    $sql .= " GROUP BY p.id ORDER BY p.datemodified DESC";

    // Prepare and execute
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    $products = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $products[] = $row;
    }

    $response['success'] = true;
    $response['message'] = 'Products fetched successfully';
    $response['details'] = $products;
    $response['count'] = count($products);

} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = $e->getMessage();
    error_log("List Products Error: " . $e->getMessage());
}

$conn = null;
echo json_encode($response);
