<?php
header('Content-Type: application/json');
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$response = ['success' => false, 'data' => []];

try {
    $product_id = $_GET['product_id'] ?? '';
    $warehouse_id = $_GET['warehouse_id'] ?? '';
    
    if (empty($product_id) || empty($warehouse_id)) {
        throw new Exception('Product ID and Warehouse ID are required');
    }
    
    $pdo = $conn;
    
    $sql = "
        SELECT 
            quantity_on_hand,
            quantity_allocated,
            quantity_available,
            average_cost,
            reorder_level
        FROM stock_balance 
        WHERE product_id = ? AND warehouse_id = ?
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$product_id, $warehouse_id]);
    $stock = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($stock) {
        $response['success'] = true;
        $response['data'] = $stock;
    } else {
        $response['success'] = true;
        $response['data'] = [
            'quantity_on_hand' => 0,
            'quantity_allocated' => 0,
            'quantity_available' => 0,
            'average_cost' => 0,
            'reorder_level' => 0
        ];
    }
    
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
?>