<?php
session_start();
header('Content-Type: application/json');
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$response = [
    'success' => false,
    'message' => '',
    'product_id' => null
];

try {
    // Get org and user from session
    $org_id = $_SESSION['orgid'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;

    // Receive all POST fields (matching your FormData)
    $product_code     = trim($_POST['product_code'] ?? '');
    $name             = trim($_POST['name'] ?? '');
    $description      = trim($_POST['description'] ?? '');
    $category         = trim($_POST['category'] ?? '');
    $sub_category     = trim($_POST['sub_category'] ?? '');
    $product_brand    = trim($_POST['product_brand'] ?? '');
    $product_type     = trim($_POST['product_type'] ?? '');
    $tracking_type    = trim($_POST['tracking_type'] ?? '');
    $price            = trim($_POST['price'] ?? '');
    $cost_price       = trim($_POST['cost_price'] ?? '');
    $tax_rate         = trim($_POST['tax_rate'] ?? 0);
   // $currency         = trim($_POST['currency'] ?? '');
    $units            = trim($_POST['units'] ?? '');
    $weight           = trim($_POST['weight'] ?? '');
    $dimensions       = trim($_POST['dimensions'] ?? '');
    $barcode          = trim($_POST['barcode'] ?? '');
    $color            = trim($_POST['color'] ?? '');
    $warranty_period  = trim($_POST['warranty_period'] ?? '');
    $status           = trim($_POST['status'] ?? '');

    // ✅ Validate required fields
    if ($name === '' || $product_code === '') {
        throw new Exception('Product name and code are required.');
    }

    // ✅ Handle Image Upload
    $imagePath = 'xd-assets/img/default.jpg'; // Default placeholder
    if (!empty($_FILES['product_image']['name'])) {
        $uploadDir = '../../../../xd-uploads/products/images/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        $fileInfo = pathinfo($_FILES['product_image']['name']);
        $fileExtension = strtolower($fileInfo['extension']);
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

        if (!in_array($fileExtension, $allowed)) {
            throw new Exception('Invalid image format. Only JPG, PNG, GIF, and WEBP allowed.');
        }

        if ($_FILES['product_image']['size'] > 5 * 1024 * 1024) {
            throw new Exception('Image too large. Max 5MB allowed.');
        }

        $newFileName = 'product_' . uniqid() . '.' . $fileExtension;
        $uploadPath = $uploadDir . $newFileName;

        if (move_uploaded_file($_FILES['product_image']['tmp_name'], $uploadPath)) {
            $imagePath = 'xd-uploads/products/images/' . $newFileName;
        } else {
            throw new Exception('Image upload failed.');
        }
    }

    // ✅ Start Transaction
    $conn->beginTransaction();

    // Check for duplicate product code
    $checkStmt = $conn->prepare("SELECT id FROM tblproduct WHERE product_code = :product_code AND org_id = :org_id");
    $checkStmt->execute([':product_code' => $product_code, ':org_id' => $org_id]);
    if ($checkStmt->rowCount() > 0) {
        throw new Exception('Product code already exists. Use a different code.');
    }

    // ✅ Insert into tblproduct
    $sql = "INSERT INTO tblproduct (
        name, product_code, image, description, category, sub_category, product_brand,
        product_type, tracking_type, price, cost, tax_rate, units, weight,
        dimensions, barcode, color, warranty, status, org_id, user_id, datemodified
    ) VALUES (
        :name, :product_code, :image, :description, :category, :sub_category, :product_brand,
        :product_type, :tracking_type, :price, :cost_price, :tax_rate, :units, :weight,
        :dimensions, :barcode, :color, :warranty_period, :status, :org_id, :user_id, NOW()
    )";

    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':name'             => $name,
        ':product_code'     => $product_code,
        ':image'            => $imagePath,
        ':description'      => $description,
        ':category'         => $category,
        ':sub_category'     => $sub_category,
        ':product_brand'    => $product_brand,
        ':product_type'     => $product_type,
        ':tracking_type'    => $tracking_type,
        ':price'            => $price,
        ':cost_price'       => $cost_price,
        ':tax_rate'         => $tax_rate,
       // ':currency'         => $currency,
        ':units'            => $units,
        ':weight'           => $weight,
        ':dimensions'       => $dimensions,
        ':barcode'          => $barcode,
        ':color'            => $color,
        ':warranty_period'  => $warranty_period,
        ':status'           => $status,
        ':org_id'           => $org_id,
        ':user_id'          => $user_id
    ]);

    $product_id = $conn->lastInsertId();
    $conn->commit();

    // ✅ Response
    $response['success'] = true;
    $response['message'] = 'Product created successfully';
    $response['product_id'] = $product_id;
    $response['product_code'] = $product_code;
    $response['image_path'] = $imagePath;

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    $response['success'] = false;
    $response['message'] = $e->getMessage();
    error_log('Product Creation Error: ' . $e->getMessage());
}

echo json_encode($response);
?>
