 function  requisitionsHeader(){
  let today = new Date().toISOString().slice(0, 10);
  $('#page-options').empty(); 
  $('#page-options').append('<select class="requisitionsSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="requisitionsList">All Requisitions</option></select> <span id="record01" class="topNavTotals"></span>');
 $('#right_nav_options0').empty();
  $('#right_nav_options0').append('<a href="#" id="bankAccountDepositIconDiv" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file depositSlipIcon1"></span></a>');
 
  $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
  $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102  w3-hide-small top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
 $('#right_nav_options0').append('<div id="exportTransactioins" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-share-2"></span></div>');
 $('#right_nav_options0').append('<div  class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
   $('#right_nav_options0').append('<div class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-upload"></span></div>');
  $('#right_nav_options0').append('<div class="top-right-navigation-icons101 createRequisitionst101"><span class="fontx fx-plus"></span></div>');
   $('#right_nav_options0').append('<div class="top-right-navigation-icons101 initialStockBalance101"><span class="fontx fx-edit-2"></span></div>');
  
  $('#sub_top_nav').empty(); 
  $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s7 w3-center"><input id="searchProductWarehouse101" type="text" placeholder="Type to search..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span><select id="revenueReportDisplayType" class="reduceSizeOnSmallScreen"  style="background-color:transparent;border:none;outline:none;color:gray;"><option value="Charts">Charts</option><option value="Normal">Normal</option><option value="Display All">Display All</option><option value="Map">Map</option></select></span><div/></div><div class="w3-col l5 m5 s3 w3-center" style="padding-left:7px;padding-top:3px;color:gray;background-color:;"><span style="float:right;"><input type="date" value="'+today+'" id="revenueReportStartDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/><input type="date" value="'+today+'" id="revenueReportEndDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/></span></div>');

 }
// Load warehouses on click
$(document).on('click', '.requisitions101', async function() { 
   requisitionsHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
  loadPurchaseRequisitions();
});


 //// GETING AND DISPLAYING REQUISITIONS//

// === Purchase Requisitions Dashboard ===
function loadPurchaseRequisitions() {
    const container = $("#main-body");
    container.html('<div style="text-align:center;padding:50px;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:var(--primary-color);"></i><p>Loading requisitions...</p></div>');

    $.ajax({
        url: "xd-modules/inventory/procurement/backend/get_purchase_requisitions.php",
        type: "GET",
        dataType: "json",
        success: function (data) {
            container.empty();

            if (data.success && data.data.length > 0) {
                // Render summary cards
                renderRequisitionSummary(container, data.data);

                // Render table
                renderRequisitionTable(container, data.data);
            } else {
                container.html(`
                    <div style="text-align:center;padding:50px;">
                        <span class="fontx fx-file-text" style="font-size:4em;color:#ccc;"></span>
                        <h3 style="color:gray;">No Requisitions Found</h3>
                        <p style="color:gray;">You have not created or received any purchase requisitions yet.</p>
                        <button class="createRequisitionst101" 
                            style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">
                            Create New Requisition
                        </button>
                    </div>
                `);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error loading requisitions:", error);
            container.html(`
                <div style="text-align:center;padding:50px;color:red;">
                    <span class="fontx fx-alert-triangle" style="font-size:3em;"></span>
                    <h3>Error Loading Requisitions</h3>
                    <p>${error}</p>
                    <button onclick="loadPurchaseRequisitions()" 
                        style="background-color:#f44336;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
                        Retry
                    </button>
                </div>
            `);
        }
    });
}

// === Render Summary Cards ===
function renderRequisitionSummary(container, data) {
    const total = data.length;
    const pending = data.filter(r => r.status === 'Pending').length;
    const approved = data.filter(r => r.status === 'Approved').length;
    const declined = data.filter(r => r.status === 'Declined').length;
    const totalValue = data.reduce((sum, r) => sum + (parseFloat(r.total_estimated) || 0), 0);

    container.append(`
        <div class="w3-row" style="margin-bottom:10px;margin-top:10px;">
            <!-- Total Requisitions -->
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Requisitions</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${total}</h2>
                </div>
            </div>

            <!-- Pending -->
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, gray 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Pending</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${pending}</h2>
                </div>
            </div>

            <!-- Approved -->
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, green 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Approved</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${approved}</h2>
                </div>
            </div>

            <!-- Declined -->
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, red 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Declined</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${declined}</h2>
                </div>
            </div>
 
            <div class="w3-col l4  m6 s12" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Estimated Value</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">K${totalValue.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</h2>
                </div>
            </div>
    

        </div>

        
    `);
}

// === Render Table ===
function renderRequisitionTable(container, data) {
    container.append(`
        <div style="background:transparent;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <!-- Table Header -->
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" 
                 style="font-weight:600;background:#f5f5f5;padding:15px 10px;">
                <div class="w3-col l1 m1 s12">RQ No.</div> 
                <div class="w3-col l1 m1 s12">Total</div>
                <div class="w3-col l2 m2 s12">Department</div>
                <div class="w3-col l3 m3 s12">Requested By</div>
                <div class="w3-col l1 m1 s12">Priority</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">Items</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">Progress</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Status</div>
                 <div class="w3-col l1 m1 s12">Actions</div>
            </div>
            <div id="requisition_table_body"></div>
        </div>
    `);

    const tbody = $("#requisition_table_body");
    data.forEach((r, i) => {
        const statusBadge = getStatusBadge(r.status);
        tbody.append(`
            <div class="inner-data-div w3-col l12 m12 s12" 
                 style="padding:0px 5px;border-bottom:1px solid #f0f0f0;cursor:pointer;"
                 data-id="${r.id}">
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:red;">${r.requisition_number}</div>
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:var(--primary-color);">K${parseFloat(r.total_estimated || 0).toLocaleString('en-US', {minimumFractionDigits:2})}</div>
                <div class="w3-col l2 m2 s12" style="font-weight:600;">${r.department || '-'}</div>
                 <div class="w3-col l3 m3 s12">${r.requested_by_name || '-'}</div>
                <div class="w3-col l1 m1 s12">${r.priority || '-'}</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">${r.item_count || 0}</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">Progress</div>

                <div class="w3-col l1 m1 s12" style="text-align:center;">${statusBadge}</div>

                  <div class="w3-col l1 m1 s3">
                <select class="innerDivProductSelectKey inner-data-more-actions2 hideOnPrint" 
                data-id="${r.id}" data-requisition-number="${r.requisition_number}">
                <option value="select-actions">⚙️ Actions</option>
                <option value="view-details">📊 Requisition Details</option> 
                <option value="transfer">🔄 Reveiews/Approvals</option> 
                <option value="delete">🗑️ Delete</option>
                <option value="activate">✅ Activate</option>
                <option value="suspend">🚫 Suspend</option>
                </select>
                </div>
            </div>
        `);
    });
}

// === Status Badge Helper ===
function getStatusBadge(status) {
    const map = {
        'Approved': '<span style="background:green;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Approved</span>',
        'Pending': '<span style="background:orange;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Pending</span>',
        'Declined': '<span style="background:red;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Declined</span>'
    };
    return map[status] || '<span style="background:gray;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Unknown</span>';
}

 // END OF GETING AND DISPLAYING REQUISITIONS// 



// CREATING REQUISITIONS // 
$(document).on('click', '.createRequisitionst101', async function() {
   createRequistion();
   addProductToReceipt101(); // calling the function  addProductToReceipt101() from xd-assets/js/products.js file
});
  
function createRequistion() {
     let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    shoppingCart.clearCart(); 
    invoiceCart.clearCart();
     invoicePaymentCart.clearCart();
  
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;margin-top:-30px;"></div>');
     // modal acttion buttons
     $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span> <div id="createRequisitionDiv02"><span class="createRequisition02" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> Create Requisition</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 penDiv101" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2 pen101" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
     // modal acttion buttons
 $('#invoice_modal_div_0').append(`
  <div class="w3-center w3-col l12 m12 s12 receiptTitles00">
  
       <div class="w3-center w3-col l12 m12 s12 org_logo_div"></div>
      <div class="w3-center w3-col l12 m12 s12"><b class="org_name" style="text-transform:uppercase"></b></div>
      <div class="w3-center w3-col l12 m12 s12 w3-hide-small pobox"></div>
      <div class="w3-center w3-col l12 m12 s12 w3-hide-small org_address" style="font-size: 0.7em;"></div>
      
     
`);
  $('#invoice_modal_div_0').append(`
    
    <div class="w3-col l12 m12 s12 receipt_modal_div_01" style="float:left;text-align:left;">
   
     <div class="w3-col l12 m12 s12">
     <h3 style="margin-top:40px;float:left">PURCHASE REQUISITION</h3>
     <div class="w3-col l12 m12 s12">
       Requisition N0: <input id="requisitionNumber"  class="clearOnTransactionSuccess" placeholder="0" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;color:red;"/>
     
     </div>
      <div class="w3-col l12 m12 s12">
       <select id="request-department" name="request-department"  style="border:none;"required>
        <option value="">Select Department</option>
     </select>
     </div>
    <div class="w3-col l12 m12 s12">
    Request Date: <input id="requestDate"  class="clearOnTransactionSuccess" placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
     </div>
    <div class="w3-col l12 m12 s12">
     Date Required: <input id="requestDate"  class="clearOnTransactionSuccess" placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
    </div>
     <div class="w3-col l12 m12 s12">
    
        <select id="request-priority" name="request-priority" style="border:none;" required>
        <option value="">Select Priority</option>
        <option value="low">Priority: 🟢 Low</option>
        <option value="medium" selected>Priority: 🟡 Medium</option>
        <option value="high"> Priority: 🟠 High</option>
        <option value="urgent">Priority: 🔴 Urgent</option>
        </select>
     </div>
    
      
        </div>
     <div>
    </div>
    
    `);
 
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:5px;background-color:rgba(96, 146, 205,0.2);font-weight:600;"><div class="w3-col l7 m7 s8" id="addProductToReceipt101"><span style="padding:7px;cursor:pointer;">Item/Product <span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Amount</div></div>');
       $('#invoice_modal_div_0').append('<div class="show-cart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.1);padding-left:7px;border-left:1px solid rgba(96, 146, 205,0.2);border-right:1px solid rgba(96, 146, 205,0.2);"></div>');
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.2);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l7 m7 s8"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="display:none;">00</div><div class="w3-col l1 m1 s3  w3-hide-small" style="color:transparent;">00</div><div class="w3-col l2 m2 s2 totalBilledAmounts" style="color:red;">00</div></div>');
      
       $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101"><textarea id="comment101" style="color:red;" placeholder="State the reason why this is needed..."></textarea></div>');
       $('#invoice_modal_div_0').append(`
        
        <p class="w3-col l12 m12 s12">
        <span style="float:left;margin-top: 0px;"> Requested By: 
         <span id="requestedBy354" style="padding-left:10px;padding-right:20px;text-transform:capitalize"></span>
         </span> 
       <span style="float:left;margin-top: 0px;"> Signature: 
       
       <span id="agentSignature" style="color:gray">______________________</span
       </span>
       </p>

       <div id="requisitionWorkflows" class="w3-col l12 m12 s12">
       
       </div>
       `);
      

$.getJSON('xd-modules/admin-modules/backend/getUserDeprtments.php', function(data) {
$.each(data.details, function(i, cyberdesk) {
$('#request-department').append(`<option value="${cyberdesk.id}" data-name="${cyberdesk.name}">Department: ${cyberdesk.name}</option>`);
});
});
   
// Fetch workflow roles dynamically
 
 
    // Load workflow automatically when form loads
    const workflowTableBody = document.getElementById("requisitionWorkflows");
    //const workflowIdField = document.getElementById("workflowId");
    fetchWorkflowSteps();

    function fetchWorkflowSteps() {
       const workflowType = "PURCHASE_REQUISITION"; // can be dynamic

        fetch(`xd-modules/inventory/stock-management/backend/get_requisition_workflows.php?type=${workflowType}`)
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                 //   workflowIdField.value = data.workflow_id;
                    renderWorkflowSteps(data.steps);
                } else {
                    workflowTableBody.innerHTML = `
                        <tr><td colspan="6" style="text-align:center;color:red;">${data.message || "No workflow found."}</td></tr>
                    `;
                }
            })
            .catch(err => {
                workflowTableBody.innerHTML = `
                    <tr><td colspan="6" style="text-align:center;color:red;">Error loading workflow: ${err.message}</td></tr>
                `;
            });
    }

    function renderWorkflowSteps(steps) {
        workflowTableBody.innerHTML = ""; // clear table first

        if (!steps || steps.length === 0) {
            workflowTableBody.innerHTML = `
                <tr><td colspan="6" style="text-align:center;">No workflow steps defined.</td></tr>
            `;
            return;
        }

        steps.forEach((step, index) => {
            const row = document.createElement("tr");
            row.innerHTML = `
                <td>${index + 1}</td>
                <td>${step.role_name || step.role || "-"}</td>
                <td>${step.approved_by || "-"}</td>
                <td>${step.approval_status || "Pending"}</td>
                <td>${step.approved_at ? new Date(step.approved_at).toLocaleString() : "__________________"}</td>
                <td>${step.is_final == 1 ? "✅ Final" : "-"}</td>
            `;
            workflowTableBody.appendChild(row);
        });
    }
 
 


     
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed
       

        ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.org_name').empty().append(user.orgname);              
                $('.org_email').empty().append(user.org_email);
                $('.org_contacts').empty().append(user.org_contacts);
                $('.org_address').empty().append(user.org_address); 
                $('.pobox').empty().append(user.org_p_o_box);
                $('#requestedBy354').empty().append(user.username); 
               // alert(user.username);
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                        class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        });
     
 $('.select2Styles').select2({
  //  placeholder: "Select an option",
    allowClear: false,
    width: '100%',
    dropdownParent: $('#invoice_modal') // ensures dropdown appears inside modal
});

}
 

$(document).on('click', '.createRequisition02', function (event) {
  event.preventDefault();
  event.stopPropagation(); 

  $('#createRequisitionDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"> <span style="color:rgba(96, 146, 205,1);margin-top:-20px;">Creating...</span></span>');
          
  // Gather data for the transaction

   // const requisitionNumber = 1;
    const department = $('#request-department').val();
    const priority = $('#request-priority').val();
    const requisitionDate = $('#requestDate').val();
    const requiredByDate = $('#requestDate').val(); // You can add another field if needed
    const justification = $('#comment101').val();
 
  // Get the cart list from invoicePaymentCart
  var cartlist = invoicePaymentCart.listCart();
  if (!cartlist || cartlist.length === 0) {
      cartlist = shoppingCart.listCart(); // Fallback if the cart is empty
  }
  var cartlistDetails = JSON.stringify(cartlist);

  // Calculate total sum of items/products
var totalAmount = 0;
if (cartlist && cartlist.length > 0) {
    totalAmount = cartlist.reduce(function(sum, item) {
        // Change 'total_charge' to the correct property if needed
        return sum + (parseFloat(item.total) || 0);
    }, 0);
}
 
  // Ensure that necessary fields are populated
if (
  requiredByDate && requiredByDate !== '0' &&
  justification && justification !== '0' //&&
 // cartlistDetails && cartlistDetails !== '[]' && totalAmount > 0
) {
    
      var datastring = 'requisitionDate=' + requisitionDate + '&requiredByDate=' + requiredByDate + '&justification=' + justification +
                       '&priority=' + priority + '&department=' + department + '&orderDetails=' + cartlistDetails;

  $.ajax({
    data: datastring,
    url: "xd-modules/inventory/procurement/backend/create_requisistion.php",
    type: "POST",
    dataType: "json", // ✅ ADD THIS LINE
})
.done(function (response) { // ✅ jQuery now passes parsed JSON
    if (response.status === 'created') {
        $('#createRequisitionDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Success</span></span>');
        
        document.getElementById('requisitionNumber').value = response.requisitionnumber;
        
        setTimeout(function() { 
            window.print(); 
            setTimeout(function(){ 
                $(".invoiceDivActions101").show();
                $('#createRequisitionDiv02').empty().append('<span class="createRequisition02" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> Create Requisition</span></span>');
            }, 700);
        }, 200);

    } else {
        $('#createRequisitionDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span>Failed try again!</span></span>');
    }
}).fail(function (error) {
          reject('Server error: ' + error); 
      });

  } else {
      alert('Please ensure dates and amount is not zero.');
      $('#createRequisition02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span>Failed try again!</span></span>');
    
    }
 


});

