// ========================================
// PURCHASE ORDERS MODULE
// File: xd-modules/inventory/procurement/js/purchase-orders.js
// ========================================

// === PO Header Navigation ===
function purchaseOrdersHeader() {
    let today = new Date().toISOString().slice(0, 10);
    $('#page-options').empty();
    $('#page-options').append('<select class="poSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="poList">All Purchase Orders</option></select> <span id="record01" class="topNavTotals"></span>');
    
    $('#right_nav_options0').empty();
    $('#right_nav_options0').append('<a href="#" id="bankAccountDepositIconDiv" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file depositSlipIcon1"></span></a>');
    $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
    $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102 w3-hide-small top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
    $('#right_nav_options0').append('<div id="exportTransactioins" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-share-2"></span></div>');
    $('#right_nav_options0').append('<div class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
    $('#right_nav_options0').append('<div class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-upload"></span></div>');
    $('#right_nav_options0').append('<div class="top-right-navigation-icons101 createPurchaseOrder101"><span class="fontx fx-plus"></span></div>');
    
    $('#sub_top_nav').empty();
    $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s7 w3-center"><input id="searchPO101" type="text" placeholder="Search PO..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span><select id="poDisplayType" class="reduceSizeOnSmallScreen" style="background-color:transparent;border:none;outline:none;color:gray;"><option value="Normal">Normal</option><option value="Charts">Charts</option></select></span></div><div class="w3-col l5 m5 s3 w3-center" style="padding-left:7px;padding-top:3px;color:gray;"><span style="float:right;"><input type="date" value="'+today+'" id="poStartDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/><input type="date" value="'+today+'" id="poEndDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/></span></div></div>');
}

// === Load POs on Menu Click ===
$(document).on('click', '.purchaseOrders101', async function() { 
    purchaseOrdersHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
    loadPurchaseOrders();
});

// === Load Purchase Orders ===
function loadPurchaseOrders() {
    const container = $("#main-body");
    container.html('<div style="text-align:center;padding:50px;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:var(--primary-color);"></i><p>Loading purchase orders...</p></div>');

    $.ajax({
        url: "xd-modules/inventory/procurement/backend/get_purchase_orders.php",
        type: "GET",
        dataType: "json",
        success: function (data) {
            container.empty();

            if (data.success && data.data.length > 0) {
                renderPOSummary(container, data.data);
                renderPOTable(container, data.data);
            } else {
                container.html(`
                    <div style="text-align:center;padding:50px;">
                        <span class="fontx fx-shopping-cart" style="font-size:4em;color:#ccc;"></span>
                        <h3 style="color:gray;">No Purchase Orders Found</h3>
                        <p style="color:gray;">You have not created any purchase orders yet.</p>
                        <button class="createPurchaseOrder101" 
                            style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">
                            Create Purchase Order
                        </button>
                    </div>
                `);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error loading POs:", error);
            container.html(`
                <div style="text-align:center;padding:50px;color:red;">
                    <span class="fontx fx-alert-triangle" style="font-size:3em;"></span>
                    <h3>Error Loading Purchase Orders</h3>
                    <p>${error}</p>
                    <button onclick="loadPurchaseOrders()" 
                        style="background-color:#f44336;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
                        Retry
                    </button>
                </div>
            `);
        }
    });
}

// === Render PO Summary Cards ===
function renderPOSummary(container, data) {
    const total = data.length;
    const draft = data.filter(p => p.status === 'Draft').length;
    const sent = data.filter(p => p.status === 'Sent').length;
    const received = data.filter(p => p.status === 'Received').length;
    const totalValue = data.reduce((sum, p) => sum + (parseFloat(p.grand_total) || 0), 0);

    container.append(`
        <div class="w3-row" style="margin-bottom:10px;margin-top:10px;">
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Total POs</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${total}</h2>
                </div>
            </div>
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, orange 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Draft</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${draft}</h2>
                </div>
            </div>
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, blue 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Sent</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${sent}</h2>
                </div>
            </div>
            <div class="w3-col l2 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, green 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Received</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${received}</h2>
                </div>
            </div>
            <div class="w3-col l4 m6 s12" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Value</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">K${totalValue.toLocaleString('en-US', {minimumFractionDigits: 2})}</h2>
                </div>
            </div>
        </div>
    `);
}

// === Render PO Table ===
function renderPOTable(container, data) {
    container.append(`
        <div style="background:transparent;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" 
                 style="font-weight:600;background:#f5f5f5;padding:15px 10px;">
                <div class="w3-col l1 m1 s12">PO No.</div>
                <div class="w3-col l2 m2 s12">Supplier</div>
                <div class="w3-col l1 m1 s12">PO Date</div>
                <div class="w3-col l1 m1 s12">Delivery</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">Items</div>
                <div class="w3-col l2 m2 s12" style="text-align:right;">Total</div>
                <div class="w3-col l2 m2 s12">Created By</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Status</div>
                <div class="w3-col l1 m1 s12">Actions</div>
            </div>
            <div id="po_table_body"></div>
        </div>
    `);

    const tbody = $("#po_table_body");
    data.forEach((po) => {
        const statusBadge = getPOStatusBadge(po.status);
        tbody.append(`
            <div class="inner-data-div w3-col l12 m12 s12" 
                 style="padding:0px 5px;border-bottom:1px solid #f0f0f0;cursor:pointer;"
                 data-id="${po.id}">
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:red;">${po.po_number}</div>
                <div class="w3-col l2 m2 s12" style="font-weight:600;">${po.supplier_name || '-'}</div>
                <div class="w3-col l1 m1 s12">${po.po_date || '-'}</div>
                <div class="w3-col l1 m1 s12">${po.expected_delivery_date || '-'}</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">${po.item_count || 0}</div>
                <div class="w3-col l2 m2 s12" style="text-align:right;font-weight:600;color:var(--primary-color);">K${parseFloat(po.grand_total || 0).toLocaleString('en-US', {minimumFractionDigits:2})}</div>
                <div class="w3-col l2 m2 s12">${po.created_by_name || '-'}</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">${statusBadge}</div>
                <div class="w3-col l1 m1 s12">
                    <select class="innerDivPOSelectKey inner-data-more-actions2 hideOnPrint" 
                        data-id="${po.id}" data-po-number="${po.po_number}">
                        <option value="select-actions">⚙️ Actions</option>
                        <option value="view-details">📊 View Details</option>
                        <option value="edit">✏️ Edit</option>
                        <option value="send-email">📧 Send to Supplier</option>
                        <option value="receive-goods">📦 Receive Goods (GRN)</option>
                        <option value="print">🖨️ Print</option>
                        <option value="delete">🗑️ Delete</option>
                    </select>
                </div>
            </div>
        `);
    });
}

// === Status Badge Helper ===
function getPOStatusBadge(status) {
    const map = {
        'Draft': '<span style="background:gray;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Draft</span>',
        'Sent': '<span style="background:blue;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Sent</span>',
        'Partially Received': '<span style="background:orange;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Partial</span>',
        'Received': '<span style="background:green;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Received</span>',
        'Cancelled': '<span style="background:red;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Cancelled</span>'
    };
    return map[status] || '<span style="background:gray;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Unknown</span>';
}

// ========================================
// CREATE PURCHASE ORDER MODAL
// ========================================

$(document).on('click', '.createPurchaseOrder101', async function() {
    const requisitionId = $(this).data('requisition-id') || null;
    createPurchaseOrderModal(requisitionId);
   // addProductToReceipt101(); // From products.js
});

 

function createPurchaseOrderModal(requisitionId = null) {
     let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    shoppingCart.clearCart(); 
    invoiceCart.clearCart();
     invoicePaymentCart.clearCart();
  
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;margin-top:50px;"></div>');
     // modal acttion buttons
     $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span> <div id="invoicePaymentDiv02"><span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Make Bank Payment</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 penDiv101" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2 pen101" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
     // modal acttion buttons
 $('#invoice_modal_div_0').append(`
  <div class="w3-col l12 m12 s12">
  
  <div class="w3-col l8 m8 s12" style="background-color:transparent;float:left;text-align:left">
      <div class="w3-col l1 m1 s12 po-org_logo_div w3-center" style="margin-top:-30px;"></div>
       <div class="w3-col l11 m11 s12" style="float:left !important;padding-left:30px;">
    
      <div class="w3-col l12 m12 s12"><b class="po-org_name" style="text-transform:uppercase;font-size:1.5em;"></b></div>
     <div class="w3-col l12 m12 s12 w3-hide-small po-org_contacts" style="font-size:1em;"></div>
    <div class="w3-col l12 m12 s12 w3-hide-small po-po-pobox" style="font-size:1em;"></div>
      <div class="w3-col l12 m12 s12 w3-hide-small po-org_address" style="font-size:1em;"></div>
      
       </div>

             <h1 style="color:var(--primary-color);margin-bottom:0px;"> PURCHASE ORDER </h1>
           
            <span id="receiptTitle00" style="font-size:1em">PO #: </span>
            <span id="poNumberr" style="color:red;font-weight:400;font-size:1em">Auto-Generated</span>
            </br>
            
           
    
  </div>

            <div class="w3-col l4 m4 s12" style="margin-top:0px;margin-bottom:0px;float:left !important;text-align:left;">

            <div class="w3-col l12 m12 s12" style="margin-left:5px;">
      
            
            <b>DATE: </b><input id="poDate"  placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
             </br>
             <b>DELIVERY DATE: </b><input id="poDeliveryDate"  placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
           </br>
            <div class="w3-col l12 m12 s12">
            <b>PAYMENT MODE:</b>
            <select style="outline: none;margin-bottom:0px;color:black;margin-top:0px;border:none;font-weight:400;font-size:1em;background-color: transparent;text-indent: 0.01px;text-transform:capitalize;">
            <option value="BANK TRANSFER"> Any Form</option>
            <option value="BANK TRANSFER">Bank Transfer</option>
            <option value="MOMO"> Mobile Money</option>
            <option value="CASH"> Cash Payment</option>
            <option value="BANK"></b>Bank Deposit</option>
            </select>
                
            </div>

            <div class="w3-col l12 m12 s12">
            <b>PAYMENT TERM:</b>
            <select style="outline: none;margin-bottom:0px;color:black;margin-top:0px;border:none;font-weight:400;font-size:1em;background-color: transparent;text-indent: 0.01px;text-transform:capitalize;">
            <option value="Payment on Delivery">Payment on Delivery</option>        
            <option value="Net 30">Net 30 Days</option>
            <option value="Net 60">Net 60 Days</option>

            <option value="Advance Payment">Advance Payment</option>

            </select>

            </div>
              <div class="w3-col l12 m12 s12">
                   <b>DEPARTMENT:</b>
                    <select id="po-department" style="font-weight:400;border:none;">
                        <option value="1" selected>Select</option> 
                    </select>
                </div>
           <div class="w3-col l12 m12 s12">
                   <b>STATUS:</b>
                    <select id="po-priority" style="font-weight:400;border:none;">
                        <option value="draf" selected>Draft</option>
                        <option value="high">Paid</option>
                        <option value="urgent">Delivered</option>
                    </select>
                </div>
                <div class="w3-col l12 m12 s12">
                   <b>PRIORITY:</b>
                    <select id="po-priority" style="font-weight:400;border:none;">
                        <option value="normal" selected>Normal</option>
                        <option value="high">Priority: High</option>
                        <option value="urgent">Priority: Urgent</option>
                    </select>
                </div>
                <div class="w3-col l12 m12 s12">
                 <span style="">REQUISITION #: </span><input id="requisitionNumber01"  value="00000" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
             </div>

        </div>
    </div>
</div>
`);



  $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 receipt_modal_div_01" style="background-color:rgba(96, 146, 205,0.1);margin-top:0px;"></div>');
 


  $('.receipt_modal_div_01').append('<div class="w3-col l8 m8 s12 style="padding-right: 0px;padding-left:8px;"><span class="w3-col l6 m6 s8" style="margin-top:0px;font-weight: 600;"> <div class="w3-col l12 m12 s12"><select id="po-vendor" class="select2Styles" style="font-weight:400;border:none;background-color:transparent;width:100%;"><option value="1" selected>SELECT SUPPLIER</option></select> </div> </span><span class="w3-col l6 m6 s12" style="display:none;"><span style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="po-vendor-address" Placeholder="Enter Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><span class="w3-col l12 m12 s4"  style="margin-top:0px;"><input id="po-vendor-email" Placeholder="Enter Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 style="margin-top:0px;"><input id="po-vendor-phone" placeholder="Enter Phone No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span><span class="w3-col l12 m12 s4 style="margin-top:0px;"><input id="po-vendor-tpin" placeholder="Enter Tax Pin No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
 

  $('.receipt_modal_div_01').append('<div class="w3-col l4 m4 s12 style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" style="margin-top:0px;font-weight: 600;"> <div class="w3-col l12 m12 s12"><select id="po-deliverplace" class="select2Styles" style="font-weight:400;border:none;background-color:transparent;width:100%;"><option value="1" selected>SELECT DELIVERY PLACE</option></select> </div> </span><span class="w3-col l6 m6 s12" style="display:none;"><span style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="po-delivery-address" Placeholder="Enter Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><span class="w3-col l12 m12 s4"  style="margin-top:0px;"><input id="po-delivery-email" Placeholder="Enter Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 style="margin-top:0px;"><input id="po-delivery-phone" placeholder="Enter Phone No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
 
 
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:5px;background-color:rgba(96, 146, 205,0.2);font-weight:600;"><div class="w3-col l7 m7 s8" id="addProductToReceipt101"><span style="padding:7px;cursor:pointer;">Item/Product <span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Amount</div></div>');
       $('#invoice_modal_div_0').append('<div class="show-cart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.1);padding-left:7px;border-left:1px solid rgba(96, 146, 205,0.2);border-right:1px solid rgba(96, 146, 205,0.2);"></div>');
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.2);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l7 m7 s8"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="display:none;">00</div><div class="w3-col l1 m1 s3  w3-hide-small" style="color:transparent;">00</div><div class="w3-col l2 m2 s2 totalBilledAmounts" style="color:red;">00</div></div>');
      
       $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
       $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Prepared by: <span class="preparedBy" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
      
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed
      
        $('#invoicePaymentDiv02').empty().append('<span class="createPurchaseOrderBtn" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> CREATE PURCHASE ORDER</span></span>');
      
     
    

        ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.po-org_name').empty().append(user.orgname);              
                $('.po-org_email').empty().append(user.org_email);
                $('.po-org_contacts').empty().append(user.org_contacts);
                $('.po-org_address').empty().append(user.org_address); 
                $('.po-po-pobox').empty().append(user.org_p_o_box);
                $('.preparedBy').empty().append(user.username); 
    
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                         class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.po-org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        
        });
     
        // Load vendors into the dropdown
// Load vendors into the dropdown
 // Fetch vendor list
$.ajax({
    url: "xd-modules/inventory/procurement/backend/allSuppliers.php", // replace with your actual PHP endpoint
    method: "GET",
    dataType: "json",
    success: function (response) {
        console.log("Vendors:", response);

        const vendorSelect = $("#po-vendor");
        vendorSelect.empty(); // clear previous options
        vendorSelect.append('<option value="">SELECT VENDOR</option>');

        if (response.details && response.details.length > 0) {
            response.details.forEach(vendor => {
                vendorSelect.append(
                    `<option value="${vendor.id}" 
                        data-address="${vendor.supplier_address}" 
                        data-email="${vendor.supplier_email}" 
                        data-phone="${vendor.supplier_phone}" 
                        data-tpin="${vendor.tax_id}">
                        SUPPLIER: ${vendor.company_name || vendor.supplier_name}
                    </option>`
                );
            });
        } else {
            vendorSelect.append('<option value="">No vendors found</option>');
        }
    },
    error: function (xhr, status, error) {
        console.error("Error fetching vendors:", error);
    }
});

// Auto-fill vendor details when selected
$(document).on("change", "#po-vendor", function () {
    const selected = $(this).find("option:selected");

    $("#po-vendor-address").val(selected.data("address") || "");
    $("#po-vendor-email").val(selected.data("email") || "");
    $("#po-vendor-phone").val(selected.data("phone") || "");
    $("#po-vendor-tpin").val(selected.data("tpin") || "");
});



    $.getJSON('xd-modules/admin-modules/backend/getUserDeprtments.php', function(data) {
$.each(data.details, function(i, cyberdesk) {
$('#po-department').append(`<option value="${cyberdesk.id}" data-name="${cyberdesk.name}">${cyberdesk.name}</option>`);
});
});
// Load warehouses into the dropdown
$.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
    if (data.success && data.details) {
        const $select = $('#po-deliverplace');
        $select.empty().append('<option value="">Select Delivery Place</option>');
        $.each(data.details, function(i, warehouse) {
            $select.append(`
                <option value="${warehouse.id}" data-phon="${warehouse.phone}" data-email="${warehouse.email}" data-address="${warehouse.address}">DELIVER TO:  ${warehouse.warehouse_name}</option>
            `);
        });
    }
});

// Handle change event to populate phone/email
$(document).on('change', '#po-deliverplace', function() {
    const selected = $(this).find(':selected');
    const phone = selected.data('phon') || '';
    const email = selected.data('email') || '';
     const address = selected.data('address') || '';
    $('#po-delivery-address').val(address);
    $('#po-delivery-phone').val(phone);
    $('#po-delivery-email').val(email);
});


  $('.select2Styles').select2({
  //  placeholder: "Select an option",
    allowClear: false,
   // width: '100%',
    dropdownParent: $('#invoice_modal') // ensures dropdown appears inside modal
});


}


// === Load Requisition Items (Convert to PO) ===
function loadRequisitionItems(requisitionId) {
    $.ajax({
        url: `xd-modules/inventory/procurement/backend/get_requisition_details.php?id=${requisitionId}`,
        type: "GET",
        dataType: "json",
        success: function(data) {
            if (data.success && data.items) {
                // Clear cart first
                shoppingCart.clearCart();
                
                // Add items to cart
                data.items.forEach(item => {
                    shoppingCart.addItemToCart(
                        item.product_name,
                        item.estimated_unit_price,
                        item.quantity_requested,
                        item.product_id
                    );
                });
                
                // Refresh cart display
                displayCart();
            }
        }
    });
}
 

// ========================================
// CREATE PURCHASE ORDER - SUBMIT
// ========================================
//  
 
 $(document).on('click', '.createPurchaseOrderBtn', function (event) {
    event.preventDefault();
    event.stopPropagation();

    // Show temporary loader
    $('#invoicePaymentDiv02').empty().append(`
        <span style="float:right;cursor:pointer;margin-left:3px;height:40px;
        font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);">
        <span>Creating...</span></span>
    `);

    // === Collect form data ===
    const requisitionNumber = $('#requisitionNumber01').val(); 
    const supplierId = $('#po-vendor').val(); 
    const supplierName = $('#invoicedClientName0').val();
    const poDate = $('#poDate').val();
    const deliveryDate = $('#poDeliveryDate').val();
    const paymentMode = $('#paymentMode').val() || 'Cash';
    const paymentTerm = $('#paymentTerm').val() || 'Immediate';
    const status = $('#po-status').val() || 'Draft';
    const priority = $('#po-priority').val() || 'Normal';
    const justification = $('#comment101').val() || '';
    const deliverplace = $('#po-deliverplace').val() || '';
    const departmentId = $('#po-department').val() || '';
   // === Collect cart data ===
    let cartlist = invoicePaymentCart.listCart();
    if (!cartlist || cartlist.length === 0) {
        cartlist = shoppingCart.listCart();
    }

    if (!cartlist.length) {
        alert('Please enter supplier and add at least one item.');
        resetCreateButton();
        return;
    }

    const orderDetails = JSON.stringify(cartlist);

    // === Prepare data ===
    const datastring = {
        departmentId: departmentId,
        requisitionNumber: requisitionNumber,
        supplierId: supplierId,
        supplierName: supplierName,
        poDate: poDate,
        deliveryDate: deliveryDate,
        paymentMode: paymentMode,
        paymentTerm: paymentTerm,
        status: status,
        priority: priority,
        justification: justification,
        deliverplace: deliverplace,
        orderDetails: orderDetails
    };

    // === Send to PHP ===
    $.ajax({
        url: 'xd-modules/inventory/procurement/backend/create_purchase_order.php',
        type: 'POST',
        data: datastring,
        dataType: 'json',
        success: function (response) {
            if (response.status === 'created') {
                $('#poNumberr').text(response.po_number);
                $('#invoicePaymentDiv02').html(`
                    <span style="float:right;cursor:pointer;margin-left:3px;height:40px;
                    font-size:0.9em;padding:10px;color:white;background-color:green;">Created!</span>
                `);

                setTimeout(function() { 
                    window.print(); 
                    setTimeout(function(){ 
                        $('#invoicePaymentDiv02').html(`
                            <span class="createPurchaseOrderBtn" 
                            style="float:right;cursor:pointer;margin-left:3px;height:40px;
                            font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);">
                            <span>CREATE PURCHASE ORDER</span></span>
                        `);
                    }, 700);
                }, 200);

            } else {
                alert('Failed: ' + (response.message || 'Unknown error'));
                resetCreateButton();
            }
        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            alert('An error occurred while creating the Purchase Order.');
            resetCreateButton();
        }
    });

    // Reusable function to restore the button
    function resetCreateButton() {
        $('#invoicePaymentDiv02').html(`
            <span class="createPurchaseOrderBtn" 
            style="float:right;cursor:pointer;margin-left:3px;height:40px;
            font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);">
            <span>CREATE PURCHASE ORDER</span></span>
        `);
    }
});


// ========================================
// CONVERT REQUISITION TO PO
// ========================================

// Add "Convert to PO" button in requisition details/actions
$(document).on('click', '.convertRequisitionToPO', function() {
    const requisitionId = $(this).data('requisition-id');
    
    if (!requisitionId) {
        alert('Invalid requisition ID');
        return;
    }

    // Check if requisition is approved
    $.ajax({
        url: `xd-modules/inventory/procurement/backend/get_requisition_details.php?id=${requisitionId}`,
        type: "GET",
        dataType: "json",
        success: function(data) {
            if (data.success) {
                if (data.requisition.status !== 'Approved') {
                    alert('Only approved requisitions can be converted to Purchase Orders.');
                    return;
                }
                
                // Open PO modal with requisition data
                createPurchaseOrderModal(requisitionId);
                addProductToReceipt101();
            }
        }
    });
});

// ========================================
// HANDLE PO DROPDOWN ACTIONS
// ========================================

$(document).on('change', '.innerDivPOSelectKey', function() {
    const action = $(this).val();
    const poId = $(this).data('id');
    const poNumber = $(this).data('po-number');

    if (action === 'view-details') {
        viewPODetails(poId);
    } else if (action === 'edit') {
        editPO(poId);
    } else if (action === 'send-email') {
        sendPOToSupplier(poId);
    } else if (action === 'receive-goods') {
        receiveGoods(poId); // This will be GRN functionality
    } else if (action === 'print') {
        printPO(poId);
    } else if (action === 'delete') {
        if (confirm(`Delete Purchase Order ${poNumber}?`)) {
            deletePO(poId);
        }
    }

    // Reset dropdown
    $(this).val('select-actions');
});

// === View PO Details ===
function viewPODetails(poId) {
    $.ajax({
        url: `xd-modules/inventory/procurement/backend/get_po_details.php?id=${poId}`,
        type: "GET",
        dataType: "json",
        success: function(data) {
            if (data.success) {
                displayPODetailsModal(data.po, data.items);
            } else {
                alert('Failed to load PO details: ' + data.message);
            }
        },
        error: function() {
            alert('Error loading PO details');
        }
    });
}

// === Display PO Details Modal ===
function displayPODetailsModal(po, items) {
    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:999999999;"></div>');
    
    $('#invoice_modal').append(`
        <div style="background-color:white;max-width:900px;margin:50px auto;padding:30px;border-radius:10px;max-height:90vh;overflow-y:auto;">
            <span class="close_invoice_modal" style="float:right;cursor:pointer;font-size:2em;color:red;">&times;</span>
            
            <h2 style="color:var(--primary-color);">Purchase Order Details</h2>
            <hr/>
            
            <div style="margin-bottom:20px;">
                <p><strong>PO Number:</strong> <span style="color:red;font-weight:600;">${po.po_number}</span></p>
                <p><strong>Supplier:</strong> ${po.supplier_name}</p>
                <p><strong>PO Date:</strong> ${po.po_date}</p>
                <p><strong>Expected Delivery:</strong> ${po.expected_delivery_date || '-'}</p>
                <p><strong>Payment Terms:</strong> ${po.payment_terms || '-'}</p>
                <p><strong>Priority:</strong> ${po.priority || 'Normal'}</p>
                <p><strong>Status:</strong> ${getPOStatusBadge(po.status)}</p>
                <p><strong>Created By:</strong> ${po.created_by_name}</p>
            </div>

            <h4>Order Items</h4>
            <table style="width:100%;border-collapse:collapse;">
                <thead>
                    <tr style="background:#f5f5f5;">
                        <th style="padding:10px;border:1px solid #ddd;text-align:left;">Product</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:right;">Qty</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:right;">Unit Price</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:right;">Total</th>
                    </tr>
                </thead>
                <tbody id="poItemsTableBody"></tbody>
            </table>

            <div style="margin-top:20px;text-align:right;">
                <p><strong>Subtotal:</strong> K${parseFloat(po.subtotal).toFixed(2)}</p>
                <p><strong>Tax:</strong> K${parseFloat(po.tax_amount).toFixed(2)}</p>
                <p><strong>Discount:</strong> K${parseFloat(po.discount_amount).toFixed(2)}</p>
                <p><strong>Shipping:</strong> K${parseFloat(po.shipping_cost).toFixed(2)}</p>
                <h3 style="color:red;"><strong>Grand Total:</strong> K${parseFloat(po.grand_total).toFixed(2)}</h3>
            </div>

            ${po.notes ? `<div style="margin-top:20px;"><strong>Notes:</strong><p style="background:#f9f9f9;padding:10px;border-left:3px solid var(--primary-color);">${po.notes}</p></div>` : ''}

            <div style="margin-top:30px;text-align:center;">
                <button onclick="$('#invoice_modal').fadeOut();" style="background-color:gray;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-right:10px;">Close</button>
                <button onclick="printPO(${po.id})" style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">Print PO</button>
            </div>
        </div>
    `);

    // Populate items table
    const tbody = $('#poItemsTableBody');
    items.forEach(item => {
        tbody.append(`
            <tr>
                <td style="padding:10px;border:1px solid #ddd;">${item.product_name}</td>
                <td style="padding:10px;border:1px solid #ddd;text-align:right;">${item.quantity}</td>
                <td style="padding:10px;border:1px solid #ddd;text-align:right;">K${parseFloat(item.unit_price).toFixed(2)}</td>
                <td style="padding:10px;border:1px solid #ddd;text-align:right;">K${parseFloat(item.line_total).toFixed(2)}</td>
            </tr>
        `);
    });

    $('#invoice_modal').fadeIn('slow');
}

// === Print PO ===
function printPO(poId) {
    // Implement print functionality or redirect to print view
    window.open(`xd-modules/inventory/procurement/print_po.php?id=${poId}`, '_blank');
}

// === Send PO to Supplier ===
function sendPOToSupplier(poId) {
    if (confirm('Send this Purchase Order to the supplier via email?')) {
        $.ajax({
            url: 'xd-modules/inventory/procurement/backend/send_po_email.php',
            type: 'POST',
            data: { po_id: poId },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert('Purchase Order sent successfully!');
                } else {
                    alert('Failed to send email: ' + response.message);
                }
            },
            error: function() {
                alert('Error sending email');
            }
        });
    }
}

// === Delete PO ===
function deletePO(poId) {
    $.ajax({
        url: 'xd-modules/inventory/procurement/backend/delete_po.php',
        type: 'POST',
        data: { po_id: poId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert('Purchase Order deleted successfully');
                loadPurchaseOrders(); // Reload list
            } else {
                alert('Failed to delete: ' + response.message);
            }
        }
    });
}

// === Receive Goods (GRN) - Placeholder ===
function receiveGoods(poId) {
    alert('Goods Receipt (GRN) functionality will be implemented next!');
    // This will be the next module we build
}