// ========================================
// GOODS RECEIPT (GRN) MODULE
// File: Add to your procurement JavaScript file
// ========================================

// === GRN Header Navigation ===
function goodsReceiptHeader() {
    let today = new Date().toISOString().slice(0, 10);
    $('#page-options').empty();
    $('#page-options').append('<select class="grnSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="grnList">All Goods Receipts</option></select> <span id="record01" class="topNavTotals"></span>');
    
    $('#right_nav_options0').empty();
    $('#right_nav_options0').append('<a href="#" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file"></span></a>');
    $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
    $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102 top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
    $('#right_nav_options0').append('<div class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
    $('#right_nav_options0').append('<div class="top-right-navigation-icons101 createGoodsReceipt101"><span class="fontx fx-plus"></span></div>');
    
    $('#sub_top_nav').empty();
    $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s7 w3-center"><input id="searchGRN101" type="text" placeholder="Search GRN..." style="font-weight:400;outline:none;color:black;border:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-pie-chart" style="color:var(--primary-color);"></span><select id="grnDisplayType" style="background-color:transparent;border:none;outline:none;color:gray;"><option value="Normal">Normal</option><option value="Charts">Charts</option></select></span></div><div class="w3-col l5 m5 s3 w3-center" style="padding-left:7px;padding-top:3px;"><span style="float:right;"><input type="date" value="'+today+'" id="grnStartDate" style="color:var(--primary-color);border:none;outline:none;background-color:transparent;"/><input type="date" value="'+today+'" id="grnEndDate" style="color:var(--primary-color);border:none;outline:none;background-color:transparent;"/></span></div></div>');
}

// === Load GRNs on Menu Click ===
$(document).on('click', '.goodsReceipt101', async function() { 
    goodsReceiptHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
    loadGoodsReceipts();
});

// === Load Goods Receipts List ===
function loadGoodsReceipts() {
    const container = $("#main-body");
    container.html('<div style="text-align:center;padding:50px;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:var(--primary-color);"></i><p>Loading goods receipts...</p></div>');

    $.ajax({
        url: "xd-modules/inventory/procurement/backend/get_goods_receipts.php",
        type: "GET",
        dataType: "json",
        success: function (data) {
            container.empty();

            if (data.success && data.data.length > 0) {
                renderGRNSummary(container, data.data);
                renderGRNTable(container, data.data);
            } else {
                container.html(`
                    <div style="text-align:center;padding:50px;">
                        <span class="fontx fx-package" style="font-size:4em;color:#ccc;"></span>
                        <h3 style="color:gray;">No Goods Receipts Found</h3>
                        <p style="color:gray;">You have not received any goods yet.</p>
                        <button class="createGoodsReceipt101" 
                            style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">
                            Receive Goods
                        </button>
                    </div>
                `);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error loading GRNs:", error);
            container.html(`
                <div style="text-align:center;padding:50px;color:red;">
                    <span class="fontx fx-alert-triangle" style="font-size:3em;"></span>
                    <h3>Error Loading Goods Receipts</h3>
                    <p>${error}</p>
                </div>
            `);
        }
    });
}

// === Render GRN Summary Cards ===
function renderGRNSummary(container, data) {
    const total = data.length;
    const pending = data.filter(g => g.status === 'Pending').length;
    const completed = data.filter(g => g.status === 'Completed').length;
    const totalValue = data.reduce((sum, g) => sum + (parseFloat(g.total_amount) || 0), 0);

    container.append(`
        <div class="w3-row" style="margin-bottom:10px;margin-top:10px;">
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Total GRNs</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${total}</h2>
                </div>
            </div>
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, orange 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Pending</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${pending}</h2>
                </div>
            </div>
            <div class="w3-col l3 m6 s6" style="padding:5px;">
                <div style="background:linear-gradient(135deg, green 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Completed</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">${completed}</h2>
                </div>
            </div>
            <div class="w3-col l3 m6 s12" style="padding:5px;">
                <div style="background:linear-gradient(135deg, var(--primary-color) 0%, white 100%);color:white;padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,0.1);">
                    <p style="margin:0;opacity:0.9;font-size:0.9em;">Total Value</p>
                    <h2 style="margin:10px 0 0 0;font-size:2em;">K${totalValue.toLocaleString('en-US', {minimumFractionDigits: 2})}</h2>
                </div>
            </div>
        </div>
    `);
}

// === Render GRN Table ===
function renderGRNTable(container, data) {
    container.append(`
        <div style="background:transparent;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" 
                 style="font-weight:600;background:#f5f5f5;padding:15px 10px;">
                <div class="w3-col l1 m1 s12">GRN No.</div>
                <div class="w3-col l1 m1 s12">PO No.</div>
                <div class="w3-col l2 m2 s12">Supplier</div>
                <div class="w3-col l2 m2 s12">Warehouse</div>
                <div class="w3-col l1 m1 s12">Date</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">Items</div>
                <div class="w3-col l2 m2 s12" style="text-align:right;">Amount</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">Status</div>
                <div class="w3-col l1 m1 s12">Actions</div>
            </div>
            <div id="grn_table_body"></div>
        </div>
    `);

    const tbody = $("#grn_table_body");
    data.forEach((grn) => {
        const statusBadge = getGRNStatusBadge(grn.status);
        tbody.append(`
            <div class="inner-data-div w3-col l12 m12 s12" 
                 style="padding:0px 5px;border-bottom:1px solid #f0f0f0;cursor:pointer;">
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:red;">${grn.grn_number}</div>
                <div class="w3-col l1 m1 s12" style="font-weight:600;color:blue;">${grn.po_number || '-'}</div>
                <div class="w3-col l2 m2 s12">${grn.supplier_name || '-'}</div>
                <div class="w3-col l2 m2 s12">${grn.warehouse_name || '-'}</div>
                <div class="w3-col l1 m1 s12">${grn.receipt_date || '-'}</div>
                <div class="w3-col l1 m1 s12" style="text-align:right;">${grn.item_count || 0}</div>
                <div class="w3-col l2 m2 s12" style="text-align:right;font-weight:600;color:var(--primary-color);">K${parseFloat(grn.total_amount || 0).toLocaleString('en-US', {minimumFractionDigits:2})}</div>
                <div class="w3-col l1 m1 s12" style="text-align:center;">${statusBadge}</div>
                <div class="w3-col l1 m1 s12">
                    <select class="innerDivGRNSelectKey inner-data-more-actions2 hideOnPrint" 
                        data-id="${grn.id}">
                        <option value="select-actions">⚙️ Actions</option>
                        <option value="view-details">📊 View Details</option>
                        <option value="print">🖨️ Print</option>
                    </select>
                </div>
            </div>
        `);
    });
}

// === Status Badge Helper ===
function getGRNStatusBadge(status) {
    const map = {
        'Completed': '<span style="background:green;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Completed</span>',
        'Pending': '<span style="background:orange;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Pending</span>',
        'Partial': '<span style="background:blue;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Partial</span>'
    };
    return map[status] || '<span style="background:gray;color:white;padding:3px 8px;border-radius:12px;font-size:0.8em;">Unknown</span>';
}

// ========================================
// CREATE GOODS RECEIPT MODAL
// ========================================

$(document).on('click', '.createGoodsReceipt101', async function() {
    const purchaseOrderId = $(this).data('purchaseorder-id') || null;
    createGoodsReceiptModal();
});

/*
function createGoodsReceiptModal() {
    let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    
    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
    $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;margin-top:50px;"></div>');
    
    // Modal action buttons
    $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span> <div id="invoicePaymentDiv02"><span class="createGoodsReceiptBtn" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span>RECEIVE GOODS</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span></div>');
    
    // Header section
    $('#invoice_modal_div_0').append(`
        <div class="w3-col l12 m12 s12">
            <div class="w3-col l8 m8 s12" style="background-color:transparent;float:left;text-align:left">
                <div class="w3-col l1 m1 s12 grn-org_logo_div w3-center" style="margin-top:-30px;"></div>
                <div class="w3-col l11 m11 s12" style="float:left !important;padding-left:30px;">
                    <div class="w3-col l12 m12 s12"><b class="grn-org_name" style="text-transform:uppercase;font-size:1.5em;"></b></div>
                    CONTACTS: <div class="w3-col l12 m12 s12 w3-hide-small grn-org_contacts" style="font-size:1em;"></div>
                    P.O BOX: <div class="w3-col l12 m12 s12 w3-hide-small grn-pobox" style="font-size:1em;"></div>
                    ADDRESS: <div class="w3-col l12 m12 s12 w3-hide-small grn-org_address" style="font-size:1em;"></div>
                </div>
                <h1 style="color:var(--primary-color);margin-bottom:0px;">GOODS RECEIPT NOTE</h1>
                <span style="font-size:1em">GRN #: </span>
                <span id="grnNumber" style="color:red;font-weight:400;font-size:1em">Auto-Generated</span>
            </div>

            <div class="w3-col l4 m4 s12" style="margin-top:0px;float:left !important;text-align:left;">
                <div class="w3-col l12 m12 s12" style="margin-left:5px;">
                    <b>RECEIPT DATE: </b><input id="grnDate" type="date" value="${today.replace(/\//g, '-')}" style="margin-left:5px;border:none;font-size:0.9em;color:black;"/>
                    <br/><br/>
                    <div class="w3-col l12 m12 s12">
                        <b>SELECT PO:</b>
                        <select id="grn-po-select" class="select2Styles" style="border:none;width:100%;">
                            <option value="">-- Select Purchase Order --</option>
                        </select>
                    </div>
                    <div class="w3-col l12 m12 s12">
                        <b>WAREHOUSE:</b>
                        <select id="grn-warehouse" class="select2Styles" style="border:none;width:100%;">
                            <option value="">-- Select Warehouse --</option>
                        </select>
                    </div>
                    <div class="w3-col l12 m12 s12">
                        <b>RECEIVED BY:</b>
                        <span id="receivedBy" style="padding-left:10px;color:gray;"></span>
                    </div>
                </div>
            </div>
        </div>
    `);

    // Supplier/PO Details Section
    $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 receipt_modal_div_01" style="background-color:rgba(96, 146, 205,0.1);margin-top:10px;padding:10px;"></div>');
    
    $('.receipt_modal_div_01').append(`
        <div class="w3-col l6 m6 s12">
            <b>SUPPLIER DETAILS:</b>
            <div id="grn-supplier-name" style="color:gray;margin-left:10px;">-</div>
            <div id="grn-supplier-phone" style="color:gray;margin-left:10px;font-size:0.9em;">-</div>
            <div id="grn-supplier-email" style="color:gray;margin-left:10px;font-size:0.9em;">-</div>
        </div>
        <div class="w3-col l6 m6 s12">
            <b>PO DETAILS:</b>
            <div>PO Number: <span id="grn-po-number" style="color:red;font-weight:600;">-</span></div>
            <div>PO Date: <span id="grn-po-date" style="color:gray;">-</span></div>
            <div>Expected: <span id="grn-po-delivery" style="color:gray;">-</span></div>
        </div>
    `);

    // Items Table
    $('#invoice_modal_div_0').append(`
        <div class="inner-data-div w3-col l12 m12 s12" style="margin-top:10px;background-color:rgba(96, 146, 205,0.2);font-weight:600;">
            <div class="w3-col l4 m4 s12" style="padding:7px;">Product</div>
            <div class="w3-col l2 m2 s12">Ordered</div>
            <div class="w3-col l2 m2 s12">Received Qty</div>
            <div class="w3-col l2 m2 s12">Batch/Serial</div>
            <div class="w3-col l1 m1 s12 w3-hide-small">Expiry</div>
            <div class="w3-col l1 m1 s12">Total</div>
        </div>
        <div id="grn-items-body" class="w3-col l12 m12 s12" style="background-color:rgba(96, 146, 205,0.1);padding:7px;min-height:100px;"></div>
        <div class="inner-data-div w3-col l12 m12 s12" style="background-color:rgba(96, 146, 205,0.2);font-weight:600;border-top:2px solid gray;padding:10px;">
            <div class="w3-col l10 m10 s8" style="text-align:right;padding-right:10px;"><b>GRAND TOTAL:</b></div>
            <div class="w3-col l2 m2 s4" id="grn-grand-total" style="color:red;font-size:1.2em;">K0.00</div>
        </div>
    `);

    // Notes & Signature
    $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101"><textarea id="grnNotes" placeholder="Notes/Comments..."></textarea></div>');
    $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12" style="float:left;">Received by: <span class="receivedByName" style="color:gray"></span></span><span class="w3-col l6 m6 s12" style="float:left;">Signature: <span style="color:gray">______________________</span></span></p>');

    $('#invoice_modal').fadeIn('slow').css('display', 'block');

    // Load user data
    getUserFromIndexedDB().then((userData) => {
        if (userData.length > 0) {
            const user = userData[0];
            $('.grn-org_name').text(user.orgname);
            $('.grn-org_contacts').text(user.org_contacts);
            $('.grn-org_address').text(user.org_address);
            $('.grn-pobox').text(user.org_p_o_box);
            $('#receivedBy, .receivedByName').text(user.username);

            if (user.org_logo) {
                const logoURL = URL.createObjectURL(user.org_logo);
                $('.grn-org_logo_div').html(`<img src="${logoURL}" alt="Logo" style="max-width:80px;"/>`);
            }
        }
    });

    // Load POs and Warehouses
    loadPOsForGRN();
    loadWarehousesForGRN();

    // Initialize select2
    $('.select2Styles').select2({
        allowClear: false,
        width: '100%',
        dropdownParent: $('#invoice_modal')
    });
}
*/ 

function createGoodsReceiptModal(purchaseOrderId = null) {
     let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    shoppingCart.clearCart(); 
    invoiceCart.clearCart();
     invoicePaymentCart.clearCart();
  
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;margin-top:50px;"></div>');
     // modal acttion buttons
     $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span> <div id="invoicePaymentDiv02"><span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Make Bank Payment</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 penDiv101" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2 pen101" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
     // modal acttion buttons
 $('#invoice_modal_div_0').append(`
  <div class="w3-col l12 m12 s12">
  
  <div class="w3-col l8 m8 s12" style="background-color:transparent;float:left;text-align:left">
      <div class="w3-col l1 m1 s12 po-org_logo_div w3-center" style="margin-top:-30px;"></div>
       <div class="w3-col l11 m11 s12" style="float:left !important;padding-left:30px;">
    
      <div class="w3-col l12 m12 s12"><b class="po-org_name" style="text-transform:uppercase;font-size:1.5em;"></b></div>
      <div class="w3-col l12 m12 s12 w3-hide-small po-org_contacts" style="font-size:1em;"></div>
       <div class="w3-col l12 m12 s12 w3-hide-small po-po-pobox" style="font-size:1em;"></div>
     <div class="w3-col l12 m12 s12 w3-hide-small po-org_address" style="font-size:1em;"></div>
      
       </div>

        
            
           
    
  </div>

            <div class="w3-col l4 m4 s12" style="margin-top:0px;margin-bottom:0px;float:left !important;text-align:left;">
            
            <h2 style="color:var(--primary-color);margin-bottom:0px;"> GOODS RECEIVED NOTE </h2>
           
            <span id="receiptTitle00" style="font-size:1em">GRN #: </span>
            <span id="grnNumber" style="color:red;font-weight:400;font-size:1em">Auto-Generated</span>
            
          
 
            <div class="w3-col l12 m12 s12" style="margin-left:5px;">
      
            
            DATE: <input id="poDate"  placeholder="${today}" value="${today}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
           

        </div>
    </div>
</div>
`);



  $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 receipt_modal_div_01" style="margin-top:0px;"></div>');
 

 
  $('.receipt_modal_div_01').append('<div class="w3-col l8 m8 s12 style="padding-right: 0px;padding-left:8px;"><span class="w3-col l6 m6 s8" style="margin-top:0px;font-weight: 600;"> <div class="w3-col l12 m12 s12"><select id="po-vendor" class="select2Styles" style="font-weight:400;border:none;background-color:transparent;width:100%;"><option value="1" selected>SELECT SUPPLIER</option></select> </div> </span><span class="w3-col l6 m6 s12" style="display:none;"><span style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="po-vendor-address" Placeholder="Enter Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><span class="w3-col l12 m12 s4"  style="margin-top:0px;"><input id="po-vendor-email" Placeholder="Enter Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 style="margin-top:0px;"><input id="po-vendor-phone" placeholder="Enter Phone No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span><span class="w3-col l12 m12 s4 style="margin-top:0px;"><input id="po-vendor-tpin" placeholder="Enter Tax Pin No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
 

  $('.receipt_modal_div_01').append(`
    <div class="w3-col l4 m4 s12 style="padding-right: 0px;padding-left:8px;">
    <span class="w3-col l12 m12 s12" style="margin-top:0px;font-weight: 600;"> <div class="w3-col l12 m12 s12">
    <select id="grn-poId-select" class="select2Styles" style="font-weight:400;border:none;background-color:transparent;width:100%;"><option value="1" selected>SELECT PURCHASE ORDER</option></select> </div> </span>
    <span class="w3-col l12 m12 s12"  style="margin-top:0px;"><input id="po-date" Placeholder="Enter PO Date" type="text" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/>
    <span class="w3-col l12 m12 s4"  style="margin-top:0px;"><input id="po-expected-delivery" Placeholder="Expected Delivery" type="text"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span>
    <span class="w3-col l12 m12 s4 style="margin-top:0px;"><input id="po-deparment" placeholder="Department" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span>
</div>`);


  $('.receipt_modal_div_01').append(`
    <div class="w3-col l4 m4 s12 style="padding-right: 0px;padding-left:8px;background-color:rgba(96, 146, 205,0.1);">
    <span class="w3-col l12 m12 s12" style="margin-top:0px;font-weight: 600;"><div class="w3-col l12 m12 s12">
    <select id="po-deliverplace" style="border:none;font-weight:400;border:none;background-color:transparent;width:100%;"><option value="1" selected>SELECT DELIVERY PLACE</option></select> </div> </span>
    <span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="display:none;margin-top:0px;"><input id="po-delivery-address" Placeholder="Enter Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/>
    <span class="w3-col l12 m12 s4"  style="margin-top:0px;display:none;"><input id="po-delivery-email" Placeholder="Enter Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span>
    <span class="w3-col l12 m12 s4 style="margin-top:0px;display:none;""><input id="po-delivery-phone" placeholder="Enter Phone No:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 160px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span>
</div>`);
 
 
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:5px;background-color:rgba(96, 146, 205,0.2);font-weight:600;"><div class="w3-col l4 m4 s8" id="addProductToReceipt101"><span style="padding:7px;cursor:pointer;">Item/Product <span class="fontx fx-plus"></span></span></div><div class="w3-col l3 m3 s3 w3-hide-small">Description/Comments</div><div class="w3-col l1 m1 s1 w3-hide-small">Ordered</div><div class="w3-col l1 m1 s1 w3-hide-small">Received</div><div class="w3-col l1 m1 s1 w3-hide-small">Expiry</div><div class="w3-col l1 m1 s1 w3-hide-small">Serial/Batch</div><div class="w3-col l1 m1 s2">Total</div></div>');
       $('#invoice_modal_div_0').append('<div class="show-cart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.1);padding-left:7px;border-left:1px solid rgba(96, 146, 205,0.2);border-right:1px solid rgba(96, 146, 205,0.2);"></div>');
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(96, 146, 205,0.2);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l7 m7 s8"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="display:none;">00</div><div class="w3-col l1 m1 s3  w3-hide-small" style="color:transparent;">00</div><div class="w3-col l2 m2 s2 totalBilledAmounts" style="color:red;">00</div></div>');
      
       $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
       $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Received by: <span class="preparedBy" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
      
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed
      
        $('#invoicePaymentDiv02').empty().append('<span class="createPurchaseOrderBtn" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> RECEIVE</span></span>');
      
     
    

        ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.po-org_name').empty().append(user.orgname);              
                $('.po-org_email').empty().append(user.org_email);
                $('.po-org_contacts').empty().append(user.org_contacts);
                $('.po-org_address').empty().append(user.org_address); 
                $('.po-po-pobox').empty().append(user.org_p_o_box);
                $('.preparedBy').empty().append(user.username); 
    
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                         class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.po-org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        
        });
     
        // Load vendors into the dropdown
// Load vendors into the dropdown
 // Fetch vendor list
$.ajax({
    url: "xd-modules/inventory/procurement/backend/allSuppliers.php", // replace with your actual PHP endpoint
    method: "GET",
    dataType: "json",
    success: function (response) {
        console.log("Vendors:", response);

        const vendorSelect = $("#po-vendor");
        vendorSelect.empty(); // clear previous options
        vendorSelect.append('<option value="">SELECT VENDOR</option>');

        if (response.details && response.details.length > 0) {
            response.details.forEach(vendor => {
                vendorSelect.append(
                    `<option value="${vendor.id}" 
                        data-address="${vendor.supplier_address}" 
                        data-email="${vendor.supplier_email}" 
                        data-phone="${vendor.supplier_phone}" 
                        data-tpin="${vendor.tax_id}">
                       VENDOR:  ${vendor.company_name || vendor.supplier_name}
                    </option>`
                );
            });
        } else {
            vendorSelect.append('<option value="">No vendors found</option>');
        }
    },
    error: function (xhr, status, error) {
        console.error("Error fetching vendors:", error);
    }
});

// Auto-fill vendor details when selected
$(document).on("change", "#po-vendor", function () {
    const selected = $(this).find("option:selected");

    $("#po-vendor-address").val(selected.data("address") || "");
    $("#po-vendor-email").val(selected.data("email") || "");
    $("#po-vendor-phone").val(selected.data("phone") || "");
    $("#po-vendor-tpin").val(selected.data("tpin") || "");
});


$.ajax({
    url: "xd-modules/inventory/procurement/backend/list_purchase_order_numbers.php", // replace with your actual PHP endpoint
    method: "GET",
    dataType: "json",
    success: function (response) { 

        const vendorSelect = $("#grn-poId-select");
        vendorSelect.empty(); // clear previous options
        vendorSelect.append('<option value="0">SELECT PO #</option>');

        if (response.details && response.details.length > 0) {
            response.details.forEach(cyberdesk => {
                vendorSelect.append(
                    `<option value="${cyberdesk.id}"
                       data-ponumber="${cyberdesk.po_number}"  
                    data-supplierid="${cyberdesk.supplier_id}"
                    data-suppliername="${cyberdesk.supplier_name}"
                    data-supplieremail="${cyberdesk.supplier_email}"
                    data-supplierphone="${cyberdesk.supplier_phone}" 
                    data-supplieraddress="${cyberdesk.supplier_adresss}"
                    data-expecteddeliverydate="${cyberdesk.expected_delivery_date}"
                    data-departmentname="${cyberdesk.department_name}"
                    data-warehousename="${cyberdesk.warehouse_name}">
                      PO #: ${cyberdesk.po_number}
                    </option>`
                );
            });
        } else {
            vendorSelect.append('<option value="">No po found</option>');
        }
    },
    error: function (xhr, status, error) {
        console.error("Error fetching purchase orders:", error);
    }
});

 // Auto-fill vendor details when selected
$(document).on("change", "#grn-poId-select", function () {
    const selected = $(this).find("option:selected");

    $("#po-vendor-address").val(selected.data("supplieraddress") || "");
    $("#po-vendor-email").val(selected.data("supplieremail") || "");
    $("#po-vendor-phone").val(selected.data("supplierphone") || "");
    $("#po-deparment").val(selected.data("departmentname") || "");
    $("#po-expected-delivery").val(selected.data("expecteddeliverydate") || "");
    var warehouse = selected.data("warehousename");
    $('#po-deliverplace').empty().append('<option value="'+warehouse+'">'+warehouse+'</option>');
    $("#po-vendor-tpin").val(selected.data("tpin") || "");
});


// Load warehouses into the dropdown
$.getJSON('xd-modules/inventory/backend/list_warehouses.php', function(data) {
    if (data.success && data.details) {
        const $select = $('#po-deliverplace');
        $select.empty().append('<option value="">Select Delivery Place</option>');
        $.each(data.details, function(i, warehouse) {
            $select.append(`
                <option value="${warehouse.id}" data-phon="${warehouse.phone}" data-email="${warehouse.email}" data-address="${warehouse.address}">DELIVERED TO: ${warehouse.warehouse_name}</option>
            `);
        });
    }
});

// Handle change event to populate phone/email
$(document).on('change', '#po-deliverplace', function() {
    const selected = $(this).find(':selected');
    const phone = selected.data('phon') || '';
    const email = selected.data('email') || '';
     const address = selected.data('address') || '';
    $('#po-delivery-address').val(address);
    $('#po-delivery-phone').val(phone);
    $('#po-delivery-email').val(email);
});


  $('.select2Styles').select2({
  //  placeholder: "Select an option",
    allowClear: false,
   // width: '100%',
    dropdownParent: $('#invoice_modal') // ensures dropdown appears inside modal
});

 


}

// === Load POs for GRN ===
function loadPOsForGRN() {
    $.ajax({
        url: 'xd-modules/inventory/procurement/backend/get_purchase_orders.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            const select = $('#grn-po-select');
            select.empty().append('<option value="">-- Select PO --</option>');
            
            if (data.success && data.data) {
                // Filter only Sent or Partially Received POs
                const availablePOs = data.data.filter(po => 
                    po.status === 'Sent' || po.status === 'Partially Received' || po.status === 'Draft'
                );
                
                availablePOs.forEach(po => {
                    select.append(`<option value="${po.id}" data-po-number="${po.po_number}">${po.po_number} - ${po.supplier_name} (${po.expected_delivery_date || 'No date'})</option>`);
                });

                if (availablePOs.length === 0) {
                    select.append('<option value="">No POs available for receiving</option>');
                }
            }
        }
    });
}

// === Load Warehouses ===
function loadWarehousesForGRN() {
    $.ajax({
        url: 'xd-modules/inventory/backend/list_warehouses.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            const select = $('#grn-warehouse');
            select.empty().append('<option value="">-- Select Warehouse --</option>');
            
            if (data.success && data.details) {
                data.details.forEach(wh => {
                    select.append(`<option value="${wh.id}">${wh.warehouse_name}</option>`);
                });
            }
        }
    });
}

// === Handle PO Selection ===
$(document).on('change', '#grn-po-select', function() {
    const poId = $(this).val();
    if (poId) {
        loadPODetailsForGRN(poId);
    } else {
        $('#grn-items-body').empty();
        $('#grn-supplier-name, #grn-supplier-phone, #grn-supplier-email').text('-');
        $('#grn-po-number, #grn-po-date, #grn-po-delivery').text('-');
    }
});

// === Load PO Details and Items ===
function loadPODetailsForGRN(poId) {
    $.ajax({
        url: `xd-modules/inventory/procurement/backend/get_po_details.php?id=${poId}`,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                // Fill supplier details
                $('#grn-supplier-name').text(data.po.supplier_name || '-');
                $('#grn-supplier-phone').text(data.po.supplier_phone || '-');
                $('#grn-supplier-email').text(data.po.supplier_email || '-');
                
                // Fill PO details
                $('#grn-po-number').text(data.po.po_number);
                $('#grn-po-date').text(data.po.po_date);
                $('#grn-po-delivery').text(data.po.expected_delivery_date || '-');
                
                // Load items
                displayGRNItems(data.items);
            }
        },
        error: function() {
            alert('Failed to load PO details');
        }
    });
}

// === Display GRN Items ===
function displayGRNItems(items) {
    const container = $('#grn-items-body');
    container.empty();
    
    if (!items || items.length === 0) {
        container.html('<div class="w3-col l12 m12 s12" style="padding:20px;text-align:center;color:gray;">No items in this PO</div>');
        return;
    }
    
    items.forEach((item, index) => {
        container.append(`
            <div class="inner-data-div w3-col l12 m12 s12" style="border-bottom:1px solid #ddd;padding:8px;" 
                 data-item-id="${item.id}" data-product-id="${item.product_id}">
                <div class="w3-col l4 m4 s12" style="font-weight:600;">${item.product_name}</div>
                <div class="w3-col l2 m2 s12">${item.quantity}</div>
                <div class="w3-col l2 m2 s12">
                    <input type="number" class="grn-received-qty" data-index="${index}" 
                           value="${item.quantity}" min="0" max="${item.quantity}" 
                           style="width:90%;border:1px solid #ddd;padding:5px;border-radius:3px;"/>
                </div>
                <div class="w3-col l2 m2 s12">
                    <input type="text" class="grn-batch-number" placeholder="Batch" 
                           style="width:90%;border:1px solid #ddd;padding:5px;border-radius:3px;"/>
                </div>
                <div class="w3-col l1 m1 s12 w3-hide-small">
                    <input type="date" class="grn-expiry-date" 
                           style="width:100%;border:1px solid #ddd;padding:5px;border-radius:3px;"/>
                </div>
                <div class="w3-col l1 m1 s12 grn-item-total" data-price="${item.unit_price}">
                    K${(item.quantity * item.unit_price).toFixed(2)}
                </div>
            </div>
        `);
    });
    
    calculateGRNTotal();
    
    // Update totals when quantity changes
    $(document).off('input', '.grn-received-qty').on('input', '.grn-received-qty', function() {
        const qty = parseFloat($(this).val()) || 0;
        const maxQty = parseFloat($(this).attr('max')) || 0;
        
        if (qty > maxQty) {
            $(this).val(maxQty);
            alert('Received quantity cannot exceed ordered quantity');
            return;
        }
        
        const price = parseFloat($(this).closest('.inner-data-div').find('.grn-item-total').data('price')) || 0;
        const total = qty * price;
        
        $(this).closest('.inner-data-div').find('.grn-item-total').text('K' + total.toFixed(2));
        calculateGRNTotal();
    });
}

// === Calculate GRN Grand Total ===
function calculateGRNTotal() {
    let grandTotal = 0;
    $('.grn-item-total').each(function() {
        const text = $(this).text().replace('K', '').replace(',', '');
        grandTotal += parseFloat(text) || 0;
    });
    $('#grn-grand-total').text('K' + grandTotal.toFixed(2));
}

// ========================================
// SUBMIT GOODS RECEIPT
// ========================================

$(document).on('click', '.createGoodsReceiptBtn', function(event) {
    event.preventDefault();
    event.stopPropagation();

    // Update button state
    $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(0, 0, 0,0.1);"><span style="color:rgba(96, 146, 205,1);">Processing...</span></span>');

    // Gather form data
    const poId = $('#grn-po-select').val();
    const warehouseId = $('#grn-warehouse').val();
    const grnDate = $('#grnDate').val();
    const notes = $('#grnNotes').val();

    // Validation
    if (!poId) {
        alert('Please select a Purchase Order');
        resetGRNButton();
        return;
    }

    if (!warehouseId) {
        alert('Please select a warehouse');
        resetGRNButton();
        return;
    }

    // Gather items with received quantities
    const items = [];
    let hasItems = false;

    $('#grn-items-body .inner-data-div').each(function() {
        const productId = $(this).data('product-id');
        const itemId = $(this).data('item-id');
        const receivedQty = parseFloat($(this).find('.grn-received-qty').val()) || 0;
        const batchNumber = $(this).find('.grn-batch-number').val() || null;
        const expiryDate = $(this).find('.grn-expiry-date').val() || null;
        const unitPrice = parseFloat($(this).find('.grn-item-total').data('price')) || 0;

        if (receivedQty > 0) {
            hasItems = true;
            items.push({
                po_item_id: itemId,
                product_id: productId,
                received_qty: receivedQty,
                unit_price: unitPrice,
                batch_number: batchNumber,
                expiry_date: expiryDate
            });
        }
    });

    if (!hasItems) {
        alert('Please enter received quantities for at least one item');
        resetGRNButton();
        return;
    }

    // Prepare data
    const grnData = {
        po_id: poId,
        warehouse_id: warehouseId,
        receipt_date: grnDate,
        notes: notes,
        items: items
    };

    console.log('Submitting GRN Data:', grnData);

    // Submit to backend
    $.ajax({
        url: 'xd-modules/inventory/procurement/backend/create_goods_receipt.php',
        type: 'POST',
        data: JSON.stringify(grnData),
        contentType: 'application/json',
        dataType: 'json',
        timeout: 30000
    })
    .done(function(response) {
        console.log('GRN Response:', response);

        if (response.success) {
            // SUCCESS!
            $('#invoicePaymentDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:green;"><span>✓ Success!</span></span>');
            
            // Update GRN number display
            $('#grnNumber').text(response.grn_number);

            // Show success message
            let successMsg = 'Goods Receipt Created Successfully!\n\n';
            successMsg += 'GRN Number: ' + response.grn_number + '\n';
            successMsg += 'Items Received: ' + items.length + '\n';
            successMsg += 'Total Amount: K' + response.total_amount.toFixed(2) + '\n';
            successMsg += '\n✓ Stock has been updated in warehouse!\n';
            successMsg += '✓ PO status updated to: ' + (response.po_status || 'Updated');

            alert(successMsg);

            // Print after short delay
            setTimeout(function() {
                window.print();
                
                setTimeout(function() {
                    $('.invoiceDivActions101').show();
                    resetGRNButton();
                    
                    // Close modal and reload list
                    $('#invoice_modal').fadeOut(function() {
                        loadGoodsReceipts();
                    });
                }, 700);
            }, 200);

        } else {
            alert('Failed to create goods receipt:\n\n' + (response.message || 'Unknown error'));
            resetGRNButton();
        }
    })
    .fail(function(xhr, status, error) {
        console.error('GRN Submission Error:', {
            status: status,
            error: error,
            response: xhr.responseText
        });

        let errorMsg = 'Server error while creating goods receipt.\n\n';
        errorMsg += 'Status: ' + status + '\n';
        errorMsg += 'Error: ' + error + '\n\n';
        
        if (xhr.responseText) {
            try {
                const errorData = JSON.parse(xhr.responseText);
                errorMsg += 'Message: ' + (errorData.message || 'Unknown error');
            } catch (e) {
                errorMsg += 'Response: ' + xhr.responseText.substring(0, 200);
            }
        }
        
        alert(errorMsg);
        resetGRNButton();
    });
});

function resetGRNButton() {
    $('#invoicePaymentDiv02').empty().append('<span class="createGoodsReceiptBtn" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span>RECEIVE GOODS</span></span>');
}

// ========================================
// HANDLE GRN DROPDOWN ACTIONS
// ========================================

$(document).on('change', '.innerDivGRNSelectKey', function() {
    const action = $(this).val();
    const grnId = $(this).data('id');

    if (action === 'view-details') {
        viewGRNDetails(grnId);
    } else if (action === 'print') {
        printGRN(grnId);
    }

    $(this).val('select-actions');
});

// === View GRN Details ===
function viewGRNDetails(grnId) {
    $.ajax({
        url: `xd-modules/inventory/procurement/backend/get_grn_details.php?id=${grnId}`,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                displayGRNDetailsModal(data.grn, data.items);
            } else {
                alert('Failed to load GRN details: ' + data.message);
            }
        },
        error: function() {
            alert('Error loading GRN details');
        }
    });
}

// === Display GRN Details Modal ===
function displayGRNDetailsModal(grn, items) {
    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:999999999;"></div>');
    
    $('#invoice_modal').append(`
        <div style="background-color:white;max-width:900px;margin:50px auto;padding:30px;border-radius:10px;max-height:90vh;overflow-y:auto;">
            <span class="close_invoice_modal" style="float:right;cursor:pointer;font-size:2em;color:red;">&times;</span>
            
            <h2 style="color:var(--primary-color);">Goods Receipt Details</h2>
            <hr/>
            
            <div style="margin-bottom:20px;">
                <p><strong>GRN Number:</strong> <span style="color:red;font-weight:600;">${grn.grn_number}</span></p>
                <p><strong>PO Number:</strong> ${grn.po_number}</p>
                <p><strong>Supplier:</strong> ${grn.supplier_name}</p>
                <p><strong>Warehouse:</strong> ${grn.warehouse_name}</p>
                <p><strong>Receipt Date:</strong> ${grn.receipt_date}</p>
                <p><strong>Received By:</strong> ${grn.received_by_name}</p>
                <p><strong>Status:</strong> ${getGRNStatusBadge(grn.status)}</p>
            </div>

            <h4>Received Items</h4>
            <table style="width:100%;border-collapse:collapse;">
                <thead>
                    <tr style="background:#f5f5f5;">
                        <th style="padding:10px;border:1px solid #ddd;text-align:left;">Product</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:right;">Qty Received</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:right;">Unit Cost</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:left;">Batch/Serial</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:left;">Expiry</th>
                        <th style="padding:10px;border:1px solid #ddd;text-align:right;">Total</th>
                    </tr>
                </thead>
                <tbody id="grnDetailsItemsBody"></tbody>
            </table>

            <div style="margin-top:20px;text-align:right;">
                <h3 style="color:red;"><strong>Grand Total:</strong> K${parseFloat(grn.total_amount).toFixed(2)}</h3>
            </div>

            ${grn.notes ? `<div style="margin-top:20px;"><strong>Notes:</strong><p style="background:#f9f9f9;padding:10px;border-left:3px solid var(--primary-color);">${grn.notes}</p></div>` : ''}

            <div style="margin-top:30px;text-align:center;">
                <button onclick="$('#invoice_modal').fadeOut();" style="background-color:gray;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;margin-right:10px;">Close</button>
                <button onclick="printGRN(${grn.id})" style="background-color:var(--primary-color);color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">Print GRN</button>
            </div>
        </div>
    `);

    // Populate items
    const tbody = $('#grnDetailsItemsBody');
    items.forEach(item => {
        tbody.append(`
            <tr>
                <td style="padding:10px;border:1px solid #ddd;">${item.product_name}</td>
                <td style="padding:10px;border:1px solid #ddd;text-align:right;">${item.quantity_received}</td>
                <td style="padding:10px;border:1px solid #ddd;text-align:right;">K${parseFloat(item.unit_cost).toFixed(2)}</td>
                <td style="padding:10px;border:1px solid #ddd;">${item.batch_number || '-'}</td>
                <td style="padding:10px;border:1px solid #ddd;">${item.expiry_date || '-'}</td>
                <td style="padding:10px;border:1px solid #ddd;text-align:right;">K${parseFloat(item.line_total).toFixed(2)}</td>
            </tr>
        `);
    });

    $('#invoice_modal').fadeIn('slow');
}

// === Print GRN ===
function printGRN(grnId) {
    window.open(`xd-modules/inventory/procurement/print_grn.php?id=${grnId}`, '_blank');
}

// === Close Modal Handler ===
$(document).on('click', '.close_invoice_modal', function() {
    $('#invoice_modal').fadeOut();
});