<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

// Connect to the database
try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    // set the PDO error mode to exception
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['status' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// Retrieve session user ID
$userloggedid = $_SESSION["userid"];

// Retrieve and filter input data
$id = filter_input(INPUT_POST, "id");
$supplier_code = filter_input(INPUT_POST, "supplier_code");
$supplier_name = filter_input(INPUT_POST, "supplier_name");
$company_name = filter_input(INPUT_POST, "company_name");
$email = filter_input(INPUT_POST, "email");
$phone = filter_input(INPUT_POST, "phone");
$mobile = filter_input(INPUT_POST, "mobile");
$website = filter_input(INPUT_POST, "website");
$tax_id = filter_input(INPUT_POST, "tax_id");
$payment_terms = filter_input(INPUT_POST, "payment_terms");
$credit_limit = filter_input(INPUT_POST, "credit_limit");
$currency = filter_input(INPUT_POST, "currency");
$address = filter_input(INPUT_POST, "address");
$city = filter_input(INPUT_POST, "city");
$state = filter_input(INPUT_POST, "state");
$country = filter_input(INPUT_POST, "country");
$postal_code = filter_input(INPUT_POST, "postal_code");
$contact_person = filter_input(INPUT_POST, "contact_person");
$contact_phone = filter_input(INPUT_POST, "contact_phone");
$contact_email = filter_input(INPUT_POST, "contact_email");
$rating = filter_input(INPUT_POST, "rating");
$lead_time_days = filter_input(INPUT_POST, "lead_time_days");
$is_active = filter_input(INPUT_POST, "is_active");
$notes = filter_input(INPUT_POST, "notes");
$org_id = filter_input(INPUT_POST, "org_id");
$created_by = filter_input(INPUT_POST, "created_by");
$created_at = filter_input(INPUT_POST, "created_at");
$updated_at = filter_input(INPUT_POST, "updated_at");
$role_id = filter_input(INPUT_POST, "role_id");
$role_name = filter_input(INPUT_POST, "role_name");
$department_id = filter_input(INPUT_POST, "department_id");
//$departmentname = filter_input(INPUT_POST, "departmentname");
//$depot_id = filter_input(INPUT_POST, "depot_id");
//$area = filter_input(INPUT_POST, "area");
$status = filter_input(INPUT_POST, "status");
$nrc = filter_input(INPUT_POST, "nrc");
$tpin = filter_input(INPUT_POST, "tpin");

// Validate required fields
$requiredFields = [
    'id' => $id,
    'supplier_code' => $supplier_code,
    'supplier_name' => $supplier_name,
    'company_name' => $company_name,
    'email' => $email,
    'phone' => $phone,
    'mobile' => $mobile,
    'website' => $website,
    'tax_id' => $tax_id,
    'payment_terms' => $payment_terms,
    'credit_limit' => $credit_limit,
    'currency' => $currency,
    'address' => $address,
    'city' => $city,
    'state' => $state,
    'country' => $country,
    'postal_code' => $postal_code,
    'contact_person' => $contact_person,
    'contact_phone' => $contact_phone,
    'contact_email' => $contact_email,
    'rating' => $rating,
    'lead_time_days' => $lead_time_days,
    'is_active' => $is_active,
    'notes' => $notes,
    'org_id' => $org_id,
    'created_by' => $created_by,
    'created_at' => $created_at,
    'updated_at' => $updated_at,
    'role_id' => $role_id,
    'role_name' => $role_name,
    'department_id' => $department_id,
   // 'departmentname' => $departmentname,
   // 'depot_id' => $depot_id,
   // 'area' => $area,
    'status' => $status,
    'nrc' => $nrc,
    'tpin' => $tpin
];
foreach ($requiredFields as $field => $value) {
    if ($value === null || $value === false || $value === '' || $value === 'undefined') {
        echo json_encode(['status' => 'not updated', 'error' => "Missing or invalid value for $field"]);
        exit;
    }
}

// Handle avatar file upload if present
$avatarUpdateSQL = '';
$avatarParam = [];
if (isset($_FILES['avatarImage']) && $_FILES['avatarImage']['error'] === UPLOAD_ERR_OK) {
    // Get old avatar path from DB
    $oldAvatarPath = '';
    $getOldAvatarStmt = $conn->prepare('SELECT avatar FROM users WHERE id = :id LIMIT 1');
    $getOldAvatarStmt->execute([':id' => $id]);
    $oldAvatarRow = $getOldAvatarStmt->fetch(PDO::FETCH_ASSOC);
    if ($oldAvatarRow && !empty($oldAvatarRow['avatar'])) {
        $oldAvatarPath = $oldAvatarRow['avatar'];
    }

    $uploadDir = '../../../../xd-uploads/user-pictures/';
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    $fileInfo = pathinfo($_FILES['avatarImage']['name']);
    $fileExtension = strtolower($fileInfo['extension']);
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    if (!in_array($fileExtension, $allowedExtensions)) {
        echo json_encode(['status' => 'not updated', 'error' => 'Invalid file type. Only JPG, PNG, GIF, and WebP files are allowed.']);
        exit;
    }
    if ($_FILES['avatarImage']['size'] > 5 * 1024 * 1024) {
        echo json_encode(['status' => 'not updated', 'error' => 'File size too large. Maximum 5MB allowed.']);
        exit;
    }
    $timestamp = time();
    $randomString = bin2hex(random_bytes(8));
    $newFileName = "avatar_" . $timestamp . "_" . $randomString . "." . $fileExtension;
    $targetPath = $uploadDir . $newFileName;
    if (move_uploaded_file($_FILES['avatarImage']['tmp_name'], $targetPath)) {
        $avatarPath = 'xd-uploads/user-pictures/' . $newFileName;
        $avatarUpdateSQL = ', avatar = :avatar';
        $avatarParam = [':avatar' => $avatarPath];
        // Delete old avatar file if not default and exists
        if ($oldAvatarPath && $oldAvatarPath !== 'xd-uploads/user-pictures/avatar.png') {
            $oldAvatarFullPath = '../../../../' . $oldAvatarPath;
            if (file_exists($oldAvatarFullPath)) {
                unlink($oldAvatarFullPath);
            }
        }
    } else {
        echo json_encode(['status' => 'not updated', 'error' => 'Failed to upload avatar image.']);
        exit;
    }
}

// Prepare the SQL update query for users
$updateUserQuery = "
    UPDATE users SET 
        email = :email,
        names = :supplier_name,
        phone = :phone, 
        address = :address,
        nrc = :nrc, 
        tpin = :tpin,  
        user_type = :role_name,
        status = :status,
        sessionUserId = :userloggedid" . $avatarUpdateSQL . "
    WHERE id = :id
";
$statement = $conn->prepare($updateUserQuery);
$userParams = [
    ':email' => $email,
    ':supplier_name' => $supplier_name,
    ':phone' => $phone, 
    ':address' => $address,
    ':nrc' => $nrc,  
    ':tpin' => $tpin, 
    ':role_name' => $role_name,
    ':status' => $status,
    ':userloggedid' => $userloggedid,
    ':id' => $id
] + $avatarParam;

// Prepare the SQL update query for supplier
$updateSupplierQuery = "
    UPDATE supplier SET  
        supplier_code = :supplier_code,
        supplier_name = :supplier_name,
        company_name = :company_name,
        email = :email,
        phone = :phone,
        mobile = :mobile,
        website = :website,
        tax_id = :tax_id,
        payment_terms = :payment_terms,
        credit_limit = :credit_limit,
        currency = :currency,
        address = :address,
        city = :city,
        state = :state,
        country = :country,
        postal_code = :postal_code,
        contact_person = :contact_person,
        contact_phone = :contact_phone,
        contact_email = :contact_email,
        rating = :rating,
        lead_time_days = :lead_time_days,
        is_active = :is_active,
        notes = :notes,
        org_id = :org_id,
        created_by = :created_by,
        created_at = :created_at,
        updated_at = :updated_at,
        role_id = :role_id,
        role_name = :role_name,
        department_id = :department_id,
        status = :status
    WHERE user_id = :id
";
$supplierParams = [
    ':supplier_code' => $supplier_code,
    ':supplier_name' => $supplier_name,
    ':company_name' => $company_name,
    ':email' => $email,
    ':phone' => $phone,
    ':mobile' => $mobile,
    ':website' => $website,
    ':tax_id' => $tax_id,
    ':payment_terms' => $payment_terms,
    ':credit_limit' => $credit_limit,
    ':currency' => $currency,
    ':address' => $address,
    ':city' => $city,
    ':state' => $state,
    ':country' => $country,
    ':postal_code' => $postal_code,
    ':contact_person' => $contact_person,
    ':contact_phone' => $contact_phone,
    ':contact_email' => $contact_email,
    ':rating' => $rating,
    ':lead_time_days' => $lead_time_days,
    ':is_active' => $is_active,
    ':notes' => $notes,
    ':org_id' => $org_id,
    ':created_by' => $created_by,
    ':created_at' => $created_at,
    ':updated_at' => $updated_at,
    ':role_id' => $role_id,
    ':role_name' => $role_name,
    ':department_id' => $department_id,   
    ':status' => $status,  
    ':id' => $id
];

try {
    $statement->execute($userParams);
    $supplierStatement = $conn->prepare($updateSupplierQuery);
    $supplierStatement->execute($supplierParams);
    $json_data = ['status' => 'Success'];
    echo json_encode($json_data);
} catch (PDOException $e) {
    $json_data = ['status' => 'not updated', 'error' => $e->getMessage()];
    echo json_encode($json_data);
}
?>
