<?php
/**
 * List Suppliers
 * File: xd-modules/inventory/procurement/backend/list_suppliers.php
 */

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'details' => [], 'message' => ''];

try {
    $orgId = $_SESSION['orgid'] ?? null;

    if (!$orgId) {
        throw new Exception('Organization ID not found');
    }

    // Get active suppliers
    $stmt = $conn->prepare("
        SELECT 
            id,
            supplier_name,
            supplier_code,
            email,
            phone,
            address,
            city,
            country,
            payment_terms,
            is_active
        FROM supplier
        WHERE org_id = :org_id
        AND is_active = 1
        ORDER BY supplier_name ASC
    ");
    $stmt->execute([':org_id' => $orgId]);
    $suppliers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [
        'success' => true,
        'details' => $suppliers,
        'count' => count($suppliers),
        'message' => 'Suppliers retrieved successfully.'
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("List Suppliers Error: " . $e->getMessage());
}

echo json_encode($response);
?>

<?php
/**
 * Get Requisition Details (for converting to PO)
 * File: xd-modules/inventory/procurement/backend/get_requisition_details.php
 */

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'requisition' => null, 'items' => [], 'message' => ''];

try {
    $reqId = $_GET['id'] ?? null;

    if (!$reqId) {
        throw new Exception('Requisition ID is required');
    }

    // Get requisition header
    $stmt = $conn->prepare("
        SELECT 
            pr.*,
            u.names AS requested_by_name,
            d.name AS department_name
        FROM purchase_requisition pr
        LEFT JOIN users u ON pr.requested_by = u.id
        LEFT JOIN departments d ON pr.department = d.id
        WHERE pr.id = :req_id
    ");
    $stmt->execute([':req_id' => $reqId]);
    $requisition = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$requisition) {
        throw new Exception('Requisition not found');
    }

    // Get requisition items
    $stmt = $conn->prepare("
        SELECT 
            pri.*,
            p.name AS product_name,
            p.product_code,
            p.units
        FROM purchase_requisition_item pri
        LEFT JOIN tblproduct p ON pri.product_id = p.id
        WHERE pri.requisition_id = :req_id
        ORDER BY pri.id
    ");
    $stmt->execute([':req_id' => $reqId]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [
        'success' => true,
        'requisition' => $requisition,
        'items' => $items,
        'message' => 'Requisition details retrieved successfully.'
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("Get Requisition Details Error: " . $e->getMessage());
}

echo json_encode($response);
?>